# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

"""Helper functions for UTF-8 encoding."""
import sys

_ENCODING = 'utf-8'


def isunicode(value):
    """Checks whether a string-like object is unicode

    :param value:   the value to inspect
    :returns:       whether the given value is unicode
    """
    return isinstance(value, str) if sys.version_info >= (3, 0) else isinstance(value, unicode)


def asstring(value):
    """Converts str-like objects to string.
    
    :param value:   the str-like object to convert
    :returns:       the str representation for the given value
    """
    if value is None or isinstance(value, str):
        return value

    if isinstance(value, bytes):
        return value.decode(_ENCODING)

    if isunicode(value):
        return value.encode(_ENCODING)

    raise ValueError('unexpected value of type {0}'.format(type(value)))


def asbytes(value):
    """Converts bytes-like objects to bytes.
    
    :param value:   the bytes-like object to convert
    :returns:       the bytes representation for the given value
    """
    if value is None or isinstance(value, bytes):
        return value

    if isinstance(value, str) or isunicode(value):
        return value.encode(_ENCODING)

    raise ValueError('unexpected value of type {0}'.format(type(value)))
