# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

"""Helper functions extending/enhancing the Python language."""
from .encoding import isunicode


def isempty(value):
    """Checks whether a string-like object is None or empty.

    :param value:   the value to inspect
    :returns:       whether the given value is None or empty
    """
    if value is None:
        return True

    if isinstance(value, str) or isinstance(value, bytes) or isunicode(value):
        return len(value) == 0 or value.isspace()

    raise ValueError('unexpected value of type {0}'.format(type(value)))
