# Copyright Citrix Systems, Inc. All rights reserved.

"""CWC Authorization Mode.

Use :py:class:`cwc.auth.mode.CwcAuthorizationMode` to specify the authorization mode
for CWC requests.
"""
from enum import Enum

class CwcAuthorizationMode(Enum):
    """Represents a CWC authorization mode."""

    bearer = 1
    servicekey = 2
    both = 3
    either = 7

    def requires_bearer(self):
        """Returns whether the authorization requires a bearer token.

        :returns:   a boolean value indicating whether the authorization requires a bearer token
        """
        return self != CwcAuthorizationMode.servicekey

    def requires_servicekey(self):
        """Returns whether the authorization requires a service key.

        :returns:   a boolean value indicating whether the authorization requires a service key
        """
        return self != CwcAuthorizationMode.bearer
