#!/usr/bin/env python

#
# Copyright 2004-2025 Citrix Systems, Inc. All rights reserved.
# This software and documentation contain valuable trade
# secrets and proprietary property belonging to Citrix Systems, Inc.
# None o1f this software and documentation may be copied,
# duplicated or disclosed without the express
# written permission of Citrix Systems, Inc.

# Scripts Constant
DEFAULT_DEBUG_LEVEL = 'info'
WAITING_TIME_REGISTRATION_STATUS_CHECK = 30       # 30:00S
WAITING_TIME_PER_LIGHTPROBE            = 60       # 01:00M
WAITING_TIME_PER_PROBE                 = 1*60*60  # 01:00H
WAITING_TIME_AUTOMATION_TOOL           = 45*60    # 45:00M
WAITING_TIME_LIC_SNO_REFRESH           = 1*60*60  # 01:00H
WAITING_TIME_MEM_USAGE_CHECK_FREQUENT  = 1*60*60  # 01:00H
WAITING_TIME_MEM_USAGE_CHECK_NORMAL    = 24*60*60 # 24:00H
WAITING_TIME_HDDCF_PE_FAILURE_CHECK    = 24*60*60 # 24:00H
WAITING_TIME_CRITICAL_EVENTS           = 24*60*60 # 24:00H
WAITING_TIME_NSCONF_REFRESH            = 24*60*60 # 24:00H
WAITING_TIME_MAX_PER_PROBE             = 24*60*60 # 24:00H
ADM_ENDPOINTS = "https://adm.cloud.com/endpoints"
SAFEHAVEN_HEARTBEAT_URL = "/safehaven-fe/nitro/v1/config/probes/actions/heartbeat"
SAFEHAVEN_LIGHTHEARTBEAT_URL = "/safehaven-fe/nitro/v1/config/probes/actions/lightheartbeat"
SAFEHAVEN_HEALTH_URL = "/safehaven-fe/nitro/v1/config/health"
HTTP = "http://"
HTTPS = "https://"
HTTP_GET = 'GET'
HTTP_POST = 'POST'
HTTP_PUT = 'PUT'
HTTP_DELETE = 'DELETE'
CONTENT_TYPE_JSON = 'application/json'
TIMEOUT = 20
RETRY = 3
MAX_FAILED_PROBE_COUNT = 5
ADM_AUTOREG_SECTION = 'AdmAutoReg'
ADM_AUTOREG_SAFEHAVEN_REACHABLE_FLAG = 'safehaven_reachable'
ADM_AUTOREG_ADCCLAIMED_FLAG = 'adc_claimed'
ADM_AUTOREG_ADCREGISTRATION_FLAG = 'adc_registration'
ADM_NS_INTERNAL_REGISTRATION_FLAG_OLD = 'ns_internal_registration'
ADM_NS_INTERNAL_REGISTRATION_FLAG = 'internal_registration_status'
ADM_NS_INTERNAL_REGISTRATION_NSIP = 'ns_internal_registration_ns_ip'
ADM_IS_NS_INTERNAL = 'is_internal'
TEST_LODESTONE = 'test_lodestone'
UPDATE_DEVICE_PROFILE = 'update_device_profile'
DELETE_CORE_DUMP = 'delete_core_dump'
ADM_NS_INTERNAL_REGISTRATION_START_TIME = 'ns_internal_registration_start_time'
ADM_NS_UNIQUE_ID = 'ns_unique_id'
CLEAN_UP = 'clean_up'
IS_ZERO_TOUCH_REGISTRATION_ALLOWED = 'is_zero_touch_registration_allowed'
DEPLOYMENT_TYPE = 'deployment_type'
UPDATE_NSIP_DEPLOYMENT_TYPE = 'update_nsip_deployment_type'
CLIP = 'clip'
ADM_NS_INTERNAL_REGISTRATION_TIMEOUT = 60*60 # 1 hour
MANAGED_DEVICE_POLL_TIMEOUT = 15*60
CLOUD_CONNECT_USER = "admuser"
OLD_CLOUD_CONNECT_USER_1 = "admcloudconnectuser"
OLD_CLOUD_CONNECT_USER_2 = "admcloud"
VPX_HA_STATE_PREFIX = 'Node:'
VPX_HA_STATE_PRIMARY = 'Primary'
VPX_HA_STATE_SECONDARY = 'Secondary'
SHOW_CLUSTER_NODE = 'sh cluster node'
ADM_AUTOREG_LODESTONE_ENABLE_FLAG = 'adc_lodestone_enable'
INITIAL_WAIT = 'initial_wait'
REGISTRATION = 'Registration'
INPROGRESS = 'InProgress'
SUCCESS = 'Success'
BLOCKED = 'BLOCKED'
FAILURE = 'Failure'
ENABLED = 'ENABLED'
DISABLED = 'DISABLED'
NOT_ALLOWED = 'NOT_ALLOWED'
UP = 'UP'
DOWN = 'DOWN'
DEPLOYMENT_TYPE_CLUSTER = 'cluster'
DEPLOYMENT_TYPE_STANDALONE = 'standalone'
DEPLOYMENT_TYPE_HA = 'ha'
CLUSTER_CCO = 'Cluster CCO'
CLUSTER_NONCCO = 'Cluster Non-CCO'
HA_PRIMARY = 'HA Primary'
HA_SECONDARY = 'HA Secondary'
STANDALONE = 'Standalone Primary'
PRIMARY = 'Primary'
NOT_APPLICABLE = 'NA'
DISABLED = 'DISABLED'
ENABLED = 'ENABLED'
LOCAL_TYPE = 'local'
POOLED_TYPE = 'pooled'
SNO_IDENTIFIER = 'SN='
NOTICE_IDENTIFIER = 'NOTICE='
INTERNAL_NOTICE_VALUE_1 = 'Citrix Systems, Inc.'
INTERNAL_NOTICE_VALUE_2 = 'Citrix Systems Inc.'
ERROR_TYPE_HDD_ERROR = 'HDD_Error'
ERROR_TYPE_PSU_FAILURE = 'PSU_Failure'
ERROR_TYPE_SSL_FAILURE = 'SSL_Failure'
ERROR_TYPE_WARM_RESTART = 'Warm_Restart'
ERROR_TYPE_MEMORY_ANOMALY = 'Memory_Anomaly'
PSU_FAILED = 'FAILED'
PSU_FAILED_MAX_LIMIT = 3
MEM_MONITOR_LOW_LIMIT = 70.0
MEM_MONITOR_HIGH_LIMIT = 90.0
MEM_INCREASE_COUNT_LIMIT = 12
MEM_USAGE_CHECK_FREQUENT_LIMIT = 24
IGNORE_FIRST_FAILED_PROBE_COUNT = 3
LOG_FORMAT_STR = '%(asctime)s %(levelname)5s : %(funcName)s() %(lineno)d : %(message)s'
SYSCTL_CMD = 'sysctl -n'
NSCLI_CMD = '/netscaler/nscli -U %%:.:.'
CLICMDNITRO_EXEC = 'clicmdnitro -execute -clicmd'
HYPERVISER_LIST = ["None", "Xen", "ESX", "HyperV", "KVM", "AWS"]
CLOUD_LIST = ["None", "AWS", "None", "AZURE", "GCP"]
CLUSTER_CCO_LIST = ['*', 'Configuration Coordinator']
AUTOMATION_USER_AGENTS = {"Ansible": "ansible-ctxadc", "Terraform": "terraform-ctxadc", "NITRO-Python": "nitropython-ctxadc", "NITRO-Java": "nitrojava-ctxadc", "NITRO-Dotnet": "nitrodotnet-ctxadc"}
AUTOMATION_LOG_FILE='/var/log/httpaccess.log'
NS_LOG_DIR = '/var/log/'
CRITICAL_EVENT_LIST = ['HDD_Error','PSU_Failure','SSL_Failure','Warm_Restart','Memory_Anomaly']
DEVELOPER_KEY_CHECK = ['device_info', 'device_events','device_license']
LICENSE_KEYS = {'lic_sno','lic_type'}
CRITICAL_EVENT_KEYS = {'error_type','utc_time'}
DEVELOPER_MAIN_PROBE = "main_probe"
DEVELOPER_LIGHT_PROBE = "light_probe"
LIGHT_PROBE_KEY = ['serial_id', 'host_id']
FILE_PERMISSION_CODE = 0o600
VERSION_13_0 = '13.0'
VERSION_13_1 = '13.1'
VERSION_12_1 = '12.1'
VERSION_14_1 = '14.1'
BUILD_39_7 = 39.7
BUILD_58_0 = 58.0
VPX_LAS_INFO_FILE = '/nsconfig/license/.laslicinfo'
SVM_LAS_INFO_FILE = '/mpsconfig/license/.laslicinfo'
############################################################
## Commands to check if there are any Hard disk failure   ##
## errors or Compact Flash errors or warm restart due to  ##
## PE crash based on the logfile messages.                ##
## Exit values:                                           ##
##	  0 : No errors/PE crash found                        ##
##	  1 : HDD errors found                                ##
##	  2 : CF errors found                                 ##
## 	  3 : both HDD and CF errors found                    ##
## 	  4 : Warm restart due to PE crash                    ##
##	100 : Internal/processing errors                      ##
############################################################
CHECK_DISK_FAILURE_CMD = '/netscaler/ns_monuploadd_err.pl -HDDCF'
CHECK_PE_FAILURE_CMD = '/netscaler/ns_monuploadd_err.pl -WR'
EXIT_CODE_NO_ERRORS = 0
EXIT_CODE_HDD_ERRORS = 1
EXIT_CODE_CF_ERRORS = 2
EXIT_CODE_HDD_CF_ERRORS = 3
EXIT_CODE_PE_CRASH_ERRORS = 4
EXIT_CODE_INTERNAL_ERRORS = 100
############################################################

############################################################
## Parameters defined to communicate with nslped(C)       ##
## daemon to get pooled license Serial Numbers.           ##
## Request and response structure parameters expected by  ##
## nslped(C) daemon is defined in following C header file.##
## File: usr.src/netscaler/triscale/lped/nslped.h         ##
############################################################
NS_LPE_MAX_SERVER_NAME_LEN_32 = 32
# NSCONFIG-3269: NS_LPE_MAX_SERVER_NAME_LEN increased from 32 to 256
NS_LPE_MAX_SERVER_NAME_LEN_256 = 256
NS_LPE_MAX_CLIENTHOSTNAME_LEN = 128
NS_LPE_MAX_PROD_LEN = 32
NSLPE_MAX_STR = 128
NSLPED_SOCK = '/tmp/.nslped_sock'
LPE_CMD_INVENTORY_FILTERED = 11
LPE_POOL_INSTANCE = 54
LIC_MODE = 127
############################################################

# SYSTEM Files
NSCONF = '/nsconfig/ns.conf'
TMP_NSCONF = '/var/tmp/ns.conf.admautoreg'
ADM_AUTOREG_STATE_FILE = '/nsconfig/admautoreg.state'
ADM_AUTOREG_LOG_FILE = '/var/log/admautoreg.log'
ADM_CERT_BUNDLE_FILE='/var/mastools/cert/cacert.pem'
ADMPARAM_CONF_FILE='/nsconfig/admparam.conf'
MASTOOLS_AGENT_CONF_FILE='/var/mastools/conf/agent.conf'
MASTOOLS_INIT_STATUS='/var/mastools/conf/mastools_init.status'
ADC_LOCAL_LICENSE_FILES = '/nsconfig/license/*.lic'
DEVELOPER_CONF_FILE = '/var/mastools/scripts/admautoreg/.developer_config.json'
ADM_AUTOREG_INTERNAL_FILE = '/nsconfig/.internal'
RESOLV_CONF_FILE = '/etc/resolv.conf'

# Internal auto registration nameserver
INTERNAL_AUTOREG_NAMESERVER = '8.8.8.8'

# SVM Auto reg stat file
SVM_ADM_AUTOREG_STATE_FILE = '/mpsconfig/admautoreg.state'
SVM_LOCAL_LICENSE_FILES = '/mpsconfig/license/*.lic'

# CLI Commands
SHOW_HARDWARE = 'sh hardware'
SHOW_NSIP = 'sh nsip -type NSIP'
SHOW_HOSTNAME = 'sh hostName'
SHOW_VERSION = 'sh ver'
SHOW_LICENSE = 'sh license'
SHOW_NSFEATURE = 'sh ns feature'
SHOW_NSMODE = 'sh ns mode'
SHOW_HANODE = 'sh ha node'
SHOW_LICENSESERVER = 'sh licenseserver'
SHOW_CLUSTER_NODE = 'sh cluster node'
SHOW_NSIP_CLIP = 'sh nsip -type CLIP'
SHOW_CALLHOME = 'sh callhome'
SHOW_SERVICE_BY_NAME = 'sh service {}'

STAT_NS = 'stat ns -fullValues'
STAT_SSL = 'stat ssl -fullValues'
STAT_SYSTEM = 'stat system -detail'
STAT_MEMORY = 'stat system memory -fullValues'


# Registration commands
MASTOOLS_INIT_ADC = '/var/mastools/scripts/mastools_init.sh %s %s "%s" -profile &'
MASTOOLS_INIT_SDX = '/var/mastools/scripts/mastools_init.sh %s %s "%s" -sdx -profile &'
MASTOOLS_INIT_BLX = '/var/mastools/scripts/mastools_init.sh %s %s "%s" -blx -profile &'
ADD_CENTRALMGMTSRV = 'add ns centralmanagementserver %s %s -IPAddress %s -validateCert NO -deviceProfileName %s'
CLI_ERROR = 'ERROR'

# CLI Output Strings
SERIAL_NO = 'Serial no'
ENCODED_SERIAL_NO = 'Encoded serial no'
HOST_ID = 'Host Id'
NS_UUID = 'Netscaler UUID'
MASTER_STATE = 'Master State'
UP_SINCE = 'Up since'
PACKET_CPU_PER = 'Packet CPU usage (%)'
MGMT_CPU_PER = 'Management CPU usage (%)'
MEMORY_PER = 'InUse Memory (%)'
MEGABITS_TX = 'Megabits transmitted'
NEW_SSL_SESSIONS = 'New SSL sessions'
BYTES_ENC = 'Bytes encrypted'
BYTES_DEC = 'Bytes decrypted'
NUMBER_OF_SSL_CARDS_PRESENT = '# SSL cards present'
NUMBER_OF_SSL_CARDS_UP = '# SSL cards UP'
SYSHEALTH_PS1FAIL = 'Power supply 1 status'
SYSHEALTH_PS2FAIL = 'Power supply 2 status'
SYSHEALTH_PS3FAIL = 'Power supply 3 status'
SYSHEALTH_PS4FAIL = 'Power supply 4 status'


# SYSCTL Commands Input
NS_HYPERVISER = 'netscaler.hypervised_ns'
NS_CLOUD = 'netscaler.vpx_on_cloud'
NS_SYSID = 'netscaler.sysid'
NS_DESCR = 'netscaler.descr'
NS_SDXVPX = 'netscaler.sdxvpx'


# License Codes
licenseCode = {'Web Logging': 'wl', 'Surge Protection': 'sp', 'Load Balancing': 'lb', 'Content Switching': 'cs', 'Cache Redirection': 'cr', 'Sure Connect': 'sc', 'Compression Control': 'cmp', 'Delta Compression': 'delta', 'Priority Queuing': 'pq', 'SSL Offloading': 'ssl', 'Global Server Load Balancing': 'gslb', 'GSLB Proximity': 'gslbp', 'Http DoS Protection': 'hdosp', 'Dynamic Routing': 'routing', 'Content Filtering': 'cf', 'Content Accelerator': 'contentaccelerator', 'Integrated Caching': 'ic', 'SSL VPN': 'sslvpn', 'AAA': 'aaa', 'OSPF Routing': 'ospf', 'RIP Routing': 'rip', 'BGP Routing': 'bgp', 'Rewrite': 'rewrite', 'IPv6 protocol translation': 'ipv6pt', 'Application Firewall': 'appfw', 'Responder': 'responder', 'HTML Injection': 'htmlinjection', 'NetScaler Push': 'push', 'Web Interface on NS': 'wionns', 'AppFlow': 'appflow', 'CloudBridge': 'cloudbridge', 'ISIS Routing': 'isis', 'Clustering': 'cluster', 'CallHome': 'ch', 'AppQoE': 'appqoe', 'Appflow for ICA': 'appflowica', 'RISE': 'rise', 'Front End Optimization': 'feo', 'Large Scale NAT': 'lsn', 'RDP Proxy': 'rdpproxy', 'Reputation': 'rep', 'URL Filtering': 'urlfiltering', 'Video Optimization': 'videooptimization', 'Forward Proxy': 'forwardproxy', 'SSL Interception': 'sslinterception', 'Remote Content Inspection': 'remotecontentinspection', 'Adaptive TCP': 'adaptivetcp', 'Connection Quality Analytics': 'cqa', 'Bot Management': 'bot', 'API Gateway': 'apigateway'}

#SVM contstants
SVM_NOT_APPLICABLE = ''
SVM_PLATFORM_TYPE = 'SDX'

SVM_SERIAL_ID = 'netscaler.serial'
SVM_HOST_ID_CMD = '/netscaler/lmutil hostid'
SVM_MGMT_IP_CMD = '/bin/sh /var/mastools/scripts/mastools_sdx_ip.sh'
SVM_HOST_NAME = 'kern.hostname'
SVM_BUID_INFO = 'netscaler.version'
SVM_SYS_ID = 'netscaler.sysid'
SVM_PLATFORM_DESCR = 'netscaler.descr'


#ADC diag command
ADC_DIAG_COMMAND = 'sh /var/mastools/scripts/mastools_diag print'

ADC_DIAG_KEYWORD = 'device_diag'

DRY_RUN_STATUS_FILE = '/var/mastools/conf/mastools_dry_run_status'
DRY_RUN_COMMAND = 'sh /var/mastools/scripts/mastools_dry_run %s %s "%s" %s print &'

#ADC Lodestone test file related enums
ADC_LODESTONE_TEST_FILE = '/var/mastools/adc_lodestone_test.json'
ADC_LODESTONE_TEST_SERIAL_ID = 'serial_id'
ADC_LODESTONE_TEST_EP = 'endpoint'

REMOVE_CORE_DUMP_CMD = 'rm -rf  /var/core/mastools-* & rm -rf  /var/core/*/mastools-*'

ONPREM_CLOUD_TYPE = 0
AWS_CLOUD_TYPE = 1
AZURE_CLOUD_TYPE = 3
GCP_CLOUD_TYPE = 4

# Metadata URL to fetch data for AWS, Azure and GCP
# In the cloud VM,  169.254. 169.254 used to retrieve user data and instance metadata specific to an instance
AWS_METADATA_URL = 'http://169.254.169.254/latest/dynamic/instance-identity/document'
AZURE_METADATA_URL = 'http://169.254.169.254/metadata/instance?api-version=2021-02-01'
GCP_METADATA_URL = 'http://169.254.169.254/computeMetadata/v1/?recursive=true&alt=json'

GCP_METADATA_HEADER = {"Metadata-Flavor": "Google"}
AZURE_METADATA_HEADER = {"Metadata": "true"}

STOP_MASTOOLS_CMD = "/var/mastools/scripts/mastoolsd stop"
RESTART_MASTOOLS_CMD = "/var/mastools/scripts/mastoolsd restart"
REMOVE_AGENT_CONF_CMD = "rm -rf  /var/mastools/conf/agent.conf"
REMOVE_PREV_INST_CMD = "rm -rf  /var/mastools/conf/prev_inst"
REMOVE_MASTOOL_INIT_STATUS_CMD = "rm -rf  /var/mastools/conf/mastools_init.status"

INTERNAL_NS_PROBE_WAIT_TIME_MIN = 30*60
INTERNAL_NS_PROBE_WAIT_TIME_MAX = 45*60

INTERNAL_NS_ADM_SVC_API_WAIT_TIME_MIN = 10*60
INTERNAL_NS_ADM_SVC_API_WAIT_TIME_MAX = 20*60

MASTOOLS_REGISTRATION_TIMEOUT = 30*60

OTP_SERVICE = "10.106.150.168:5000"
CREATE_OTP_URL = "/create-otp"


