#!/usr/bin/env python3
#
# Copyright 2020-2025 Citrix Systems, Inc. All rights reserved.
# This software and documentation contain valuable trade
# secrets and proprietary property belonging to Citrix Systems, Inc.
# None of this software and documentation may be copied,
# duplicated or disclosed without the express
# written permission of Citrix Systems, Inc.
#
# -*- coding: utf-8 -*-


import argparse
import subprocess
import os, sys
import logging
import logging.handlers
import psycopg2

if sys.version_info[0] < 3: 
    # Python 2
    import ConfigParser as configparser
    import StringIO as io
else:
    # Python 3
    import configparser

import cloud_constants as const


log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
isMastools = True
BASE_PATH = '/var/mastools/scripts/'


LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

class bcolors:
    OK = '\033[92m' #GREEN
    WARNING = '\033[93m' #YELLOW
    FAIL = '\033[91m' #RED
    RESET = '\033[0m' #RESET COLOR

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)
#======================================================================================================================================================

# this nees to update with env variable  
def addJapanOption(cloudOption):
    configWriter = configparser.ConfigParser()
    configWriter['region'] = {'cloudOption':'japan'}
    with open(BASE_PATH + const.CLOUD_SERVICE_FILE, 'w') as file:
        configWriter.write(file)
    print(bcolors.OK+ 'Cloud connectivity being set to Japan Cloud')
    logger.debug('Added Japan cloud option to the file')
    
def restartService():
    try:
        subprocess.run(['/var/mastools/scripts/mastoolsd', 'restart'], check=True)
        logger.debug('Mastools service restarted')
        subprocess.run(['/bin/sh', '/var/mastools/scripts/admautoreg/admautoregd_ctl', 'restart_if_running'], check=True)
        logger.debug('AdmAutoreg service restarted')                
    except subprocess.CalledProcessError as e:
        print (bcolors.FAIL+ 'Error while restarting  Mastools and AdmAutoReg service: ', e)
        logger.error('Error while restarting  Mastools and AdmAutoReg service: ', e)

def isDeviceInJapanCloud():
    japanCloud = False
    if os.path.isfile(const.CLOUD_SERVICE_FILE):
        with open(const.CLOUD_SERVICE_FILE, 'r') as file:
            for line in file:
                if const.JP_CLOUD_OPTION in line:
                    japanCloud = True
                    break
    return japanCloud

def checkCloudOption():
    if os.path.isfile(BASE_PATH + const.CLOUD_SERVICE_FILE):
        configReader = configparser.ConfigParser()
        if sys.version_info[0] < 3:
            configReader.readfp(io.StringIO(config_string))
        else:
            configReader.read(BASE_PATH + const.CLOUD_SERVICE_FILE)
        if 'region' in configReader.sections():
            if configReader['region']['cloudoption'] == const.JP_CLOUD_OPTION:
                return const.JP_NETWORK_TEST_EP
    return const.NETWORK_TEST_EP

if __name__ == '__main__':
    # read the runtime paramaters
    parser = argparse.ArgumentParser()
    parser.add_argument('-y', action='store_true', help='Japan cloud option to be added "-y"')
    args = parser.parse_args()
    if args.y:
        addJapanOption('japan')
        logger.debug('Japan cloud option added to the file')
    restartService()
    print(bcolors.RESET+'Cloud selection : Done ')