#!/usr/local/bin/python
##
##Copyright (c) 2008-2025 Citrix Systems, Inc.
##
import unicodedata
import datetime
import uuid
import httplib2
import argparse
import sys
import ast
import re
import os
import stat
import pwd
import grp
from ctypes import *
import ctypes
from os import environ
from os import path
import subprocess
import warnings
import requests
import xml.etree.ElementTree as ET
import yaml
import codecs
from botocore.exceptions import ClientError

is_container = False
if os.path.exists("/mpsconfig/container.conf"):
    is_container = True

if os.system("uname -n|grep frontend") == 0:
    is_container = False

is_mastools = False
if os.path.exists("/var/mastools"):
    is_mastools = True

if is_mastools: 
    sys.path.insert(0 ,"/var/mastools/scripts/pythonlib/boto3-1.7.70-py3.9.egg/")
else:
    import urllib.parse
import boto3

is_grp_container = False
if os.path.exists("/GRP"):
    is_grp_container = True

import shlex

if sys.version_info[0] < 3: 
    # Python 2
    import ConfigParser as configparser
    import StringIO as io
else:
    # Python 3
    import configparser

try:
    from ccauth import *
    from ccauth.crypto import *
    from ccauth.security import *
    from ccauth import newkeypair
except Exception as e:
    pass
from Crypto.PublicKey import RSA
from Crypto.Util import number
from base64 import standard_b64encode, b64decode
import json
import base64
import json, ast
import binascii
import struct
from multiprocessing import Process
import smtplib
import email.utils
from email.mime.multipart import MIMEMultipart
from email.mime.image import MIMEImage
from email.mime.text import MIMEText
from jinja2 import Environment, FileSystemLoader
import time
import logging
import logging.handlers
from logging.handlers import SysLogHandler
from logging.handlers import RotatingFileHandler

from calendar import timegm

if is_container:
    import pg8000
    from azure.servicebus.control_client import ServiceBusService, Message, Topic, Rule, DEFAULT_RULE_NAME
else:
    if not is_mastools:
        import psycopg2

if os.system("uname -n|grep frontend") == 0:
    from azure.servicebus.control_client import ServiceBusService, Message, Topic, Rule, DEFAULT_RULE_NAME

import subprocess
import time
from threading import Thread

if not is_mastools:
    import psycopg2.extensions
from Crypto.Util.asn1 import DerSequence
from Crypto.PublicKey import RSA
from binascii import a2b_base64
from os.path import basename, exists
from xml.dom import minidom

MGMT_MONIT_HOST = os.environ["MGMT_MONIT_HOST"] if "MGMT_MONIT_HOST" in os.environ else "127.0.0.1"
PGXL_DB_CONFIG_PATH = '/mpsconfig/db_connection_str.conf'
TELEMETRY_ENDPOINT_INFO_PATH = '/mpsconfig/telemetry_cloud.conf'
CERT_BUNDLE_PATH = '/mps/cacert.pem'
SERVICE_VIP_SKU = '000000000002003363'
SERVICE_STORAGE_SKU = '000000000002003365'
SERVICE_TP_SKU = '000000000002003364'
SERVICE_FREE_SKU = 'admfreemium'
SERVICE_AZ_PU_SKU = '1000009-NONE-VSVR-E-A-AZPU'
SERVICE_AZ_PU_STORAGE_SKU = '1000023-NONE-NONE-E-A-AZPU'
SERVICE_TRIAL_SKU = 'mastechpreview'
ENT_TYPE_PROD = 'ProductionTrial'
log_file_name_local = os.path.basename(__file__)
if is_mastools:
    LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
    BASE_PATH = '/var/mastools/'
elif is_grp_container:
    LOG_FILENAME = '/var/mps/log/' + log_file_name_local + '.log'
else:
    LOG_FILENAME = '/var/mps/log/' + log_file_name_local + '.log'
    BASE_PATH = '/mpsconfig/'
LOG_MAX_BYTE = 10 * 1024 * 1024
LOG_BACKUP_COUNT = 20
DEFAULT_VIPS_PER_SKU = 10
DEFAULT_STORAGE_PER_SKU = 5
DEFAULT_STORAGE_PER_VIP = 0.5
DEFAULT_TP_STORAGE_PER_SKU = 1
DEFAULT_TPVIPS_PER_SKU = 10
DEFAULT_VIPS_PER_FREE_SKU = 2
DEFAULT_STORAGE_PER_FREE_SKU = 0.5
ADS_TRIAL_VIPS_PER_SKU = 2
ADS_TRIAL_STORAGE = 0.5
ADS_DEFAULT_STORAGE_PER_VIP = 0.5
ADS_DEFAULT_STORAGE_PER_SKU = 5
FREE_LICENSE_TYPE = 6
FREE_ENT_TYPE = "Freemium"
TRIAL_SUBSCRIPTION = 60
SUBSCRIPTION1 = 365
ERROR_TOO_FEW_ARGS = '{ "errorcode" : 10007 , "message" : "Error: too few arguments" }'
ERROR_UNSUPPORTED_CMD = '{ "errorcode" : 10007 , "message" : "Error: Command not supported through IPC" }'
url_cwc_worker = "inproc://cwc_workers"
url_client = "ipc:///tmp/mps/ipc_sockets/cwcutil_client_sock"
SERVICE_PROFILE_CONF = '/mpsconfig/citrix_cloud_sp.json'
ADM_TELEMETRY_CONF = '/mpsconfig/adm_telemetry_cloud.conf'
CAS_CONF = '/mpsconfig/cas_server_info.conf'
CREATE_PENDING_TENANT_FILE = '/var/mps/create_tenant_pending.txt'
CLOUD_CONF = '/mpsconfig/cloud.conf'
AGENT_CONF = '/mpsconfig/agent.conf'
CREATE_PENDING_TENANT_IN_PROGRESS_FILE = '/var/mps/tenants/root/creatingPendingTenantsInProgress.conf'
LOCAL_CREATE_PENDING_TENANT_IN_PROGRESS_FILE = '/var/mps/localCreatePendingTenantsInProgress.conf'
IS_GRP_FILE = '/mpsconfig/pop_info.conf'
CRYPTO_LIB = '/mps/lib/libmps_crypto.so'
CWS_TRUST_PVT_KEY = "/mpsconfig/trust/.ssh/privatecws.pem"
TRUST_PVT_KEY = "/mpsconfig/trust/.ssh/private.pem"
EMAIL_TEMPLATE_DIR = "/mps/email_templates"
if is_mastools:
    CWS_TRUST_PVT_KEY = "/var/mastools/trust/.ssh/privatecws.pem"
    TRUST_PVT_KEY = "/var/mastools/trust/.ssh/private.pem"
else:
    CWS_TRUST_PVT_KEY = "/mpsconfig/trust/.ssh/privatecws.pem"
    TRUST_PVT_KEY = "/mpsconfig/trust/.ssh/private.pem"

# Citrix Cloud Info constants
CC_TENANT_CUSTID = "customer_id"
CC_TENANT_GEO = "geo"
CC_TENANT_EMAIL = "createdByEmail"
CC_TENANT_ERRCODE = "errorcode"
CC_TENANT_MSG = "message"
CC_TENANT_DEF_GEO = "NONE"

# CC region info
CC_REGION_DEF = "DEFAULT"
CC_REGION_EU = "EU"
CC_REGION_APS = "AP-S"
CC_REGION_JP = "JP"
CC_CAS_SVC = "CAS_SVC_HOST"

CLOUD_SERVICE_FILE = 'cloudService.properties'



DEFAULT = 'default'
JAPAN = 'japan'
FQDN = 'fqdn'
AGENT = 'agent'
DOWNLOAD = 'download'
SAFEHAVEN = 'safehaven'
ADM_TRUST = "trust"
ADM_SVC = "adm_svc"
CC_URL = 'cc_url;'
TRUST = 'trust'

ENDPOINTS = {
    DEFAULT : {
        TRUST :"https://trust.citrixnetworkapi.net/", 
        CC_URL : "https://core.citrixworkspacesapi.net/"
    },
    JAPAN : {
        TRUST : "https://trust.citrixnetworkapi.jp/",
        CC_URL : "https://core.citrixworkspacesapi.jp/"
        }

}

is_initialized = False
is_multi_db = False
is_grp = False
if os.path.exists(IS_GRP_FILE):
    is_grp = True
# Syslog constants
# File containing details of the syslog server to which NetScaler Console has to send syslogs to
SYSLOG_SERVER_CONF = '/mpsconfig/syslog_server.conf'
SYSLOG_MAS_SERVER_TAG = 'SERVER'
# Set up a specific logger with our desired output level

#======================================================================================================================================================================
class RotatingFileHandlerWithPerms(RotatingFileHandler):
    """
    Custom RotatingFileHandler that enforces permissions (e.g. 0o666)
    only after log rotation.
    """
    def __init__(self, *args, permissions=0o666, **kwargs):
        self.permissions = permissions
        os.umask(0)
        super().__init__(*args, **kwargs)
        # Set permissions once at startup
        self._set_perms_once()

    def doRollover(self):
        """Perform rollover and set permissions only after rotation."""
        super().doRollover()
        self._set_perms_once()

    def _set_perms_once(self):
        """Set file permissions only once (on creation or rotation)."""
        try:
            if os.path.exists(self.baseFilename):
                os.chmod(self.baseFilename, self.permissions)
        except Exception as e:
            pass 


# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = RotatingFileHandlerWithPerms(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT, permissions=0o666)
logger_fortmater = logging.Formatter(fmt='%(asctime)s [%(levelname)s] [%(processName)s] %(process)d [%(funcName)s:%(lineno)d]: %(message)s')
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)
#==========================================================================================================================================================================
warnings.filterwarnings("ignore")

class cwcUtil:

    def __init__(self):
        self.isCloud = True if os.path.isfile(SERVICE_PROFILE_CONF) else False
        if not is_mastools:
            psycopg2.extensions.register_type(psycopg2.extensions.UNICODE)
            psycopg2.extensions.register_type(psycopg2.extensions.UNICODEARRAY)
        self.routeTemplate = ''
        self.serviceName = ""
        self.privateKey = ""
        self.service_profile_dict = {}
        self.products = {}
        self.skuNameId = {}
        self.skuList = {}
        if ((self.isCloud) and (os.path.exists(AGENT_CONF) == False)):
            self.serviceName = self.getServiceName()
            self.privateKey = self.getPrivateKey()
            with open(SERVICE_PROFILE_CONF) as data_file:
                self.service_profile_dict = json.load(data_file)
                self.products = self.service_profile_dict["ResourceProviders"][0]["Products"]
            if "ADS_SERVICE_TYPE" in os.environ:
                self.ads_service_type = os.environ["ADS_SERVICE_TYPE"]
            else:
                self.ads_service_type = "ADM"
            self.getSkuNameIdDict()
        self.ccAuthHandle = self.getCCAuthHandle()
        self.CASSvcHost = {}

    def is_ads_service_type_adm(self):
        try:
            return "ADM" == self.ads_service_type
        except :
            return False
    
    def is_ads_service_type_automation(self):
        try:
            return "AUTOMATION" == self.ads_service_type
        except:
            return False

    def is_ads_service_type_intent(self):
        try:
            return "INTENT" == self.ads_service_type
        except:
            return False

    def getSkuNameIdDict(self):
        self.skuList["INTENT"] = []
        self.skuList["AUTOMATION"] = []
        self.skuList["ADM"] = []
        self.skuNameId["trial"] = self.get_adm_trial_skuId()
        self.skuNameId["vips"] = self.get_adm_vips_skuId()
        self.skuNameId["storage"] = self.get_adm_storage_skuId()
        self.skuNameId["tpvips"] = self.get_adm_tp_skuId()
        self.skuNameId["freemium"] = self.get_adm_freemium_skuId()
        self.skuNameId["azpu"] = self.get_adm_azpu_skuId()
        self.skuNameId["azpustorage"] = self.get_adm_azpustorage_skuId()
        self.skuNameId["intenttrial"] = self.get_ads_intent_trial_skuId()
        self.skuNameId["autotrial"] = self.get_ads_automation_trial_skuId()
        self.skuNameId["intentadvance"] = self.get_ads_intent_advance_skuId()
        self.skuNameId["intentpremium"] = self.get_ads_intent_premium_skuId()
        self.skuNameId["intentdns"] = self.get_ads_intent_dns_skuId()
        self.skuNameId["autovips"] = self.get_ads_automation_vips_skuId()
        self.skuNameId["autostorage"] = self.get_ads_automation_storage_skuId()
        self.skuNameId["intentadvance3t2m"] = self.get_ads_intent_advance_3t2m_skuId()
        self.skuNameId["intentpremium3t2m"] = self.get_ads_intent_premium_3t2m_skuId()
        self.skuNameId["intentadvance1t1m"] = self.get_ads_intent_advance_1t1m_skuId()
        self.skuNameId["intentpremium1t1m"] = self.get_ads_intent_premium_1t1m_skuId()
        self.skuNameId["intentadvance4t4m"] = self.get_ads_intent_advance_4t4m_skuId()
        self.skuNameId["intentpremium4t4m"] = self.get_ads_intent_premium_4t4m_skuId()
        self.skuNameId["intentadvance2t2b"] = self.get_ads_intent_advance_2t2b_skuId()
        self.skuNameId["intentpremium2t2b"] = self.get_ads_intent_premium_2t2b_skuId()
        self.skuNameId["intentdns1bdq"] = self.get_ads_intent_dns_1bdq_skuId()
        self.skuNameId["intentpremiumbundled"] = self.get_ads_intent_premium_bundled_skuId()
        self.skuNameId["autocitrixcloudtrigger"] = self.get_ads_automation_citrix_cloud_trigger_skuId()
        self.skuNameId["CPL"] = "1000267-NONE-NONE-T"
        self.skuNameId["CUL"] = "1000268-NONE-NONE-T"

    def get_adm_trial_skuId(self):
        try:
            return self.skuNameId["admTrialSkuId"]
        except KeyError:
            if ((self.is_ads_service_type_adm()) and (0 < len(self.products)) and ("ProductSku" in self.products[0])):
                self.skuNameId["admTrialSkuId"] = str(self.products[0]["ProductSku"])
            else:
                self.skuNameId["admTrialSkuId"] = None
            self.skuList["ADM"].append(self.skuNameId["admTrialSkuId"])
            return self.skuNameId["admTrialSkuId"]

    def get_adm_vips_skuId(self):
        try:
            return self.skuNameId["admVipsSkuId"]
        except KeyError:
            if ((self.is_ads_service_type_adm()) and (1 < len(self.products)) and ("ProductSku" in self.products[1])):
                self.skuNameId["admVipsSkuId"] = str(self.products[1]["ProductSku"])
            else:
                self.skuNameId["admVipsSkuId"] = None
            self.skuList["ADM"].append(self.skuNameId["admVipsSkuId"])
            return self.skuNameId["admVipsSkuId"]

    def get_adm_storage_skuId(self):
        try:
            return self.skuNameId["admStorageSkuId"]
        except KeyError:
            if ((self.is_ads_service_type_adm()) and (2 < len(self.products)) and ("ProductSku" in self.products[2])):
                self.skuNameId["admStorageSkuId"] = str(self.products[2]["ProductSku"])
            else:
                self.skuNameId["admStorageSkuId"] = None
            self.skuList["ADM"].append(self.skuNameId["admStorageSkuId"])
            return self.skuNameId["admStorageSkuId"]

    def get_adm_tp_skuId(self):
        try:
            return self.skuNameId["admTPSkuId"]
        except KeyError:
            if ((self.is_ads_service_type_adm()) and (3 < len(self.products)) and ("ProductSku" in self.products[3])):
                self.skuNameId["admTPSkuId"] = str(self.products[3]["ProductSku"])
            else:
                self.skuNameId["admTPSkuId"] = None
            self.skuList["ADM"].append(self.skuNameId["admTPSkuId"])
            return self.skuNameId["admTPSkuId"]

    def get_adm_freemium_skuId(self):
        try:
            return self.skuNameId["admFreemiumSkuId"]
        except KeyError:
            if ((self.is_ads_service_type_adm()) and (4 < len(self.products)) and ("ProductSku" in self.products[4])):
                self.skuNameId["admFreemiumSkuId"] = str(self.products[4]["ProductSku"])
            else:
                self.skuNameId["admFreemiumSkuId"] = None
            self.skuList["ADM"].append(self.skuNameId["admFreemiumSkuId"])
            return self.skuNameId["admFreemiumSkuId"]

    def get_adm_azpu_skuId(self):
        try:
            return self.skuNameId["admAzpuSkuId"]
        except KeyError:
            if ((self.is_ads_service_type_adm()) and (5 < len(self.products)) and ("ProductSku" in self.products[5])):
                self.skuNameId["admAzpuSkuId"] = str(self.products[5]["ProductSku"])
            else:
                self.skuNameId["admAzpuSkuId"] = None
            self.skuList["ADM"].append(self.skuNameId["admAzpuSkuId"])
            return self.skuNameId["admAzpuSkuId"]

    def get_adm_azpustorage_skuId(self):
        try:
            return self.skuNameId["admAzpustorageSkuId"]
        except KeyError:
            if ((self.is_ads_service_type_adm()) and (6 < len(self.products)) and ("ProductSku" in self.products[6])):
                self.skuNameId["admAzpustorageSkuId"] = str(self.products[6]["ProductSku"])
            else:
                self.skuNameId["admAzpustorageSkuId"] = None
            self.skuList["ADM"].append(self.skuNameId["admAzpustorageSkuId"])
            return self.skuNameId["admAzpustorageSkuId"]

    def get_ads_intent_trial_skuId(self):
        try:
            return self.skuNameId["adsIntentTrialSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (0 < len(self.products)) and ("ProductSku" in self.products[0])):
                self.skuNameId["adsIntentTrialSkuId"] = str(self.products[0]["ProductSku"])
            else:
                self.skuNameId["adsIntentTrialSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentTrialSkuId"])
            return self.skuNameId["adsIntentTrialSkuId"]


    def get_ads_automation_trial_skuId(self):
        try:
            return self.skuNameId["adsAutoTrialSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (1 < len(self.products)) and ("ProductSku" in self.products[1])):
                self.skuNameId["adsAutoTrialSkuId"] = str(self.products[1]["ProductSku"])
            else:
                self.skuNameId["adsAutoTrialSkuId"] = None
            self.skuList["AUTOMATION"].append(self.skuNameId["adsAutoTrialSkuId"])
            return self.skuNameId["adsAutoTrialSkuId"]


    def get_ads_intent_advance_skuId(self):
        try:
            return self.skuNameId["adsIntentAdvanceSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (2 < len(self.products)) and ("ProductSku" in self.products[2])):
                self.skuNameId["adsIntentAdvanceSkuId"] = str(self.products[2]["ProductSku"])
            else:
                self.skuNameId["adsIntentAdvanceSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentAdvanceSkuId"])
            return self.skuNameId["adsIntentAdvanceSkuId"]


    def get_ads_intent_premium_skuId(self):
        try:
            return self.skuNameId["adsIntentPremiumSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (3 < len(self.products)) and ("ProductSku" in self.products[3])):
                self.skuNameId["adsIntentPremiumSkuId"] = str(self.products[3]["ProductSku"])
            else:
                self.skuNameId["adsIntentPremiumSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentPremiumSkuId"])
            return self.skuNameId["adsIntentPremiumSkuId"]  


    def get_ads_intent_dns_skuId(self):
        try:
            return self.skuNameId["adsIntentDnsSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (4 < len(self.products)) and ("ProductSku" in self.products[4])):
                self.skuNameId["adsIntentDnsSkuId"] = str(self.products[4]["ProductSku"])
            else:
                self.skuNameId["adsIntentDnsSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentDnsSkuId"])
            return self.skuNameId["adsIntentDnsSkuId"]


    def get_ads_automation_vips_skuId(self):
        try:
            return self.skuNameId["adsAutoVipsSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (5 < len(self.products)) and ("ProductSku" in self.products[5])):
                self.skuNameId["adsAutoVipsSkuId"] = str(self.products[5]["ProductSku"])
            else:
                self.skuNameId["adsAutoVipsSkuId"] = None
            self.skuList["AUTOMATION"].append(self.skuNameId["adsAutoVipsSkuId"])
            return self.skuNameId["adsAutoVipsSkuId"]


    def get_ads_automation_storage_skuId(self):
        try:
            return self.skuNameId["adsAutoStorageSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (6 < len(self.products)) and ("ProductSku" in self.products[6])):
                self.skuNameId["adsAutoStorageSkuId"] = str(self.products[6]["ProductSku"])
            else:
                self.skuNameId["adsAutoStorageSkuId"] = None
            self.skuList["AUTOMATION"].append(self.skuNameId["adsAutoStorageSkuId"])
            return self.skuNameId["adsAutoStorageSkuId"]

    def get_ads_intent_advance_3t2m_skuId(self):
        try:
            return self.skuNameId["adsIntentAdvance3T2MSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (7 < len(self.products)) and ("ProductSku" in self.products[7])):
                self.skuNameId["adsIntentAdvance3T2MSkuId"] = str(self.products[7]["ProductSku"])
            else:
                self.skuNameId["adsIntentAdvance3T2MSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentAdvance3T2MSkuId"])
            return self.skuNameId["adsIntentAdvance3T2MSkuId"]

    def get_ads_intent_premium_3t2m_skuId(self):
        try:
            return self.skuNameId["adsIntentPremium3T2MSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (8 < len(self.products)) and ("ProductSku" in self.products[8])):
                self.skuNameId["adsIntentPremium3T2MSkuId"] = str(self.products[8]["ProductSku"])
            else:
                self.skuNameId["adsIntentPremium3T2MSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentPremium3T2MSkuId"])
            return self.skuNameId["adsIntentPremium3T2MSkuId"]

    def get_ads_intent_advance_1t1m_skuId(self):
        try:
            return self.skuNameId["adsIntentAdvance1T1MSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (9 < len(self.products)) and ("ProductSku" in self.products[9])):
                self.skuNameId["adsIntentAdvance1T1MSkuId"] = str(self.products[9]["ProductSku"])
            else:
                self.skuNameId["adsIntentAdvance1T1MSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentAdvance1T1MSkuId"])
            return self.skuNameId["adsIntentAdvance1T1MSkuId"]

    def get_ads_intent_premium_1t1m_skuId(self):
        try:
            return self.skuNameId["adsIntentPremium1T1MSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (10 < len(self.products)) and ("ProductSku" in self.products[10])):
                self.skuNameId["adsIntentPremium1T1MSkuId"] = str(self.products[10]["ProductSku"])
            else:
                self.skuNameId["adsIntentPremium1T1MSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentPremium1T1MSkuId"])
            return self.skuNameId["adsIntentPremium1T1MSkuId"]

    def get_ads_intent_advance_4t4m_skuId(self):
        try:
            return self.skuNameId["adsIntentAdvance4T4MSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (11 < len(self.products)) and ("ProductSku" in self.products[11])):
                self.skuNameId["adsIntentAdvance4T4MSkuId"] = str(self.products[11]["ProductSku"])
            else:
                self.skuNameId["adsIntentAdvance4T4MSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentAdvance4T4MSkuId"])
            return self.skuNameId["adsIntentAdvance4T4MSkuId"]

    def get_ads_intent_premium_4t4m_skuId(self):
        try:
            return self.skuNameId["adsIntentPremium4T4MSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (12 < len(self.products)) and ("ProductSku" in self.products[12])):
                self.skuNameId["adsIntentPremium4T4MSkuId"] = str(self.products[12]["ProductSku"])
            else:
                self.skuNameId["adsIntentPremium4T4MSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentPremium4T4MSkuId"])
            return self.skuNameId["adsIntentPremium4T4MSkuId"]

    def get_ads_intent_advance_2t2b_skuId(self):
        try:
            return self.skuNameId["adsIntentAdvance2T2BSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (13 < len(self.products)) and ("ProductSku" in self.products[13])):
                self.skuNameId["adsIntentAdvance2T2BSkuId"] = str(self.products[13]["ProductSku"])
            else:
                self.skuNameId["adsIntentAdvance2T2BSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentAdvance2T2BSkuId"])
            return self.skuNameId["adsIntentAdvance2T2BSkuId"]

    def get_ads_intent_premium_2t2b_skuId(self):
        try:
            return self.skuNameId["adsIntentPremium2T2BSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (14 < len(self.products)) and ("ProductSku" in self.products[14])):
                self.skuNameId["adsIntentPremium2T2BSkuId"] = str(self.products[14]["ProductSku"])
            else:
                self.skuNameId["adsIntentPremium2T2BSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentPremium2T2BSkuId"])
            return self.skuNameId["adsIntentPremium2T2BSkuId"]

    def get_ads_intent_dns_1bdq_skuId(self):
        try:
            return self.skuNameId["adsIntentDns1BDQSkuId"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (15 < len(self.products)) and ("ProductSku" in self.products[15])):
                self.skuNameId["adsIntentDns1BDQSkuId"] = str(self.products[15]["ProductSku"])
            else:
                self.skuNameId["adsIntentDns1BDQSkuId"] = None
            self.skuList["INTENT"].append(self.skuNameId["adsIntentDns1BDQSkuId"])
            return self.skuNameId["adsIntentDns1BDQSkuId"]

    def get_ads_intent_premium_bundled_skuId(self):
        try:
            return self.skuNameId["intentpremiumbundled"]
        except KeyError:
            if ((not self.is_ads_service_type_adm()) and (17 < len(self.products)) and ("ProductSku" in self.products[17])):
                self.skuNameId["intentpremiumbundled"] = str(self.products[17]["ProductSku"])
            else:
                self.skuNameId["intentpremiumbundled"] = None
            self.skuList["INTENT"].append(self.skuNameId["intentpremiumbundled"])
            return self.skuNameId["intentpremiumbundled"]

    def get_ads_automation_citrix_cloud_trigger_skuId(self):
        try:
            return self.skuNameId["adsAutoCitrixCloudTriggerSkuId"]
        except KeyError:
            try:
                if ((self.is_ads_service_type_adm()) and (7 < len(self.products)) and ("ProductSku" in self.products[7])):
                    self.skuNameId["adsAutoCitrixCloudTriggerSkuId"] = str(self.products[7]["ProductSku"])
                else:
                    self.skuNameId["adsAutoCitrixCloudTriggerSkuId"] = None
                self.skuList["ADM"].append(self.skuNameId["adsAutoCitrixCloudTriggerSkuId"])
                return self.skuNameId["adsAutoCitrixCloudTriggerSkuId"]
            except Exception as e:
                logger.error("Exception: ads_auto_citrix_cloud_trigger product SKU " + str(e))
                return ''

    def get_svc_for_sku(self, skuId):
         if (skuId in self.skuList["INTENT"]):
             return "INTENT"
         elif (skuId in self.skuList["AUTOMATION"]):
             return "AUTOMATION"
         else:
             return "ADM"

    def getServiceName(self):
        try:
            svcName = ''
            with open(SERVICE_PROFILE_CONF) as data_file:
                data = json.load(data_file)

            for item in data['Services']:
                svcName = item['Name']

            route_template = data['ServiceRouteTemplate']
            self.routeTemplate = route_template.replace("/[customer]", "")
            return svcName
        except Exception as e:
            logger.error("Exception while getting serviceName %s", e)
            return ''

    def getPrivateKey(self):
        secret_val = self.privateKey
        if (secret_val != ""):
            return secret_val
        try:
            if is_grp_container:
                try:
                    from mpspython.infra.comm.citrixcloud.CitrixCloudEnviron import CitrixCloudEnviron
                    return CitrixCloudEnviron.get_cc_key()
                except Exception as e:
                    logger.error('Failed to get the private key')
            secret_name = os.environ["SP_PRIVATE_KEY_SECRET"] if "SP_PRIVATE_KEY_SECRET" in os.environ else self.serviceName + "_SP_PRIVATE_KEY"
            region_name = os.environ["AWS_SECRET_REGION"] if "AWS_SECRET_REGION" in os.environ else "eu-central-1"
            error_code, secret_val = self.getSecretFromAWS(secret_name, region_name)
            if (error_code == 1 or secret_val == ''):
                try:
                    privatekey = data = ''
                    region = "eu-central-1"
                    kms_key_str = "adm"
                    with open(SERVICE_PROFILE_CONF) as data_file:
                        data = json.load(data_file)
                    for item in data['Services']:
                        privatekey = str(item['PrivateKey'])
                    self.create_secret(secret_name, privatekey, region, kms_key_str)
                    secret_val = privatekey
                except Exception as e:
                    logger.error("Exception in create SecretFromAWS : %s", e)
        except Exception as e:
            logger.error("Exception when getting private key %s", e)
        return secret_val

    def getCCAuthHandle(self):
        try:
            data = svcName = privatekey = route_template = deploymentType = iscloud = ''
            # service_profile is only present in case of cloud_deployments
            if (os.path.exists(AGENT_CONF) == False and os.path.exists(SERVICE_PROFILE_CONF) == True):
                with open(SERVICE_PROFILE_CONF) as data_file:
                    data = json.load(data_file)
                for item in data['Services']:
                    svcName = item['Name']
                route_template = data['ServiceRouteTemplate']
                route_template = route_template.replace("/[customer]", "")
                privatekey = self.getPrivateKey()
            return CCAuthHandle(
                ConfigurationOptions(route_template=route_template, service_name=svcName, private_key=privatekey))
        except Exception as e:
            logger.error('Exception in func=cwcUtil::getCCAuthHandle')
            logger.error(e)
            exit(-1)

    def authModeEnum(self, mode):
        try:
            if mode == 'bearer':
                mode = CwcAuthorizationMode(1)
            elif mode == 'servicekey':
                mode = CwcAuthorizationMode(2)
            elif mode == 'both':
                mode = CwcAuthorizationMode(3)
            elif mode == 'either':
                mode = CwcAuthorizationMode(7)
            return mode
        except Exception as e:
            return ""

    def validateResponse(self, requestResult):
        try:
            json_object = json.loads(requestResult)
        except ValueError as e:
            return False
        return True

    '''
    Handles all HTTP Request to CWC.
    '''

    def httpRequest(self, targetURL, headers=None):
        request = ""
        payload = ""

        try:
            httpConnection = httplib2.Http(ca_certs=CERT_BUNDLE_PATH)
            responseStatus, payload = httpConnection.request(targetURL, "GET", headers=headers)
            status = str(responseStatus['status'])
            payload = payload.decode()

        except Exception as e:
            logger.error(e)
            return '{ "errorcode" : ' + status + ' }'

        if cwcUtil().validateResponse(payload):
            payload = '{ "errorcode" : ' + status + ' , "message" : ' + payload + ' }'
        else:
            payload = '{ "errorcode" : ' + status + ' , "message" : "' + payload + '" }'

        return payload

    '''
    CWC is a utility. Used to handle authentication related with CWC.
    '''

    def cwcRequest(self, targetURL, mode, resourceProviderName, private_key, authToken):
        try:

            authMode = cwcUtil().authModeEnum(mode)
            if authMode == "":
                return '{ "errorcode" : 10008 , "message" : "' + mode + ' is not a valid CwcAuthorizationMode."}'

            settings = ""
            headers = ""
            if mode == "bearer":
                if authToken == "" or authToken is None:
                    return '{ "errorcode" : 10006 , "message" :' + ' "Bearer token missing." }'
                settings = cwc.client.CwcRequestSettings(bearer=authToken)
                headers = cwc.client.getheaders(authMode, settings, targetURL)
            else:
                keyparams = cwc.auth.CwcServiceKeyParameters(private_key, resourceProviderName)
                settings = cwc.client.CwcRequestSettings(keyparams=keyparams)
                headers = cwc.client.getheaders(authMode, settings, targetURL)

            # Sending Request
            payload = cwcUtil().httpRequest(targetURL, headers)
            return payload
        except Exception as e:
            return '{"errorcode" : 10012 , "message" : "Request can not be processed"}'

    def isCASRequest(self, targetURL):
        try:
            self.readCASHost()
            casHosts = self.CASSvcHost.values()
            targetURLHostname = urllib.parse.urlparse(targetURL).netloc
            for casHost in casHosts:
                CASURLHostname = urllib.parse.urlparse(casHost).netloc
                if targetURLHostname == CASURLHostname:
                    return True
            return False
        except Exception as e:
            logger.error('Exception in func=cwc:isCASRequest')
            logger.error(e)
            return False

    def getCCAuthHandleForURL(self, targetURL):
        try:
            # Overwrite svcName & privatekey if appropriate overwrite env variables are present
            # This is mainly done as a hack to allow CAS communication to setups not integrated to CAS
            overwrite_svcname = os.environ.get("CAS_SERVICE_NAME")
            overwrite_privatekey = os.environ.get("CAS_PRIVATE_KEY")

            if overwrite_svcname and overwrite_privatekey and self.isCASRequest(targetURL):
                logger.info("getCCAuthHandleForURL: overwriting svcName with %s & its private key"%(overwrite_svcname))
                options = ConfigurationOptions(
                    service_name=overwrite_svcname,
                    private_key=overwrite_privatekey
                )
                return CCAuthHandle(options)
            else:
                return self.ccAuthHandle
        except Exception as e:
            logger.error('Exception in func=cwc:getCCAuthHandleForURL')
            logger.error(e)
            return self.ccAuthHandle


    def getCCServiceKey(self, targetURL):
        try:
            ccAuthHandleForURL = self.getCCAuthHandleForURL(targetURL)
            request_info = RequestInfo(method=RequestMethod.GET, uri=targetURL)
            servicekey = ccAuthHandleForURL.create_servicekey(request_info, SigningAlgorithm.RSA_SHA256_V2)
            return servicekey
        except Exception as e:
            logger.error('Exception in func=cwc:getCCServiceKey')
            logger.error(e)
            return '{"errorcode" : 10012 , "message" : "Request can not be processed"}'

    # Below func is deprecated
    def getServiceKey(self, targetURL, serviceName, private_key):
        try:
            keyparams = cwc.auth.CwcServiceKeyParameters(private_key, serviceName, None,
                                                         CwcSigningAlgorithm.RSA_SHA256_V2)
            settings = cwc.client.CwcRequestSettings(keyparams=keyparams)
            headers = cwc.client.getheaders(cwc.auth.CwcAuthorizationMode.servicekey, settings, targetURL)
            servicekey_regex = re.search('CWSAuth service=\"(.*)\"', headers["Authorization"])
            if servicekey_regex is None:
                return None
            servicekey = servicekey_regex.group(1);
            return servicekey
        except Exception as e:
            logger.error(e)
            return '{"errorcode" : 10012 , "message" : "Request can not be processed"}'

    def read_command_output(self, cmd):
        args = shlex.split(cmd)
        process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=None)
        output = process.communicate()
        return output[0]

    def encode_to_base64(self, n):
        data = struct.pack('<Q', n).rstrip('\x00')
        if len(data) == 0:
            data = '\x00'
        s = base64.urlsafe_b64encode(data).rstrip('=')
        return s

    def strip_key_values(self, val):
        val = val.replace(':', '')
        val = re.sub('\s+', ' ', val)
        val = val.replace(' ', '')
        val = binascii.b2a_base64(codecs.decode(val, 'hex')).decode()
        return val

    def createCWSPrivateKey(self):
        try:
            if os.path.exists(CWS_TRUST_PVT_KEY):
                f = open(CWS_TRUST_PVT_KEY, "r")
                priKey = f.read()
                return priKey
            pemPrivKey = os.popen("cat " + TRUST_PVT_KEY).read()
            # print pemPrivKey
            lines = pemPrivKey.replace(" ", '').split()
            # print lines
            keyDer = DerSequence()
            keyDer.decode(a2b_base64(''.join(lines[1:-1])))
            private_key_xml = '<RSAKeyValue>'
            private_key_xml += '<Modulus>'
            private_key_xml += standard_b64encode(number.long_to_bytes(keyDer[1])).decode()
            private_key_xml += '</Modulus>'
            private_key_xml += '<Exponent>'
            private_key_xml += standard_b64encode(number.long_to_bytes(keyDer[2])).decode()
            private_key_xml += '</Exponent>'
            private_key_xml += '<D>'
            private_key_xml += standard_b64encode(number.long_to_bytes(keyDer[3])).decode()
            private_key_xml += '</D>'
            private_key_xml += '<P>'
            private_key_xml += standard_b64encode(number.long_to_bytes(keyDer[4])).decode()
            private_key_xml += '</P>'
            private_key_xml += '<Q>'
            private_key_xml += standard_b64encode(number.long_to_bytes(keyDer[5])).decode()
            private_key_xml += '</Q>'
            private_key_xml += '<DP>'
            private_key_xml += standard_b64encode(number.long_to_bytes(keyDer[6])).decode()
            private_key_xml += '</DP>'
            private_key_xml += '<DQ>'
            private_key_xml += standard_b64encode(number.long_to_bytes(keyDer[7])).decode()
            private_key_xml += '</DQ>'
            private_key_xml += '<InverseQ>'
            private_key_xml += standard_b64encode(number.long_to_bytes(keyDer[8])).decode()
            private_key_xml += '</InverseQ>'
            private_key_xml += '</RSAKeyValue>'
            private_key_xml = standard_b64encode(private_key_xml.encode()).decode()
            f = open(CWS_TRUST_PVT_KEY, "w")
            f.write(private_key_xml)
            f.close()
            if os.path.exists(CWS_TRUST_PVT_KEY):
                f = open(CWS_TRUST_PVT_KEY, "r")
                priKey = f.read()
                return priKey
        except Exception as e:
            logger.error(e)

    def create_servicekey(self, request_info, servicename, instanceid, private_key, signing_algorithm):
        try:
            options = ConfigurationOptions(
                service_name=servicename,
                service_instance=instanceid,  # optional
                private_key=private_key
            )
            with CCAuthHandle(options) as handle:
                return handle.create_servicekey(request_info, signing_algorithm)
        except CCAuthException as e:
            logger.error(str(e))
            return None

    def getKeyFromSecretServer(self, serialNumber):
        try:
            targetURL = "http://127.0.0.1:8100//nitro/v1/config/enc_key/" + serialNumber
            headers = {'Content-Type': 'application/json'}
            resp = requests.get(targetURL, headers=headers, timeout=10)
            errorcode = json.loads(resp.text)['errorcode']
            if errorcode == 0:
                return True
            return False
        except Exception as e:
            logger.error(str(e))
            return False

    def testSecretServerHealth(self):
        try:
            targetURL = "http://127.0.0.1:8100/health"
            headers = {'Content-Type': 'application/json'}
            resp = requests.get(targetURL, headers=headers, timeout=10)
            errorcode = json.loads(resp.text)['errorcode']

            if errorcode == 0:
                return True
            return False
        except Exception as e:
            logger.error(str(e))
            return False
          
    def isRegisteredCCEmail(self, email):
        try:
            targetURL = self.routeTemplate.replace("[service]", "delegatedadministration-eastus-release-b")
            userIDURL = targetURL + "/root/Administrators/AvailableIdentityProviders/" + email
            serviceToken = self.getCCServiceKey(userIDURL)
            headers = {'Authorization': 'CWSAuth service=' + serviceToken}
            resp = requests.get(userIDURL, headers=headers, timeout=10)
            userID = json.loads(resp.text)['userId']

            if userID is None:
                return False
            return True
        except Exception as e:
            logger.error(str(e))
            return False

    def getInvalidEmailList(self, args):
        try:
            emailList = args.emailList
            if ';' in emailList:
                emailList = emailList.split(';')

            if isinstance(emailList, list):
                resultStr = ''
                for item in emailList:
                    if not self.isRegisteredCCEmail(item):
                        if resultStr == '':
                            resultStr = item
                        else:
                            resultStr = resultStr + ';' + item
                return resultStr
            elif isinstance(emailList, str):
                return emailList if not self.isRegisteredCCEmail(emailList) else ''
        except Exception as e:
            logger.error(e)
            return ''

    def getCWSServiceKey(self, args):
        try:
            instanceid_to_print = args.instanceid
            if is_mastools:
                f = open("/var/mastools/trust/.ssh/private.pem", "r")
                if len(args.instanceid) > 8:
                    instanceid_to_print = args.instanceid[:4] + '****' + args.instanceid[-4:]
            else:
                f = open("/mpsconfig/trust/.ssh/private.pem", "r")
            private_key = f.read()
            f.close()
            # checking if the private key is not in XML format then change it to XML format
            if private_key.find("BEGIN RSA PRIVATE KEY") >= 0:
                private_key = self.createCWSPrivateKey()
            logger.debug(
                "getCWSServiceKey: instanceid: " + instanceid_to_print + " serviceName: " + args.serviceName + " targetURL: " + args.targetURL)

            request_info = RequestInfo(
                method=RequestMethod.GET,
                uri=args.targetURL
            )
            if args.version == "v1":
                servicekey = self.create_servicekey(request_info, args.serviceName, args.instanceid, private_key,
                                                    SigningAlgorithm.RSA_SHA256_V1)  # signing algorithm is optional, defaults to SigningAlgorithm.RSA_SHA256_V2
            elif args.version == "v2":
                servicekey = self.create_servicekey(request_info, args.serviceName, args.instanceid, private_key,
                                                    SigningAlgorithm.RSA_SHA256_V2)  # signing algorithm is optional, defaults to SigningAlgorithm.RSA_SHA256_V2
            if not servicekey is None:
                # send the service key as part of the CWSAuth header in the http request
                logger.debug("Service token generated successfully")
                return servicekey
            logger.error("Error occured while generating service token, returning empty string")
            return ""
        except Exception as e:
            logger.error(e)
            return '{"errorcode" : 10012 , "message" : "Request can not be processed"}'

    def redirectURL(self, targetURL, servicekey):
        try:
            redirect_encoded = base64.b64encode(targetURL + ";" + servicekey).decode()
            return redirect_encoded
        except Exception as e:
            return '{"errorcode" : 10012 , "message" : "Request can not be processed"}'

    def verifyOnpremCCRequest(self, args):
        try:
            # args.servicekey = 'CWSAuth service=TFAraDJzSm43YUZoRC9Qb1B4SzAvTGx...'
            decoded_servicekey = timestamp = nonce = signature = servicekey = ''
            index = (args.servicekey).find("service")
            servicekey = args.servicekey[index + 8:]
            servicekey = servicekey.strip()
            decoded_servicekey = decode_servicekey(servicekey)
            timestamp = str(decoded_servicekey.timestamp)
            nonce = str(decoded_servicekey.nonce)
            signature = decoded_servicekey.signature
            messageToVerify = args.urlToVerify + "\n" + timestamp + "\n" + nonce

            # Signature : verify ( bytes, bytes, str)
            result = verify(messageToVerify.encode('utf-8'), base64.b64decode(signature), args.publickey)
            return True
        except Exception as e:
            logger.error('Exception in func=cwcUtil:verifyOnpremCCRequst')
            logger.exception(e)
            return False

    def verifyCCService(self, urlToVerify, serviceKeyToVerify, custID):
        try:
            # header = 'CWSAuth service=TFAraDJzSm43YUZoRC9Qb1B4SzAvTGx...'
            header = serviceKeyToVerify
            if 'CWSAuth service=' not in serviceKeyToVerify:
                header = 'CWSAuth service=' + serviceKeyToVerify
            validation_context = IdentityValidationContext(customer_id=custID)
            request_info = RequestInfo(method=RequestMethod.GET, uri=urlToVerify)
            id_result = self.ccAuthHandle.validate_identity(header, validation_context, request_info)

            if id_result.code == AuthorizationCode.OK:
                return '{ "errorcode" : 0 , "message" : "true" }'
            else:
                return '{ "errorcode" : 0 , "message" : "false" }'
        except Exception as e:
            logger.error('Exception in func=cwcUtil:verifyCCService')
            logger.error(e)
            return '{ "errorcode" : 0 , "message" : "false" }'

    # Below func is deprecated
    def verifyService(self, resourceProviderName, private_key, urlToVerify, serviceKeyToVerify, pubKeyGetURL):
        try:
            # Reading Service Key to verify
            # Used to read signature, customer Name
            readInfo = cwc.auth.readkey(serviceKeyToVerify)
            # signature and customer name
            sig = readInfo[0]
            customerName = readInfo[1]
            if (len(readInfo) > 3):
                timestamp = str(readInfo[2])
                nonce = str(readInfo[3])
                urlToVerify = urlToVerify + "\n" + timestamp + "\n" + nonce
            requiredPubKeyURL = pubKeyGetURL + "/" + customerName
            result = cwcUtil().httpRequest(requiredPubKeyURL)
            response = json.loads(result);
            errorcode = response['errorcode']
            if errorcode == 200:
                payload = response['message']
                for key, value in list(payload.items()):
                    if key == "items":
                        for tempPublicKey in value:
                            verified = cwc.crypto.verify(urlToVerify, sig, tempPublicKey)
                            if verified is True:
                                return '{ "errorcode" : 0 , "message" : "true" }'
            else:
                return result
            return '{ "errorcode" : 0 , "message" : "false" }'
        except:
            return '{ "errorcode" : 10012 , "message" : "Request can not be processed"}'

    def verifyNwsServiceKeys(self, urlToVerify, serviceKeyToVerify, publicKeys):
        try:
            # Reading Service Key to verify
            # Used to read signature, customer Name
            readInfo = cwc.auth.readkey(serviceKeyToVerify)
            # signature and customer name
            sig = readInfo[0]
            serviceName = readInfo[1]
            instanceID = readInfo[2]
            result = json.loads(publicKeys);
            for key, value in list(result.items()):
                if key == "items":
                    for tempPublicKey in value:
                        verified = cwc.crypto.verify(urlToVerify, sig, tempPublicKey)
                        if verified is True:
                            return '{ "errorcode" : 0 , "message" : "true" }'
            return '{ "errorcode" : 0 , "message" : "false" }'
        except:
            return '{ "errorcode" : 10012 , "message" : "Request can not be processed"}'

    @staticmethod
    def parseToken(bearer_token):
        try:
            result = cwcUtil().ccAuthHandle.parse_bearer_token(bearer_token)
            result_obj = cwcUtil.to_dict(result)
            return result_obj
        except Exception as e:
            logger.error("Failed to parse token. %s" %(str(e)))
            return None

    @staticmethod
    def to_dict(obj):
        if hasattr(obj, '_attrs_'):
            result = {}
            for attr, _ in obj._attrs_:
                value = getattr(obj, attr)
                if isinstance(value, tuple) or isinstance(value, list):
                    result[attr] = [
                        CCHandler.to_dict(v) if hasattr(v, '_attrs_') else v
                        for v in value
                    ] if value is not None else None
                elif hasattr(value, '_attrs_'):
                    result[attr] = CCHandler.to_dict(value)
                else:
                    result[attr] = value
            return result
        return obj

    def getDetails(self, conn):
        shared_access_key_name = ''
        shared_access_key_value = ''
        endpoint = ''
        entitypath = ''
        conn = conn.split(';')
        for ele in conn:
            ele = ele.split('=')
            if ele[0] == 'SharedAccessKeyName':
                shared_access_key_name = (ele[1]).strip()
            elif ele[0] == 'SharedAccessKey':
                shared_access_key_value = (ele[1]).strip()
                if len(ele) > 2:
                    shared_access_key_value = shared_access_key_value + "="
            elif ele[0] == 'EntityPath':
                entitypath = (ele[1]).strip()
            elif ele[0] == 'Endpoint':
                endpoint = ele[1]
                endpoint = re.sub(r'\.servicebus\.windows\.net(\/)*$', '', endpoint)
                endpoint = (re.sub(r'^sb://', '', endpoint)).strip()

        return shared_access_key_name, shared_access_key_value, endpoint, entitypath

    def get_cc_url(self):
        return ENDPOINTS[self.checkCloudOption()][CC_URL]
    

    def get_turst_url(self):
        return ENDPOINTS[self.checkCloudOption()][TRUST]

    def checkCloudOption(self):
        if os.path.isfile(BASE_PATH + CLOUD_SERVICE_FILE):
            configReader = configparser.ConfigParser()
            if sys.version_info[0] < 3:
                configReader.readfp(io.StringIO(config_string))
            else:
                configReader.read(BASE_PATH + CLOUD_SERVICE_FILE)
            if 'region' in configReader.sections():
                if configReader['region']['cloudoption'] == JAPAN:
                    return JAPAN
        return DEFAULT

    def post_order(self, orgId, custId, emailId, skuId, quantity, subTime):
        try:
            ent_type = ''
            svcName = ''
            URL = os.environ["CC_API_URL"] if "CC_API_URL" in os.environ else self.get_cc_url()
            URL = URL.replace("core", "ordersapi")
            sku = ''
            pkgs = ''

            if (skuId == 'freemium'):
                time = 500 * SUBSCRIPTION1
            elif ('trial' in skuId):
                time = TRIAL_SUBSCRIPTION
            elif subTime is None:
                time = SUBSCRIPTION1
            else:
                time = int(subTime)

            if skuId in self.skuNameId:
                sku = self.skuNameId[skuId]

            if sku is None:
                logger.debug("skuId " + skuId + "is not found for post_order")
                return False

            temp = datetime.datetime.now() + datetime.timedelta(days=time)
            endDate = temp.isoformat()
            targetURL = URL + "root/orders"
            service_key = self.getCCServiceKey(targetURL)
            headers = {'Content-Type': 'application/json', 'Authorization': "CWSAuth service=" + service_key}
            order_id = uuid.uuid4().urn[9:]
            ent_type = 'Production'
            data = '{"action":"Deliver","orderId":"' + order_id + '","purchaseOrderId":null,"orgId":"' + orgId + '","CustomerId":"' + custId + '","contactEmail":"' + emailId + '","packages":[{"packageSKU":"' + sku + '","entitlementType":"' + ent_type + '","startDate":"' + (
                        datetime.datetime.now() - datetime.timedelta(
                    minutes=1)).isoformat() + '","endDate":"' + endDate + '","quantity":' + str(
                quantity) + ',"entitlements": [{"productSKU":"' + sku + '","cwcSerialNumber": null, "orderItemId": 0, "orderId": null,"serialNumbers": null, "action": null,"startDate": null, "endDate": null}]}]}'
            logger.debug("data = %s", data)
            try:
                httpConnection = httplib2.Http(ca_certs=CERT_BUNDLE_PATH)
                responseStatus, resp = httpConnection.request(targetURL, 'POST', headers=headers, body=data)
                resp = resp.decode()
                response = json.loads(resp);
                logger.debug("response = %s", response)
                if (str(responseStatus['status']) == '200'):
                    return True
                else:
                    return False
            except Exception as e:
                logger.error("Exception while sending order request : %s ", e)
                return False
        except Exception as e:
            logger.error("Exception while sending order request")
            logger.error(e)

    def send_fulfillment_request(self, fulfillmentQueue, sendQueueConn, data, svcName, action, result):
        try:
            key_name, key_value, endpoint, entitypath = self.getDetails(sendQueueConn)
            bus_service = ServiceBusService(service_namespace=endpoint, shared_access_key_name=key_name,
                                            shared_access_key_value=key_value)
            entId = ''
            custId = ''
            sno = []
            msg = json.loads(data)
            entId = msg['EntitlementId']
            custId = msg['CustomerId']
            payload = '{"EntitlementId":"' + entId + '","CustomerId":"' + custId + '","SerialNumbers":["' + entId + '"],"ServiceName":"' + svcName + '"}'
            logger.debug("Fulfillment request payload:" + payload)
            msg = Message(payload, custom_properties={'Version': 1, 'Result': result, 'Action': action})
            logger.debug("Fulfillment request result :" + result + " custId :" + custId)
            bus_service.send_queue_message(fulfillmentQueue, msg)
        except Exception as e:
            logger.error("Exception while sending fulfillment request for custId : " + custId)
            logger.error(e)

    def checkTenantCreateComplete(self, custId, service_type):
        isTenantCompFlag = "set schema 'Owner';SELECT id FROM tenant WHERE name =%s and service_type=%s"
        # get id , search in tenant_Server_map
        data_tuple = (custId, str(service_type))
        try:
            conn = self.get_connection("Owner")
            cur = conn.cursor()
            cur.execute(isTenantCompFlag, data_tuple)
            row = cur.fetchone()
            if row:
                isTenantCompFlag = "set schema 'Owner';SELECT ten_id FROM tenant_server_map WHERE ten_id =%s and ten_type=%s"
                data_tuple = (str(row[0]), str(service_type))
                cur.execute(isTenantCompFlag, data_tuple)
                row = cur.fetchone()
                conn.close()
                if row:
                    logger.debug("#CreatePendingTenants : Tenant was created completely :" + custId)
                    return True
                else:
                    return False
            else:
                conn.close()
                return False

        except Exception as e:
            logger.error("Error while executing query in checkTenantCreatedPartially: " + custId);
            logger.error(e)
            conn.close()
            return False

        return False

    def deleteTenant(self, custId):
        deletefrom_owner = "set schema 'Owner';delete FROM tenant WHERE name =\'" + custId + "\'"
        data_tuple = (custId,)
        try:
            self.execute_query_to_db("Owner", deletefrom_owner)
        except Exception as e:
            logger.error("Error while executing query in deleteTenant: " + custId);
        del_ten_query = "drop schema \"" + custId + "\" cascade"
        return self.execute_query_to_db("Owner", del_ten_query);

    def isTenantCreatedForAnyService(self, custId):
        isTenantCompFlag = "set schema 'Owner';SELECT id FROM tenant WHERE name =%s"
        data_tuple = (custId,)
        try:
            conn = self.get_connection("Owner")
            cur = conn.cursor()
            cur.execute(isTenantCompFlag, data_tuple)
            row = cur.fetchone()
            if row:
                isTenantCompFlag = "set schema 'Owner';SELECT ten_id FROM tenant_server_map WHERE ten_id =%s"
                data_tuple = (str(row[0]),)
                cur.execute(isTenantCompFlag, data_tuple)
                row = cur.fetchone()
                conn.close()
                if row:
                    logger.debug(
                        "#isTenantCreatedForAnyService : Tenant was created for other service completely :" + custId)
                    return True
                else:
                    return False
            else:
                conn.close()
                return False
        except Exception as e:
            logger.error("Error while executing query in isTenantCreatedForAnyService: " + custId);
            logger.error(e)
            conn.close()
            return False

        return False

    def checkSchemaExist(self, custId):
        ifSchemaExist = "select schema_name from information_schema.schemata where schema_name= %s;"
        data_tuple = (custId,)
        try:
            conn = self.get_connection(custId)
            cur = conn.cursor()
            cur.execute(ifSchemaExist, data_tuple)
            row = cur.fetchone()
            conn.close()
            if row:
                logger.debug("#checkSchemaExist : schema exists for tenant :" + custId)
                return True
        except Exception as e:
            logger.error(e)
            logger.error("Exception in checkSchemaExist")
        return False

    def deleteTenantIfCreatedPartially(self, custId, service_type):
        try:
            ents = {}
            part_flag = self.checkTenantCreateComplete(custId, service_type)
            if part_flag is False:
                schema_exist = self.checkSchemaExist(custId)
                if schema_exist is True:
                    flag = self.isTenantCreatedForAnyService(custId)
                    if flag is False:
                        ents = self.getEntitlements(custId)
                        self.deleteTenant(custId), ents
                        return True, ents
                    else:
                        return True, ents
                else:
                    return True, ents
            return part_flag, ents
        except Exception as e:
            logger.error("Error while executing query in deleteTenantIfCreatedPartially: " + custId);
            logger.error(e)
        return False, ents

    def get_adm_tlmy_deets(self):
        try:
            secret_name = os.environ["ADM_TELEMETRY_CONF"]
            region_name = os.environ["REGION"] if "REGION" in os.environ else "us-east-1"
            session = boto3.session.Session()
            client = session.client(
                service_name='secretsmanager',
                region_name=region_name
            )
            get_secret_value_response = client.get_secret_value(
                SecretId=secret_name
            )
            if isinstance(get_secret_value_response, dict):
                secret = get_secret_value_response['SecretString']
                file = open(ADM_TELEMETRY_CONF, "w")
                file.write(secret)
                file.close()
                logger.debug('Telemetry file created successfully...')

        except Exception as e:
            logger.error("Error while getting telemetry configuration")
            logger.error(e)

    def getEntitlements(self, custId, entId=None):
        try:
            get_service_licenses = "set schema %s ;select * from mas_service_license;"
            data_tuple = (custId,)
            conn = self.get_connection(custId)
            cur = conn.cursor()
            cur.execute(get_service_licenses, data_tuple)
            row = cur.fetchone()
            entitlement_str = {}
            i = 0
            while row is not None:
                newEntId = row[4]
                if entId == newEntId:
                    i = i + 1
                    row = cur.fetchone()
                    continue
                custId = row[5]
                start_date = row[6]
                end_date = row[7]
                ent_type = row[8]
                skuId = row[9]
                quantity, key = self.decrypt(custId, row[10], "")
                approved = row[12]
                if approved:
                    approved = 'true'
                else:
                    approved = 'false'
                entitlement_str[
                    i] = '{"EntitlementId":"' + newEntId + '","CustomerId":"' + custId + '","StartDate":"' + start_date + '","EndDate":"' + end_date + '","EntitlementType":"' + ent_type + '","ProductSku":"' + skuId + '","Quantity":' + str(
                    quantity) + ',"SerialNumbers":[],"Approved":' + approved + '}'
                logger.debug("#getEntitlements for tenant " + custId + " entitlement_str = " + entitlement_str[i])
                i = i + 1
                row = cur.fetchone()

            conn.close()
            for ent in entitlement_str:
                outfile = open(CREATE_PENDING_TENANT_FILE, 'a+')
                outfile.write(entitlement_str[ent] + '\n')
                outfile.close()

            return entitlement_str
        except Exception as e:
            logger.error("Error while executing query in getEntitlements: " + custId);
            logger.error(e)
            conn.close()
            return {}

    def addPrevEntitlements(self, custId, prevEntitlements, action):
        try:
            for ent in prevEntitlements:
                logger.debug("#addPrevEntitlements ent = " + str(prevEntitlements[ent]))
                msg = json.loads(prevEntitlements[ent])
                entId = msg['EntitlementId']
                isTenantCompFlag = "set schema %s ;SELECT entitlement_id FROM mas_service_license WHERE entitlement_id = %s"
                data_tuple = (schema, entId)
                conn = self.get_connection(custId)
                cur = conn.cursor()
                cur.execute(isTenantCompFlag, data_tuple)
                row = cur.fetchone()
                conn.close()
                if row:
                    logger.debug("#addPrevEntitlements : Entitlement already exists :" + entId)
                else:
                    logger.debug("#addPrevEntitlements : Adding entitlement :" + entId)
                    self.insert_lic_entitlement_to_db(prevEntitlements[ent], action)
        except Exception as e:
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print(exc_type, fname, exc_tb.tb_lineno)
            logger.error("Exception raise in addPrevEntitlements")
            logger.error(e)

    def entitlements(self):
        try:
            with open(SERVICE_PROFILE_CONF) as data_file:
                data = json.load(data_file)
                deliveryQueue = ''
                listenQueueConn = ''
                fulfillmentQueue = ''
                sendQueueConn = ''
                svcName = ''

                for item in data['Services']:
                    svcName = item['Name']

                for item in data['ResourceProviders']:
                    deliveryQueue = item['DeliveryQueue']
                    listenQueueConn = item['ListenQueueConnectionString']
                    fulfillmentQueue = item['FulfillmentQueue']
                    sendQueueConn = item['SendQueueConnectionString']
                key_name, key_value, endpoint, entitypath = self.getDetails(listenQueueConn)
                while True:
                    try:
                        bus_service = ServiceBusService(service_namespace=endpoint, shared_access_key_name=key_name,
                                                        shared_access_key_value=key_value)
                        while True:
                            logger.debug("Waiting for entitlements....")
                            msg = bus_service.receive_queue_message(deliveryQueue, peek_lock=False)
                            msgString = str(msg.body)
                            logger.debug("Data received.." + msgString)
                            logger.debug("Custom Properties: " + str(msg.custom_properties))
                            try:
                                msgString = msgString[msgString.index('{'):]
                                msgString = msgString[:msgString.index('}') + 1]
                                logger.debug('Received Entitlement : ' + msgString)
                                action = msg.custom_properties['action']
                                logger.debug("Action: " + action)
                                # Code to send fullfilment
                                retFlag = self.insert_lic_entitlement_to_db(msgString, action)
                                if retFlag is True:
                                    self.send_fulfillment_request(fulfillmentQueue, sendQueueConn, msgString, svcName,
                                                                  action, 'Success')
                                elif retFlag is False:
                                    self.send_fulfillment_request(fulfillmentQueue, sendQueueConn, msgString, svcName,
                                                                  action, 'Failure')

                            except Exception as e:
                                logger.error(e)
                                pass
                    except Exception as e:
                        logger.error(e)
                        logger.error("Resetting entitlement connection....")
        except Exception as e:
            logger.error("Exception raise in entitlements")
            logger.error(e)

    def isTenantCreated(self, custId):
        try:
            get_query = "set schema %s; select name from tenant where name=%s and (service_type&1) = 1;"
            default_tenant_name = 'Owner'
            schema_tuple = (default_tenant_name, custId)

            try:
                conn = self.get_connection("Owner")
                cur = conn.cursor()
                cur.execute(get_query, schema_tuple)
                row = cur.fetchone()
                conn.close()
                if row:
                    logger.debug("#isTenantCreated : Tenant exists :" + custId)
                    return True
                else:
                    logger.debug("#isTenantCreated : Tenant does not exist :" + custId)
                    return False
            except Exception as e:
                logger.error("Error while executing query in isTenantCreated: " + custId);
                logger.error(e)
                conn.close()
                return False
        except Exception as e:
            logger.error("Exception raised in isTenantCreated : " + custId)
            logger.error(e)
            return False

    def isValidTenant(self, custId):
        data = self.getCustomTenantDetails(custId)
        if 'org_id' in data:
            return True
        return False

    def getTenantDetails(self, custId):
        try:
            URL = os.environ["CC_API_URL"] if "CC_API_URL" in os.environ else self.get_cc_url()
            svcName = ''
            with open(SERVICE_PROFILE_CONF) as data_file:
                data = json.load(data_file)

            for item in data['Services']:
                svcName = item['Name']

            targetURL = URL + "root/customers/" + custId
            service_key = self.getCCServiceKey(targetURL)
            headers = {'Content-Type': 'application/json', 'Authorization': "CWSAuth service=" + service_key}
            payload = self.httpRequest(targetURL, headers)
            return payload
        except Exception as e:
            logger.error(e)
            return ''

    def getCustomTenantDetails(self, custId):
        try:
            result = self.getTenantDetails(custId)
            result = json.loads(result)
            result = result['message']
            result['display_name'] = result.pop('displayName')
            result['nick_name'] = result.pop('nickname')
            result['created_by_email'] = result.pop('createdByEmail')
            result['org_id'] = result.pop('orgId')
            return result
        except Exception as e:
            logger.error('Exception in getting custom tenant details')
            logger.error(e)
            return ''

    def getUsername(self, custId):
        try:
            payload = self.getTenantDetails(custId)
            logger.debug("user details payload = %s", payload)
            msg = json.loads(payload)
            errorcode = msg['errorcode']
            if errorcode == 200:
                payload = msg['message']
                for key, value in list(payload.items()):
                    if key == "createdByEmail":
                        return value
            else:
                logger.error("Could not get the details of user: %s ", custId)
            return ''
        except Exception as e:
            logger.error(e)
            return ''

    def getSecretFromAWS(self, secret_name, region_name):
        # Create a Secrets Manager client
        session = boto3.session.Session()
        client = session.client(service_name='secretsmanager', region_name=region_name)
        error_code = 0
        try:
            get_secret_value_response = client.get_secret_value(SecretId=secret_name)
        except ClientError as e:
            if e.response['Error']['Code'] == 'ResourceNotFoundException':
                error_message = "The requested secret " + secret_name + " was not found"
                logger.error(error_message)
                error_code = 1
            elif e.response['Error']['Code'] == 'InvalidRequestException':
                error_message = "The request was invalid due to:%s" % repr(e)
                logger.error(error_message)
                error_code = 2
            elif e.response['Error']['Code'] == 'InvalidParameterException':
                error_message = "The request had invalid params: %s" % repr(e)
                logger.error(error_message)
                error_code = 3
        else:
            # Decrypted secret using the associated KMS CMK
            # Depending on whether the secret was a string or binary, one of these fields will be populated
            if 'SecretString' in get_secret_value_response:
                secret = get_secret_value_response['SecretString']
                return error_code, secret
        return error_code, ''

    def get_adm_kms_key(self, region, kms_key_str):
        kms_client = boto3.client('kms', region_name=region)
        aliases_response = kms_client.list_aliases()
        aliases = aliases_response['Aliases']
        for alias in aliases:
            kms_key = alias['AliasName']
            if kms_key_str in kms_key:
                return kms_key
        raise Exception("Failed to fetch NetScaler Console key from AWS secrets manager")
    
    def getMapsApiKey(self):
        secret_name= "maps_api_key"
        region_name = "eu-central-1"
        error_code, secret_val = self.getSecretFromAWS(secret_name, region_name)
        if (error_code == 1 or secret_val == ''):
            logger.error("Error in extracting maps_api_key from AWS")
        else:
            secret_val_json = json.loads(secret_val)
            secret_key= secret_val_json["maps_api_key"]
            with open("/mpsconfig/maps_api_key", "w") as f:
                f.write(secret_key)            
        return secret_val      

    def create_secret(self, name, secret, region_name, kms_key_str):
        try:
            session = boto3.session.Session()
            client = session.client(service_name='secretsmanager', region_name=region_name)
            adm_kms_key = self.get_adm_kms_key(region_name, kms_key_str)
            create_secret_string_response = client.create_secret(Name=name, KmsKeyId=adm_kms_key, SecretString=secret)
        except ClientError as e:
            if e.response['Error']['Code'] == 'ResourceExistsException':
                error_message = "The requested secret " + name + " already exists"
                logger.error(error_message)
            elif e.response['Error']['Code'] == 'InvalidRequestException':
                error_message = "The request was invalid: " + str(e)
                logger.error(error_message)
            elif e.response['Error']['Code'] == 'InvalidParameterException':
                error_message = "The request had invalid params: " + str(e)
                logger.error(error_message)
            elif e.response['Error']['Code'] == 'AccessDeniedException':
                error_message = "Access Denied: " + str(e)
                logger.error(error_message)
        except Exception as e:
            logger.error("Exception while creating secret")
            logger.error(str(e))
            raise
        else:
            logger.debug('create_secret:Successfully set the secret : ' + name)
            return

    def requestFreeEntitlement(self, custId):
        try:
            orgId = '';
            emailId = '';
            payload = self.getTenantDetails(custId)
            logger.debug("user details payload = %s", payload)
            msg = json.loads(payload)
            errorcode = msg['errorcode']
            if errorcode == 200:
                payload = msg['message']
                for key, value in list(payload.items()):
                    if key == "createdByEmail":
                        emailId = value
                    elif key == "orgId":
                        orgId = value

            ret_result = self.post_order(orgId, emailId, "freemium", 2, None)
            if (ret_result):
                return 0;
            else:
                logger.error("Could not get the details of user for requesting an entitlement : %s ", custId)
        except Exception as e:
            logger.error("Exception when request for free entitlement : %s", e)
        return 1

    # Get username and CC region info to the tenant
    def getUsernameAndRegion(self, custId):
        result = {}
        try:
            payload = self.getTenantDetails(custId)
            logger.debug("user details payload = %s", payload)
            msg = json.loads(payload)
            if CC_TENANT_ERRCODE in msg and msg[CC_TENANT_ERRCODE] == 200:
                result = msg[CC_TENANT_MSG]
            else:
                logger.error("Could not get the details of user: %s ", custId)
        except Exception as e:
            logger.error("Exception: %s" % (repr(e)))
        finally:
            return result

    # Create new tenant for NetScaler Console
    def createTenant(self, custId, message, action):
        createTenantFlag = False
        try:
            email = None
            cc_region = CC_TENANT_DEF_GEO

            # Get the email and region info
            info = self.getUsernameAndRegion(custId)
            if CC_TENANT_EMAIL in info:
                email = str(info[CC_TENANT_EMAIL])
            if CC_TENANT_GEO in info:
                cc_region = str(info[CC_TENANT_GEO])

            logger.debug("createTenant Cust : %s, CC Region: %s" % (custId, cc_region))

            if not email:
                email = 'dummy'

            targetURL = "http://%s:%s/nitro/v1/config/tenant" % (MGMT_MONIT_HOST, MGMT_MONIT_PORT)
            headers = {'Content-Type': 'application/json'}
            data = 'object={"tenant":{"name":"' + str(custId) + '","user_name":"' + str(email) + '","password":"dummy","cc_region":"' + str(cc_region) + '","entitlement":"' + message.replace(
                '\"', '\\\"') + '"}}'
            tmp_data = data.replace("dummy", "*******")
            logger.debug("data = %s", tmp_data)
            httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
            responseStatus, resp = httpConnection.request(targetURL, 'POST', headers=headers, body=data)
            resp = resp.decode()
            response = json.loads(resp)
            logger.debug("response = %s", response)
            if (str(responseStatus['status']) == '200'):
                errorcode = response['errorcode']
                if errorcode == 0:
                    logger.debug("Tenant creation successful : %s", custId)
                    createTenantFlag = True
                    if (os.path.exists(CAS_CONF) == True):
                        self.createAAResources(custId)
                        self.createAAResourceswithAgentConfPush(custId)
                        logger.debug(" Creating Cloud Analytics Resources for Tenant: %s ", custId)
                    else:
                        logger.debug("cas_server_info.conf file not present skipping AA Resource Creation ")
                else:
                    logger.debug("Tenant creation failed error code not OK : %s", custId)
                    createTenantFlag = False
            else:
                logger.debug("Tenant creation failed: %s", custId)
                createTenantFlag = False
        except Exception as e:
            logger.error("Exception while creating tenant %s : %s ", custId, e)
            createTenantFlag = False
        finally:
            logger.debug("Returning from function createTenant : %s", custId)
            return createTenantFlag

    def add_license(self, custId, message, action, createTenantFlag):
        fulfillmentQueue = ''
        sendQueueConn = ''
        svcName = ''
        ent_id_list = ''
        retFlag = False
        try:
            with open(SERVICE_PROFILE_CONF) as data_file:
                data = json.load(data_file)

                for item in data['Services']:
                    svcName = item['Name']

                for item in data['ResourceProviders']:
                    fulfillmentQueue = item['FulfillmentQueue']
                    sendQueueConn = item['SendQueueConnectionString']

            message_json = '[' + message + ']'
            message_json.replace(':true}', ':True}')
            logger.debug("#add_license message = " + message)
            message_json = json.loads(message_json)
            if createTenantFlag is True:
                for item in message_json:
                    logger.debug("items = " + str(item))
                    item = json.dumps(item)
                    ent_message = json.loads(item)
                    ent_id = ent_message['EntitlementId']
                    if (ent_id_list.find(ent_id) == -1):
                        if ent_id_list != '':
                            ent_id_list = ent_id_list + "," + ent_id
                        else:
                            ent_id_list = ent_id
                        try:
                            retFlag = self.insert_lic_entitlement_to_db(item, action)
                            if retFlag is True:
                                self.send_fulfillment_request(fulfillmentQueue, sendQueueConn, item, svcName, action,
                                                              'Success')
                                logger.debug("#add_license : License added successfully: %s", custId)
                            else:
                                self.send_fulfillment_request(fulfillmentQueue, sendQueueConn, item, svcName, action,
                                                              'Failure')
                        except Exception as e:
                            logger.error("Exception while insert data into DB %s : %s ", custId, e)
                            return

        except Exception as e:
            logger.error("Exception while adding license %s : %s ", custId, e)
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print(exc_type, fname, exc_tb.tb_lineno)
            return

    def create_tenant_on_request(self, custId, email, message):
        thread = Thread(target=self.tenant_create, args=(custId, email, "1", "", message))
        thread.start()

    def tenant_create(self, custId, email, serviceType, adminTenant, message):
        try:
            if (adminTenant is None):
                adminTenant = ""
            if (message is None):
                messsage = ""
            else:
                message = message.replace('\"', '\\\"')

            targetURL = "http://%s:%s/nitro/v1/config/tenant" % (MGMT_MONIT_HOST, MGMT_MONIT_PORT)
            headers = {'Content-Type': 'application/json'}
            data = 'object={"tenant":{"name":"' + custId + '","user_name":"' + email + '","password":"dummy","service_type":' + str(
                serviceType) + ',"admin_tenant":"' + str(adminTenant) + '","entitlement":"' + str(message) + '"}}'
            logger.debug("data = %s", data)
            httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
            responseStatus, resp = httpConnection.request(targetURL, 'POST', headers=headers, body=data)
            resp = resp.decode()
            response = json.loads(resp);
            logger.debug("response = %s", response)
            if (str(responseStatus['status']) == '200'):
                errorcode = response['errorcode']
                if errorcode == 0:
                    logger.debug("Tenant creation successful: %s", custId)
                else:
                    logger.error("Tenant creation failed error code not OK : %s", custId)
            else:
                logger.debug("Tenant creation failed: %s", custId)

        except Exception as e:
            logger.error("Exception while creating tenant %s : %s ", custId, e)

        logger.debug("Returning from function createTenant : %s", custId)

    # Read CAS Service Host info from /mpsconfig/cas_server_info.conf
    def readCASHost(self):
        # cas_svc_host:https://dummy.cloud.com/casvc/
        with open(CAS_CONF) as data_file:
            data = json.load(data_file)
            for key, value in list(data.items()):
                self.CASSvcHost[key.upper()] = value[CC_CAS_SVC]

        logger.debug("CASSvcHost: %s" % (self.CASSvcHost))

    # Get CAS Host info based on tenant region
    def getCASHost(self, cc_region, regionInADM):
        host = None
        try:
            if len(self.CASSvcHost) == 0:
                self.readCASHost()

            # Default - CAS US, else pick Geo-specific hosts
            cc_region = cc_region.upper()
            if cc_region == CC_REGION_EU:
                host = self.CASSvcHost[CC_REGION_EU]
            elif cc_region == CC_REGION_JP:
                host = self.CASSvcHost[CC_REGION_JP]
            elif cc_region == CC_REGION_APS:
                # Select CAS APS host only if both Region in CC and NetScaler Console are 'AP-S', else default host
                logger.debug("getCASHost: cc_region=%s regionInADM=%s" % (cc_region, regionInADM))
                if regionInADM is not None and regionInADM == CC_REGION_APS:
                    host = self.CASSvcHost[CC_REGION_APS]
                else:
                    host = self.CASSvcHost[CC_REGION_DEF]
            else:
                host = self.CASSvcHost[CC_REGION_DEF]

        except Exception as e:
            logger.error("Exception: %s" % (repr(e)))
        finally:
            return host

    # Create Advance Analytics resources at CAS side
    def createAAResources(self, custId, regionInADM, isNGSAdmin="False"):
        createAAResourcesFlag = "False"
        try:
            email = "dummy"
            cc_region = "NONE"
            info = self.getUsernameAndRegion(custId)
            if CC_TENANT_EMAIL in info:
                email = str(info[CC_TENANT_EMAIL])
            if CC_TENANT_GEO in info:
                cc_region = str(info[CC_TENANT_GEO])

            logger.debug("createAAResources custId : %s , email : %s region : %s, isNGSAdmin: %s, regionInADM: %s", custId, email,
                         cc_region, isNGSAdmin, regionInADM)

            if isNGSAdmin == "True":
                # if NGS Admin, we need to get the CAS Host for the given geo - regionInADM
                # ( cc_region of the tenant shouldn't be considered )
                cas_fqdn = self.getCASHost(regionInADM, regionInADM)
            else:
                cas_fqdn = self.getCASHost(cc_region, regionInADM)

            if cas_fqdn is not None:
                targetURL = "%s%s/ctxana/v1/cas/%s/NetScaler/MasService/onboardingresources" % (
                    cas_fqdn, custId, custId)
                logger.debug("createAAResources targetURL : %s ", targetURL)
                data = '{"customerName":"' + custId + '","customerEmail":"' + email + '","cna": true}'
                # Fill the offering type in the payload based on the deployment type
                if self.is_ads_service_type_automation():
                    data = '{"customerName":"' + custId + '","customerEmail":"' + email + '","offering": "adsauto"}'
                elif self.is_ads_service_type_intent():
                    data = '{"customerName":"' + custId + '","customerEmail":"' + email + '","offering": "adsintent"}'

                logger.debug("createAAResources data : %s ", data)
                service_key = self.getCCServiceKey(targetURL)
                headers = {'Content-Type': 'application/json', 'Authorization': "CWSAuth service=" + service_key}

                httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
                responseStatus, resp = httpConnection.request(targetURL, 'POST', headers=headers, body=data)
                resp = resp.decode()
                response = json.loads(resp)
                logger.debug("response = %s", response)
                if (str(responseStatus['status']) == '200'):
                    logger.debug("Advanced Analytics Resource creation successful: %s", custId)
                    createAAResourcesFlag = "True"
                else:
                    errorcode = response['error']
                    logger.debug("Advanced Analytics Resource creation failed: %s , error : %s, status : %s ", custId,
                                 errorcode, responseStatus['status'])
                    createAAResourcesFlag = "False"
            else:
                logger.error("CAS FQDN is None")

        except Exception as e:
            logger.exception("Exception while creating AA Resources tenant %s : %s ", custId, e)
            createAAResourcesFlag = "False"

        finally:
            logger.debug("Advanced analytics resource creation custId=%s status=%s" % (custId, createAAResourcesFlag))
            return createAAResourcesFlag

    # Create Advance Analytics resource for Agent config
    def createAAResourceswithAgentConfPush(self, custId, regionInADM, isNGSAdmin="False"):
        createAAwithAgentPushFlag = "False"
        try:
            if (os.path.exists(CAS_CONF) == False):
                logger.debug("createAAResourceswithAgentConfPush cas_server_info.conf file not present ")
                return createAAwithAgentPushFlag

            email = "dummy"
            cc_region = "NONE"
            info = self.getUsernameAndRegion(custId)
            if CC_TENANT_EMAIL in info:
                email = str(info[CC_TENANT_EMAIL])
            if CC_TENANT_GEO in info:
                cc_region = str(info[CC_TENANT_GEO])

            logger.debug("createAAResourceswithAgentConfPush custId : %s , email : %s region : %s, isNGSAdmin: %s, regionInADM: %s", custId, email,
                         cc_region, isNGSAdmin, regionInADM)

            if isNGSAdmin == "True":
                # if NGS Admin, we need to get the CAS Host for the given geo - regionInADM
                # ( cc_region of the tenant shouldn't be considered )
                cas_fqdn = self.getCASHost(regionInADM, regionInADM)
            else:
                cas_fqdn = self.getCASHost(cc_region, regionInADM)

            if cas_fqdn is not None:
                targetURL = "%s%s/ctxana/v1/cas/%s/NetScaler/analyticsenablement" % (cas_fqdn, custId, custId)
                logger.debug("createAAResourceswithAgentConfPush targetURL : %s ", targetURL)
                service_key = self.getCCServiceKey(targetURL)
                headers = {'Content-Type': 'application/json', 'Authorization': "CWSAuth service=" + service_key}
                data = '{"sourceType":"MasService","customerName":"' + custId + '","customerEmail":"' + email + '","cna": true }'
                # Fill the offering type in the payload based on the deployment type
                if self.is_ads_service_type_automation():
                    data = '{"sourceType":"MasService","customerName":"' + custId + '","customerEmail":"' + email + '","offering": "adsauto" }'
                elif self.is_ads_service_type_intent():
                    data = '{"sourceType":"MasService","customerName":"' + custId + '","customerEmail":"' + email + '","offering": "adsintent" }'

                logger.debug("createAAResourceswithAgentConfPush data : %s ", data)

                httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
                responseStatus, resp = httpConnection.request(targetURL, 'PUT', headers=headers, body=data)
                resp = resp.decode()
                logger.debug(responseStatus)

                if (str(responseStatus['status']) == '200'):
                    logger.debug("Advanced Analytics Resource creation successful: %s", custId)
                    createAAwithAgentPushFlag = "True"
                else:
                    logger.debug("Advanced Analytics Resource creation failed: %s , status : %s ", custId,
                                 responseStatus['status'])
                    createAAwithAgentPushFlag = "False"
            else:
                logger.error("CAS FQDN is None")

        except Exception as e:
            logger.exception("Exception while creating tenant %s : %s ", custId, e)
            createAAwithAgentPushFlag = "False"

        finally:
            logger.debug(
                "createAAwithAgentPushFlag resource creation custId=%s status=%s" % (custId, createAAwithAgentPushFlag))
            return createAAwithAgentPushFlag

    def deleteAAResources(self, custId):
        deleteAAResourcesFlag = "False"

        if (os.path.exists(CAS_CONF) == False):
            logger.debug("deleteAAResources cas_server_info.conf file not present ")
            return deleteAAResourcesFlag

        email = "dummy"
        cc_region = "NONE"
        info = self.getUsernameAndRegion(custId)
        if CC_TENANT_EMAIL in info:
            email = str(info[CC_TENANT_EMAIL])
        if CC_TENANT_GEO in info:
            cc_region = str(info[CC_TENANT_GEO])

        logger.debug("deleteAAResources custId : %s , email : %s region : %s", custId, email,
                     cc_region)
        cas_fqdn = self.getCASHost(custId)
        if cas_fqdn is not None:
            targetURL = "%s%s/ctxana/v1/cas/%s/nssitedelete" % (cas_fqdn, custId, custId)
            service_key = self.getCCServiceKey(targetURL)
            headers = {'Content-Type': 'application/json', 'Authorization': "CWSAuth service=" + service_key}
            data = '{"sourceType":"MasService","customerName":"' + custId + '","customerEmail":"' + email + '"}'
            logger.debug("deleteAAResources data : %s ", data)
            try:
                httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
                responseStatus, resp = httpConnection.request(targetURL, 'DELETE', headers=headers, body=data)
                resp = resp.decode()
                response = json.loads(resp)
                logger.debug("response = %s", response)
                if (str(responseStatus['status']) == '200'):
                    logger.debug("Advanced Analytics Resource deletion successful: %s", custId)
                    deleteAAResourcesFlag = "True"
                else:
                    errorcode = response['error']
                    logger.debug("Advanced Analytics Resource deletion failed: %s , error : %s, status : %s ", custId,
                                 errorcode, responseStatus['status'])
                    deleteAAResourcesFlag = "False"

            except Exception as e:
                logger.error("Exception while deleting AA Resources for tenant %s : %s ", custId, e)
                deleteAAResourcesFlag = "False"
        else:
            logger.error("CAS FQDN is None")
        logger.debug("Advanced analytics resource deletion completed: %s", custId)
        return deleteAAResourcesFlag

    # Create Token for CAS LUI
    def generate_cas_lui_token(self, custId):
        generateCASLUIToken = "False"
        try:
            if (os.path.exists(CAS_CONF) == False):
                logger.debug("generate_cas_lui_token cas_server_info.conf file not present ")
                return generateCASLUIToken

            email = "dummy"
            cc_region = "NONE"
            info = self.getUsernameAndRegion(custId)
            if CC_TENANT_EMAIL in info:
                email = str(info[CC_TENANT_EMAIL])
            if CC_TENANT_GEO in info:
                cc_region = str(info[CC_TENANT_GEO])

            logger.debug("generate_cas_lui_token custId : %s , email : %s region : %s", custId, email,
                         cc_region)

            cas_fqdn = self.getCASHost(cc_region, cc_region)
            if cas_fqdn is not None:
                targetURL = "%s%s/ctxana/v1/cas/%s/License/cico/dsconfigdata" % (cas_fqdn, custId, custId)
                logger.debug("generate_cas_lui_token targetURL : %s ", targetURL)
                service_key = self.getCCServiceKey(targetURL)
                headers = {'Content-Type': 'application/json', 'Authorization': "CWSAuth service=" + service_key}
                data = '{"sourceType":"MasService","customerName":"' + custId + '","customerEmail":"' + email + '"}'
                logger.debug("generate_cas_lui_token data : %s ", data)

                httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
                responseStatus, resp = httpConnection.request(targetURL, 'POST', headers=headers, body=data)
                resp = resp.decode()
                logger.debug(responseStatus)
                response = json.loads(resp)

                status = True
                if (str(responseStatus['status']) == '200'):
                    logger.debug("CAS LUI Resource creation successful: %s", custId)
                    generateCASLUIToken = "True"

                    sql_query = "SET SCHEMA %s; DELETE FROM cas_lui_token;"
                    sql_query = sql_query + "INSERT INTO cas_lui_token (prop_key, prop_value) VALUES (%s , %s);"
                    sql_query = sql_query + "INSERT INTO cas_lui_token (prop_key, prop_value) VALUES (%s , %s);"
                    sql_query = sql_query + "INSERT INTO cas_lui_token (prop_key, prop_value) VALUES (%s , %s);"
                    data_tuple = (custId, 'eventHubEndpoint', str(response['eventHubEndpoint']), 'eventHubToken',
                                  str(response['eventHubToken']), 'eventHubExpiry', str(response['eventHubExpiry']))
                    try:
                        self.execute_query_to_db(custId, sql_query, data_tuple)
                    except Exception as e:
                        logger.error(
                            "Error while executing query in customer : " + custId + ", sql_query:" + sql_query);
                else:
                    logger.debug("CAS LUI Resource creation failed: %s , status : %s ", custId,
                                 responseStatus['status'])
                    generateCASLUIToken = "False"
            else:
                logger.error("CAS FQDN is None")

        except Exception as e:
            logger.error("Exception while generate_cas_lui_token tenant %s : %s ", custId, e)
            generateCASLUIToken = "False"

        finally:
            logger.debug("generate_cas_lui_token resource creation custId=%s status=%s" % (custId, generateCASLUIToken))
            return generateCASLUIToken

    def upload_cas_lui_data(self, custId, payload):
        try:
            logger.debug("payload = %s", payload)
            get_query = "SET SCHEMA %s; SELECT prop_key, prop_value from cas_lui_token;"
            schema_tuple = (custId,)
            self.get_connection(custId)
            cur = self.conn.cursor()
            cur.execute(get_query, schema_tuple)
            rows = cur.fetchall()
            self.close_connection()

            eventHubEndpoint = ""
            eventHubToken = ""
            eventHubExpiry = ""

            for row in rows:
                tmp = str(row[0])
                if (str(row[0]) == 'eventHubEndpoint'):
                    eventHubEndpoint = str(row[1])
                elif (str(row[0]) == 'eventHubToken'):
                    eventHubToken = str(row[1])
                elif (str(row[0]) == 'eventHubExpiry'):
                    eventHubExpiry = str(row[1])

            email = "sample"
            info = self.getUsernameAndRegion(custId)
            if CC_TENANT_EMAIL in info:
                email = str(info[CC_TENANT_EMAIL])

            data = {}
            data["ver"] = "1"
            data["id"] = str(uuid.uuid4())
            data["prod"] = "ADM"
            data["type"] = "Licensing.Bandwidth.CICO"

            now = datetime.datetime.now()
            data["st"] = now.strftime("%Y-%m-%dT%H:%M:%S.%fZ")

            data["user"] = {"Email": email}
            data["tenant"] = {"id": custId}
            payload_list = json.loads(payload)
            data["payload"] = {"format": "json", "license_monthly_usage": payload_list}

            headers = {'Authorization': eventHubToken, 'Content-Type': 'application/json'}
            httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
            responseStatus, resp = httpConnection.request(eventHubEndpoint, 'POST', headers=headers,
                                                          body=json.dumps(data))
            if (str(responseStatus['status']) == '201'):
                logger.debug("upload_cas_lui_data successful: %s", custId)
            else:
                logger.debug("upload_cas_lui_data failed Tenant : %s, error code : %s", custId,
                             str(responseStatus['status']))
        except Exception as e:
            logger.error("Exception raised in upload_cas_lui_data tenant %s : %s ", custId, e)

    def updateTenantDB(self, schema, message):
        try:
            get_query = u"set schema 'Owner'; select name from tenant where name=%s and (service_type&1) = 1;"
            schema_tuple = (schema,)

            try:
                conn = self.get_connection("Owner")
                cur = conn.cursor()
                cur.execute(get_query, schema_tuple)
                row = cur.fetchone()
                conn.close()
                if row:
                    logger.debug("#updateTenantDB : Tenant exists already :" + schema)
                    return True
                else:
                    logger.debug("#updateTenantDB : create tenant for NetScaler Console :" + schema)
                    self.create_tenant_on_request(schema, "", message)
            except Exception as e:
                logger.error("Error while executing query in updateTenantDB: " + schema);
                logger.error(e)
                conn.close()
                return False

            return True

        except Exception as e:
            logger.error("Exception raised in updateTenantDB")
            logger.error(e)
            return False

    def execute_query_to_db_wrapper(self, schema, set_schema_query, schema_tuple, query_dict, action):
        try:
            index = 0
            counter = 0
            flag = 0
            conn = self.get_connection(schema)
            cur = self.get_cursor()
            if len(query_dict[action][0]['query']) != len(query_dict[action][1]['tuple']):
                logger.error("length of query list and tuple list doesn't match")
                self.close_connection()
                return False
            else:
                for key, value in list(query_dict.items()):
                    if key == action:
                        while (counter >= index and counter < len(query_dict[action][0]['query'])):
                            query = value[0]['query'][index]
                            qtuple = value[1]['tuple'][index]
                            if qtuple == None:
                                self.cur.execute(set_schema_query, schema_tuple)
                                retFlag = self.cur.execute(query)
                            else:
                                self.cur.execute(set_schema_query, schema_tuple)
                                retFlag = self.cur.execute(query, qtuple)
                                self.conn.commit()
                            if retFlag == None:
                                index += 1
                                counter += 1
                                flag = 1
                            else:
                                index += 1
                                flag = 0
                        if flag == 1:
                            self.update_mas_license(schema)
                        self.close_connection()
                        return True
                    else:
                        logger.error("length of query list and tuple list doesn't match")
                        self.close_connection()
                        return False
        except Exception as e:
            self.close_connection()
            logger.error(e)
            logger.error("Exception raised in execute_query_to_db_wrapper")
            return False

    def get_tanant_details_grp(self):

        try:
            con1 = self.get_connection("Owner")
        except:
            logger.error("Could not get DB connection ")
            return False

        if not con1:
            logger.error("Could not get DB connection")
            return False

        try:
            query_str = "SET SCHEMA 'Owner';select name, user_name, service_type from tenant;"
            self.get_cursor()
            self.cur.execute(query_str)
            rows = self.cur.fetchall()
            self.conn.commit()
            self.close_connection()
            with open('tenants.txt', 'w') as f:
                for row in rows:
                    tmp = ""
                    tmp = str(row[0]) + "," + str(row[1]) + "," + str(row[2]) + "\n"
                    f.write(str(tmp))
            logger.debug("Query successfully executed, %s", query_str)
        except Exception as e:
            self.close_connection()
            print(e)
            logger.error("Error happen executing query %s. %s" % (query_str, str(e)))
            return False

    def create_user(self, user, schema, groupNames):
        try:
            targetURL = "http://%s:%s/nitro/v1/config/mpsuser" % (MGMT_MONIT_HOST, MGMT_MONIT_PORT)
            groupName = json.dumps(groupNames)
            data = 'object={ "tenant_name": "' + str(schema) + '","mpsuser":{"name":"' + str(
                user) + '","password":"' + str(uuid.uuid4()) + '","groups":' + groupName + '}}'
            headers = {'Content-Type': 'application/json'}
            httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
            responseStatus, resp = httpConnection.request(targetURL, 'POST', headers=headers, body=data)
            resp = resp.decode()
            if (str(responseStatus['status']) == '200'):
                response = json.loads(resp)
                logger.debug("response = %s", response)
                errorcode = response['errorcode']
                if errorcode == 0:
                    logger.debug("Create user successful: %s", schema)
                else:
                    logger.debug("Create user failed error code not OK : %s", schema)

            else:
                logger.debug("Create user failed error code not OK : %s", schema)
        except Exception as e:
            logger.error("Exception raised in create_user")
            logger.error(e)

    def update_user(self, user, schema, groupNames):
        try:
            targetURL = "http://%s:%s/nitro/v1/config/mpsuser" % (MGMT_MONIT_HOST, MGMT_MONIT_PORT)
            groupName = json.dumps(groupNames)
            data = '{ "tenant_name": "' + str(schema) + '","mpsuser":{"name":"' + str(user) + '","password":"' + str(
                uuid.uuid4()) + '","groups":' + groupName + '}}'
            headers = {'Content-Type': 'application/json'}
            httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
            responseStatus, resp = httpConnection.request(targetURL, 'PUT', headers=headers, body=data)
            resp = resp.decode()
            if (str(responseStatus['status']) == '200'):
                response = json.loads(resp)
                logger.debug("response = %s", response)
                errorcode = response['errorcode']
                if errorcode == 0:
                    logger.debug("Update user successful: %s", schema)
                else:
                    logger.debug("Update user failed error code not OK : %s", schema)

            else:
                logger.debug("Update user failed error code not OK : %s", schema)
        except Exception as e:
            logger.error("Exception raised in update_user")
            logger.error(e)

    def delete_user(self, user, schema):
        try:
            targetURL = "http://%s:%s/nitro/v1/config/mpsuser" % (MGMT_MONIT_HOST, MGMT_MONIT_PORT)
            data = 'object={ "tenant_name": "' + str(schema) + '","mpsuser":{"name":"' + str(user) + '"}}'
            headers = {'Content-Type': 'application/json'}
            httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
            responseStatus, resp = httpConnection.request(targetURL, 'DELETE', headers=headers, body=data)
            resp = resp.decode()
            if (str(responseStatus['status']) == '200'):
                response = json.loads(resp)
                logger.debug("response = %s", response)
                errorcode = response['errorcode']
                if errorcode == 0:
                    logger.debug("Delete user successful: %s", schema)
                else:
                    logger.debug("Delete user failed error code not OK : %s", schema)

            else:
                logger.debug("Delete user failed error code not OK : %s", schema)
        except Exception as e:
            logger.error("Exception raised in delete_user")
            logger.error(e)
            
    def get_entitled_vips_storage(self, skuId, quantity):
        if ("ADM" == self.get_svc_for_sku(skuId)):
            return self.get_entitled_adm(skuId, quantity)
        elif ("AUTOMATION" == self.get_svc_for_sku(skuId)):
            return self.get_entitled_ads_automation(skuId, quantity)
        elif (self.IsValidSku(skuId)):
            return 0,0,0
        else:
            return -1,0,0

    def IsValidSku(self, skuId):
        skuIdList = list(set(self.skuNameId.values()))
        if (skuId in skuIdList):
            return True
        else:
            return False

    def get_entitled_adm(self, skuId, qnty):
        max_vips = 0
        max_storage = 0
        max_tp_vservers = 0
        try:
            if (skuId == self.get_adm_vips_skuId()):
                max_vips = qnty
                max_storage = DEFAULT_STORAGE_PER_VIP * float(qnty)
            elif (skuId == self.get_adm_storage_skuId()):
                max_storage = DEFAULT_STORAGE_PER_SKU * float(qnty)
            elif (skuId== self.get_adm_tp_skuId()):
                max_tp_vservers = qnty
                max_storage = DEFAULT_STORAGE_PER_VIP * float(qnty)
            elif (skuId == self.get_adm_trial_skuId()):
                max_storage = DEFAULT_STORAGE_PER_SKU
                max_vips = DEFAULT_VIPS_PER_SKU
                max_tp_vservers = DEFAULT_TPVIPS_PER_SKU
            elif (skuId == self.get_adm_freemium_skuId()):
                max_storage = DEFAULT_STORAGE_PER_FREE_SKU
                max_vips = DEFAULT_VIPS_PER_FREE_SKU
            elif (skuId == self.get_adm_azpu_skuId()):
                max_vips = qnty
                max_storage = DEFAULT_STORAGE_PER_VIP * float(qnty)
            elif (skuId == self.get_adm_azpustorage_skuId()):
                max_storage = DEFAULT_STORAGE_PER_SKU * float(qnty)
            else:
                logger.debug("Entitlement not identified, Not inserting into DB")
                return False,False,False

        except Exception as e:
            logger.error("Exception raised in get_entitled_adm")
            logger.error(e)
            return -1, 0, 0
        return max_vips, max_storage, max_tp_vservers


    def get_entitled_ads_automation(self, skuId, qnty):
        max_vips = 0
        max_storage = 0
        max_tp_vservers = 0
        try:
            if (skuId == self.get_ads_automation_vips_skuId()):
                max_vips = qnty
                max_storage = ADS_DEFAULT_STORAGE_PER_VIP * float(qnty)
            elif (skuId == self.get_ads_automation_storage_skuId()):
                max_storage = ADS_DEFAULT_STORAGE_PER_SKU * float(qnty)
            elif (skuId == self.get_ads_automation_trial_skuId()):
                max_storage = ADS_TRIAL_STORAGE
                max_vips = ADS_TRIAL_VIPS_PER_SKU
                max_tp_vservers = ADS_TRIAL_VIPS_PER_SKU
            else:
                logger.debug("Entitlement not identified, Not inserting into DB")
                return -1,0,0

        except Exception as e:
            logger.error("Exception raised in get_entitled_ads_automation")
            logger.error(e)
            return -1, 0, 0
        return max_vips, max_storage, max_tp_vservers

    def insert_lic_entitlement_to_db(self, data, action):
        try:
            query_dict = dict()
            msg = json.loads(data)
            entId = msg['EntitlementId']
            custId = msg['CustomerId']
            stDate = msg['StartDate']
            endDate = msg['EndDate']
            entType = msg['EntitlementType']
            prodSku = msg['ProductSku']
            qnty = msg['Quantity']
            serialNo = msg['SerialNumbers']
            approved = msg['Approved']
            max_vips = 0
            max_tp_vservers = 0
            max_storage = 0
            lic_type = 1
            end_time = 0
            schema = custId

            if approved is True:
                approved = 't'
            else:
                approved = 'f'

            tenantFlag = self.isTenantCreated(custId)
            if tenantFlag is False:
                thread = Thread(target=self.createTenant, args=(custId, data, action,))
                thread.start()
                return;
            curr_time = time.time()
            update_license_qry = "update job_Schedule set next_scheduletime = %s where job_name=%s"
            licence_qry_tuple = (curr_time, 'EmonJob')
            if (action == 'Extend'):
                try:
                    end_time = time.mktime(datetime.datetime.strptime(endDate, "%Y-%m-%dT%H:%M:%S.%fZ").timetuple())
                except:
                    end_time = time.mktime(datetime.datetime.strptime(endDate, "%Y-%m-%dT%H:%M:%SZ").timetuple())
                set_schema_query = "set schema %s;"
                schema_tuple = (schema,)
                update_qry = "update mas_service_license set lic_type = 1, end_date = %s, end_time = %s where entitlement_id = %s"
                if (self.is_ads_service_type_intent()):
                    update_qry = "update adc_service_license set lic_state = 1, end_date = %s, end_time = %s where entitlement_id = %s"
                update_tuple = (endDate, end_time, entId)
                logger.debug("update_qry = %s", set_schema_query + update_qry + update_license_qry)
                query_dict.update({action: []})
                query_dict[action].append({"query": [update_qry, update_license_qry]})
                query_dict[action].append({"tuple": [update_tuple, licence_qry_tuple]})

            if (action == 'Cancel'):
                set_schema_query = "set schema %s;"
                schema_tuple = (schema,)
                update_qry = "update mas_service_license set lic_type = 4 where entitlement_id = %s"
                if (self.is_ads_service_type_intent()):
                    update_qry = "update adc_service_license set lic_state = 4 where entitlement_id = %s"
                update_tuple = (entId,)
                logger.debug("update_qry = %s", set_schema_query + update_qry + update_license_qry)
                query_dict.update({action: []})
                query_dict[action].append({"query": [update_qry, update_license_qry]})
                query_dict[action].append({"tuple": [update_tuple, licence_qry_tuple]})

            if (action == 'Delete'):
                set_schema_query = "set schema %s;"
                schema_tuple = (schema,)
                delete_qry = "delete from mas_service_license where entitlement_id = %s"
                if (self.is_ads_service_type_intent()):
                    delete_qry = "delete from adc_service_license where entitlement_id = %s"
                delete_tuple = (entId,)
                logger.debug("delete_qry = %s", set_schema_query + delete_qry + update_license_qry)
                query_dict.update({action: []})
                query_dict[action].append({"query": [delete_qry, update_license_qry]})
                query_dict[action].append({"tuple": [delete_tuple, licence_qry_tuple]})

            max_vips, max_storage,max_tp_vservers =  self.get_entitled_vips_storage(prodSku, qnty)
            if 'INT_STORAGE' in prodSku:
                max_vips, max_storage,max_tp_vservers = 0,qnty,0

            if (max_vips == -1):
                logger.debug("Error in get_entitled_vips_storage")
                return False

            if (entType == "ProductionTrial"):
                lic_type = 0
            elif (prodSku == self.get_adm_freemium_skuId()):
                lic_type = FREE_LICENSE_TYPE

            key = ""
            encypMaxVips, key = self.encrypt(schema, max_vips, key)
            encypMaxStorage, key = self.encrypt(schema, max_storage, key)
            encypMaxTPVips, key = self.encrypt(schema, max_tp_vservers, key)
            encypQnty, key = self.encrypt(schema, qnty, key)

            try:
                st_epoch_time = time.mktime(datetime.datetime.strptime(stDate, "%Y-%m-%dT%H:%M:%S.%fZ").timetuple())
            except:
                st_epoch_time = time.mktime(datetime.datetime.strptime(stDate, "%Y-%m-%dT%H:%M:%SZ").timetuple())

            try:
                end_epoch_time = time.mktime(datetime.datetime.strptime(endDate, "%Y-%m-%dT%H:%M:%S.%fZ").timetuple())
            except:
                end_epoch_time = time.mktime(datetime.datetime.strptime(endDate, "%Y-%m-%dT%H:%M:%SZ").timetuple())

            set_schema_query = "set schema %s;"
            schema_tuple = (schema,)
            final_query = ''
            if (action == 'Deliver') and (not self.is_ads_service_type_intent()):
                insert_keys = 'id,max_vips,max_tp_vservers,max_storage,entitlement_id,customer_id,start_date,end_date,entitlement_type,product_sku,quantity,serial_numbers,approved,lic_type,end_time,start_time'
                insert_values = '%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s'
                insert_tuple = (
                    uuid.uuid4().urn[9:], encypMaxVips, encypMaxTPVips, encypMaxStorage, entId, custId, stDate, endDate,
                    entType, prodSku, encypQnty, entId, approved, str(lic_type), end_epoch_time, st_epoch_time)
                final_query = "INSERT INTO mas_service_license ( " + insert_keys + ") VALUES (" + insert_values + ");"
                self.updateTenantDB(schema, data);

            if (action == 'Deliver') and (self.is_ads_service_type_intent()):
                insert_keys = 'id,entitlement_id,customer_id,start_date,end_date,entitlement_type,product_sku,quantity,approved,lic_state'
                insert_values = '%s,%s,%s,%s,%s,%s,%s,%s,%s,%s'
                insert_tuple = (
                    uuid.uuid4().urn[9:], entId, custId, stDate, endDate,
                    entType, prodSku, encypQnty, approved, str(lic_type))
                final_query = "INSERT INTO adc_service_license ( " + insert_keys + ") VALUES (" + insert_values + ");"

            if (action == 'Upgrade') and (not self.is_ads_service_type_intent()):
                final_query = "UPDATE mas_service_license set max_vips=%s,max_tp_vservers=%s ,max_storage=%s ,quantity=%s,start_date=%s,end_date=%s,end_time=%s,start_time=%s where entitlement_id =%s"
                insert_tuple = (
                    encypMaxVips, encypMaxTPVips, encypMaxStorage, encypQnty, stDate, endDate, end_epoch_time,
                    st_epoch_time, entId)

            if (action == 'Upgrade') and (self.is_ads_service_type_intent()):
                final_query = "UPDATE adc_service_license set quantity=%s,start_date=%s,end_date=%s where entitlement_id =%s"
                insert_tuple = (
                    encypQnty, stDate, endDate, entId)

            if action == 'Deliver' or action == 'Upgrade':
                logger.debug("Query to be executed = %s", set_schema_query + final_query)
                query_dict.update({action: []})
                query_dict[action].append({"query": [final_query, update_license_qry]})
                query_dict[action].append({"tuple": [insert_tuple, licence_qry_tuple]})

            retFlag = self.execute_query_to_db_wrapper(schema, set_schema_query, schema_tuple, query_dict, action)
            if retFlag == True:
                return True
            else:
                return False

        except Exception as e:
            logger.error("Exception raised in insert_lic_entitlement_to_db")
            logger.error(e)
            return False

        return True

    def update_mas_license(self, schema):
        try:
            targetURL = "http://%s:%s/nitro/v1/config/mas_service_license" % (MGMT_MONIT_HOST, MGMT_MONIT_PORT)
            data = 'object={"params": {"action":"UPDATE_MAS_LICENSE"}, "tenant_name": "' + schema + '","mas_service_license":{"customer_id":"' + schema + '"}}'
            logger.debug("update_mas_license data = %s", data)
            headers = {'Content-Type': 'application/json'}
            httpConnection = httplib2.Http(disable_ssl_certificate_validation=True, ca_certs=CERT_BUNDLE_PATH)
            responseStatus, resp = httpConnection.request(targetURL, 'POST', headers=headers, body=data)
            resp = resp.decode()
            response = json.loads(resp);
            logger.debug("response = %s", response)
            if (str(responseStatus['status']) == '200'):
                errorcode = response['errorcode']
                if errorcode == 0:
                    logger.debug("update mas service license successful: %s", schema)
                else:
                    logger.debug("update mas service license failed error code not OK : %s", schema)
            else:
                logger.debug("update mas service license failed: %s", schema)
        except Exception as e:
            exc_type, exc_obj, exc_tb = sys.exc_info()
            fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
            print(exc_type, fname, exc_tb.tb_lineno)
            logger.error("Exception in update_mas_license : ", schema)
            logger.error(e)

    def expireEntitlement(self, custId, entId):
        try:
            try:
                with open(SERVICE_PROFILE_CONF) as data_file:
                    data = json.load(data_file)
                    sendQueueConn = ''
                    svcName = ''
                    for item in data['Services']:
                        svcName = item['Name']

                    for item in data['ResourceProviders']:
                        fulfillmentQueue = item['FulfillmentQueue']
                        sendQueueConn = item['SendQueueConnectionString']

                    key_name, key_value, endpoint, entitypath = self.getDetails(sendQueueConn)

                    bus_service = ServiceBusService(service_namespace=endpoint, shared_access_key_name=key_name,
                                                    shared_access_key_value=key_value)
                    payload = '{"EntitlementId":"' + entId + '","CustomerId":"' + custId + '","SerialNumbers":["' + entId + '"],"ServiceName":"' + svcName + '"}'
                    logger.debug("Expire request payload :" + payload)
            except Exception as e:
                logger.error(e)

            msg = Message(payload.encode('utf-8'), custom_properties={'Version': 1, 'Result': 'Expired'})
            bus_service.send_queue_message(fulfillmentQueue, msg)
        except Exception as e:
            logger.error("Exception while sending entitlement expire request")
            logger.error(e)

    def getSKUIds(self):
        try:
            with open(SERVICE_PROFILE_CONF) as data_file:
                data = json.load(data_file)
                trialSku = SERVICE_TRIAL_SKU
                vipSku = SERVICE_VIP_SKU
                storageSku = SERVICE_STORAGE_SKU
                tpSku = SERVICE_TP_SKU
                freeSku = SERVICE_FREE_SKU
                azpuSku = SERVICE_AZ_PU_SKU
                azpuStorageSku = SERVICE_AZ_PU_STORAGE_SKU

                item = data['ResourceProviders']
                for key, value in list(item[0].items()):
                    if (key == 'Products'):
                        try:
                            trialSku = value[0]['ProductSku']
                            vipSku = value[1]['ProductSku']
                            storageSku = value[2]['ProductSku']
                            tpSku = value[3]['ProductSku']
                            freeSku = value[4]['ProductSku']
                            try:
                                azpuSku = value[5]['ProductSku']
                            except IndexError:
                                logger.error("Azure public product sku missing...")
                            try:
                                azpuStorageSku = value[6]['ProductSku']
                            except IndexError:
                                logger.error("Azure public storage product sku missing...")
                        except IndexError:
                            logger.debug(
                                "Product section in service profile conf does not have 4 entries. Continuing with default values for missing entry...")
                            pass

                logger.debug(
                    "SKUIds are  trialSku = %s, vipSku = %s, storageSku = %s, tpSku = %s, freeSku = %s ,azpuSKU = %s ,azpuStorageSku=%s",
                    trialSku, vipSku, storageSku, tpSku, freeSku, azpuSku, azpuStorageSku)
                return trialSku, vipSku, storageSku, tpSku, freeSku, azpuSku, azpuStorageSku
        except:
            logger.error("Failed to get SKUIds from file %s", SERVICE_PROFILE_CONF)
            return SERVICE_TRIAL_SKU, SERVICE_VIP_SKU, SERVICE_STORAGE_SKU, SERVICE_TP_SKU, SERVICE_FREE_SKU, SERVICE_AZ_PU_SKU, SERVICE_AZ_PU_STORAGE_SKU

    def get_connection_str(self, db_name):
        try:
            file_test = os.path.exists(PGXL_DB_CONFIG_PATH)
            if (file_test == False):
                logger.error("Config file doesn't exists %s", PGXL_DB_CONFIG_PATH)
                return False

            with open(PGXL_DB_CONFIG_PATH, 'r') as f:
                for line in f:
                    line = line.rstrip()
                    key, line = line.split(':', 1)
                    if (key == 'bulk_connection_string'):
                        if not line:
                            break
                        else:
                            host_str = "host='" + db_name + "' "
                            self.db_ip = re.sub(r"host='(.*?)' ", host_str, line)
        except:
            logger.error("Not able to get connection str")
            return False

    def get_connection(self, tenant_name):
        logger.debug("Tenant Name " + tenant_name)
        try:
            db_name = ""
            if (tenant_name == 'Owner'):
                return self.get_connection_owner()
            global is_initialized
            global is_multi_db
            if (is_initialized != True):
                self.get_connection_owner()
                multi_db_exit = "set schema 'Owner';SELECT count(1) FROM database_list"
                self.cur = self.conn.cursor()
                self.cur.execute(multi_db_exit)
                row = self.cur.fetchone()
                self.conn.close()
                is_initialized = True
                if row:
                    row_count = row[0]
                    if (row_count > 1):
                        is_multi_db = True

            if (is_multi_db == False):
                logger.debug("Single database is enabled")
                return self.get_connection_owner()
            else:
                logger.debug("Multi database is enabled")
                self.get_connection_owner()
                db_name = self.db_ip
                db_exist = "set schema 'Owner';SELECT database_name FROM tenant WHERE name = %s"
                data_tuple = (tenant_name,)
                self.cur = self.conn.cursor()
                self.cur.execute(db_exist, data_tuple)
                row = self.cur.fetchone()
                if row:
                    db_name = row[0]

                logger.error("Database name:" + db_name)
                self.conn.close()
                self.get_connection_str(db_name)
                self.conn = psycopg2.connect(self.db_ip)
                return self.conn

        except Exception as e:
            logger.error("Not able to get DB ip address" + str(e))
        try:
            if self.conn != False:
                self.conn.close()
        except:
            logger.error("Error in closing connection")

        return False

    def get_connection_owner(self):
        try:
            file_test = os.path.exists(PGXL_DB_CONFIG_PATH)
            if (file_test == False):
                logger.error("Config file doesn't exists %s", PGXL_DB_CONFIG_PATH)
                return False

            self.db_ips = []
            try:
                with open(PGXL_DB_CONFIG_PATH, 'r') as f:
                    for line in f:
                        line = line.rstrip()
                        key, line = line.split(':', 1)
                        if (key == 'bulk_connection_string'):
                            if not line:
                                break
                            else:
                                self.db_ips.append(line)
                                self.db_ip = line
            except:
                logger.error("Opening failed for file %s", PGXL_DB_CONFIG_PATH)
                return False

        except:
            logger.error("Not able to get DB ip address")
            return False

        for self.db_ip in self.db_ips:
            try:
                self.conn = psycopg2.connect(self.db_ip)
                if self.conn == False:
                    continue
                else:
                    return self.conn
            except:
                logger.error("Error while connecting to DB")
                continue

        return False

    def close_connection(self):
        self.conn.close()

    def get_cursor(self):
        self.cur = self.conn.cursor()

    def execute_query_to_db(self, schema_name, query_str, data_tuple=None):
        try:
            con1 = self.get_connection(schema_name)
        except:
            logger.error("Could not get DB connection while trying to execute query %s", query_str)
            return False

        if not con1:
            logger.error("Could not get DB connection while trying to execute query %s", query_str)
            return False

        try:
            self.get_cursor()
            if data_tuple == None:
                self.cur.execute(query_str)
            else:
                self.cur.execute(query_str, data_tuple)
            self.conn.commit()
            self.close_connection()
            logger.debug("Query successfully executed, %s", query_str)
        except Exception as e:
            self.close_connection()
            print(e)
            logger.error("Error happen executing query %s. %s" % (query_str, str(e)))
            return False

        return True

    # Generate a new key using mpsutil
    def gen_new_key(self):
        try:
            key = ""
            lib = cdll.LoadLibrary(CRYPTO_LIB)
            lib.get_key.argtypes = (POINTER(c_char_p),)
            res = c_char_p()
            lib.get_key(byref(res))
            key = res.value
            return key
        except:
            return ""

    # Encrypts the data and returns encrypted value and key in STRING format
    def encrypt(self, schema, rawData, key):
        try:
            if key == "":
                key = self.get_encryption_key(schema)

            lib = cdll.LoadLibrary(CRYPTO_LIB)
            lib.encrypt_str.argtypes = (c_char_p, c_char_p, POINTER(c_char_p),)

            # Convert key, data to bytes (if not)
            if key is not None and type(key) != bytes:
                key = str(key).encode('utf-8')
            if rawData is not None and type(rawData) != bytes:
                rawData = str(rawData).encode('utf-8')

            c_key = ctypes.c_char_p(key)
            c_str = ctypes.c_char_p(rawData)
            res = c_char_p()
            lib.encrypt_str(c_key, c_str, byref(res))

            result = res.value
            # Convert key, data to string (if not)
            if result is not None and type(result) == bytes:
                result = result.decode()
            if key is not None and type(key) == bytes:
                key = key.decode()

            return result, key
        except Exception as e:
            logger.exception(e)

    # Decrypts the data and returns decrypted value and key in STRING format
    def decrypt(self, schema, encData, key):

        try:
            if key == "":
                key = self.get_encryption_key(schema)

            lib = cdll.LoadLibrary(CRYPTO_LIB)
            lib.decrypt_str.argtypes = (c_char_p, c_char_p, POINTER(c_char_p),)

            # Convert key, data to bytes (if not)
            if key is not None and type(key) != bytes:
                key = str(key).encode('utf-8')
            if encData is not None and type(encData) != bytes:
                encData = str(encData).encode('utf-8')

            c_key = ctypes.c_char_p(key)
            c_str = ctypes.c_char_p(encData)
            res = c_char_p()
            lib.decrypt_str(c_key, c_str, byref(res))

            result = res.value
            # Convert key, data to string (if not)
            if result is not None and type(result) == bytes:
                result = result.decode()
            if key is not None and type(key) == bytes:
                key = key.decode()

            return result, key
        except Exception as e:
            logger.exception(e)

    def eventHubDetails(self):
        try:
            with open(TELEMETRY_ENDPOINT_INFO_PATH) as config_data:
                data = json.load(config_data)
                uri = data['eventHubEndpoint'] + data['customerId'] + '/' + data['agent_id'] + '?code=' + data[
                    'eventhHubToken']
                args = ['curl', '-s', '-X', 'post', uri, '--cacert', CERT_BUNDLE_PATH]
                p = subprocess.Popen(args, stdout=subprocess.PIPE)
                result, err = p.communicate()
                return result
        except Exception as e:
            logger.error(e)

    def eventBlobCntrDetails(self):
        try:
            with open(TELEMETRY_ENDPOINT_INFO_PATH) as config_data:
                data = json.load(config_data)
                uri = data['eventHubEndpoint'] + data['customerId'] + '/' + data['agent_id'] + '?code=' + data[
                    'blobToken']
                args = ['curl', '-s', '-X', 'post', uri, '--cacert', CERT_BUNDLE_PATH]
                p = subprocess.Popen(args, stdout=subprocess.PIPE)
                result, err = p.communicate()
                return result
        except Exception as e:
            logger.error(e)

    def send_hubevent(self, connectionStr="", payload=""):
        try:
            key_name, key_value, endpoint, entitypath = self.getDetails(connectionStr)
            bus_service = ServiceBusService(service_namespace=endpoint, shared_access_key_name=key_name,
                                            shared_access_key_value=key_value)
            msg = Message(payload.encode('utf-8'))
            bus_service.send_queue_message(entitypath, msg)
        except Exception as e:
            logger.error("Error in send_hubevent")
            logger.error(e)

    def send_event(self, eventhubinfo="", payload=""):
        try:
            eventhubinfo = json.loads(eventhubinfo)
            payload = ast.literal_eval(payload)
            eh_endpoint = eventhubinfo['endpoint']
            sig = eventhubinfo['sas']
            headers = {'Authorization': sig, 'Content-Type': 'application/atom+xml;type=entry;charset=utf-8'}
            result = requests.post(eh_endpoint, headers=headers, data=json.dumps(payload, sort_keys=True))
        except Exception as e:
            logger.error("Error in eventhub send_event")
            logger.error(e)

    # Get Encryption Key
    def get_encryption_key(self, schema):
        tenant_id = ""
        try:
            logger.debug("get_wallet_key for encryption method called " + schema)
            get_query = ("set schema 'Owner';select id from tenant where name='") + str(schema) + ("'")
            conn = self.get_connection("Owner")
            cur = conn.cursor()
            cur.execute(get_query)
            row = cur.fetchone()
            conn.close()
            if row:
                tenant_id = row[0]
                logger.debug("tenant_id found for tenant in database: " + schema)
        except Exception as e:
            logger.error(e)
            logger.error("Error while executing query to fetch tenant id in get_encryption_key")
            return self.gen_new_key()
        try:
            logger.debug("get_wallet_key for encryption method called " + schema + " and tenant id " + tenant_id)
            data = route_template = ''
            # service_profile is only present in case of cloud_deployments
            if (os.path.exists(AGENT_CONF) == False and os.path.exists(SERVICE_PROFILE_CONF) == True):
                with open(SERVICE_PROFILE_CONF) as data_file:
                    data = json.load(data_file)
                route_template = data['ServiceRouteTemplate']
                route_template = route_template.replace("[customer]", schema)
                route_template = route_template.replace("[service]", "credentialwallet")
                route_template = route_template + "/secrets/MPS_SERVER_WALLET_KEY_" + tenant_id
                sessionid = self.getCCServiceKey(route_template)
                if sessionid != "":
                    logger.debug("Successfully obtained authorization key " + schema)
                headers = {'Content-type': 'application/json', 'Authorization': 'CWSAuth service=' + sessionid}
                response = requests.get(route_template, headers=headers, timeout=10, verify=CERT_BUNDLE_PATH)
                result = response.text

                if response.status_code == requests.codes.ok:
                    logger.debug("Wallet key successfully obtained " + schema)
                    result = json.loads(result)
                    result = result['value']
                else:
                    logger.error("failure in obtaining wallet key")
                    logger.error(result)

                return result

        except Exception as e:
            logger.error('Exception in func=cwcUtil::get_encryption_key')
            logger.error(e)
            return self.gen_new_key()

    def encode_to_base64(self, n):
        data = struct.pack('<Q', n).rstrip('\x00')
        if len(data) == 0:
            data = '\x00'
        s = base64.urlsafe_b64encode(data).rstrip('=')
        return s

    def gen_key_pair(self):
        try:
            (public_key, private_key) = newkeypair()
            payload = {}
            payload.update({"pvtKey": private_key})
            payload.update({"pubKey": public_key})
            return json.dumps(payload)
        except Exception as e:
            logger.error("Exception occured while generating key pair")
            logger.error(e)
            return {}

    def gen_public_key(self):
        try:
            if os.path.exists("/mpsconfig/trust/.ssh/"):
                os.system("rm -rf /mpsconfig/trust/.ssh/")
            os.system("mkdir -p /mpsconfig/trust/.ssh")
            (public_key, private_key) = newkeypair()
            f = open("/mpsconfig/trust/.ssh/private.pem", "w")
            f.write(private_key)
            f = open("/mpsconfig/trust/.ssh/public.pem", "w")
            f.write(public_key)
            f = open("/mpsconfig/trust/.ssh/public.pem", "r")
            
            # Get user and group IDs
            pgxl_uid = pwd.getpwnam('pgxl').pw_uid
            nobody_gid = grp.getgrnam('nobody').gr_gid

            # Set ownership (user: pgxl, group: nobody)
            os.chown("/mpsconfig/trust/.ssh/private.pem", pgxl_uid, nobody_gid)
            os.chown("/mpsconfig/trust/.ssh/public.pem", pgxl_uid, nobody_gid)

            # Then set permissions -rw-rw-r--
            os.chmod("/mpsconfig/trust/.ssh/private.pem", stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP | stat.S_IWGRP | stat.S_IROTH)
            os.chmod("/mpsconfig/trust/.ssh/public.pem", stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP | stat.S_IWGRP | stat.S_IROTH)

            public_key_xml = f.read()
            f.close()

            return public_key_xml
        except Exception as e:
            logger.error("Exception occured while opening public key file")
            logger.error(e)
            return ''

    def render_html(self, html_template, **content):

        """
        Function to render the html with values
        return: html content
        """
        return_details = ""
        try:
            # HTML_TEMP = EMAIL_TEMPLATE_DIR+'/no_adc_notify'
            HTML_TEMP = os.path.join(EMAIL_TEMPLATE_DIR, "no_adc_notify")
            file_loader = FileSystemLoader(HTML_TEMP)
            env = Environment(loader=file_loader)
            template = env.get_template(html_template)
            output = template.render(**content)
        except Exception as e:
            return_details = return_details + "HTMLFilePathError :" + str(e)
            return return_details
        else:
            return output.encode('utf-8')

    # FUNCTION TO SEND THE MAIL USING SMTP
    def send_SMTP_Mail(self, html_template, recipient, args):
        """
        Function to send mail using SMTP and AWS
        return: "Success" or relevant error message
        """
        SENDER = args.smtp_sender if args.smtp_sender else ''
        SENDERNAME = 'DO NOT REPLY'
        SENDER = 'adm-service@citrix.com'
        SENDERNAME = 'NetScaler Console'
        USERNAME_SMTP = args.smtp_user if args.smtp_user else ''
        PASSWORD_SMTP = args.smtp_password if args.smtp_password else ''
        HOST = args.smtp_host if args.smtp_host else ''
        PORT = args.smtp_port if args.smtp_port else 25
        return_details = ""

        msg = MIMEMultipart('related')
        msg['Subject'] = 'Manage your NetScaler infrastructure with NetScaler Console'
        msg['From'] = email.utils.formataddr((SENDERNAME, SENDER))
        msg['To'] = recipient

        imageList = []
        images = re.findall(r"(cid:)([a-zA-Z_]+)(.*)", html_template)
        for image in images:
            imageList.append(image[1] + '.png')
        html_part = MIMEText(html_template, 'html')

        msg.attach(html_part)
        # code to attach the values
        pngfiles = EMAIL_TEMPLATE_DIR + '/images'
        for file in os.listdir(pngfiles):
            if file.endswith(".png") and file in imageList:
                image_file = os.path.join(pngfiles, file)
                with open(image_file, 'rb') as fp:
                    img = MIMEImage(fp.read())
                    img.add_header('Content-ID', '<' + file.split('.')[0] + '>')
                msg.attach(img)
        # smtb code to send mail
        try:
            server = smtplib.SMTP(HOST, PORT)
            server.ehlo()
            server.starttls()
            server.ehlo()
            server.login(USERNAME_SMTP, PASSWORD_SMTP)
            server.sendmail(SENDER, recipient, msg.as_string())
            server.close()
        except Exception as e:
            return_details = return_details + "SendingError :" + str(e)
        else:
            return_details = "Email sent successfully"

        return return_details

    def getAdminDetails(self, custId):
        try:
            URL = os.environ["CC_API_URL"] if "CC_API_URL" in os.environ else self.get_cc_url()
            URL = URL.replace("core", "delegatedadministration")
            targetURL = URL + custId + "/administrators"
            service_key = self.getCCServiceKey(targetURL)
            headers = {'Content-Type': 'application/json', 'Authorization': "CWSAuth service=" + service_key}
            payload = self.httpRequest(targetURL, headers)
            return payload
        except Exception as e:
            logger.error(e)
            return ''

    def isUserSubscribedToADM(self, custId, userId):
        logger.debug('isUserSubscribedToADM:' + custId + " , userId: " + userId)
        userSubscribedToADM = True
        try:
            URL = os.environ["CC_API_URL"] if "CC_API_URL" in os.environ else self.get_cc_url()
            URL = URL.replace("core", "delegatedadministration")
            targetURL = URL + custId + "/administrators/access?id=" + userId
            service_key = self.getCCServiceKey(targetURL)
            headers = {'Content-Type': 'application/json', 'Authorization': "CWSAuth service=" + service_key}
            payload = self.httpRequest(targetURL, headers)
            userDetails = json.loads(payload)
            logger.debug("userDetails = %s", userDetails)
            if "accessType" in userDetails['message']:
                accessType = userDetails['message']['accessType']
                logger.debug("accessType= %s", accessType)
                if accessType == 'Custom':
                    if "policies" in userDetails['message']:
                        for item in userDetails['message']['policies']:
                            if (item['serviceName'] == 'MAS'):
                                userSubscribedToADM = item['checkable']['value']
                                logger.debug("isUserSubscribedToADM MAS Service " + custId + " userId " + userId +" displayName "+item['displayName'] + " isUserSubscribedToADM "+ str(userSubscribedToADM))
                                if (userSubscribedToADM == True):
                                    break
        except Exception as e:
            logger.error(e)

        return userSubscribedToADM

    def adc_not_discovered_notify(self, customer_id, args):
        try:
            custDeets = json.loads(self.getTenantDetails(customer_id))

            orgId = custDeets['message']['orgId']
            orgName = custDeets['message']['displayName']
            custEmail = custDeets['message']['createdByEmail']

            first_name = ''
            adminList = json.loads(self.getAdminDetails(customer_id))

            adminList = adminList['message']['items']
            for admin in adminList:
                if admin['principal'] == custEmail:
                    first_name = admin['firstName']
                    break
            year = datetime.date.today().year
            rendered_html_template = self.render_html('ADCNotDiscoveredTemplate.html', name=first_name, orgId=orgId,
                                                      orgName=orgName, year=year)
            rendered_html_template = rendered_html_template.decode()
            if 'Error' in rendered_html_template:
                logger.error('Error while creating template for customer:' + customer_id + ".")
                logger.error(rendered_html_template)
                return
            status = self.send_SMTP_Mail(rendered_html_template, custEmail, args)
            logger.debug('No NetScaler found mail send to:' + customer_id + " , status: " + status)

        except Exception as e:
            logger.error("Exception occured while sending no NetScaler discovered email")
            logger.error(e)

    def get_verifyurl(self, args):
        result = '{ "errorcode" : ' + str(-1) + ', "verifyurl": "", "pollingtoken":"" }'
        try:
            public_key_xml = self.gen_public_key()
            if public_key_xml == '':
                result = '{ "errorcode" : ' + str(
                    -1) + ', "verifyurl": "", "pollingtoken":"", "errormessage":"Failed to generate SSH keys."}'
            else:
                payload = '{"signingkey":"' + public_key_xml + "\"}"
                headers_preauth = {'Content-Type': 'application/json'}
                url = os.environ["TRUST_ENDPOINT"] if "TRUST_ENDPOINT" in os.environ else self.get_turst_url()
                url = url + "root/trust/v1/identity"
                response = ''
                try:
                    if args.proxy_server_ip is not None and args.proxy_server_ip != '':
                        if args.proxy_user is not None and args.proxy_user != '' and args.proxy_password is not None and args.proxy_password != '':
                            decoded_password = base64.b64decode(args.proxy_password).decode('utf-8')
                            user_url_encoded = urllib.parse.quote(args.proxy_user, safe='')
                            password_url_encoded = urllib.parse.quote(decoded_password, safe='')
                            https_proxy = "http://" + user_url_encoded + ":" + password_url_encoded + "@" + args.proxy_server_ip + ":" + args.proxy_server_port
                        else:
                            https_proxy = "http://" + args.proxy_server_ip + ":" + args.proxy_server_port
                        PROXIES = {'https': https_proxy}
                        response = requests.post(url, headers=headers_preauth, data=payload, verify=CERT_BUNDLE_PATH,
                                                 proxies=PROXIES, timeout=15)
                    else:
                        response = requests.post(url, headers=headers_preauth, data=payload, verify=CERT_BUNDLE_PATH,
                                                 timeout=15)
                    if (response.ok):
                        json_data_preauth = json.loads(response.text)
                        pvt_key = ''
                        pub_key = ''
                        if (json_data_preauth['status'] == "verify"):
                            file_list = {"pvt_key": "/mpsconfig/trust/.ssh/private.pem",
                                         "pub_key": "/mpsconfig/trust/.ssh/public.pem"}
                            try:
                                for key in file_list:
                                    with open(file_list[key], 'r') as myfile:
                                        if key == 'pvt_key':
                                            pvt_key = myfile.read()
                                        elif key == 'pub_key':
                                            pub_key = myfile.read()
                            except Exception as e:
                                logger.error('Failed to read the key contents')
                                logger.error(str(e))
                            if json_data_preauth['verifyurl'] == '' or pvt_key == '' or pub_key == '':
                                result = '{ "errorcode" : ' + str(
                                    -1) + ', "verifyurl": "", "pollingtoken":"", "pvt_key":"", "pub_key":"", "errormessage":"Failed to generate keys for customer identity."}'
                            else:
                                result = '{ "errorcode" : ' + str(0) + ', "verifyurl": "' + json_data_preauth[
                                    'verifyurl'] + '", "pvt_key":"' + pvt_key + '", "pub_key":"' + pub_key + '", "pollingtoken":"' + \
                                         json_data_preauth['pollingtoken'] + '" }'
                    else:
                        logger.error("Error, response code :" + str(response.status))
                except Exception as e:
                    result = '{ "errorcode" : ' + str(
                        -1) + ', "verifyurl": "", "pollingtoken":"", "errormessage":"Please check internet connectivity."}'
                    logger.error("Exception in get_verifyurl")
                    logger.error(e)

        except Exception as e:
            logger.error(e)

        finally:
            return result

    def run(self):
        p1 = Process(target=self.entitlements)
        if (is_grp == False):
            p1.start()
        p3.start()

    def cwcProcessReq2(self, args):
        pdict = {}
        try:
            params = json.loads(args)
        except Exception as e:
            logger.error("json loads exception" + str(e) + "  json string: " + str(args))
            resp = '{ "errorcode" : 10014 , "message" : "Invalid json encoding"}'
            return resp

        try:
            action = params["command"]
            pdict = params["parameters"]
            for k in pdict:
                pdict[k] = pdict[k].encode("ascii")

        except Exception as e:
            logger.error("Invalid json object format" + str(e) + "  json string: " + str(args))
            resp = '{ "errorcode" : 10014 , "message" : "Invalid json object format"}'
            return resp

        return self.cwcProcessReq(action, pdict)

    def cwcProcessReq(self, action, pdict):
        try:
            if action == "verifyService":
                if "--urlToVerify" in pdict and "--serviceKeyToVerify" in pdict and "--customerName" in pdict:
                    resp = cwcUtil().verifyCCService(pdict["--urlToVerify"], pdict["--serviceKeyToVerify"],
                                                     pdict["--customerName"])
                else:
                    resp = ERROR_TOO_FEW_ARGS
            elif action == "getServiceKey":
                if "--targetURL" in pdict:
                    resp = cwcUtil().getCCServiceKey(pdict["--targetURL"])
                else:
                    resp = ERROR_TOO_FEW_ARGS
            elif action == "parseJWT":
                if "--jwtToken" in pdict:
                    resp = cwcUtil().parseToken(pdict["--jwtToken"])
                else:
                    resp = ERROR_TOO_FEW_ARGS
            else:
                resp = ERROR_UNSUPPORTED_CMD

            return resp

        except Exception as e:
            resp = '{ "errorcode" : 10008 , "message" : "Invalid Parameter"}'
            logger.error("process request exception exit " + str(e))
            return resp


    def addExtraStorage (self, customerName, quantity, startDate, endDate):
        qty = ''
        startDate = startDate + "T00:00:00Z"
        endDate = endDate + "T23:59:59Z"
        start_epoch = 0
        end_epoch = 0
        try:
            qty = int(quantity)
        except:
            print ("Specify integer quantity")
            return
        try:
            start_epoch = int(time.mktime(datetime.datetime.strptime(startDate, "%Y-%m-%dT%H:%M:%SZ").timetuple()))
            end_epoch   = int(time.mktime(datetime.datetime.strptime(endDate, "%Y-%m-%dT%H:%M:%SZ").timetuple()))
        except:
            print ("Specify start and end date in format: yyyy-mm-dd")
            return

        internal_storage_sku = 'INT_STORAGE_SKU'

        licObj = {}
        licObj['EntitlementId'] = str(uuid.uuid4())
        licObj['CustomerId'] = customerName
        licObj['StartDate'] = startDate
        licObj['EndDate'] = endDate
        licObj['EntitlementType'] = "Production"
        licObj['ProductSku'] = internal_storage_sku
        licObj['Quantity'] = qty
        licObj['SerialNumbers'] = licObj['EntitlementId']
        licObj['Approved'] = True

        licObj["max_vips"] = 0
        licObj["max_tp_vservers"] = 0
        licObj["max_storage"] = 0
        licObj["lic_type"] = 1
        licObj["end_time"] = end_epoch
        licObj["start_time"] = start_epoch

        #print (licObj)
        self.insert_lic_entitlement_to_db (json.dumps(licObj), 'Deliver')


def main():

    parser = argparse.ArgumentParser(description="CWC Utility")
    parser.add_argument('action')
    parser.add_argument('--privatekey', dest="private_key")
    parser.add_argument('--servicekey', dest="servicekey")
    parser.add_argument('--targetURL', '-tURL', type=str, dest="targetURL")
    parser.add_argument('--resourceProviderName', dest="resourceProviderName")
    parser.add_argument('--bearerToken', dest="bearer_token")
    parser.add_argument('--authMode', dest="authMode")
    parser.add_argument('--urlToVerify', dest="urlToVerify")
    parser.add_argument('--serviceKeyToVerify', dest="serviceKeyToVerify")
    parser.add_argument('--pubKeyGetURL', dest="pubKeyGetURL")
    parser.add_argument('--jwtToken', dest="jwtToken")
    parser.add_argument('--customerName', dest="customerName")
    parser.add_argument('--serviceName', dest="serviceName")
    parser.add_argument('--publicKeys', dest="publicKeys")
    parser.add_argument('--orgId', dest="orgId")
    parser.add_argument('--emailId', dest="emailId")
    parser.add_argument('--skuId', dest="SkuId")
    parser.add_argument('--quantity', dest="quantity")
    parser.add_argument('--time', dest="time")
    parser.add_argument('--entId', dest="entId")
    parser.add_argument('--payload', dest="payload")
    parser.add_argument('--eventhubinfo', dest="eventhubinfo")
    parser.add_argument('--connectionstr', dest="connectionstr")
    parser.add_argument('--proxy_server_ip', dest="proxy_server_ip")
    parser.add_argument('--proxy_server_port', dest="proxy_server_port")
    parser.add_argument('--proxy_user', dest="proxy_user")
    parser.add_argument('--proxy_password', dest="proxy_password")
    parser.add_argument('--entitlement_message', dest="ent_msg")
    parser.add_argument('--instanceid', dest="instanceid")
    parser.add_argument('--version', dest="version")
    parser.add_argument('--publickey', dest="publickey")
    parser.add_argument('--schema', dest="schemaName")
    parser.add_argument('--smtp_sender', dest="smtp_sender")
    parser.add_argument('--smtp_user', dest="smtp_user")
    parser.add_argument('--smtp_password', dest="smtp_password")
    parser.add_argument('--smtp_host', dest="smtp_host")
    parser.add_argument('--smtp_port', dest="smtp_port")
    parser.add_argument('--emailList', dest="emailList")
    parser.add_argument('--userId', dest="userId")
    parser.add_argument('--regionInADM', dest="regionInADM")
    parser.add_argument('--encryptedData', dest="enc_data")
    parser.add_argument('--isNGSAdmin', dest="isNGSAdmin")
    parser.add_argument('--startDate', dest="startDate")
    parser.add_argument('--endDate', dest="endDate")
    parser.add_argument('--serialNumber', dest="serialNumber")

    try:
        args = parser.parse_args()
        if args.action == "verifyService":
            if args.customerName is None or args.urlToVerify is None or args.serviceKeyToVerify is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().verifyCCService(args.urlToVerify, args.serviceKeyToVerify, args.customerName))
        elif args.action == "noADCFound":
            cwcUtil().adc_not_discovered_notify(args.customerName, args)
        elif args.action == "getVerifyURL":
            print(cwcUtil().get_verifyurl(args))
        elif args.action == "getKeyPair":
            print(cwcUtil().gen_key_pair())
        elif args.action == "getInvalidEmailList":
            print(cwcUtil().getInvalidEmailList(args))
        elif args.action == "getCWSServiceKey":
            print(cwcUtil().getCWSServiceKey(args))
        elif args.action == "verifyOnpremCCRequest":
            print(cwcUtil().verifyOnpremCCRequest(args))
        elif args.action == "testSecretServerHealth":
            print(cwcUtil().testSecretServerHealth())
        elif args.action == "fetchKeyFromSecretServer":
            print(cwcUtil().getKeyFromSecretServer(args.serialNumber))
        elif args.action == "ccService":
            ccService = cwcUtil()
            ccService.run()
        elif args.action == "decrypt":
            print(cwcUtil().decrypt(args.schemaName, args.enc_data, ""))
        elif args.action == "verifyNwsServiceKeys":
            if args.urlToVerify is None or args.serviceKeyToVerify is None or args.publicKeys is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().verifyNwsServiceKeys(args.urlToVerify, args.serviceKeyToVerify, args.publicKeys))
        ####################TODO cwcRequest function is not used by NetScaler Console Code as of now####################
        elif args.action == "cwcRequest":
            if args.targetURL is None or args.private_key is None or args.authMode is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().cwcRequest(args.targetURL, args.authMode, args.resourceProviderName, args.private_key,
                                           args.bearer_token))
        ####################TODO no need to be done in python. Move to C++####################
        elif args.action == "redirectURL":
            if args.targetURL is None or args.servicekey is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().redirectURL(args.targetURL, args.servicekey))
        elif args.action == "getServiceKey":
            if args.targetURL is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().getCCServiceKey(args.targetURL))
        elif args.action == "parseJWT":
            if args.jwtToken is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().parseToken(args.jwtToken))
        elif args.action == "addEntitlement":
            if args.SkuId is None or args.emailId is None or args.orgId is None or args.quantity is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().post_order(args.orgId, args.emailId, args.SkuId, args.quantity, args.time))
        elif args.action == "expireEntitlement":
            if args.customerName is None or args.entId is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().expireEntitlement(args.customerName, args.entId))
        elif args.action == "create_tenant":
            if args.customerName is None or args.emailId is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().create_tenant_on_request(args.customerName, args.emailId, ""))
        elif args.action == "updateMasLicense":
            print(cwcUtil().update_mas_license(args.customerName))
        elif args.action == "insertandFullfillEntitlement":
            print(cwcUtil().add_license(args.customerName, args.ent_msg, "Deliver", True))
        elif args.action == "getEventHubDetails":
            print(cwcUtil().eventHubDetails())
        elif args.action == "getBlobCntrDetails":
            print(cwcUtil().eventBlobCntrDetails())
        elif args.action == "getTenantDetails":
            print(cwcUtil().getTenantDetails(args.customerName))
        elif args.action == "getADMTelemetryDetails":
            cwcUtil().get_adm_tlmy_deets()
        elif args.action == "getCustomTenantDetails":
            print(cwcUtil().getCustomTenantDetails(args.customerName))
        elif args.action == "getUsername":
            print(cwcUtil().getUsername(args.customerName))
        elif args.action == "isUserSubscribedToADM":
            if args.customerName is None or args.userId is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().isUserSubscribedToADM(args.customerName, args.userId))
        elif args.action == "getPrivateKey":
            print(cwcUtil().getPrivateKey())
        elif args.action == "requestFreeEntitlement":
            if args.customerName is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().requestFreeEntitlement(args.customerName))
        elif args.action == "createAAResources":
            if args.customerName is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().createAAResources(args.customerName, args.regionInADM, args.isNGSAdmin))
        elif args.action == "createAAResourceswithAgentConfPush":
            if args.customerName is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().createAAResourceswithAgentConfPush(args.customerName, args.regionInADM, args.isNGSAdmin))
        elif args.action == "deleteAAResources":
            if args.customerName is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().deleteAAResources(args.customerName))
        elif args.action == "sendEvent":
            try:
                cwcUtil().send_event(args.eventhubinfo, args.payload)
            except Exception as e:
                logger.error(e)
        elif args.action == "sendHubEvent":
            try:
                cwcUtil().send_hubevent(args.connectionstr, args.payload)
            except Exception as e:
                logger.error(e)
        elif args.action == "getEntitlements":
            try:
                cwcUtil().getEntitlements(args.customerName)
            except Exception as e:
                logger.error(e)
        elif args.action == "getEncryptionKey":
            print(cwcUtil().get_encryption_key(args.schemaName))
        elif args.action == "generateCASLUIToken":
            if args.customerName is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().generate_cas_lui_token(args.customerName))
        elif args.action == "uploadCASLUIData":
            if args.customerName is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            elif args.payload is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print(cwcUtil().upload_cas_lui_data(args.customerName, args.payload))
        elif args.action == "mapKey":
            print(cwcUtil().getMapsApiKey())
        elif args.action == "addExtraStorage":
            if args.customerName is None or args.quantity is None or args.startDate is None or args.endDate is None:
                print('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                cwcUtil().addExtraStorage(args.customerName, args.quantity, args.startDate, args.endDate)


    except Exception as e:
        logger.error(repr(e))
        return '{ "errorcode" : 10008 , "message" : "Invalid Parameter"} '


class CustomSyslogHandler(SysLogHandler):

    def __init__(self, *args, **kargs):
        SysLogHandler.__init__(self, *args, **kargs)

    def emit(self, record):
        """
        Emit a record.

        The record is formatted, and then sent to the syslog server. If
        exception information is present, it is NOT sent to the server.
        """
        try:
            msg = self.format(record) + '\000'
            """
            We need to convert record level to lowercase, maybe this will
            change in the future.
            """
            prio = '<%d>' % self.encodePriority(self.facility,
                                                self.mapPriority(record.levelname))
            # Message is a string. Convert to bytes as required by RFC 5424
            if type(msg) is str:
                msg = msg.encode('utf-8')
            if type(prio) is str:
                prio = prio.encode('utf-8')
            msg = prio + msg
            messages = [msg[i:i + 930] for i in range(0, len(msg), 930)]
            if self.unixsocket:
                for m in messages:
                    try:
                        self.socket.send(m)
                    except socket.error:
                        self.socket.close()  # See issue 17981
                        self._connect_unixsocket(self.address)
                        self.socket.send(m)
            elif self.socktype == socket.SOCK_DGRAM:
                self.socket.sendto(msg, self.address)
            else:
                self.socket.sendall(msg)
        except (KeyboardInterrupt, SystemExit):
            raise
        except:
            self.handleError(record)


# Prefixing cwcUtil process,PID to the log while sending it to Syslog server
if (os.path.exists(SYSLOG_SERVER_CONF) == True):
    syslog = CustomSyslogHandler(address='/dev/log', facility='local3')
    syslogger_formatter = logging.Formatter(
        fmt='process_tag=' + 'cwcUtil[%(process)d]: ' + 'component_tag=' + SYSLOG_MAS_SERVER_TAG + ' %(funcName)s:%(lineno)d: [%(levelname)s] %(message)s')
    syslog.setFormatter(syslogger_formatter)
    logger.addHandler(syslog)


def getServiceHTTPPort():
    service_http_port = 80
    hostname = ""
    if "HOSTNAME" in os.environ:
        hostname = os.environ["HOSTNAME"]
    try:
        if ("MGMT_MONIT_PORT" in os.environ and hostname.startswith('mgmt-monit') == False):
            service_http_port = int(os.environ["MGMT_MONIT_PORT"])
            logger.debug("MM port is '%s'" % (str(service_http_port)))
        else:
            cmd = "awk -F\"=\" '/http.port/{print $2}' /mps/mas_service.properties"
            key = subprocess.getoutput(cmd)
            service_http_port = key.strip()
            logger.debug("MM port is '%s'" % (str(service_http_port)))
    except:
        logger.debug("Returning default subsystem's http port 80")
        service_http_port = 80

    if not service_http_port:
        service_http_port = 80

    return service_http_port


if not is_mastools:
    MGMT_MONIT_PORT = getServiceHTTPPort()

if __name__ == '__main__':
    main()
