import pexpect
import argparse
import subprocess
import shlex
import os
import sys
import re
import copy
import json
import time
import base64
import xmltodict
import httplib2
import encodings
import uuid
import requests
import platform


try:
    from mastools_reg import sign_request, is_python_2_6, auth_request_header, get_mastools_proxy_httplib2
except:
    pass

from mastools_util import checkCloudOption
import cloud_constants as const




MASTOOLS_CONF_FILE = '/var/mastools/conf/agent.conf'
MASTOOLS_TRUST_DIR = '/var/mastools/trust'
MASTOOLS_CERT_DIR = '/var/mastools/cert'
MASTOOLS_UPGRADE_SCRIPT = '/var/mastools/scripts/mastools_upgrade.py'
MASTOOLS_DAEMON_SCRIPT = '/var/mastools/scripts/mastoolsd'
MASTOOLS_FILE = '/var/mastools/mastools_file.tgz'
MASTOOLS_DEST_DIR = '/var/mastools'
MASTOOLS_FILE_NAME = 'mastools_file.tgz'
MASTOOLS_TRUST_KEY_DIR = '/var/mastools/trust/.ssh/'

CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'

MGMT_TENANT_COOKIE = '_MGMT_TENANT'

ONE_MINUTE = 60*1

ADC_NETWORK_TIMEOUT = 0.5*ONE_MINUTE

ADC_DEVICE_TIMEOUT = 0.5*ONE_MINUTE

LEGATUS_AGENT_REQ_COOKIE = 'legatus_agent_request'

MASTOOLS_CWS_SERVICENAME = 'netappliance'

NETWORK_TEST_EP = "adm.cloud.com"
ADM_GRP_EP = "adm.cloud.com"
ADM_AGENT_EP = "agent.adm.cloud.com"
ADM_TRUST_EP = "trust.citrixnetworkapi.net"
ADM_DOWNLOAD_EP = "download.citrixnetworkapi.net"

ADM_EP_LIST = (ADM_GRP_EP, ADM_AGENT_EP, ADM_TRUST_EP, ADM_DOWNLOAD_EP)

ADC_LOGIN_URL = "%s://%s/nitro/v1/config/login"
ADC_NSIP_URL = "%s://%s/nitro/v1/config/nsip"
ADC_NS_LICENSE_URL = "%s://%s/nitro/v1/config/nslicense"

ADC_HTTP_PROTOCOL = "http"
ADC_HTTPS_PROTOCOL = "https"

ADC_SECURE_ONLY = "SECUREONLY"


SYSCTL_CMD = 'sysctl -n'
NSCLI_CMD = '/netscaler/nscli -U %%:.:.'
CLICMDNITRO_EXEC = 'clicmdnitro -execute -clicmd'

SHOW_NSIP = 'sh nsip -type NSIP'
SHOW_CLUSTER_NODE = 'sh cluster node'
SHOW_HANODE = 'sh ha node'
SHOW_NSIP_CLIP = 'sh nsip -type CLIP'
SHOW_HARDWARE = 'sh hardware'

CLUSTER_CCO = 'Cluster CCO'
CLUSTER_NONCCO = 'Cluster Non-CCO'
HA_PRIMARY = 'HA Primary'
HA_SECONDARY = 'HA Secondary'
STANDALONE = 'Standalone Primary'
PRIMARY = 'Primary'


ADC_DIAG_RESULT = 'adc_diag'
ADC_DIAG_NSCLI = 'nscli'
ADC_DIAG_DNS = 'dns'
ADC_DIAG_INTENET_CONNECTION = 'internet'
ADC_DIAG_ADM_ENDPOINT = 'adm'
ADC_DIAG_ADM_AGENT_ENDPOINT = 'agent'
ADC_DIAG_TRUST_ENDPOINT = 'trust'
ADC_DIAG_DOWNLOAD_ENDPOINT = 'download'
ADC_DIAG_END_TIME = 'endtime'

ADM_DIAG_END_POINT = (ADC_DIAG_ADM_ENDPOINT, ADC_DIAG_ADM_AGENT_ENDPOINT, ADC_DIAG_TRUST_ENDPOINT, ADC_DIAG_DOWNLOAD_ENDPOINT)

ADC_DIAG_STATE_WORKING = 0
ADC_DIAG_STATE_NOT_WORKING = 1
ADC_DIAG_STATE_NOT_DONE = 2

SVM_MPS_LIB = '/mps/lib'


#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)

def is_python_3_running():
    if platform.python_version().startswith('3.'):
        return True
    return False

is_python_3 = is_python_3_running()

class bcolors:
    OK = '\033[92m' #GREEN
    WARNING = '\033[93m' #YELLOW
    FAIL = '\033[91m' #RED
    RESET = '\033[0m' #RESET COLOR

def get_logger_header():
    return '[mastools_diag]'


def print_config_block():
    color = bcolors.WARNING
    print(bcolors.RESET+"Collecting Console Advisory Connect related configuration, please wait.....")
    if is_device_sdx:
        host_id = ""
        serial_id = ""
    else:
        host_id, serial_id = get_hardware_info()
    print(color+"\t-----Console Advisory Connect related Configuration-----")
    print(color+"\t\t mgmt_ip : " + NSIP)
    print(color+"\t\t host_id : " + host_id)
    print(color+"\t\t serial_id : " + serial_id)
    if os.path.exists(MASTOOLS_CONF_FILE) and not print_diag_dictionary_result:
        print(color+"\t\t customer_id : " + CUSTOMER_ID)
        print(color+"\t\t instance_id : " + INSTANCE_ID)
        print(color+"\t\t cloud_url : " + CLOUD_URL)
        print(color+"\t\t device_profile_name : " + DEVICE_PROFILE_NAME)
    return

def print_diag_result_dictionary():
    if print_diag_dictionary_result:
        end_time = time.localtime()
        end_time_str = time.strftime("%a %B %d %H:%M:%S %Y", end_time)
        dictionary_result[ADC_DIAG_END_TIME] = end_time_str
        print("result="+json.dumps(dictionary_result))
    return

def exit_error(print_config=False):
    if print_config:
        print_config_block()
    print(bcolors.RESET+"MASTools Diagnostic Done")
    print_diag_result_dictionary()
    sys.exit(0)

def check_dns():
    import socket
    print(bcolors.RESET+"checking DNS configuration")
    try:
        socket.gethostbyname(NETWORK_TEST_EP)
        dictionary_result[ADC_DIAG_DNS] =ADC_DIAG_STATE_WORKING
        print(bcolors.OK+"DNS is working")
        return
    except Exception as e:
        dictionary_result[ADC_DIAG_DNS] =ADC_DIAG_STATE_NOT_WORKING
        print(bcolors.FAIL+"Problem in DNS setting, could not resolve test host.")
        print(bcolors.FAIL+"Have you configured name server on your ADC? Please make sure DNS is configured and working")
        exit_error(True)

def check_req_response(end_point):
    try:
        request = requests.get("https://"+end_point, timeout=ADC_NETWORK_TIMEOUT)
        return True
    except Exception as e:
        print(bcolors.FAIL+"No internet connection. Exception:" + repr(e))
        return False


def check_internet_connection():
    print(bcolors.RESET+"checking internet connection")
    if check_req_response(NETWORK_TEST_EP):
        dictionary_result[ADC_DIAG_INTENET_CONNECTION] =ADC_DIAG_STATE_WORKING
        print(bcolors.OK+"internet connection is good")
        return
    else:
        dictionary_result[ADC_DIAG_INTENET_CONNECTION] =ADC_DIAG_STATE_NOT_WORKING
        print(bcolors.FAIL+"Something wrong with internet connection")
        print(bcolors.FAIL+"Please make sure firewall is not blocking internet access, and proxy is configured properly")
        exit_error(True)

def check_adm_connection():
    print(bcolors.RESET+"checking device to NetScaler Console connection")
    for i in range(len(ADM_EP_LIST)):
        adm_diag_key_word = ADM_DIAG_END_POINT[i]
        ep = ADM_EP_LIST[i]
        if check_req_response(ep):
            dictionary_result[adm_diag_key_word] =ADC_DIAG_STATE_WORKING
            print(bcolors.OK+"device to NetScaler Console connection %s is good" %(ep))
        else:
            dictionary_result[adm_diag_key_word] =ADC_DIAG_STATE_NOT_WORKING
            print(bcolors.FAIL+"something wrong with device to NetScaler Console connection")
            exit_error(True)

def clinitro_exec(clicmd):
    nitroJson = None
    try:
        cmd = NSCLI_CMD + ' "' + CLICMDNITRO_EXEC + " '" + clicmd + "'" + '"'
        cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
        nitroJson = get_nitroresp_from_clicmdnitro_op(cliNitroOutput)
    except subprocess.CalledProcessError as e:
        # nscli returns exit-code=1 in error-scenario (ex: when resource isn't there)
        if e.returncode == 1:
            nitroJson = get_nitroresp_from_clicmdnitro_op(e.output)
            if nitroJson:
                return nitroJson
        raise Exception("Failed to execute clinitro cmd: {}".format(clicmd))
    except Exception as e:
        logger.error(str(e))
        raise Exception("Failed to execute clinitro cmd: {}".format(clicmd))
    return nitroJson

def get_nitroresp_from_clicmdnitro_op(cliNitroOutput):
    try:
        if cliNitroOutput == None:
            return None
        nitroJson = None
        cliNitroOutput = cliNitroOutput.split(" Done\n")[1]
        tokens = cliNitroOutput.split("\n")
        for val in tokens:
            match = re.search(r"^\s*NITRORESP :\s+(.*$)", val.strip())
            if match:
                nitroJson = json.loads(match.group(1))
                break
        return nitroJson
    except Exception as e:
        logger.error(e)
        raise Exception("Failed to get NITRORESP from cliNitroOutput str: {}".format(cliNitroOutput))

def test_nscli():
    print(bcolors.RESET+"checking if nscli stealth mode is working on ADC")
    get_mgmt_ip()
    if NSIP:
        dictionary_result[ADC_DIAG_NSCLI] =ADC_DIAG_STATE_WORKING
        print(bcolors.OK+"nscli stealth mode is working on the ADC")
    else:
        dictionary_result[ADC_DIAG_NSCLI] =ADC_DIAG_STATE_NOT_WORKING
        print(bcolors.FAIL+"nscli stealth mode is not working on the ADC")
        exit_error()
    return

def get_mgmt_ip():
    logger.debug("In get_mgmt_ip")
    global NSIP
    global HTTP_PROTOCOL
    nsip = ""
    HTTP_PROTOCOL = ADC_HTTP_PROTOCOL

    try:
        nitroJson = clinitro_exec(SHOW_NSIP)
        if nitroJson != None and 'nsip' in nitroJson:
            nsips =  nitroJson['nsip']
            if len(nsips) == 1:
                nsip = nsips[0]['ipaddress']
                if nsips[0]['gui'] == ADC_SECURE_ONLY:
                    HTTP_PROTOCOL = ADC_HTTPS_PROTOCOL
            #only in cluster we can have multiple IPs
            elif (len(nsips) > 1):
                nitroJsonCluster = clinitro_exec(SHOW_CLUSTER_NODE)
                if nitroJsonCluster != None and 'clusternode' in nitroJsonCluster:
                    clusternodes = nitroJsonCluster['clusternode']
                    for node in clusternodes:
                        if node['islocalnode'] == True:
                            nsip = node["ipaddress"]
                        if node.get('gui') == ADC_SECURE_ONLY:
                            HTTP_PROTOCOL = ADC_HTTPS_PROTOCOL
    except Exception as e:
        logger.exception(repr(e))
    NSIP = nsip
    return

def get_deployment_info():
    print(bcolors.RESET+"checking ADC deployment...")
    deployment_type = ""

    try:
        # Check for cluster deployment
        nitroJson = clinitro_exec(SHOW_CLUSTER_NODE)
        if nitroJson != None and 'clusternode' in nitroJson:
            clusternodes = nitroJson['clusternode']
            for node in clusternodes:
                if node['islocalnode'] == True:
                    nodeid = node['nodeid']
                    if node['isconfigurationcoordinator'] == True:
                        deployment_type = CLUSTER_CCO
                    else:
                        deployment_type = CLUSTER_NONCCO
                    break
        else:
            # Check for HA/Standalone deployment
            nitroJson = clinitro_exec(SHOW_HANODE)
            if nitroJson != None and 'hanode' in nitroJson:
                hanodes = nitroJson['hanode']
                nodeCount = len(hanodes)
                if nodeCount == 2:
                    for node in hanodes:
                        # Id uniquely identifies the node.
                        # For self node, it will always be 0
                        if node['id'] == '0':
                            if node['state'] == PRIMARY:
                                deployment_type = HA_PRIMARY
                            else:
                                deployment_type = HA_SECONDARY
                else:
                    deployment_type = STANDALONE
            else:
                logger.error("Failed to HA node")
    except Exception as e:
        logger.exception("Failed to get Deployment info with exception:"+repr(e))

    logger.debug("deployment_type is" + deployment_type)
    if (deployment_type == STANDALONE) or (deployment_type == HA_PRIMARY) or(deployment_type == CLUSTER_CCO):
        print(bcolors.OK+"ADC is deployed as "+ deployment_type)
    else:
        print(bcolors.FAIL+"ADC is deployed as "+ deployment_type + ", builtin agent registration is not allowed")
        print(bcolors.FAIL+"Please run builtin agent registration only on standalone primary/HA primary/cluster CCO node")
        exit_error()

    return


def get_hardware_info():
    logger.debug("In get_hardware_info")
    host = ''
    serialno = ''

    try:
        nitroJson = clinitro_exec(SHOW_HARDWARE)
        if nitroJson != None and 'nshardware' in nitroJson:
            nshd =  nitroJson['nshardware']
            host = nshd.get('host', '')
            serialno = nshd.get('serialno', '')
    except Exception as e:
        logger.exception(repr(e))
    return host, serialno


def read_command_output(cmd):
    args = shlex.split(cmd)
    process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=None)
    output = process.communicate()
    return output[0]


def get_param_from_dict(name, conf_dict):
    if name not in conf_dict.keys():
        if name == 'mgmt_tenant' or name == 'type' or name == 'profile':
            return ''
        else:
            logger.error(get_logger_header()+'no ' + name + ' in agent.conf')
            system.exit(-1)
    return conf_dict[name]

def get_agent_conf():
    #print(bcolors.RESET+"get mastools configuration, please wait...")
    if not os.path.exists(MASTOOLS_CONF_FILE):
        logger.error(get_logger_header()+'device not claimed on NetScaler Console')
        print(bcolors.RESET+'device not claimed on NetScaler Console')
        exit_error(True)

    with open("/var/mastools/conf/agent.conf", "r+") as agent_conf_file:
        content= agent_conf_file.read()
        agent_conf_file.close()

    agent_conf_dict = xmltodict.parse(content)['mps_agent']
    global CUSTOMER_ID
    global SERVICE_NAME
    global INSTANCE_ID
    global CLOUD_URL
    global IS_MGMT_TENANT
    global DEVICE_PROFILE_NAME
    global IS_VPX

    CUSTOMER_ID = get_param_from_dict('customerid', agent_conf_dict)
    SERVICE_NAME = get_param_from_dict('servicename', agent_conf_dict)
    INSTANCE_ID = get_param_from_dict('instanceid', agent_conf_dict)
    CLOUD_URL = get_param_from_dict('url', agent_conf_dict)
    mgmt_tenant = get_param_from_dict('mgmt_tenant', agent_conf_dict)
    device_type = get_param_from_dict('type', agent_conf_dict)
    device_profile = get_param_from_dict('profile', agent_conf_dict)
    if mgmt_tenant != '':
        IS_MGMT_TENANT = True
    else:
        IS_MGMT_TENANT = False

    if device_type == '':
        IS_VPX = True
    else:
        IS_VPX = False

    if device_profile == '':
        DEVICE_PROFILE_NAME = "mastool_"+INSTANCE_ID+"_profile"
    else:
        DEVICE_PROFILE_NAME = device_profile

    #print(bcolors.RESET+"done getting mastools configuration.")
    return

def check_user_credential():
    print(bcolors.RESET+"check user login credential, please wait...")
    nsip_url = ADC_NSIP_URL %(HTTP_PROTOCOL, NSIP)
    status, content = send_request_device(nsip_url, "GET", "", True)
    if status:
        try:
            content_json = json.loads(content)
            if content_json["nsip"]:
                print(bcolors.OK+"user login credential is correct")
                return
        except Exception as e:
            logger.debug(get_logger_header()+"check_user_credential exception"+repr(e))

    print(bcolors.FAIL+"incorrect login credential")

    exit_error(True)


def check_user_privilege():
    print(bcolors.RESET+"check user privilege, please wait...")
    login_url = ADC_LOGIN_URL %(HTTP_PROTOCOL, NSIP)
    payload_login = {}
    payload_login["username"] = USERNAME
    payload_login["password"] = PWD
    payload = {}
    payload["login"] = payload_login
    status, content = send_request_device(login_url, "POST", json.dumps(payload))
    if status:
        try:
            content_json = json.loads(content)
            if content_json["sessionid"]:
                print(bcolors.OK+"user has the right privilege to access the ADC")
                return
        except Exception as e:
            logger.debug(get_logger_header()+"check_user_privilege exception"+repr(e))

    print(bcolors.FAIL+"User doesn't have the right privilege, please make sure user is super user")

    exit_error(True)


def check_adc_license():
    print(bcolors.RESET+"check adc license, please wait...")
    nslciense_url = ADC_NS_LICENSE_URL %(HTTP_PROTOCOL, NSIP)
    status, content = send_request_device(nslciense_url, "GET", "", True)
    if status:
        try:
            content_json = json.loads(content)
            logger.debug(get_logger_header()+ "ADC license details:" + json.dumps(content_json))
            if content_json["nslicense"]:
                print(bcolors.OK+"successfully got ADC license details")
                return
        except Exception as e:
            logger.debug(get_logger_header()+"check_adc_license exception"+repr(e))

    print(bcolors.FAIL+"Could not get ADC license details")

    exit_error(True)



def send_request_device(url, method, payload='', basic_auth=False, time_out=ADC_DEVICE_TIMEOUT):
    if HTTP_PROTOCOL == ADC_HTTPS_PROTOCOL:
        httpConnection=httplib2.Http(".cache", timeout=time_out, disable_ssl_certificate_validation=True)
    else:
        httpConnection=httplib2.Http(".cache", timeout=time_out)
    headers_conn = {'Content-Type':'application/json'}
    logger.debug(get_logger_header()+url + ";method: " + method)
    content = ''
    try:
        if basic_auth:
            httpConnection.add_credentials(USERNAME, PWD)
        if payload == '':
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn)
        else:
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
        if is_python_3:
            content = content.decode("utf-8")
        resp_str = 'responseStatus='+str(responseStatus)+' content='+content
        if "status" in responseStatus:
            if responseStatus["status"] == '200' or responseStatus["status"] == '204' or responseStatus["status"] == '201':
                return True, content
        logger.debug(get_logger_header()+resp_str)
        logger.debug(get_logger_header()+content)
        return False, content
    except Exception as e:
        logger.debug(get_logger_header()+repr(e))
        return False, content



def send_request(url, method, payload='', time_out=ADC_NETWORK_TIMEOUT):
    service_token = sign_request(url, MASTOOLS_CWS_SERVICENAME, INSTANCE_ID)
    proxy_httplib2 = get_mastools_proxy_httplib2()
    if proxy_httplib2:
        httpConnection=httplib2.Http(".cache",proxy_info=proxy_httplib2,ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    else:
        httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    headers_conn = {'Content-Type':'application/json'}
    headers_conn['Authorization'] = auth_request_header+service_token
    logger.debug(get_logger_header()+url + ";method: " + method)
    legatus_cookie = LEGATUS_AGENT_REQ_COOKIE+'=true'
    content = ''
    if IS_MGMT_TENANT:
        headers_conn['Cookie'] = legatus_cookie+';'+MGMT_TENANT_COOKIE + ':"yes"'
    else:
        headers_conn['Cookie'] = legatus_cookie
    try:
        if payload == '':
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn)
        else:
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
        if is_python_3:
            content = content.decode("utf-8")
        resp_str = 'responseStatus='+str(responseStatus)+' content='+content
        #logger.debug(get_logger_header()+resp_str)
        #logger.debug(get_logger_header()+content);
        if "status" in responseStatus:
            if responseStatus["status"] == '200' or responseStatus["status"] == '204' or responseStatus["status"] == '201':
                return True, content
        logger.debug(get_logger_header()+resp_str)
        logger.debug(get_logger_header()+content)
        return False, content
    except Exception as e:
        logger.debug(get_logger_header()+repr(e))
        return False, content

def gen_clour_req_url(uri):
    if is_python_2_6:
        cloud_uri = '/' + CUSTOMER_ID + '/' + SERVICE_NAME + uri;
    else:
        cloud_uri = '/' + CUSTOMER_ID + '/' + MASTOOLS_CWS_SERVICENAME + uri;
    clour_req_url = "https://"+ CLOUD_URL + cloud_uri
    return clour_req_url
def get_user_info(username="", pwd=""):
    global USERNAME
    global PWD
    USERNAME = username
    PASSWORD = pwd
    return

def replace_html_tags(str_input):
    str_temp = str_input.replace("&amp;", "&")
    str_temp = str_temp.replace("&lt;", "<")
    str_temp = str_temp.replace("&gt;", ">")
    str_temp = str_temp.replace("&apos;", "'")
    return str_temp

def init_diag_result():
    global dictionary_result
    dictionary_result ={}
    dictionary_result[ADC_DIAG_NSCLI] =ADC_DIAG_STATE_NOT_DONE
    dictionary_result[ADC_DIAG_DNS] =ADC_DIAG_STATE_NOT_DONE
    dictionary_result[ADC_DIAG_INTENET_CONNECTION] =ADC_DIAG_STATE_NOT_DONE
    dictionary_result[ADC_DIAG_ADM_ENDPOINT] =ADC_DIAG_STATE_NOT_DONE
    dictionary_result[ADC_DIAG_ADM_AGENT_ENDPOINT] =ADC_DIAG_STATE_NOT_DONE
    dictionary_result[ADC_DIAG_TRUST_ENDPOINT] =ADC_DIAG_STATE_NOT_DONE
    dictionary_result[ADC_DIAG_DOWNLOAD_ENDPOINT] =ADC_DIAG_STATE_NOT_DONE
    return

def get_sdx_ip():
    global NSIP
    ip_addr = subprocess.check_output(['/bin/sh', '/var/mastools/scripts/mastools_sdx_ip.sh'])
    NSIP = ip_addr.strip()
    if is_python_3:
        NSIP = NSIP.decode()
    return

def _main(argv):
    global print_diag_dictionary_result
    if (len(argv) > 1) and (argv[1] == 'print'):
        print_diag_dictionary_result = True
    else:
        print_diag_dictionary_result = False

    global  is_device_sdx
    is_device_sdx = False
    if os.path.exists(SVM_MPS_LIB):
        is_device_sdx = True
    
    # This is to check for Japan Cloud 
    jEP = checkCloudOption()
    if const.JP_NETWORK_TEST_EP.lower() == jEP.lower(): # this is to avoid case sensitivity
        global ADM_EP_LIST
        # ADM_EP_LIST = (ADM_GRP_EP, ADM_AGENT_EP, ADM_TRUST_EP, ADM_DOWNLOAD_EP)
        ADM_EP_LIST = (const.JP_ADM_GRP_EP, const.JP_ADM_AGENT_EP, ADM_TRUST_EP, ADM_DOWNLOAD_EP)

    init_diag_result()

    print(bcolors.RESET+"MASTools Diagnostic Started")
    if not is_device_sdx:
        test_nscli()
        get_deployment_info()
    else:
        get_sdx_ip()

    check_dns()
    check_internet_connection()
    check_adm_connection()
    if not print_diag_dictionary_result:
        get_agent_conf()
        #get_user_info()
        #check_user_credential()
        #check_user_privilege()
        #check_adc_license()
    print_config_block()
    print(bcolors.RESET+"MASTools Diagnostic Done")
    print_diag_result_dictionary()

if __name__ == "__main__":
    sys.exit(_main(sys.argv))