#!/usr/bin/env bash

#if first time init(invoke registration)
#argv1 username
#argv2 pwd
#argv3 service url
#argv4 activation code
#argv5 ngskey (optional) -key
#example: ./mastools_init.sh <username>  <pwd>  <service_url>  "<activation code>"
#example: ./mastools_init.sh <username>  <service_url>  "<activation code>"
#example: ./mastools_init.sh <username>   <pwd>   <service_url>  "<activation code>" -key

# Use following command to read adc-username and adc-password from env variable if you don't want to
# expose them in 'ps' command o/p:
# Set Environment variable env_adc_user and env_adc_pwd before following cmd:
# ./mastools_init.sh <service_url> <activation_code> -read_adc_cred_from_env
export  PYTHONPATH=/var/mastools/scripts/pythonlib/ccauth-4.1.1-py2.7.egg/:/var/mastools/scripts/pythonlib/rsa-3.4.2-py2.7.egg/

#needed vars for CPX
OS_RELEASE_FILE="/etc/os-release"
NSOSLX_STRING="nsoslx"
running_inside_cpx=false
python_bin="/var/python/bin/python"
mastools_log="/var/mastools/logs/mastools.log"

MASTOOLS_HOME="/var/mastools"
MASTOOLS_PID_DIR="${MASTOOLS_HOME}/run"
mkdir -p ${MASTOOLS_PID_DIR}

if [ -e $OS_RELEASE_FILE ]; then
    grep -Fq "$NSOSLX_STRING" $OS_RELEASE_FILE
    if [ $? -eq 0 ]; then
        running_inside_cpx=true
        python_bin="/usr/bin/python"

        if [ -n "$UNICON_PROVIDER_VERSION" ]; then
            mastools_log="/dev/stdout"
        fi
    fi
fi

mastools_stop()
{
    pid=`ps -axww | awk '/mastools_monit/ && !/awk/ {print $1}'`
    if [ "$pid" != "" ]; then
        kill -9 $pid
    fi
    pid=`ps -axww | awk '/mastools_upgrade/ && !/awk/ {print $1}'`
    if [ "$pid" != "" ]; then
        kill -9 $pid
    fi
    pid=`ps -axww | awk '/mastools_ha/ && !/awk/ {print $1}'`
    if [ "$pid" != "" ]; then
        kill -9 $pid
    fi
    pid=`pgrep -f "/var/mastools/bin/mastools"`
    if [ "$pid" != "" ]; then
        kill -9 $pid
    fi
}

ha_state="Standalone"
is_node_primary()
{
    user="$1"
    pwd="$2"
    command=`nscli -U 127.0.0.1:"$user":"$pwd" "show ns config | grep "Node:" "`
    case "$command" in
        *Secondary*)
            ha_state="Secondary"
            ;;
        *Primary*)
            ha_state="Primary"
            ;;
    esac

}

mastools_restart()
{
    /bin/sh /var/mastools/scripts/mastoolsd restart
}


exec 2>>/var/mastools/logs/mastools_init.log

# Below certs are added by the Citrix Gateway Service team for
# the NGS NS Connector
NETSCALER=${NETSCALER:-`cat /var/run/.NETSCALER`}
NS_GEN_PROG=${NETSCALER}/nssslgen
NS_DEFAULT_PARTITIONID=0
NS_SSL_DIR=/nsconfig/ssl
NS_NGS_CONNECTOR_ROOT_KEY=${NS_SSL_DIR}/ns-ngsconnector-root.key
NS_NGS_CONNECTOR_ROOT_REQ=${NS_SSL_DIR}/ns-ngsconnector-root.req
NS_NGS_CONNECTOR_ROOT_CERT=${NS_SSL_DIR}/ns-ngsconnector-root.cert
NS_NGS_CONNECTOR_KEY=${NS_SSL_DIR}/ns-ngsconnector.key
NS_NGS_CONNECTOR_REQ=${NS_SSL_DIR}/ns-ngsconnector.req
NS_NGS_CONNECTOR_CERT=${NS_SSL_DIR}/ns-ngsconnector.cert
NS_NGS_CONNECTOR_ROOT_SRL=${NS_SSL_DIR}/ns-ngsconnector-root.srl
NS_SSL_KEYSIZE=2048

LOG=/var/mastools/logs/mastools_init.log

create_ngs_connector_certificate()
{
        NEW_RANSTRING=`head -c 1024 /dev/urandom |tr -dc 'A-Z' |head -c${1:-6}`
        local COUNTRY="US"
        local STATE="California"
        local LOCATION="San Jose"
        local ORGANIZATION="Citrix Gateway"
        local ORGANIZATIONUNIT="NS NGSConnector"
        local COMMONNAME="NGSConnector default ""${NEW_RANSTRING}"

        clean_ngs_connector_certificate

        ###
        echo nsstart: `date` ': Creating the RSA root key'
        ###
        $NS_GEN_PROG rsakey $NS_DEFAULT_PARTITIONID $NS_NGS_CONNECTOR_ROOT_KEY $NS_SSL_KEYSIZE > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
                echo nsstart: `date` ': Error creating the RSA key file: $NS_NGS_CONNECTOR_ROOT_KEY' >> $LOG
                return
        fi

        ###
        echo nsstart: `date` ': Creating the CSR for the root certificate'
        ###
        #fixed for ENH0451441 and BUG0405363
        $NS_GEN_PROG -GUI certreq $NS_DEFAULT_PARTITIONID $NS_NGS_CONNECTOR_ROOT_REQ -keyFile $NS_NGS_CONNECTOR_ROOT_KEY -C $COUNTRY -S $STATE -L $LOCATION -O $ORGANIZATION -OU $ORGANIZATIONUNIT -CN $COMMONNAME
        if [ $? -ne 0 ]
        then
                echo nsstart: `date` ': Error creating the Certificate Signing Request file (CSR): $NS_NGS_CONNECTOR_ROOT_REQ' >> $LOG
                return
        fi

        ###
        echo nsstart: `date` ': Create the Self-Signed Certificate root certificate'
        ###
        $NS_GEN_PROG cert $NS_DEFAULT_PARTITIONID $NS_NGS_CONNECTOR_ROOT_CERT $NS_NGS_CONNECTOR_ROOT_REQ ROOT_CERT -keyFile $NS_NGS_CONNECTOR_ROOT_KEY -days 1000000
        if [ $? -ne 0 ]
        then
                echo nsstart: `date` ': Error creating the Self-Signed Certificate: $NS_NGS_CONNECTOR_ROOT_CERT' >> $LOG
                return
        fi


        echo nsstart: `date` ': Creating certificate for NGS Connector'

    ###
        $NS_GEN_PROG rsakey $NS_DEFAULT_PARTITIONID $NS_NGS_CONNECTOR_KEY $NS_SSL_KEYSIZE > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
                echo nsstart: `date` ': Error creating the RSA key file: $NS_NGS_CONNECTOR_KEY' >> $LOG
                clean_ngs_connector_certificate
                return
        fi
 ###
        echo nsstart: `date` ': Create the CSR for server cert'
        ###
#fixed for ENH0451441 and BUG0405363
        $NS_GEN_PROG -GUI certreq $NS_DEFAULT_PARTITIONID $NS_NGS_CONNECTOR_REQ -keyFile $NS_NGS_CONNECTOR_KEY -C $COUNTRY -S $STATE -L $LOCATION -O $ORGANIZATION -OU $ORGANIZATIONUNIT -CN $COMMONNAME
        if [ $? -ne 0 ]
        then
                echo nsstart: `date` ': Error creating Certificate Signing Request file (CSR): $NS_NGS_CONNECTOR_REQ' >> $LOG
                clean_ngs_connector_certificate
                return
        fi

        ###
        echo nsstart: `date` ': Create the Server Certificate'
        ###
        $NS_GEN_PROG cert $NS_DEFAULT_PARTITIONID $NS_NGS_CONNECTOR_CERT $NS_NGS_CONNECTOR_REQ SRVR_CERT -CAcert $NS_NGS_CONNECTOR_ROOT_CERT -CAkey $NS_NGS_CONNECTOR_ROOT_KEY -CAserial $NS_NGS_CONNECTOR_ROOT_SRL -days 1000000
        if [ $? -ne 0 ]
        then
                echo nsstart: `date` ': Error creating the server Certificate: $NS_NGS_CONNECTOR_CERT' >> $LOG
                clean_ngs_connector_certificate
                return
        fi
        openssl x509 -outform der -in /nsconfig/ssl/ns-ngsconnector.cert -out /nsconfig/ssl/ns-ngsconnector.der
        openssl x509 -in /nsconfig/ssl/ns-ngsconnector.cert -fingerprint -noout > /nsconfig/ssl/ns-ngsconnector.sig.tmp
        cat /nsconfig/ssl/ns-ngsconnector.sig.tmp | awk 'BEGIN {FS="="}; {print $2}' | sed 's/://g' > /nsconfig/ssl/ns-ngsconnector.sig
        rm /nsconfig/ssl/ns-ngsconnector.sig.tmp
}

clean_ngs_connector_certificate()
{
    rm $NS_NGS_CONNECTOR_ROOT_KEY > /dev/null 2>&1
        rm $NS_NGS_CONNECTOR_ROOT_REQ >/dev/null 2>&1
        rm $NS_NGS_CONNECTOR_ROOT_CERT >/dev/null 2>&1
        rm $NS_NGS_CONNECTOR_KEY >/dev/null 2>&1
        rm $NS_NGS_CONNECTOR_REQ >/dev/null 2>&1
        rm $NS_NGS_CONNECTOR_CERT >/dev/null 2>&1
        rm $NS_NGS_CONNECTOR_ROOT_SRL  >/dev/null 2>&1
}

CONFIG_FILE="/nsconfig/connector.conf"
regenerate_ngs_connector_certificate()
{
       clean_ngs_connector_certificate
       create_ngs_connector_certificate
       CONFIG="unbind ssl vserver ngs_vpn -certkeyName cwc_kp
               rm ssl certKey cwc_kp
               add ssl certKey cwc_kp -cert ns-ngsconnector.cert -key ns-ngsconnector.key
               bind ssl vserver ngs_vpn -certkeyName cwc_kp
               "
       echo "$CONFIG" > $CONFIG_FILE
       /netscaler/nscli -U :nsroot:$1 "batch -fileName $CONFIG_FILE" >> $LOG
       /netscaler/nscli -U :nsroot:$1 "save conf" >> $LOG
}

MASTOOLS_INIT_STATUS="/var/mastools/conf/mastools_init.status"
if [ $# != 0  ]; then
    is_node_primary $1 $2
    if [ "$ha_state" = "Secondary" ]
    then
        echo 'Could not do registration on secondary node, please register on priamry node'
        mastools_restart
        exit
    fi
    cd /var/mastools/scripts
    mastools_stop
    echo "Registration=InProgress" > $MASTOOLS_INIT_STATUS
    if [ "$5" = "-key" ] || [ "$5" = "-keydev" ] || [ "$5" = "-sdx" ]; then
        if [ "$5" = "-key" ] || [ "$5" = "-keydev" ]; then
            echo "NGS registration"
            regenerate_ngs_connector_certificate $2
        fi
        registrationcmd=''$python_bin'  mastools_reg.py -u '$1' -p '$2' -serviceurl '$3' -activationcode '$4' '$5' -inter n'
    elif [ $# -eq 3 ]; then
        if [ "$3" = "-read_adc_cred_from_env" ];then
            echo 'running image upgrade'
            $python_bin /var/mastools/scripts/mastools_upgrade.py $1
            echo "registration"
            registrationcmd=''$python_bin' mastools_reg.py -serviceurl '$1' -activationcode '$2' -inter n -read_adc_cred_from_env'
        else
            echo 'running image upgrade'
            $python_bin /var/mastools/scripts/mastools_upgrade.py $2
            echo "Interactive vpx registration"
            registrationcmd=''$python_bin' mastools_reg.py -u '$1' -serviceurl '$2' -activationcode '$3' -inter y'
        fi
    elif [ $# -eq 4 ]; then
        if [ "$4" = "-profile" ]; then
            echo 'running image upgrade'
            $python_bin /var/mastools/scripts/mastools_upgrade.py $2
            echo "VPX registration with device profile provided"
            registrationcmd=''$python_bin' mastools_reg.py -profile '$1' -serviceurl '$2' -activationcode '$3' -inter n'
        elif [ "$4" = "-sdx" ]; then
            echo "Interactive sdx registration"
            registrationcmd=''$python_bin' mastools_reg.py -u '$1' -serviceurl '$2' -activationcode '$3' '$4' -inter y'
        elif [ $running_inside_cpx = true ]; then
            echo 'running image upgrade'
            $python_bin /var/mastools/scripts/mastools_upgrade.py $2
            echo "CPX registration with docker host ip provided"
            registrationcmd=''$python_bin' mastools_reg.py -u '$1' -serviceurl '$2' -activationcode '$3' -inter y -dockerhostip '$4''
        elif [ "$4" = "-blx" ]; then
            echo -e "\e[4mBLX Profile Registration\e[0m"
            registrationcmd=''$python_bin' mastools_reg.py -u '$1' -serviceurl '$2' -activationcode '$3' '$4' -inter y'
        else
            echo 'running image upgrade'
            $python_bin /var/mastools/scripts/mastools_upgrade.py $3
            echo "registration"
            registrationcmd=''$python_bin' mastools_reg.py -u '$1' -p '$2' -serviceurl '$3' -activationcode '$4' -inter n'
        fi
    elif [ $# -eq 5 ]; then
        if [ "$5" = "-profile" ] && [ "$4" = "-sdx" ]; then
            echo 'running image upgrade'
            $python_bin /var/mastools/scripts/mastools_upgrade.py $2
            echo "SDX profile registration"
            registrationcmd=''$python_bin' mastools_reg.py -profile '$1' -serviceurl '$2' -activationcode '$3' -sdx -inter n'
        elif [ $running_inside_cpx = true ]; then
            echo 'running image upgrade'
            $python_bin /var/mastools/scripts/mastools_upgrade.py $3
            echo "CPX non-interactive registration with docker host ip provided"
            registrationcmd=''$python_bin' mastools_reg.py -u '$1' -p '$2' -serviceurl '$3' -activationcode '$4' -inter n -dockerhostip '$5''
        elif [ "$5" = "-profile" ] && [ "$4" = "-blx" ]; then    
            #echo 'running image upgrade'
            #$python_bin /var/mastools/scripts/mastools_upgrade.py $2
            echo -e "\e[4mBLX Profile Registration\e[0m"
            registrationcmd=''$python_bin' mastools_reg.py -profile '$1' -serviceurl '$2' -activationcode '$3' -blx -inter n'
        fi
    #we need to add this image upgrade only support. In a very rare case, we need to change upgrade and mastools_init.sh
    #we may need to ask the user first run the image upgrade, then do the registration
    elif [ $# -eq 1 ]; then
        echo 'running image upgrade'
        $python_bin /var/mastools/scripts/mastools_upgrade.py $1
        echo 'image upgrade done'
        exit
    else
        echo "Invalid command, please enter the command : ./mastools_init.sh <user-name> <service-url> <activation-code>"
        mastools_restart
        exit
    fi
    $registrationcmd
    returnval=$?
    unset histfile
    if [ $returnval -ne 0  ]; then
        echo "Registration=Failure" > $MASTOOLS_INIT_STATUS
        if [ $returnval -eq 66 ]; then
            echo -e "\e[31mMastools registration could not be done on secondary node, please run the registration command on primary node.\e[0m"
        else
            echo "Registration failed. Please check your activation code"
        fi
        mastools_restart
        exit $returnval
    else
        echo "Registration=Success" > $MASTOOLS_INIT_STATUS
    fi
fi
value=`cat /var/mastools/version.txt`
echo $value
if [ $value = "0.0-0.0" ]; then
    echo "first time registration, upgrade will download the binary"
else
    echo "re-registration, invoke the binary"
fi
mastools_restart