#!/usr/bin/env sh
#Monitering mastools daemon

exec 2>>/var/mastools/logs/mastools_monit.log

unameOut="$(uname -s)"
case "${unameOut}" in
    Linux*)       machine=Linux;;
    FreeBSD*)     machine=FreeBSD;;
esac

#needed vars for CPX
OS_RELEASE_FILE="/etc/os-release"
NSOSLX_STRING="nsoslx"
running_inside_cpx=false
python_bin="/var/python/bin/python"
mastools_log="/var/mastools/logs/mastools.log"
MASTOOLS_HOME="/var/mastools"
MASTOOLS_PID_DIR="${MASTOOLS_HOME}/run"
MASTOOLS_UPGRADE_PID_FILE="${MASTOOLS_PID_DIR}/mastools_upgrade.pid"
MASTOOLS_BIN_PID_FILE="${MASTOOLS_PID_DIR}/mastools.pid"
MASTOOLS_SPLUNK_PID_FILE="${MASTOOLS_PID_DIR}/mastools_splunk.pid"
MASTOOLS_SCRIPTS="${MASTOOLS_HOME}/scripts"
MASTOOLS_HA_SCRIPTS="${MASTOOLS_SCRIPTS}/mastools_ha.py"
MASTOOLS_CLUSTER_SCRIPTS="${MASTOOLS_SCRIPTS}/mastools_cluster.py"
MASTOOLS_RESOURCE_LIBRARY_CLIENT_SCRIPTS="${MASTOOLS_SCRIPTS}/resource_library_client.py"
MASTOOLS_CONF_DIR="${MASTOOLS_HOME}/conf"
MASTOOLS_AGENT_CONF="${MASTOOLS_CONF_DIR}/agent.conf"
MASTOOLS_MONIT_LOG="/var/mastools/logs/mastools_monit.log"
MASTOOLS_TELEMETRY_PID_FILE="${MASTOOLS_PID_DIR}/mastools_tlmy.pid"
MASTOOLS_TELEMETRY_SCRIPT="${MASTOOLS_SCRIPTS}/mastools_tlmy.py"

if [ -e $OS_RELEASE_FILE ]; then
    grep -Fq "$NSOSLX_STRING" $OS_RELEASE_FILE
    if [ $? -eq 0 ]; then
        running_inside_cpx=true
        python_bin="/usr/bin/python"

        if [ -n "$UNICON_PROVIDER_VERSION" ]; then
            mastools_log="/dev/stdout"
        fi
    fi
fi

export  PYTHONPATH=/var/mastools/scripts/pythonlib/ccauth-4.1.1-py2.7.egg/:/var/mastools/scripts/pythonlib/rsa-3.4.2-py2.7.egg/
if [ $running_inside_cpx = true ] || [ "$machine" = "Linux" ]; then
    IS_GATEWAY_CONNECTOR=0
else
    GATEWAY_CONNECTOR_SYSCTL=netscaler.is_ngs_connector
    IS_GATEWAY_CONNECTOR=$(sysctl -n ${GATEWAY_CONNECTOR_SYSCTL})
fi

vercomp(){
    if [ $1 = $2 ]; then
        return 0
    fi
    ver1_major=`echo $1 | cut -d'.' -f1`
    ver1_minor=`echo $1 | cut -d'.' -f2`
    ver2_major=`echo $2 | cut -d'.' -f1`
    ver2_minor=`echo $2 | cut -d'.' -f2`
    if [ $ver1_major -gt $ver2_major ]; then
        return 1
    fi
    if [ $ver1_major = $ver2_major ] && [ $ver1_minor -gt $ver2_minor ]; then
        return 1
    fi
    return 2
}

release_build_comp(){
    if [ $1 = $2 ]; then
        echo $1 $2 "MASTools package is running on the golden release" >> $MASTOOLS_MONIT_LOG
        return 0
    fi
    release_1=`echo $1 | cut -d'-' -f1`
    build_1=`echo $1 | cut -d'-' -f2`
    release_2=`echo $2 | cut -d'-' -f1`
    build_2=`echo $2 | cut -d'-' -f2`
    vercomp $release_1 $release_2
    release_cmp=$?
    vercomp $build_1 $build_2
    build_cmp=$?
    if [ $release_cmp = 1 ] ; then
        echo $1 $2 "MASTools package is running on the release after the golden release" >> $MASTOOLS_MONIT_LOG
        return 0
    fi
    if [ $release_cmp = 0 ] && [ $build_cmp = 1 ] ; then
        echo $1 $2 "MASTools package is running on the release after the golden release" >> $MASTOOLS_MONIT_LOG
        return 0
    fi
    echo $1 $2 "MASTools package is running on the release before the golden release" >> $MASTOOLS_MONIT_LOG
    return 1
   
}

CUR_MASTOOLS_VERSION=`cat /var/mastools/version.txt`
GOLDEN_MASTOOLS_PKG="14.1-25.14"

start_mastools_legacy(){
    echo "start legacy checking of mastools binary" >> $MASTOOLS_MONIT_LOG
    pid=`pgrep -f "/var/mastools/bin/mastools"`
    if [ "$pid" = "" ]; then
        echo "starting legacy mastools binary" >> $MASTOOLS_MONIT_LOG
        sleep 5
        if [ -e /var/mastools/bin/mastools ];then
            export LD_LIBRARY_PATH='/var/mastools/lib/';
            killall -9 mastools;
            /var/mastools/bin/mastools > $mastools_log &
        fi
    else
        echo "add mastools binary pid in mastools.pid file" >> $MASTOOLS_MONIT_LOG
        echo $pid > ${MASTOOLS_BIN_PID_FILE}
    fi
}

check_process_run()
{
    if [ -f "$1" ]; then
        kill -0 `cat $1`
        return $?
    else
        return 1
    fi
}

mastools_monit()
{
    check_process_run ${MASTOOLS_BIN_PID_FILE}
    if [ $? != 0 ]; then
        echo "mastools is not running. trying to restart it now" >> $MASTOOLS_MONIT_LOG
        sleep 5
        if [ -e /var/mastools/bin/mastools ];then
            release_build_comp $CUR_MASTOOLS_VERSION $GOLDEN_MASTOOLS_PKG
            if [ $? != 0 ]; then
                #if mastools version is running in old version without the binary change,
                #we will check and start mastools binary in old fashion, and then add the
                #in pid file
                start_mastools_legacy
            else
                echo "restarting mastools in new way" >> $MASTOOLS_MONIT_LOG
                pkill -9 -f $MASTOOLS_HA_SCRIPTS
                pkill -9 -f $MASTOOLS_CLUSTER_SCRIPTS
                pkill -9 -f $MASTOOLS_RESOURCE_LIBRARY_CLIENT_SCRIPTS
                export LD_LIBRARY_PATH='/var/mastools/lib/';
                killall -9 mastools;
                /var/mastools/bin/mastools > $mastools_log &
                echo $! > ${MASTOOLS_BIN_PID_FILE}
            fi
        fi
    fi
    check_process_run ${MASTOOLS_UPGRADE_PID_FILE}
    if [ $? != 0 ]; then
        sleep 5
        cd /var/mastools/scripts
        pkill -9 -f mastools_upgrade.py
        $python_bin /var/mastools/scripts/mastools_upgrade.py &
        echo $! > ${MASTOOLS_UPGRADE_PID_FILE}
    fi

    check_process_run ${MASTOOLS_TELEMETRY_PID_FILE}
    if [ $? != 0 ]; then
        echo "telemetry is not running. trying to restart it now" >> $MASTOOLS_MONIT_LOG
        sleep 5
        cd /var/mastools/scripts
        pkill -9 -f mastools_tlmy.py
        $python_bin ${MASTOOLS_TELEMETRY_SCRIPT} &
        echo $! > ${MASTOOLS_TELEMETRY_PID_FILE}
    fi

    if [ $IS_GATEWAY_CONNECTOR -eq 0 ]; then
        check_process_run ${MASTOOLS_SPLUNK_PID_FILE}
        if [ $? != 0 ]; then
            sleep 5
            cd /var/mastools/scripts
            pkill -9 -f adc_splunk_logger.py
            $python_bin /var/mastools/scripts/adc_splunk_logger.py &
            echo $! > ${MASTOOLS_SPLUNK_PID_FILE}
        fi
    fi
}

mastools_monit_no_registraion()
{
    check_process_run ${MASTOOLS_UPGRADE_PID_FILE}
    if [ $? != 0 ]; then
        sleep 5
        cd /var/mastools/scripts
        if [ "$1" != "" ]; then
            pkill -9 -f mastools_upgrade.py
            $python_bin /var/mastools/scripts/mastools_upgrade.py $1 loop &
        else
            pkill -9 -f mastools_upgrade.py
            $python_bin /var/mastools/scripts/mastools_upgrade.py &
        fi
        echo $! > ${MASTOOLS_UPGRADE_PID_FILE}
    fi

    check_process_run ${MASTOOLS_TELEMETRY_PID_FILE}
    if [ $? != 0 ]; then
        echo "telemetry is not running. trying to restart it now" >> $MASTOOLS_MONIT_LOG
        sleep 5
        cd /var/mastools/scripts
        pkill -9 -f mastools_tlmy.py
        $python_bin ${MASTOOLS_TELEMETRY_SCRIPT} &
        echo $! > ${MASTOOLS_TELEMETRY_PID_FILE}
    fi
}

# script name without the path
SCRIPT_NAME=$(basename "$0")

# pgrep in linux returns script's own pid as well
# Hence checking if same process is running with a different pid
for pid in $(pgrep -f "$SCRIPT_NAME"); do
    if [ $pid != $$ ]; then
        echo "Another instance of $SCRIPT_NAME is already running."
        exit 1
    fi
done

while true ; do
    sleep 120
    if [ -e $MASTOOLS_AGENT_CONF ]; then
        mastools_monit
    else
        mastools_monit_no_registraion $1
    fi
done
