import pexpect
import argparse
import subprocess
import shlex
import os
import sys
import re
import copy
import json
import time
import base64
import xmltodict
import httplib2
import encodings


#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

SVM_BASH = 'bash '
SVM_SH = '/bin/sh '
ADM_AUTO_REG = '/var/mastools/scripts/admautoreg/admautoregd_ctl '
MASTOOLS_INIT = '/var/mastools/scripts/mastools_init.sh '
SDX_PASSWORD_PROMPT = 'Password:'
VPX_USERNAME_PROMPT = 'Vpx Username:'
VPX_PASSWORD_PROMPT = 'Vpx Password:'
MASTOOLS_REGISTRATION_SUCCESS = 'NetScaler ADM Tools successfully registered'
MASTOOLS_REGISTRATION_FAILURE = 'NetScaler ADM Tools registration failure'

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)

def run_command(cmd):
    args = shlex.split(cmd)
    FNULL = open(os.devnull, 'w')
    subprocess.call(args, stdout=FNULL, stderr=subprocess.STDOUT)
    FNULL.close()


def send_back_str(child, expected_string,  back_str):
    i = child.expect([expected_string, pexpect.EOF])
    if i == 0:
        child.sendline(back_str)
    else:
        logger.info("didn't get the expected prompt, expected string: " + expected_string)
        sys.exit(-1)
    return

def is_registraion_success(child):
    i = child.expect([MASTOOLS_REGISTRATION_SUCCESS, pexpect.EOF])
    if i == 0:
        return True
    else:
        return False
    
def run_registration(sdx_user, sdx_pwd, vpx_user, vpx_pwd, service_url, activation_code):
    registraion_cmd = SVM_BASH + MASTOOLS_INIT + sdx_user + ' ' + service_url + ' ' + activation_code + ' -sdx'
    child = pexpect.spawn(registraion_cmd, timeout=300)
    logger.debug("registration command:" + registraion_cmd)
    send_back_str(child, SDX_PASSWORD_PROMPT, sdx_pwd)
    send_back_str(child, VPX_USERNAME_PROMPT, vpx_user)
    send_back_str(child, VPX_PASSWORD_PROMPT, vpx_pwd)
    if is_registraion_success(child):
        print (MASTOOLS_REGISTRATION_SUCCESS)
    else:
        print (MASTOOLS_REGISTRATION_FAILURE)
    child.close()
    return

def run_registration_profile(profile, service_url, activation_code):
    registraion_cmd = SVM_BASH + MASTOOLS_INIT + profile + ' ' + service_url + ' ' + activation_code + ' -sdx' + ' -profile'
    child = pexpect.spawn(registraion_cmd, timeout=1200)
    logger.debug("registration command:" + registraion_cmd)
    if is_registraion_success(child):
        print (MASTOOLS_REGISTRATION_SUCCESS)
    else:
        print (MASTOOLS_REGISTRATION_FAILURE)
    child.close()
    return


def run_auto_reg_script(auto_reg_cmd_option):
    auto_reg_cmd = SVM_SH + ADM_AUTO_REG + auto_reg_cmd_option
    logger.debug("auto registration command:" + auto_reg_cmd)
    run_command(auto_reg_cmd)
    return




def _main(argv):
    argv = sys.argv
    argc = len(argv)
    if argc == 7:
        sdx_user = argv[1]
        sdx_pwd = argv[2]
        vpx_user = argv[3]
        vpx_pwd = argv[4]
        service_url = argv[5]
        activation_code = argv[6]
        run_registration(sdx_user, sdx_pwd, vpx_user, vpx_pwd, service_url, activation_code)
    elif argc == 4:
        profile = argv[1]
        service_url = argv[2]
        activation_code = argv[3]
        run_registration_profile(profile, service_url, activation_code)
    elif argc == 2:
        auto_reg_cmd_option = argv[1]
        run_auto_reg_script(auto_reg_cmd_option)
    else:
        logger.debug("Please specify sdx username/pwd, vpx username/pwd, service url and password")
        sys.exit(-1)
    sys.exit(0)

if __name__ == "__main__":

    sys.exit(_main(sys.argv))
