#!/usr/local/bin/python

import sys
import time
import os
import urllib
import xmltodict
import datetime
import httplib2
import subprocess
import platform
import json
import timesync

try:
    from mastools_reg import sign_request, is_python_2_6, auth_request_header, get_mastools_proxy_httplib2
    from ccauth import newkeypair
except:
    pass


#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)
#======================================================================================================================================================

AGENT_CONFIG_FILE = '/var/mastools/conf/agent.conf'
AGENT_CONF_DICT= {}

CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'

MASTOOLS_CWS_SERVICENAME = 'netappliance'
MASTOOLS_CONF_FILE = '/var/mastools/conf/agent.conf'
LEGATUS_AGENT_REQ_COOKIE = 'legatus_agent_request'

EXPECTED_TIME_DIFF = 5*60 #5 minutes

def is_python_3_running():
    if platform.python_version().startswith('3.'):
        return True
    return False

is_python_3 = is_python_3_running()

def get_logger_header():
    instanceid_to_print = INSTANCE_ID
    if len(INSTANCE_ID) > 8:
        instanceid_to_print = INSTANCE_ID[:4] + '****' + INSTANCE_ID[-4:]
    return '['+SERVICE_NAME+']'+'['+CUSTOMER_ID+']'+'['+instanceid_to_print+']:'

def get_apigw_url():
    if 'url' not in AGENT_CONF_DICT.keys():
        apigw_url = "none"
    else:
        apigw_url = AGENT_CONF_DICT['url']
    return apigw_url

def get_agent_conf():
    if not os.path.exists(MASTOOLS_CONF_FILE):
        logger.error(get_logger_header()+' mastools not initialised')
        system.exit(-1)

    with open("/var/mastools/conf/agent.conf", "r+") as agent_conf_file:
        content= agent_conf_file.read()
        agent_conf_file.close()

    agent_conf_dict = xmltodict.parse(content)['mps_agent']
    global CUSTOMER_ID
    global SERVICE_NAME
    global INSTANCE_ID
    global CLOUD_URL
    global IS_MGMT_TENANT
    global DEVICE_PROFILE_NAME
    global IS_VPX

    CUSTOMER_ID = get_param_from_dict('customerid', agent_conf_dict)
    SERVICE_NAME = get_param_from_dict('servicename', agent_conf_dict)
    INSTANCE_ID = get_param_from_dict('instanceid', agent_conf_dict)
    CLOUD_URL = get_param_from_dict('url', agent_conf_dict)
    mgmt_tenant = get_param_from_dict('mgmt_tenant', agent_conf_dict)
    device_profile = get_param_from_dict('profile', agent_conf_dict)
    device_type = get_param_from_dict('type', agent_conf_dict)
    if mgmt_tenant != '':
        IS_MGMT_TENANT = True
    else:
        IS_MGMT_TENANT = False
    if device_profile == '':
        DEVICE_PROFILE_NAME = "mastool_"+INSTANCE_ID+"_profile"
    else:
        DEVICE_PROFILE_NAME = device_profile


    if device_type == '':
        IS_VPX = True
    else:
        IS_VPX = False

    return

def gen_clour_req_url(uri):
    if is_python_2_6:
        cloud_uri = '/' + CUSTOMER_ID + '/' + SERVICE_NAME + uri;
    else:
        cloud_uri = '/' + CUSTOMER_ID + '/' + MASTOOLS_CWS_SERVICENAME + uri;
    clour_req_url = "https://"+ CLOUD_URL + cloud_uri
    return clour_req_url



def send_request(url, method, payload='', time_out=30):
    if is_python_2_6:
        service_token = sign_request(url, SERVICE_NAME, INSTANCE_ID)
    else:
        service_token = sign_request(url, MASTOOLS_CWS_SERVICENAME, INSTANCE_ID)
    proxy_httplib2 = get_mastools_proxy_httplib2()
    if proxy_httplib2:
        httpConnection=httplib2.Http(".cache",proxy_info=proxy_httplib2,ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    else:
        httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    headers_conn = {'Content-Type':'application/json'}
    headers_conn['Authorization'] = auth_request_header+service_token
    logger.debug(get_logger_header()+url + ";method: " + method)
    legatus_cookie = LEGATUS_AGENT_REQ_COOKIE+'=true'
    content = ''
    if IS_MGMT_TENANT:
        headers_conn['Cookie'] = legatus_cookie+';'+MGMT_TENANT_COOKIE + ':"yes"'
    else:
        headers_conn['Cookie'] = legatus_cookie
    try:
        if payload == '':
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn)
        else:
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
        if is_python_3:
            content = content.decode("utf-8")
        resp_str = 'responseStatus='+str(responseStatus)+' content='+content
        logger.debug(get_logger_header()+resp_str)
        logger.debug(get_logger_header()+content);
        if "status" in responseStatus:
            if responseStatus["status"] == '200' or responseStatus["status"] == '204':
                return True, content
        logger.debug(get_logger_header()+resp_str)
        logger.debug(get_logger_header()+content)
        return False, content
    except Exception as e:
        logger.debug(get_logger_header()+repr(e))
        return False, content
        
def get_param_from_dict(name, conf_dict):
    if name not in conf_dict.keys():
        if name == 'mgmt_tenant' or name == 'type' or name == 'profile':
            return ''
        else:
            logger.error(get_logger_header()+'no ' + name + ' in agent.conf')
            system.exit(-1)
    return conf_dict[name]        

def get_epoch_time_from_response(content):
    ret_val = ""
    try:
        data=json.loads(content)
        ret_val = data["mps"][0]["current_time"]
        logger.debug("get_epoch_time is " + ret_val)
    except Exception as e:
        logger.error("Could not get_epoch_time, error:"+repr(e))

    return ret_val

def get_epoch_time_from_cloud():       
    get_agent_conf()
        
    epoch_url = gen_clour_req_url('/nitro/v1/config/mps')
    logger.debug("epoch_url: %s, trying to fetch server time", epoch_url)
    try:
        status, resp_str = send_request(epoch_url, 'GET')
    except Exception as e:
        logger.error("%s Exception occured while post request url %s, exit", get_logger_header(), repr(e))
        sys.exit(-1)
 
    if not status:
        logger.error("error in send request to cloud service, exit")
        sys.exit(-1)
        
    return  get_epoch_time_from_response(resp_str)  
        
def time_sync(epoch_time):
    if not epoch_time:
        logger.error("could not get epoch time from cloud, exit")
        sys.exit(-1)

    time_diff = abs(int(time.time())-(int)(epoch_time))
    if time_diff > EXPECTED_TIME_DIFF:
        timesync.time_sync_onprem(epoch_time)
    else:
        logger.debug("Time difference between netsclaer and cloud time is:%s seconds, skipping sync", str(time_diff))
    return         
    


if __name__ == "__main__":
    epoch_time = get_epoch_time_from_cloud()
    time_sync(epoch_time)        
        
    sys.exit(0)
        
    
