##
##Copyright (c) 2008-2025 Citrix Systems, Inc.
##

import os
import base64
import argparse
import random
import sys
import shutil
import requests

from mastools_reg import is_python_2_6, auth_request_header, get_mastools_proxy_requests

CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'
KEY_FILE='/nsconfig/ssl/ns-server.key'

#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

LOG_FILENAME = '/var/mastools/logs/mastools_upload_download.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)

class agentFileUploadDownload:

    def upload(self, sessionid, serverIP, localPath, remotePath, agentid, rowid, token, customerid, servicename):
        try:

            logger.info("In uploading file to NetScaler Console")
            logger.info("localPath: " + localPath + ", remotePath: " + remotePath)
            path = os.path.dirname(localPath)
            path = path + "/"
            filename = os.path.basename(localPath)
            file_component_name = os.path.dirname(remotePath)
            remote_filename = os.path.basename(remotePath)
            logger.info("path: " + path + ", filename: " + filename + ", file_component_name:" + file_component_name)
            logger.info("remote_filename:" + remote_filename)

            # Checking if file to be uploaded exists on client system
            if (not os.path.exists(path + filename)):
                logger.exception("File doesn't exist in the specified directory")
            if (sessionid is None):
                logger.exception(" Session doesn't Exist")
            length = os.path.getsize(path + filename)

            if is_python_2_6:
                urlstr = "https://" + serverIP + "/" + customerid + "/" + servicename + "/nitro/v1/upload"
            else:
                urlstr = "https://" + serverIP + "/" + customerid + "/netappliance/nitro/v1/upload"
            
            requests.packages.urllib3.disable_warnings()
            headers = {'Authorization': auth_request_header+token, 'Cookie': 'SESSID=' + sessionid, 'Content-Length': str(length),'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8','Accept-Encoding': 'gzip,deflate,sdch', 'Cache-Control': 'no-cache','Connection': 'Keep-Alive','isCloud':'true','agent-id': agentid, 'File-Source': 'Agent'}
            files = {file_component_name: (remote_filename, open(path+filename, 'rb'), 'multipart/form-data', {'Content-Disposition': 'form-data; name=' + file_component_name + '; filename=' + remote_filename})}
            #files = {file_component_name: (filename, open(path+filename, 'rb'), 'multipart/form-data', {'Content-Disposition': 'form-data; name=' + file_component_name + '; filename=' + remote_filename})}

            response = requests.post(urlstr, files=files, headers=headers, verify=CERT_BUNDLE_PATH, timeout=50000, proxies=get_mastools_proxy_requests())

            if (response.status_code == requests.codes.ok):
                logger.debug("Upload done successfully")
                return '{ "errorcode" : 0 , "message" : "Done"}'
            else:
                logger.debug("Upload error")
                return '{ "errorcode" : 10012 , "message" : "Request can not be processed"}'


        except Exception as e:
            logger.exception(e)
            return '{ "errorcode" : 10012 , "message" : "Request can not be processed"}'


    def download(self, sessionid, serverIP, localPath, remotePath, agentId, rowid, token, customerid, servicename, traceinfo):
        context = ""
        file_name = os.path.basename(localPath)
        if traceinfo and customerid:
            context = "%s %s" %(traceinfo, customerid)
        try:
            logger.info("Download file %s started from NetScaler Console %s" %(file_name, context))
            if is_python_2_6:
                URL = "https://" + serverIP + "/" + customerid + "/" + servicename + "/nitro/v1/download"
            else:
                URL = "https://" + serverIP + "/" + customerid + "/netappliance/nitro/v1/download"
            headers = {'Authorization': auth_request_header+token, 'Cookie':'SESSID='+sessionid, 'agent-id':agentId, 'file':remotePath, 'row-id':rowid, 'File-Source': 'Agent'}
            requests.packages.urllib3.disable_warnings()
            download_resp = requests.get(URL, verify=CERT_BUNDLE_PATH, headers=headers, stream=True, proxies=get_mastools_proxy_requests(), timeout=(300, 3600))
            download_resp.raise_for_status()

            if not download_resp.ok:
                msg = "Failed to download file %s from NetScaler Console. %s:%s:%s %s" %(file_name, str(download_resp.status_code), download_resp.reason, download_resp.text, context)
                #logger.error("%s" %(msg))
                return '{ "errorcode" : 10012 , "message" : "Error: %s"}' %(msg)

            with open(localPath, 'wb') as fw:
                for chunk in download_resp.iter_content(chunk_size=8*1024):
                    if chunk:
                        fw.write(chunk)
                fw.close()

        except requests.exceptions.ConnectionError as connectexp:
            msg = "Failed to download file %s from NetScaler Console, connection error exception: %s %s" %(file_name, str(connectexp), context)
            #logger.error("%s" %(msg))
            return '{ "errorcode" : 10012 , "message" : "Error: %s"}' %(msg)
        except requests.exceptions.RequestException as reqexp:
            msg = "Failed to download file %s from NetScaler Console, requests.get exception: %s %s" %(file_name, str(reqexp), context)
            #logger.error("%s" %(msg))
            return '{ "errorcode" : 10012 , "message" : "Error: %s"}' %(msg)
        except Exception as exp:
            msg = "Failed to download file %s from NetScaler Console, exception: %s %s" %(file_name, str(exp), context)
            #logger.error("%s" %(msg))
            return '{ "errorcode" : 10012 , "message" : "Error: %s"}' %(msg)
        logger.debug("Download file %s done from NetScaler Console %s" %(file_name, context))
        return '{ "errorcode" : 0 , "message" : "Done"}'


    def testprogram(self):
        try:
                pass
        except:
            return '{ "errorcode" : 10012 , "message" : "Request can not be processed" }'


def main():
    parser = argparse.ArgumentParser(description="Agent File Upload/Download")
    parser.add_argument('action')
    parser.add_argument('--sessionid', dest="sessionID")
    parser.add_argument('--serverip', dest="serverIP")
    parser.add_argument('--agentid', dest="agentId")
    parser.add_argument('--remotepath', dest="remotePath")
    parser.add_argument('--localpath', dest="localPath")
    parser.add_argument('--rowid', dest="rowId")
    parser.add_argument('--token', dest="Token")
    parser.add_argument('--customerid', dest="customerId")
    parser.add_argument('--servicename', dest="serviceName")
    parser.add_argument('--traceinfo', dest="traceinfo")

    try:
        args=parser.parse_args()

        traceinfo = ""
        if args.traceinfo:
            traceinfo = args.traceinfo

        if args.action == "upload":
            if args.sessionID is None or args.serverIP is None or args.remotePath is None or args.agentId is None or args.rowId is None or args.Token is None or args.customerId is None or args.serviceName is None:
                 print ('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }' )
            else:
                print (agentFileUploadDownload().upload(args.sessionID,args.serverIP,args.localPath,args.remotePath,args.agentId,args.rowId,args.Token,args.customerId,args.serviceName))
        elif args.action == "download":
            if args.sessionID is None or args.serverIP is None or args.remotePath is None or args.localPath is None or args.agentId is None or args.rowId is None or args.Token is None or args.customerId is None or args.serviceName is None:
                 print ('{ "errorcode" : 10007 , "message" : "Error: too few arguments" }')
            else:
                print (agentFileUploadDownload().download(args.sessionID,args.serverIP,args.localPath,args.remotePath,args.agentId,args.rowId,args.Token,args.customerId,args.serviceName, traceinfo))
        elif args.action == "test":
            agentFileUploadDownload().testprogram()
    except Exception as e:
        logger.info("Exception in running the script: " + repr(e)) 
        return '{ "errorcode" : 10008 , "message" : "Invalid Parameter"} '



if __name__ == '__main__':
    main()
    sys.exit(0)
