#!/usr/bin/env python

"""
Copyright 2000-2022 Citrix Systems, Inc. All rights reserved.
This software and documentation contain valuable trade secrets
and proprietary property belonging to Citrix Systems, Inc.
None of this software and documentation may be copied,
duplicated or disclosed without the express written permission
of Citrix Systems, Inc.
"""

from setuptools import find_packages
from setuptools import setup

from glob import glob

from os.path import basename
from os.path import dirname
from os.path import join
from os.path import splitext
from os import environ

environ["COPYFILE_DISABLE"] = "true"
environ["DISTUTILS_DEBUG"] = "true"


setup(
    # Application name:
    name="Rainman",

    version="2.0",

    author="Citrix Systems Inc",
    author_email="support@citrix.com",

    packages=find_packages('src'),
    package_dir={'':'src'},
    py_modules=[splitext(basename(path))[0] for path in glob('src/*.py')],
    data_files=[('rainman_core/common/', ['src/rainman_core/common/rain_stats.json'])],
    include_package_data=True,

    # Details
    url="http://www.citrix.com",

    # license="LICENSE.txt",
    description="Rainman suite: configuration engine, autoscale engine, stats engine, tags engine",

    entry_points={
        'console_scripts':[
            'rain_config = rain_config:main',
            'rain_scale = rain_scale:main',
            'rain_stats = rain_stats:main',
            'rain_tags = rain_tags:main',
            'cloudadapter = cloudadapter:main'
    ]
    },
    # Dependent packages (distributions)
    install_requires=[
    ],
)
