'''
Common to both cloud and local. 

All of these base 	methods take rainman config objects as input, and return rainman objects.
'''
class base_driver(object):

	'''
	Group management
	'''
	def add_group(self, group):
		raise NotImplementedError('%s: add_group not implemented' % (self.__class__.__name__))

	def get_group(self, group_names=None):
		raise NotImplementedError('%s: get_group not implemented' % (self.__class__.__name__))

	def remove_group(self, group):
		raise NotImplementedError('%s: remove_group not implemented' % (self.__class__.__name__))

	'''
	Servers in groups.
	'''
	def get_servers_in_group(self, group_name):
		raise NotImplementedError('%s: get_servers_in_group not implemented' % (self.__class__.__name__))

	def add_server_to_group(self, server, group):
		raise NotImplementedError('%s: add_server_to_group not implemented' % (self.__class__.__name__))

	def remove_server_from_group(self, server, group):
		raise NotImplementedError('%s: remove_server_from_group not implemented' % (self.__class__.__name__))

	'''
	Stats
	'''
	def get_stat_for_group(self, stat, group):
		raise NotImplementedError('%s: get_stat_for_group not implemented' % (self.__class__.__name__))

'''
Local only
'''
class base_local_driver(base_driver):
	'''
	Groups behind LBs

	Load balancing only happens on the local platform.
	There may be use case for "get" functions related to
	LB on cloud platforms to ease migration.
	'''
	def add_group_to_lb(self, group, lb):
		raise NotImplementedError('%s: add_group_to_lb not implemented' % (self.__class__.__name__))

	def remove_group_from_lb(self, group, lb):
		raise NotImplementedError('%s: remove_group_from_lb not implemented' % (self.__class__.__name__))

'''
Cloud only
'''
class base_cloud_driver(base_driver):
	'''
	Alarms
	'''
	def get_alarm(self, alarm):
		raise NotImplementedError('%s: get_alarm not implemented' % (self.__class__.__name__))

	def add_alarm(self, alarm):
		raise NotImplementedError('%s: add_alarm not implemented' % (self.__class__.__name__))

	def update_alarm(self, alarm):
		raise NotImplementedError('%s: update_alarm not implemented' % (self.__class__.__name__))

	def remove_alarm(self, alarm):
		raise NotImplementedError('%s: remove_alarm not implemented' % (self.__class__.__name__))


	'''
	Alarms in groups
	'''
	def get_alarms_for_group(self, group):
		raise NotImplementedError('%s: get_alarms_for_group not implemented' % (self.__class__.__name__))

	def add_alarm_to_group(self, alarm, group):
		raise NotImplementedError('%s: add_alarm_to_group not implemented' % (self.__class__.__name__))

	def remove_alarm_from_group(self, alarm, group):
		raise NotImplementedError('%s: remove_alarm_from_group not implemented' % (self.__class__.__name__))

	'''
	Events
	'''
	def get_event_queue(self, queue):
		raise NotImplementedError('%s: get_event_queue not implemented' % (self.__class__.__name__))

	def add_event_queue(self, queue):
		raise NotImplementedError('%s: add_event_queue not implemented' % (self.__class__.__name__))

	def get_events_from_queue(self, queue):
		raise NotImplementedError('%s: get_events_from_queue not implemented' % (self.__class__.__name__))

	def configure_events_for_groups(self, queue, group_names):
		raise NotImplementedError('%s: configure_events_for_groups' % (self.__class__.__name__))
	def  configure_polling_for_groups(self, group_names):
		raise NotImplementedError('%s: configure_polling_for_groups' % (self.__class__.__name__))