"""
Copyright 2000-2023 Citrix Systems, Inc. All rights reserved.
This software and documentation contain valuable trade secrets
and proprietary property belonging to Citrix Systems, Inc.
None of this software and documentation may be copied,
duplicated or disclosed without the express written permission
of Citrix Systems, Inc.
"""

import logging


DEFAULT_LOG_LEVEL = logging.INFO
CONFIG_LOG_FILE_NAME = '/var/log/rain_config.log'
SCALE_LOG_FILE_NAME = '/var/log/rain_scale.log'
STATS_LOG_FILE_NAME = '/var/log/rain_stats.log'
TAGS_LOG_FILE_NAME = '/var/log/rain_tags.log'
UNDEF_LOG_FILE_NAME = '/var/log/rain_undefined.log'

AUTOSCALE = 1
AZURETAGS = 3

# PE Parser expects values in following order
PE_ORDER_GET_CP = {0: "drain",
                   1: "asgName",
                   2: "azureTagName",
                   3: "vserverName",
                   4: "azurePollPeriod",
                   5: "servicePort",
                   6: "delay",
                   7: "serviceProtocol",
                   8: "profileType",
                   9: "vserverPort",
                   10: "vserverProtocol",
                   11: "profileName",
                   12: "azureTagValue",
                   13: "cloudip"}
PE_ORDER_GET_ASG = {0: "drain",
                    1: "name",
                    2: "locations"}

AUTOHEAL_INTERVAL = 15 * 60
CONF_LOCK_NAME = "rainman/conf_lock"
CONF_LOCK_TIMEOUT = 30
