NS_BASE_ERRORS = {
    "NSERR_NOTRUNNING":{"errno":"0x100", "desc":"NetScaler not running"},
    "NSERR_PERM":{"errno":"0x101", "desc":"Operation not permitted"},
    "NSERR_NOENT":{"errno":"0x102", "desc":"No such resource"},
    "NSERR_SRCH":{"errno":"0x103", "desc":"No such process"},
    "NSERR_INTR":{"errno":"0x104", "desc":"Interrupted system call"},
    "NSERR_IO":{"errno":"0x105", "desc":"Input/output error"},
    "NSERR_NXIO":{"errno":"0x106", "desc":"Device not configured"},
    "NSERR_2BIG":{"errno":"0x107", "desc":"Argument list too long"},
    "NSERR_NOEXEC":{"errno":"0x108", "desc":"Exec format error"},
    "NSERR_BADF":{"errno":"0x109", "desc":"Bad file descriptor"},
    "NSERR_CHILD":{"errno":"0x10A", "desc":"No child processes"},
    "NSERR_DEADLK":{"errno":"0x10B", "desc":"Resource deadlock avoided"},
    "NSERR_NOMEM":{"errno":"0x10C", "desc":"Cannot allocate memory"},
    "NSERR_ACCES":{"errno":"0x10D", "desc":"Permission denied"},
    "NSERR_FAULT":{"errno":"0x10E", "desc":"Bad address"},
    "NSERR_NOTBLK":{"errno":"0x10F", "desc":"Block device required"},
    "NSERR_BUSY":{"errno":"0x110", "desc":"Device busy"},
    "NSERR_EXIST":{"errno":"0x111", "desc":"Resource already exists"},
    "NSERR_XDEV":{"errno":"0x112", "desc":"Cross-device link"},
    "NSERR_NODEV":{"errno":"0x113", "desc":"Operation not supported by device"},
    "NSERR_NOTDIR":{"errno":"0x114", "desc":"Not a directory"},
    "NSERR_ISDIR":{"errno":"0x115", "desc":"Is a directory"},
    "NSERR_INVAL":{"errno":"0x116", "desc":"Invalid argument"},
    "NSERR_NFILE":{"errno":"0x117", "desc":"Too many open files in system"},
    "NSERR_MFILE":{"errno":"0x118", "desc":"Too many open files"},
    "NSERR_NOTTY":{"errno":"0x119", "desc":"Inappropriate ioctl for device"},
    "NSERR_TXTBSY":{"errno":"0x11A", "desc":"Text file busy"},
    "NSERR_FBIG":{"errno":"0x11B", "desc":"File too large"},
    "NSERR_NOSPACE":{"errno":"0x11C", "desc":"No space left on device"},
    "NSERR_SPIPE":{"errno":"0x11D", "desc":"Illegal seek"},
    "NSERR_ROFS":{"errno":"0x11E", "desc":"Read-only file system"},
    "NSERR_MLINK":{"errno":"0x11F", "desc":"Too many links"},
    "NSERR_PIPE":{"errno":"0x120", "desc":"Broken pipe"},
    "NSERR_DOM":{"errno":"0x121", "desc":"Numerical argument out of domain"},
    "NSERR_RANGE":{"errno":"0x122", "desc":"Result too large"},
    "NSERR_AGAIN":{"errno":"0x123", "desc":"Resource temporarily unavailable"},
    "NSERR_INPROGRESS":{"errno":"0x124", "desc":"Operation now in progress"},
    "NSERR_ALREADY":{"errno":"0x125", "desc":"Operation already in progress"},
    "NSERR_NOTSOCK":{"errno":"0x126", "desc":"Socket operation on non-socket"},
    "NSERR_DESTADDRREQ":{"errno":"0x127", "desc":"Destination address required"},
    "NSERR_MSGSIZE":{"errno":"0x128", "desc":"Message too long"},
    "NSERR_PROTOTYPE":{"errno":"0x129", "desc":"Protocol wrong type for socket"},
    "NSERR_NOPROTOOPT":{"errno":"0x12A", "desc":"Protocol not available"},
    "NSERR_PROTONOSUPPORT":{"errno":"0x12B", "desc":"Protocol not supported"},
    "NSERR_SOCKTNOSUPPORT":{"errno":"0x12C", "desc":"Socket type not supported"},
    "NSERR_OPNOTSUPP":{"errno":"0x12D", "desc":"Operation not supported"},
    "NSERR_PFNOSUPPORT":{"errno":"0x12E", "desc":"Protocol family not supported"},
    "NSERR_AFNOSUPPORT":{"errno":"0x12F", "desc":"Address family not supported by protocol family"},
    "NSERR_ADDRINUSE":{"errno":"0x130", "desc":"Address already in use"},
    "NSERR_ADDRNOTAVAIL":{"errno":"0x131", "desc":"Can't assign requested address"},
    "NSERR_NETDOWN":{"errno":"0x132", "desc":"Network is down"},
    "NSERR_NETUNREACH":{"errno":"0x133", "desc":"Network is unreachable"},
    "NSERR_NETRESET":{"errno":"0x134", "desc":"Network dropped connection on reset"},
    "NSERR_CONNABORTED":{"errno":"0x135", "desc":"Software caused connection abort"},
    "NSERR_CONNRESET":{"errno":"0x136", "desc":"Connection reset by peer"},
    "NSERR_NOBUFS":{"errno":"0x137", "desc":"No buffer space available"},
    "NSERR_ISCONN":{"errno":"0x138", "desc":"Socket is already connected"},
    "NSERR_NOTCONN":{"errno":"0x139", "desc":"Socket is not connected"},
    "NSERR_SHUTDOWN":{"errno":"0x13A", "desc":"Can't send after socket shutdown"},
    "NSERR_TOOMANYREFS":{"errno":"0x13B", "desc":"Resource in use"},
    "NSERR_TIMEDOUT":{"errno":"0x13C", "desc":"Operation timed out"},
    "NSERR_CONNREFUSED":{"errno":"0x13D", "desc":"Connection refused"},
    "NSERR_LOOP":{"errno":"0x13E", "desc":"Too many levels of symbolic links"},
    "NSERR_NAMETOOLONG":{"errno":"0x13F", "desc":"File name too long"},
    "NSERR_HOSTDOWN":{"errno":"0x140", "desc":"Host is down"},
    "NSERR_HOSTUNREACH":{"errno":"0x141", "desc":"No route to host"},
    "NSERR_NOTEMPTY":{"errno":"0x142", "desc":"Directory not empty"},
    "NSERR_PROCLIM":{"errno":"0x143", "desc":"Too many processes"},
    "NSERR_USERS":{"errno":"0x144", "desc":"Too many users"},
    "NSERR_DQUOT":{"errno":"0x145", "desc":"Disc quota exceeded"},
    "NSERR_STALE":{"errno":"0x146", "desc":"Stale NFS file handle"},
    "NSERR_REMOTE":{"errno":"0x147", "desc":"Too many levels of remote in path"},
    "NSERR_BADRPC":{"errno":"0x148", "desc":"RPC struct is bad"},
    "NSERR_RPCMISMATCH":{"errno":"0x149", "desc":"RPC version wrong"},
    "NSERR_PROGUNAVAIL":{"errno":"0x14A", "desc":"RPC prog. not avail"},
    "NSERR_PROGMISMATCH":{"errno":"0x14B", "desc":"Program version wrong"},
    "NSERR_PROCUNAVAIL":{"errno":"0x14C", "desc":"Bad procedure for program"},
    "NSERR_NOLCK":{"errno":"0x14D", "desc":"No locks available"},
    "NSERR_NOSYS":{"errno":"0x14E", "desc":"System Call not supported; Possible Reason: NetScaler is not running"},
    "NSERR_FTYPE":{"errno":"0x14F", "desc":"Inappropriate file type or format"},
    "NSERR_AUTH":{"errno":"0x150", "desc":"Authentication error"},
    "NSERR_NEEDAUTH":{"errno":"0x151", "desc":"Need authenticator"},
    "NSERR_WOULDBLOCK":{"errno":"0x152", "desc":"Operation would block"},
    "NSERR_NOCODE":{"errno":"0x153", "desc":"Feature is not implemented"},
    "NSERR_NOTSUSER":{"errno":"0x154", "desc":"Not super-user"},
    "NSERR_BIGDATA":{"errno":"0x155", "desc":"Data size is too big"},
    "NSERR_SMALLDATA":{"errno":"0x156", "desc":"Data size is too small"},
    "NSERR_NOMORENT":{"errno":"0x157", "desc":"No more entry in table"},
    "NSERR_NOSERVICE":{"errno":"0x158", "desc":"No Service"},
    "NSERR_OSERROR":{"errno":"0x159", "desc":"Operating system error"},
    "NSERR_NONEXPCMD":{"errno":"0x15A", "desc":"Unexpected command"},
    "NSERR_CMDPROPFAIL":{"errno":"0x15B", "desc":"Command propagation failed"},
    "NSERR_TOOMANYNODES":{"errno":"0x15C", "desc":"Too many nodes"},
    "NSERR_SECONDARYFAIL":{"errno":"0x15D", "desc":"Command failed on secondary node, but succeeded on primary node. Configuration will be synchronized to ensure secondary and primary have same configuration."},
    "NSERR_INVALBACKUP":{"errno":"0x15E", "desc":"Invalid backup vserver"},
    "NSERR_NOSERVER":{"errno":"0x15F", "desc":"No such server"},
    "NSERR_LOGINREQD":{"errno":"0x160", "desc":"Login is required"},
    "NSERR_RPCINVAL":{"errno":"0x161", "desc":"RPC invalid argument"},
    "NSERR_NOUSER":{"errno":"0x162", "desc":"Invalid username or password"},
    "NSERR_INVALPASSWD":{"errno":"0x163", "desc":"Invalid username or password"},
    "NSERR_LICENSE":{"errno":"0x164", "desc":"Feature(s) not licensed"},
    "NSERR_DEFERRED":{"errno":"0x165", "desc":"The command is stored for later execution"},
    "NSERR_PROPAUTHFAIL":{"errno":"0x166", "desc":"Command propagation failed due to user authentication problems"},
    "NSERR_NODELSUSER":{"errno":"0x167", "desc":"The superuser cannot be removed"},
    "NSERR_NOMODSUSER":{"errno":"0x168", "desc":"Permissions for this superuser cannot be modified"},
    "NSERR_INVALNODEID":{"errno":"0x16A", "desc":"Invalid node ID specified"},
    "NSERR_NOTOPHA":{"errno":"0x16B", "desc":"Operation not permitted on stand-alone node"},
    "NSERR_NOOPPEERBAD":{"errno":"0x16c", "desc":"Operation not possible due to invalid peer state. Rectify and retry."},
    "NSERR_NOOPBAD":{"errno":"0x16d", "desc":"Operation not possible as system state is invalid. Use show node for more information."},
    "NSERR_NOPNOW":{"errno":"0x16e", "desc":"Operation not possible now. Please wait for system to stabilize before retrying."},
    "NSERR_NOOPPRI":{"errno":"0x16f", "desc":"Operation permitted only on secondary node."},
    "NSERR_NOOPSEC":{"errno":"0x170", "desc":"Operation permitted only on primary node."},
    "NSERR_REDIRECT":{"errno":"0x171", "desc":"Redirect request (VIP down)"},
    "NSERR_BUFOVERFLOW":{"errno":"0x172", "desc":"Buffer overflow occurred"},
    "NSERR_NOUSERPOLICY":{"errno":"0x173", "desc":"No command policy defined, permission denied"},
    "NSERR_NOSYSGROUP":{"errno":"0x174", "desc":"System group does not exist"},
    "NSERR_NOSYSCMDPOL":{"errno":"0x175", "desc":"System command policy does not exist"},
    "NSERR_HAIPV6PT":{"errno":"0x176", "desc":"IPV6 Feature cannot be disabled while HA is running over IPv6."},
    "NSERR_HANSIPV6":{"errno":"0x177", "desc":"IPv6 NSIP cannot be changed while HA is running over IPv6."},
    "NSERR_NSIPV6ACTIVE":{"errno":"0x178", "desc":"IPv6 NSIP is not in ACTIVE state, rectify and retry."},
    "NSERR_RTMON_STANDALONE":{"errno":"0x179", "desc":"Unbind all route monitors before making node standalone."},
    "NSERR_IPV6FEAT_DISABLED":{"errno":"0x17a", "desc":"IPv6 Feature Disabled"},
    "NSERR_DHCP_PBR_DEPENDENT":{"errno":"0x17b", "desc":"PBR rule present with nexthop dependent on released DHCP lease"},
    "NSERR_IPSECPROF_PERM":{"errno":"0x17c", "desc":"Tunnel protocol IPSEC must have ipsec profile set to 'none'."},
    "NSERR_IFPAIR_BOUND":{"errno":"0x17d", "desc":"Interface(s) already member of other interface pair"},
    "NSERR_IFPAIR_NOTPAIR":{"errno":"0x17e", "desc":"Number of member interfaces need to be exactly 2"},
    "NSERR_PBR_SETIPTUNNEL":{"errno":"0x17f", "desc":"SET operations on PBR for changing iptunnel not allowed. Remove and add PBR with new iptunnel"},
    "NSERR_IPRANGENOTALLOWD":{"errno":"0x18A", "desc":"Range not allowed for wildcard IP"},
    "NSERR_IVALIDIPRANGE":{"errno":"0x18B", "desc":"Invalid range value"},
    "NSERR_IPRANGEMAXLIMIT":{"errno":"0x18C", "desc":"Range value greater than maximum limit 254"},
    "NSERR_IP_NOT_EXIST":{"errno":"0x18D", "desc":"IP does not exist for default or specified td"},
    "NSERR_TOOMANYRULES":{"errno":"0x18E", "desc":"Maximum number of ACLs on the system has been exceeded"},
    "NSERR_PASSWD_LEN_MIN_8":{"errno":"0x18F", "desc":"Password too short - minimum length is 8 characters"},
    "NSERR_SYNC_DISABLED":{"errno":"0x19A", "desc":"Synchronization disabled"},
    "NSERR_NODE_DISABLED":{"errno":"0x19B", "desc":"Node disabled"},
    "NSERR_SYNC_PROGRESS":{"errno":"0x19C", "desc":"Synchronization is in progress"},
    "NSERR_ADNS_PERM":{"errno":"0x19D", "desc":"Operation not permitted on ADNS service"},
    "NSERR_NOINC_IPSAMESUBNET":{"errno":"0x19E", "desc":"Peer IP should be on the NSIP subnet if INC mode is disabled"},
    "NSERR_INVALID_PEERIP":{"errno":"0x19F", "desc":"Not a valid peer IP"},
    "NSERR_REDIRECT307":{"errno":"0x1A0", "desc":"Redirect request (send 307 temporary redirect"},
    "NSERR_INVALHOSTNAME":{"errno":"0x1A1", "desc":"Invalid hostname"},
    "NSERR_REWRITE_NOT_SUPPORTED":{"errno":"0x1A2", "desc":"Port rewrite not supported on this vserver type"},
    "NSERR_IPCHG_DENY":{"errno":"0x1A3", "desc":"IP address change not permitted on this entity"},
    "NSERR_IPCHG_GSLB":{"errno":"0x1A4", "desc":"GSLB local service IP cannot be changed. Please change the corresponding vserver's IP"},
    "NSERR_GSLB_IPCHG":{"errno":"0x1A5", "desc":"corresponding GSLB service IP has also been changed."},
    "NSERR_NOAUDITSRVC":{"errno":"0x1A6", "desc":"No audit service running on the specified port"},
    "NSERR_LACPKEY_NOTSET":{"errno":"0x1A7", "desc":"LACP key not set"},
    "NSERR_CHANNEL_INUSEBYLACP":{"errno":"0x1A8", "desc":"Channel in use by LACP"},
    "NSERR_LACPENABLED":{"errno":"0x1A9", "desc":"LACP enabled interface cannot be bound manually to a channel"},
    "NSERR_IFACEMANUALLYBOUND":{"errno":"0x1AA", "desc":"LACP cannot be enabled, interface manually bound to a channel"},
    "NSERR_INTRECINUSE":{"errno":"0x1AB", "desc":"Domain name for the reverse domain name already exists"},
    "NSERR_IPPORT_VIP_CONFLICT":{"errno":"0x1AC", "desc":"IP, port conflict with another entity bound to the same vserver"},
    "NSERR_IPPORT_VIP_BOUND":{"errno":"0x1AD", "desc":"IP, port conflict with an entity already bound to the vserver "},
    "NSERR_NO_BACKUP_VIP":{"errno":"0x1AE", "desc":"No such backup vserver"},
    "NSERR_REQ_SET_ARGS":{"errno":"0x1AF", "desc":"No arguments to set"},
    "NSERR_SVCGRP_MEMBER_NAMECONFLICT":{"errno":"0x1B0", "desc":"Name conflicts with an existing service or service group member name"},
    "NSERR_SERVER_NAME_EXIST":{"errno":"0x1B1", "desc":"Server name already exists"},
    "NSERR_MAX_SERVICE_BINDING_ON_VSERVER":{"errno":"0x1B2", "desc":"Maximum services bound to vserver exceeded"},
    "NSERR_MAX_SVC_ENTITY_BINDING_ON_SVCGROUP":{"errno":"0x1B3", "desc":"Maximum services bound to service group exceeded"},
    "NSERR_FSMALL":{"errno":"0x1B4", "desc":"File too small"},
    "NSERR_INTOFLOW":{"errno":"0x1B5", "desc":"Integer overflow"},
    "NSERR_ASYNC_BLOCKED":{"errno":"0x1B6", "desc":"PI has blocked for body accumulation"},
    "NSERR_SACL_CLEARPENDING":{"errno":"0x1B7", "desc":"Clear in progress"},
    "NSERR_SACL_NAME_EXISTS":{"errno":"0x1B8", "desc":"An ACL with the same name exists"},
    "NSERR_SACL_SUPERSET_EXISTS":{"errno":"0x1B9", "desc":"Operation not permitted. (An overlapping rule already exists)"},
    "NSERR_SACL_SUBSET_EXISTS":{"errno":"0x1BA", "desc":"Operation not permitted. (A rule which is subset of this rule already exists)"},
    "NSERR_NOINC_ROUTEMONITOR":{"errno":"0x1BB", "desc":"Route monitors should be added only if INC mode is enabled"},
    "NSERR_SESSION_EXPIRED":{"errno":"0x1BC", "desc":"Session expired or killed. Please login again"},
    "NSERR_SESSION_EXCEEDED":{"errno":"0x1BD", "desc":"Session limit exceeded"},
    "NSERR_CFE_CONN_EXCEEDED":{"errno":"0x1BE", "desc":"Connection limit to CFE exceeded"},
    "NSERR_CFE_KILLSELF":{"errno":"0x1C1", "desc":"Invalid session id. Current session cannot be killed"},
    "NSERR_CFE_INCOMPLETESESSION":{"errno":"0x1C2", "desc":"Invalid session. Response/challenge is incomplete"},
    "NSERR_ACL_ALREADYINSTATE":{"errno":"0x1C3", "desc":"Entity already in this state"},
    "NSERR_CFE_SESSION_NOEXIST":{"errno":"0x1C4", "desc":"Session does not exist"},
    "NSERR_SYSGROUP_USER_EXISTS":{"errno":"0x1C5", "desc":"User already bound to system group"},
    "NSERR_SYSGROUP_POLICY_EXISTS":{"errno":"0x1C6", "desc":"Policy already bound to system group"},
    "NSERR_SLEEP":{"errno":"0x1C7", "desc":"Sleep process sleep"},
    "NSERR_PPEDIE":{"errno":"0x1C8", "desc":"Your PPE is no more"},
    "NSERR_NOCONN_CMDPROPFAIL":{"errno":"0x1C9", "desc":"Unable to establish connection with the secondary. Command propagation failed"},
    "NSERR_TIMEOUT_SECONDARY":{"errno":"0x1CA", "desc":"There is no response from the secondary. Propagation timed out"},
    "NSERR_RPC_TIMEOUT":{"errno":"0x1CB", "desc":"RPC timeout"},
    "NSERR_NOT_SUPPORTED":{"errno":"0x1CC", "desc":"Feature not supported in this release"},
    "NSERR_NOENT_VSERVER":{"errno":"0x1CD", "desc":"No such Vserver"},
    "NSERR_NOENT_SVC":{"errno":"0x1CE", "desc":"No such service"},
    "NSERR_NOENT_SVC_SVCGRP":{"errno":"0x1CF", "desc":"No such service/serviceGroup"},
    "NSERR_HA_NOV4_NETMASK":{"errno":"0x1D0", "desc":"IPv4 netmask is not required for IPv6"},
    "NSERR_MAX_VSEVRVER_BINDINGS_TO_SERVICE":{"errno":"0x1D1", "desc":"Maximum vservers bound to a service exceeded"},
    "NSERR_SACL6_CLEARPENDING":{"errno":"0x1D2", "desc":"Simple ACL6 Clear in progress"},
    "NSERR_SACL6_NAME_EXISTS":{"errno":"0x1D3", "desc":"Simple ACL6 with the same name exists"},
    "NSERR_SACL6_SUPERSET_EXISTS":{"errno":"0x1D4", "desc":"Operation not permitted. (An overlapping rule already exists)"},
    "NSERR_SACL6_SUBSET_EXISTS":{"errno":"0x1D5", "desc":"Operation not permitted. (A rule which is subset of this rule already exists)"},
    "NSERR_NO_BACKUP_VIP_BOUND":{"errno":"0x1D6", "desc":"No backupVserver bound"},
    "NSERR_SESSION_EXPIRED_REDIRECT":{"errno":"0x1D7", "desc":"Session expired, Please login again"},
    "NSERR_NOENT_VLAN":{"errno":"0x1D8", "desc":"Vlan does not exist"},
    "NSERR_MAX_SVC_ENTITY":{"errno":"0x1D9", "desc":"Maximum service limit reached"},
    "NSERR_CL_EXIST":{"errno":"0x1DA", "desc":"Resource already exists in cluster"},
    "NSERR_OWNERNODE_NOTALLOWED":{"errno":"0x1DB", "desc":"Can not specify owner node."},
    "NSERR_OWNERNODE_NOT_SPECIFIED":{"errno":"0x1DC", "desc":"Owner node is not specified."},
    "NSERR_NOT_SUPPINCLUSTER":{"errno":"0x1DD", "desc":"Operation not supported in Cluster."},
    "NSERR_VSERVER_TYPE_MISMATCH":{"errno":"0x1DE", "desc":"Vserver type mismatch."},
    "NSERR_ITER_END":{"errno":"0x1DF", "desc":"End of iteration reached."},
    "NSERR_CONNECT_TO_CLUSTER_IP":{"errno":"0x566", "desc":"Please connect to cluster IP and run showtechsupport on that node."},
    "NSERR_LB_AUDIT_IP_DENY":{"errno":"0x567", "desc":"Changing IP address of LB vserver not permitted when Audit server also referring to same server_info ."},
    "NSERR_IC_OFF_DISABLING_FEO":{"errno":"0x568", "desc":"IC is disabled, but FEO is enabled."},
    "NSERR_SYNC_VLAN_EXIST":{"errno":"0x569", "desc":"Please unset sync vlan, before removing the HA node."},
    "NSERR_CMDPROP_DISABLED":{"errno":"0x5AA", "desc":"Command propagation disabled."},
    "NSERR_NOTHEME":{"errno":"0x5AB", "desc":"Portal theme doesn't exist"},
    "NSERR_THEMEEXISTS":{"errno":"0x5AC", "desc":"Portal theme already exists"},
    "NSERR_THEME_INUSE":{"errno":"0x5AD", "desc":" Portal theme in use "},
    "NSERR_NO_CONTENT":{"errno":"0x5AE", "desc":"204 No Content"},
    "NSERR_ARP_IFACE_NODE_MISMATCH":{"errno":"0x5a0", "desc":"Interface and node mismatch"},
    "NSERR_HA_BOTH_PRIMARY":{"errno":"0x5a1", "desc":"Cannot failover as Node State set to STAYPRIMARY"},
    "NSERR_PROP_DISABLED":{"errno":"0x5a8", "desc":"Propagation disabled"},
    "NSERR_HA_FAILOVER_PERM":{"errno":"0x5a9", "desc":"Failover not permitted as one node is up and another node is down"},
    "NSERR_NOEULA":{"errno":"0x3AA", "desc":"Eula name doesn't exist"},
    "NSERR_EULAEXISTS":{"errno":"0x3AB", "desc":"Eula with same name already exists"},
    "NSERR_EULA_INUSE":{"errno":"0x3AC", "desc":" Eula name in use "},
    "NSERR_SYSLOG_TCP_CONFIG_ERR":{"errno":"0x5B3", "desc":"tcpProfileName/maxLogDataSizeToHold cannot be set when transport is UDP"},
    "NSERR_SYSLOG_LOOPBACK_OR_LOCAL_IP_NOTALLOWED":{"errno":"0x5B4", "desc":"TCP transport is not allowed for local logging(when serverIP is configured as Loopback IP or NetScaler's local IP)"},
    "NSERR_MAX_CONC_SAVECONFIG":{"errno":"0x5B5", "desc":"Maximum number of concurrent save configs are in progress. Try again later."},
    "NSERR_SYSLOG_LBMETHOD_NOTALLOWED":{"errno":"0x5B6", "desc":"LB method AUDITLOGHASH can be set only for service type SYSLOGTCP/SYSLOGUDP"},
    "NSERR_SYSLOG_PERSISTENCE_NOTSUPPORTED":{"errno":"0x5B7", "desc":"Persistency is not supported for SYSLOGTCP and SYSLOGUDP service types"},
    "NSERR_SYSLOG_HASHLBMETHODS_NOTALLOWED":{"errno":"0x5B8", "desc":"Hash based LB methods which depend on packet parameters cannot be set for SYSLOGTCP/SYSLOGUDP service types"},
    "NSERR_SYSLOG_LEASTCONN_NOTSUPPORTED":{"errno":"0x5BB", "desc":"LEASTCONNECTION algorithm is not supported for SYSLOGTCP/SYSLOGUDP service types"},
    "NSERR_SVC_EXISTS":{"errno":"0x5BC", "desc":"Service exists with this server information"},
    "NSERR_SYSLOG_NOLBVIP":{"errno":"0x5BD", "desc":"No such LB vserver of type SYSLOGUDP/SYSLOGTCP exists"},
    "NSERR_SYSLOG_LBPROTOCOL_NOTALLOWED":{"errno":"0x5BE", "desc":"LB vserver of type other than SYSLOGUDP/SYSLOGTCP cannot be set to syslogaction"},
    "NSERR_SYSLOG_TRANSPORT_UNSET_NOTALLOWED":{"errno":"0x5BF", "desc":"Transport cannot be unset when LB vserver name is configured"},
    "NSERR_SYSLOG_TRANSPORT_MISMATCH":{"errno":"0x5C0", "desc":"Mismatch in transport type of LB vserver and syslog action"},
    "NSERR_SYSLOG_LBVSRVR_INUSE_BY_SYSACT":{"errno":"0x5C1", "desc":"The LB vserver is being accessed by syslog action"},
    "NSERR_SYSLOG_LBVSRVR_RENAME_NOTSUPPORTED":{"errno":"0x5C2", "desc":"Renaming LB vserver is not supported for SYSLOGUDP/SYSLOGTCP service types"},
    "NSERR_SYSLOG_INVALID_SERVIP":{"errno":"0x5C3", "desc":"ServerIP cannot be configured as 0.0.0.0 or 0 for syslog action"},
    "NSERR_AUDITLOG_PORT_SET_UNSET_NOTALLOWED":{"errno":"0x5C4", "desc":"Port cannot be set/unset when LB vserver name/Server domain name is configured"},
    "NSERR_SYSLOG_TCPPROFILE_NOTALLOWED":{"errno":"0x5C5", "desc":"TCP profile name cannot be set when LB vserver name is configured"},
    "NSERR_SYSLOG_CANNOT_SET_LBVSNAME":{"errno":"0x5C6", "desc":"Unset the TCP profile name and then set the LB vserver name"},
    "NSERR_PORTALBINDING_NOT_SUPPORTED":{"errno":"0x5C7", "desc":"Operation not supported. Unset VPN uitheme parameter first and then try again."},
    "NSERR_PORTALTHEME_NAME_NOT_ALLOWED":{"errno":"0x5C8", "desc":"\'EULA\' and \'Custom\' keywords are reserved. Please try with any other name"},
    "NSERR_AUDIT_VERSION_MISMATCH":{"errno":"0x5C9", "desc":"Audit version mismatch"},
    "NSERR_RADIUS_LISTENER_PERM":{"errno":"0x5CA", "desc":"Operation not permitted on RADIUS LISTENER service"},
    "NSERR_SYSLOG_NETPROFILE_NOTALLOWED":{"errno":"0x5CB", "desc":"Network profile name cannot be set when LB vserver name is configured"},
    "NSERR_AUDITLOG_DMNRESOLVRETRY":{"errno":"0x5CC", "desc":"Domain resolve retry can be set only when server domain name is configured"},
    "NSERR_AUDITLOG_ARGUMENT_MISSING":{"errno":"0x5CD", "desc":"One of the arguments \"Server IP/Server domain name/LB vserver name\" is required for auditlog action"},
    "NSERR_AUDITLOG_DBS_SERVER_EXIST":{"errno":"0x5CE", "desc":"Auditlog internal DBS server with the same domain name exists"},
    "NSERR_ICAMODE_STATUS_NOT_OK":{"errno":"0x5CF", "desc":"vpn icamode status not okay"},
    "NSERR_SYSLOG_LBVSERVER_NOTALLOWED":{"errno":"0x5D0", "desc":"LB vserver name cannot be set when network profile is configured. Unset the netProfile and set LB vserver name"},
    "NSERR_INSTALL_FAILED":{"errno":"0x5D2", "desc":"Installation failed."},
    "NSERR_OSPFAREA_UNSET":{"errno":"0x5D3", "desc":"Unset of OSPFArea is allowed only for VIP and SNIP"},
    "NSERR_PREQ_HOSTROUTE":{"errno":"0x5D4", "desc":"Pre-requisite Hostroute is disabled"},
    "NSERR_PREQ_NETWORKROUTE":{"errno":"0x5D5", "desc":"Pre-requisite Networkroute is disabled"},
    "NSERR_AUDITLOG_SVC_EXISTS":{"errno":"0x5D8", "desc":"Auditlog service exists with this server information"},
    "NSERR_AUDITSINFO_EXISTS_WITH_SAME_DOMAINNAME":{"errno":"0x5D9", "desc":"Auditlog action exists with the same domain name"},
    "NSERR_NO_PERM_ON_PLATFORM":{"errno":"0x5DD", "desc":"operation not supported on this platform"},
    "NSERR_CLOUD_CRED":{"errno":"0x976", "desc":"Unable to connect to the cloud. Check credentials."},
    "NSERR_CLOUD_DNS":{"errno":"0x980", "desc":"Unable to connect to the cloud. DNS resolution failed."},
    "NSERR_CLOUD_IAM":{"errno":"0x981", "desc":"IAM validation failed"},
    "NSERR_SVC_GRP":{"errno":"0x73F", "desc":"Unable to discover Autoscale group/setting in cloud"},
    "NSERR_MISSING_POLICY":{"errno":"0x895", "desc":"Unable to discover scale down policy of Autoscale group/setting in cloud"},
}

NS_CACONF_ERRORS = {
    "NSERR_CACONF_CNFL_HEUREXP_RELEXP":{"errno":"0x1E0", "desc":"Conflicting arguments, heurExpiryParam and relExpiry"},
    "NSERR_CACONF_CNFL_HEUREXP_RELEXPMILI":{"errno":"0x1E1", "desc":"Conflicting arguments, heurExpiryParam and relExpiryMilliSec"},
    "NSERR_CACONF_CNFL_RELEXP_RELEXPMILI":{"errno":"0x1E2", "desc":"Conflicting arguments, relExpiry and relExpiryMiliSec"},
    "NSERR_CACONF_CNFL_ABSEXP_HEUREXP":{"errno":"0x1E3", "desc":"Conflicting arguments, absExpiry and heurExpiryParam"},
    "NSERR_CACONF_CNFL_ABSEXP_RELEXPMILI":{"errno":"0x1E4", "desc":"Conflicting arguments, absExpiry and relExpiryMilliSec"},
    "NSERR_CACONF_CNFL_ABSEXPGMT_HERUEXP":{"errno":"0x1E5", "desc":"Conflicting arguments, absExpiryGMT and heurExpiryParam"},
    "NSERR_CACONF_CNFL_ABSEXP_ABSEXPGMT":{"errno":"0x1E6", "desc":"Conflicting arguments, absExpiry and absExpiryGMT"},
    "NSERR_CACONF_CNFL_ABSEXPGMT_RELEXPMILI":{"errno":"0x1E7", "desc":"Conflicting arguments, absExpiryGMT and relExpiryMilliSec"},
    "NSERR_CACONF_CNFL_HITPARAMS_HITSLCTR":{"errno":"0x1E8", "desc":"Conflicting arguments, hitParams and hitSelector"},
    "NSERR_CACONF_CNFL_INVALPARAMS_HITSLCTR":{"errno":"0x1E9", "desc":"Conflicting arguments, invalParams and hitSelector"},
    "NSERR_CACONF_CNFL_HITPARAMS_INVLSLCTR":{"errno":"0x1EA", "desc":"Conflicting arguments, hitParams and invalSelector"},
    "NSERR_CACONF_CNFL_INVALPARAMS_INVLSLCTR":{"errno":"0x1EB", "desc":"Conflicting arguments, invalParams and invalSelector"},
    "NSERR_CACONF_CNFL_HITSLCTR_MATCHCOOKY":{"errno":"0x1EC", "desc":"Conflicting arguments, hitSelector and matchCookies"},
    "NSERR_CACONF_CNFL_HITSLCTR_INVALREST2HOST":{"errno":"0x1ED", "desc":"Conflicting arguments, hitSelector and invalRestrictedToHost"},
    "NSERR_CACONF_CNFL_HITSLCTR_IGNRPARAMVALCASE":{"errno":"0x1EE", "desc":"Conflicting arguments, hitSelector and ignoreParamValueCase"},
    "NSERR_CACONF_CNFL_INVALSLCTR_MATCHCOOKY":{"errno":"0x1EF", "desc":"Conflicting arguments, invalSelector and matchCookies"},
    "NSERR_CACONF_CNFL_INVALSLCTR_INVALREST2HOST":{"errno":"0x1F0", "desc":"Conflicting arguments, invalSelector and invalRestrictedToHost"},
    "NSERR_CACONF_CNFL_INVALSLCTR_IGNRPARAMVALCASE":{"errno":"0x1F1", "desc":"Conflicting arguments, invalSelector and ignoreParamValueCase"},
    "NSERR_CACONF_CNFL_POSRELEXP_RELEXP":{"errno":"0x1F2", "desc":"Conflicting arguments, weekPosRelExpiry and relExpiry"},
    "NSERR_CACONF_CNFL_POSRELEXP_RELEXPMILI":{"errno":"0x1F3", "desc":"Conflicting arguments, weekPosRelExpiry and relExpiryMiliSec"},
    "NSERR_CACONF_CNFL_ABSEXP_POSRELEXP":{"errno":"0x1F4", "desc":"Conflicting arguments, absExpiry and weekPosRelExpiry"},
    "NSERR_CACONF_CNFL_ABSEXPGMT_POSRELEXP":{"errno":"0x1F5", "desc":"Conflicting arguments, absExpiryGMT and weekPosRelExpiry"},
    "NSERR_CACONF_CNFL_IGNRPARAMVALCASE_HITPARAMS":{"errno":"0x1F6", "desc":"Invalid arguments, ignoreParamValueCase is set while hitParams is 0"},
    "NSERR_CACONF_CNFL_HIT_INVALPARAMS_MATCHCUKY":{"errno":"0x1F7", "desc":"Invalid arguments, matchCookies is set while both hitParams and invalParams are 0"},
    "NSERR_CACONF_CNFL_INVALREST2HOST_INVALPARAM":{"errno":"0x1F8", "desc":"Invalid arguments, invalRestrictedToHost is set while invalParams is 0"},
    "NSERR_CACONF_CNFL_PREFETCH_PREFETCHSEC":{"errno":"0x1F9", "desc":"Invalid arguments, prefetchPeriod is set while prefetch is disabled"},
    "NSERR_CACONF_CNFL_PREFETCH_PREFETCHMILI":{"errno":"0x1FA", "desc":"Invalid arguments, prefetchPeriodMilliSec is set while prefetch is disabled"},
    "NSERR_CACONF_CNFL_PREFETCHMILI_PREFETCHSEC":{"errno":"0x1FB", "desc":"Conflicting arguments, prefetchPeriodMilliSec and prefetchPeriod"},
    "NSERR_CACONF_ARG_LE_MIN_VAL":{"errno":"0x1FC", "desc":"Invalid arguments, given value is less than the minimum value "},
    "NSERR_CACONF_ARG_GE_MAX_VAL":{"errno":"0x1FD", "desc":"Invalid arguments, given value is more than the maximum value "},
    "NSERR_CACHEGROUP_NEGMINHIT":{"errno":"0x1FE", "desc":"ContentGroup cannot have negative minHit."},
    "NSERR_CACHEHA_OBJPERSIST_NOTSET":{"errno":"0x1FF", "desc":"Cache Object Sync to Secondary is not set, use set cache parameter to enable."},
}

NS_CR_ERRORS = {
    "NSERR_PXY_CACHE_HMG":{"errno":"0x200", "desc":"All caches in a content group should be of the same type"},
    "NSERR_PXY_RM_LAST_MEMT":{"errno":"0x201", "desc":"Cannot remove last map entry from the table; remove the map table instead"},
    "NSERR_CSW_INS_INVAL_PFX":{"errno":"0x202", "desc":"Invalid prefix specified in the URL"},
    "NSERR_PENG_EXPR_IVAL_NAME":{"errno":"0x203", "desc":"Invalid expression name"},
    "NSERR_CSW_BIG_URL":{"errno":"0x204", "desc":"URL specified is too long - maximum is 208, including . and *"},
    "NSERR_CSW_BIG_PFX":{"errno":"0x205", "desc":"Prefix specified is too long - maximum is 199, excluding *"},
    "NSERR_CSW_BIG_SFX":{"errno":"0x206", "desc":"Extension specified is too long, maximum is 8"},
    "NSERR_CSW_INVAL_SFX":{"errno":"0x207", "desc":"Extension is invalid"},
    "NSERR_EXPR_NOMETHOD":{"errno":"0x208", "desc":"Invalid method name"},
    "NSERR_EXPR_NOURLTOKENS":{"errno":"0x209", "desc":"Invalid HTTP URL tokens"},
    "NSERR_EXPR_NOVERSION":{"errno":"0x20A", "desc":"Invalid HTTP version"},
    "NSERR_EXPR_NOHDR":{"errno":"0x20B", "desc":"Invalid HTTP header"},
    "NSERR_EXPR_NOCACNTL":{"errno":"0x20C", "desc":"Invalid cache-control value"},
    "NSERR_EXPR_NOPRAG":{"errno":"0x20D", "desc":"Invalid pragma value"},
    "NSERR_EXPR_NOQUERY":{"errno":"0x20E", "desc":"Invalid query string"},
    "NSERR_EXPR_NOQUAL":{"errno":"0x20F", "desc":"Invalid qualifier"},
    "NSERR_ACTION_INUSE":{"errno":"0x210", "desc":"Action name is already in use"},
    "NSERR_ACTION_HDR_INVAL":{"errno":"0x211", "desc":"Invalid header"},
    "NSERR_URLQ_INVAL":{"errno":"0x212", "desc":""},
    "NSERR_UNDEF_ACTION":{"errno":"0x213", "desc":"Action directive or qualifier is not valid"},
    "NSERR_CPE_INUSE":{"errno":"0x214", "desc":"Policy name is already in use"},
    "NSERR_CPE_REQACT_INVAL":{"errno":"0x215", "desc":"Request action is not valid"},
    "NSERR_CPE_RSPACT_INVAL":{"errno":"0x216", "desc":"Response action is not valid"},
    "NSERR_CPE_REQRULE_INVAL":{"errno":"0x217", "desc":"Request rule is not valid"},
    "NSERR_CPE_RSPRULE_INVAL":{"errno":"0x218", "desc":"Response rule is not valid"},
    "NSERR_ACTION_DEFINVAL":{"errno":"0x219", "desc":"Default actions cannot be removed"},
    "NSERR_ACTION_NOTPRESENT":{"errno":"0x21A", "desc":"Action does not exist"},
    "NSERR_PXY_INVAL_SERVICETYPE":{"errno":"0x21B", "desc":"Invalid service type for virtual server"},
    "NSERR_CACHEPOLICY_INUSE":{"errno":"0x21C", "desc":"Caching policy name is already in use"},
    "NSERR_CACHEGROUP_INTERNAL":{"errno":"0x21F", "desc":"Built-in content groups cannot be removed"},
    "NSERR_CPE_INVAL":{"errno":"0x220", "desc":"Policy name is invalid"},
    "NSERR_EXPR_NOLEN":{"errno":"0x221", "desc":"URL length is not valid"},
    "NSERR_DNSWAIT":{"errno":"0x222", "desc":""},
    "NSERR_GW_TIMEOUT":{"errno":"0x223", "desc":""},
    "NSERR_CSWDMN_INUSE":{"errno":"0x224", "desc":"Domain is already hosted by another server"},
    "NSERR_CSWDMN_PLCY_EXIST":{"errno":"0x225", "desc":""},
    "NSERR_ACTION_NOMOD_HDR":{"errno":"0x226", "desc":"Action has missing argument"},
    "NSERR_EXPR_INVAL_OPERATOR":{"errno":"0x227", "desc":"Invalid operator for the qualifier"},
    "NSERR_EXPR_DEF_REM_INVAL":{"errno":"0x228", "desc":"Default expression cannot be removed"},
    "NSERR_EXPR_TOOMANY":{"errno":"0x229", "desc":"Expression limit reached"},
    "NSERR_ACTION_TOOMANY":{"errno":"0x22A", "desc":"Action limit reached"},
    "NSERR_CSWPOLICY_TOOMANY":{"errno":"0x22B", "desc":"CS policy limit reached"},
    "NSERR_CRDPOLICY_TOOMANY":{"errno":"0x22C", "desc":"CR policy limit reached"},
    "NSERR_MAPPOLICY_TOOMANY":{"errno":"0x22D", "desc":"Map policy limit reached"},
    "NSERR_FILTER_NOT_SUPPORT":{"errno":"0x22E", "desc":"Content Filtering is no longer supported; this feature flag will be removed on the next major release"},
    "NSERR_CACHEPOLICY_TOOMANY":{"errno":"0x22F", "desc":"Integrated cache policy limit reached"},
    "NSERR_CACHEGROUP_TOOMANY":{"errno":"0x230", "desc":"Integrated cache content group limit reached"},
    "NSERR_CACHEPARAM_MEMALLOC_FAILED":{"errno":"0x231", "desc":"Unable to allocate specified amount of memory"},
    "NSERR_CACHEGROUP_INUSE":{"errno":"0x232", "desc":"Content group name is already in use"},
    "NSERR_CACHEGROUP_EXPCONFLICT":{"errno":"0x233", "desc":"Expiry times conflict"},
    "NSERR_CACHEPARAM_INVAL":{"errno":"0x234", "desc":"Cache parameter is invalid"},
    "NSERR_CACHEGROUP_PARAM_INVAL":{"errno":"0x235", "desc":"Invalid invalidation parameter"},
    "NSERR_CACHEGROUP_QUERY_INVAL":{"errno":"0x236", "desc":"Invalid query string"},
    "NSERR_ACTION_INVAL":{"errno":"0x237", "desc":"Action name is invalid"},
    "NSERR_EXPR_DEF_SET_INVAL":{"errno":"0x238", "desc":"Default expression cannot be set"},
    "NSERR_CACHEGROUP_RESSZ_MIN_GT_MAX":{"errno":"0x239", "desc":"Minimum response size cannot exceed the maximum response size"},
    "NSERR_SVPN_CERT_CHALLENGE":{"errno":"0x23B", "desc":"Destination Server challenged for a client certificate"},
    "NSERR_CACHEGROUP_HOST_REQ":{"errno":"0x240", "desc":"Host required for a group with invalidation restricted to host"},
    "NSERR_CACHEGROUP_HOST_NREQ":{"errno":"0x241", "desc":"Host not required"},
    "NSERR_CACHEGROUP_DYNGRP_NEXP":{"errno":"0x242", "desc":"Cannot expire a parameterized content group"},
    "NSERR_CACHEGROUP_ONE_GRP_REQ":{"errno":"0x243", "desc":"Only one content group required"},
    "NSERR_CACHEGROUP_ONE_ALL_REQ":{"errno":"0x244", "desc":"ALL should be the only content group specified"},
    "NSERR_CACHEGROUP_MATCH_PARAM_INVAL":{"errno":"0x245", "desc":"Invalid request hit parameter"},
    "NSERR_CACHEGROUP_DYN_RES_CACHE":{"errno":"0x246", "desc":"Cannot specify a parameterized group with a response time CACHE action"},
    "NSERR_EXPR_INVAL_VALUE":{"errno":"0x247", "desc":"Invalid expression value"},
    "NSERR_CACHEGROUP_PREFETCH_CONFLICT":{"errno":"0x248", "desc":"Prefetch periods conflict"},
    "NSERR_CACHEGROUP_PREFETCH_ENABLE":{"errno":"0x249", "desc":"Enable prefetch to set prefetch period"},
    "NSERR_CACHEGROUP_CCH_UNKNOWN":{"errno":"0x24A", "desc":"Unknown cache-control header"},
    "NSERR_CACHEGROUP_RELEXP_X10MS":{"errno":"0x24B", "desc":"Relative expiry milliseconds must be multiples of 10"},
    "NSERR_CACHEGROUP_PREFETCH_X10MS":{"errno":"0x24C", "desc":"Prefetch period milliseconds must be multiples of 10"},
    "NSERR_CACHEGROUP_STATIC_TO_DYNAMIC":{"errno":"0x24D", "desc":" This content group cannot be made parameterized"},
    "NSERR_CLASSIC_POLICY_DEPRECATED":{"errno":"0x24E", "desc":"Classic policy expressions are deprecated - use Default (Advanced) policy expressions instead"},
    "NSERR_PLCY_DEF_REM_INVAL":{"errno":"0x24F", "desc":"Default policy cannot be removed"},
    "NSERR_CACHEGROUP_PREFETCH_REL_NREQ":{"errno":"0x250", "desc":"Relative expiry and prefetch period should both be seconds or milliseconds"},
    "NSERR_EXPR_SET_INVAL_FLOWTYPE":{"errno":"0x251", "desc":"Flow type cannot be changed"},
    "NSERR_EXPR_TOO_BIG":{"errno":"0x252", "desc":"Expression too long - maximum length is 1500, in fully-qualified form"},
    "NSERR_CPE_INVALID_IDRANGE":{"errno":"0x253", "desc":"Priority should be between 0 and 64000 (inclusive)"},
    "NSERR_EXPR_TOO_BIG_EXT":{"errno":"0x254", "desc":"Expression too long - maximum length is 800, in fully-qualified form"},
    "NSERR_CACHEGROUP_MATCHCOOKIE_DYN_REQ":{"errno":"0x255", "desc":"Match cookies argument allowed only with parameterized groups"},
    "NSERR_CACHEGROUP_MATCHCOOKIE_NREQ":{"errno":"0x256", "desc":"Cannot modify match cookies"},
    "NSERR_CACHEFWPXY_PRESENT":{"errno":"0x257", "desc":"Forward proxy is already present"},
    "NSERR_CACHE_PREFETCH_REEVAL_NREQ":{"errno":"0x258", "desc":"Cannot configure a content group to both prefetch and evaluate every miss"},
    "NSERR_CACHEFWPXY_TOOMANY":{"errno":"0x259", "desc":"Forward proxy limit reached"},
    "NSERR_CACHE_PET_FC_NREQ":{"errno":"0x25A", "desc":"Cannot enable both 'Poll Every Time' and 'Flash Cache'"},
    "NSERR_SAVECONFIG_IN_PROGRESS":{"errno":"0x25B", "desc":"Configuration is being saved, please try again later"},
    "NSERR_GWSUBNET_NOT_EXIST":{"errno":"0x25C", "desc":"The gateway is not directly reachable"},
    "NSERR_GW_REQ_SUBNET":{"errno":"0x25D", "desc":"An existing route relies on the presence of this subnet"},
    "NSERR_URLPOL_NO_PRI":{"errno":"0x25E", "desc":"Priority cannot be specified for URL-based content switching policy"},
    "NSERR_BAD_CR_ATTRIBS":{"errno":"0x25F", "desc":"Bad cache redirection VIP attributes given"},
    "NSERR_MAC_NOT_SUPPORTED":{"errno":"0x260", "desc":"MAC redirection not supported"},
    "NSERR_POLICY_NOT_SUPPORTED":{"errno":"0x261", "desc":"Policy redirection not supported with NNTP"},
    "NSERR_CACHEABILITY_NOT_SUPPORTED":{"errno":"0x262", "desc":"Cannot set cacheability on cache"},
    "NSERR_HOST_RT_NOT_ALLOWED":{"errno":"0x263", "desc":"Host route advertisement not permitted for this IP"},
    "NSERR_ROUTING_NOT_ALLOWED":{"errno":"0x264", "desc":"Routing protocols can run only on SNIP's or NSIP"},
    "NSERR_CONFIG_NOTSAVED":{"errno":"0x265", "desc":"Configuration is not saved"},
    "NSERR_DIS_ROUTING_NSIP":{"errno":"0x266", "desc":"Cannot disable dynamic routing on NSIP"},
    "NSERR_NETWORK_RT_NOT_ALLOWED":{"errno":"0x267", "desc":"Network route advertisement not permitted on this IP"},
    "NSERR_NR_ENABLE":{"errno":"0x268", "desc":"networkRoute can be enabled only for one IP per subnet"},
    "NSERR_EXPRMISMATCH":{"errno":"0x270", "desc":""},
    "NSERR_NO_HOST":{"errno":"0x273", "desc":"No host header and default not set"},
    "NSERR_NO_DFLT":{"errno":"0x274", "desc":"Host header present, no match, and default not set"},
    "NSERR_DFLTDMN_FIRST":{"errno":"0x275", "desc":"No default domain translation entry"},
    "NSERR_PXY_CONF_LOOP":{"errno":"0x276", "desc":"Source and target domains cannot be the same"},
    "NSERR_PXY_ME_DUP":{"errno":"0x278", "desc":"Duplicate map entry"},
    "NSERR_PXY_IVAL_TGT":{"errno":"0x279", "desc":"Target is invalid during map entry addition"},
    "NSERR_CONNECTED":{"errno":"0x27A", "desc":"Proxy connection established"},
    "NSERR_AUTHENTICATE":{"errno":"0x27B", "desc":"Authentication required"},
    "NSERR_LARGE_DOMAIN":{"errno":"0x27C", "desc":"Domain length overflow"},
    "NSERR_PXY_IVAL_URL":{"errno":"0x280", "desc":"Source/destination URL or the combination is not valid"},
    "NSERR_PXY_ME_USE":{"errno":"0x281", "desc":"Map entry is already in use"},
    "NSERR_PXY_MT_TYPE":{"errno":"0x282", "desc":"Map entries in a table should be homogeneous"},
    "NSERR_PXY_MT_USE":{"errno":"0x283", "desc":"Map table is in use"},
    "NSERR_PXY_MB_INVAL":{"errno":"0x284", "desc":"Invalid map bind operation"},
    "NSERR_PXY_MB_USE":{"errno":"0x285", "desc":"You can bind only one table to a vserver"},
    "NSERR_PXY_SETDCDN":{"errno":"0x286", "desc":"Invalid DCDN configuration"},
    "NSERR_PXY_SETDFLT":{"errno":"0x287", "desc":"Invalid default domain specification"},
    "NSERR_PXY_DFLT_NOTSET":{"errno":"0x288", "desc":"Removing default without setting it"},
    "NSERR_PXY_FWD_IVAL":{"errno":"0x289", "desc":"Invalid FWD PXY map entry"},
    "NSERR_PXY_MTX_PROT":{"errno":"0x290", "desc":"PXY and cache protocol should be the same"},
    "NSERR_PXY_MTX_TRA":{"errno":"0x291", "desc":"Invalid cache type on service"},
    "NSERR_PXY_MTX_FWD":{"errno":"0x292", "desc":"Forward Pxy matrix"},
    "NSERR_PXY_MTX_REV":{"errno":"0x293", "desc":"Reverse Pxy Matrix"},
    "NSERR_PXY_ADD_TRA_NONHTTP":{"errno":"0x294", "desc":"transparent non-HTTP policy is invalid"},
    "NSERR_PXY_ADD_TRA_OTHER":{"errno":"0x295", "desc":"transparent non-HTTP map/via should not be specified"},
    "NSERR_PXY_OPT_INVAL":{"errno":"0x296", "desc":"ARP/ghost options invalid for REV/FWD proxy"},
    "NSERR_PXY_ADD_SVR_OTHER":{"errno":"0x297", "desc":"Simple content based no proxy attribs"},
    "NSERR_PXY_MB_DUP":{"errno":"0x298", "desc":"Bind entry already exists"},
    "NSERR_PXY_DFLT_DUP":{"errno":"0x299", "desc":"Default already exists"},
    "NSERR_SEL_INUSE":{"errno":"0x2a0", "desc":"Selector already exists"},
    "NSERR_SEL_PARSE_FAILED":{"errno":"0x2a1", "desc":"Error in selector expression syntax"},
    "NSERR_NOSELECTOR":{"errno":"0x2a2", "desc":"No such selector"},
    "NSERR_SEL_TOOMANY":{"errno":"0x2a3", "desc":"Selector limit reached"},
    "NSERR_CACHEGROUP_NOSELPARAM":{"errno":"0x2a5", "desc":"Cannot change param-based content group to selector-based (or vice-versa)"},
    "NSERR_NOCACHEGROUP":{"errno":"0x2a6", "desc":"Content group does not exist"},
    "NSERR_NONREQ_SEL":{"errno":"0x2a7", "desc":"Selector expression is not request based"},
    "NSERR_INVALARG":{"errno":"0x2a8", "desc":"The action qualifier and the specified argument(s) do not match"},
    "NSERR_NOWILD_ALLOWED":{"errno":"0x2a9", "desc":"Wildcard not allowed with BETWEEN operator"},
    "NSERR_DATE_INCOMPAT":{"errno":"0x2aa", "desc":"Time arguments incompatible"},
    "NSERR_TIMEDATE_INVALID":{"errno":"0x2ab", "desc":"Date/time value invalid"},
    "NSERR_CONTENTGROUP_COOKIE_REQ_PARAM":{"errno":"0x2ac", "desc":"Hit parameters or inval parameters needed to enable cookie matching"},
    "NSERR_CONTENTGROUP_IGNORECASE_REQ_HITPARAM":{"errno":"0x2ad", "desc":"Hit parameters needed to enable case-insensitive param value matching"},
    "NSERR_CONTENTGROUP_INVALPARAM_REQ":{"errno":"0x2ae", "desc":"Inval parameters needed to enable host-based invalidation"},
    "NSERR_CLISEC_EXP_TOO_LONG":{"errno":"0x2af", "desc":"Client security expression too long"},
    "NSERR_NONHTTP_CSW_BIND_HTTP_SSL_POLICY":{"errno":"0x2b0", "desc":"HTTP/SSL protocol based policies can be bound only to HTTP/SSL CS vserver"},
    "NSERR_NONHTTP_CSW_BIND_DOMAIN_POLICY":{"errno":"0x2b1", "desc":"Domain based policies can be bound only to HTTP/SSL CS vserver"},
    "NSERR_NONHTTP_CSW_BIND_URL_POLICY":{"errno":"0x2b2", "desc":"URL based policies can be bound only to HTTP/SSL CS vserver"},
    "NSERR_POLBOUNDTO_TOO_MANY_VSVRS":{"errno":"0x2b3", "desc":"Domain cannot be set - policy bound to more than one vserver."},
    "NSERR_PI_CSW_URL_DOMAIN":{"errno":"0x2b4", "desc":"Domain/URL options disallowed along with advanced expressions"},
    "NSERR_PI_TO_PE_CSW":{"errno":"0x2b5", "desc":"Advanced expressions based  policies cannot be bound to a classic CS vserver."},
    "NSERR_PE_TO_PI_CSW":{"errno":"0x2b6", "desc":"Classic expression policies cannot be bound to a advanced CS vserver."},
    "NSERR_PRIORITY_COMP_PI_CSW":{"errno":"0x2b7", "desc":"Priority is mandatory for advanced expressions."},
    "NSERR_PI_TCPCSW":{"errno":"0x2b8", "desc":"Advanced expressions can not be bound to non-HTTP CS Vserver."},
    "NSERR_PE_GOTO":{"errno":"0x2b9", "desc":"Priority Jump expression cannot be bound with a classic expression based policy."},
    "NSERR_PI_TO_PE_POL_CSW":{"errno":"0x2ba", "desc":"Advanced expression based policy cannot be converted to a classic expression based policy and vice versa."},
    "NSERR_CACHEOBJECT_EVICT":{"errno":"0x2bb", "desc":"Cached object removed on expiry."},
    "NSERR_DNSFAIL":{"errno":"0x2bc", "desc":"DNS request failed"},
    "NSERR_HC_RET_TYPE_CHANGE":{"errno":"0x2bd", "desc":"Cannot change http callout return type."},
    "NSERR_HC_NOT_HTTP_VS":{"errno":"0x2be", "desc":"Not a HTTP or SSL vserver."},
    "NSERR_HC_REQ_CONFIG_XOR":{"errno":"0x2bf", "desc":"Full request expression and other request attributes cannot be set at the same time."},
    "NSERR_HC_SERVICE_CONFIG_XOR":{"errno":"0x2c0", "desc":"<ip, port> and vserver cannot be set at the same time."},
    "NSERR_HC_RET_TYPE_REQD":{"errno":"0x2c1", "desc":"Return type needs to be configured first."},
    "NSERR_RTSP_CSW_BIND_IP_POLICY":{"errno":"0x2c2", "desc":"Only IP based policies can be bound to RTSP CS vserver"},
    "NSERR_CSW_BIND_INCOMPAT_TGT":{"errno":"0x2c3", "desc":"The target vserver is not compatible with the CS verver."},
    "NSERR_CSW_BIND_INCOMPAT_CSPL":{"errno":"0x2d5", "desc":"The target vserver is not compatible with the CS policylabel."},
    "NSERR_AS_BAD_XMLNAMESPACE_PREFIX":{"errno":"0x2c4", "desc":"Invalid XML-Namespace prefix."},
    "NSERR_INVALID_SIP_EXPR":{"errno":"0x2c5", "desc":"The SourceIP Expression specified is invalid."},
    "NSERR_NO_BACKENDVSERVER":{"errno":"0x2c6", "desc":"No backend LB vserver found."},
    "NSERR_CONTENT_GROUP_TOOMANY":{"errno":"0x2c7", "desc":"ContentGroup limit reached"},
    "NSERR_CACHE_MEM_SIZE_CHANGED":{"errno":"0x2c8", "desc":"To use new Integrated Cache memory limit, save the configuration and restart the NetScaler."},
    "NSERR_CACHE_MEM_SIZE_ZERO":{"errno":"0x2c9", "desc":"No memory limit is configured for Integrated Cache. Use set cache parameter command to set the memory limit."},
    "NSERR_L2CONN_NOT_ALLOWED":{"errno":"0x2ca", "desc":"l2conn feature is supported only for ncore."},
    "NSERR_SQL_NOT_ALLOWED":{"errno":"0x2cb", "desc":"Database feature is supported only on nCore"},
    "NSERR_IPSEC_NOT_ALLOWED":{"errno":"0x2cc", "desc":"IPSec feature is not supported"},
    "NSERR_HTMLPAGE_NOT_ALLOWED":{"errno":"0x2cd", "desc":"Respondwith/sqlresponse_ok/sqlresponse_error actions cannot be set to respondwithhtmlpage action, and vice versa."},
    "NSERR_PE_NOT_ALLOWED_DB":{"errno":"0x2ce", "desc":"PE expressions are not allowed for DataStream."},
    "NSERR_CSW_NO_POLICY_NAME":{"errno":"0x2cf", "desc":"Policy name is required with priority."},
    "NSERR_SQL_MSG_EXCEED":{"errno":"0x2d0", "desc":"Message length should be smaller than 512"},
    "NSERR_CSW_CLASSIC_APPFW_POL":{"errno":"0x2d1", "desc":"Binding classic appfw policy to CS vserver is not supported."},
    "NSERR_ROUTING_STRIPED_SNIP":{"errno":"0x2d2", "desc":"Routing protocols can run only on a spotted SNIP in a cluster"},
    "NSERR_USERNAME_MISSING":{"errno":"0x2d3", "desc":"UserName argument Missing"},
    "NSERR_ACTION_EXIST":{"errno":"0x2d4", "desc":"Default Action for this type already exist."},
    "NSERR_WRONG_SERVICENAME":{"errno":"0x2d6", "desc":"Use corresponding 'gslb service' command."},
    "NSERR_PE_NOT_ALLOWED_RULE":{"errno":"0x2d7", "desc":"PE expressions are not allowed for RULE based persistence"},
    "NSERR_NODE_NOT_IN_CLUSTER":{"errno":"0x2d8", "desc":"Node is not in the cluster"},
    "NSERR_MCMX_CNRES":{"errno":"0x2d9", "desc":"Error in communication with other cores"},
    "NSERR_HC_POST_REQ_CONFIG_XOR":{"errno":"0x2da", "desc":"Parameters and body cannot be set at the same time for the POST method"},
    "NSERR_HC_CACGRP":{"errno":"0x2db", "desc":"Operation on 'calloutContentGroup' content group not permitted"},
    "NSERR_CSW_BIND_INCOMPAT_BKUP":{"errno":"0x2dc", "desc":"The backup vserver of the target vserver is not compatible with the CS vserver."},
    "NSERR_CACHE_MEM_RESIZE_IN_PROGRESS":{"errno":"0x2dd", "desc":"Integrated Cache memory resize is in progress. Please wait a few seconds."},
    "NSERR_CACHE_MEM_RESIZE_FAILED":{"errno":"0x2de", "desc":"Integrated Cache memory resize failed."},
    "NSERR_CSW_BIND_INCOMPAT_TARGET":{"errno":"0x2df", "desc":"The target vserver has to be an LB vserver."},
    "NSERR_ATTRIB_MEM_FREED":{"errno":"0x2e0", "desc":"ATTRIB memory already freed"},
    "NSERR_RULE_MISSING":{"errno":"0x2e1", "desc":"EvalRule argument Missing"},
    "NSERR_CACHEGROUP_CCH_MAXAGE_MAX":{"errno":"0x2e2", "desc":"max-age value cannot be greater than 2147483647"},
    "NSERR_CACHE_MEM_REDUCTION_NOT_ALLOWED":{"errno":"0x2e3", "desc":"Integrated Cache memory limit cannot be reduced."},
    "NSERR_CSW_POL_INCOMPAT_LB":{"errno":"0x2e4", "desc":"The target vserver is not compatible with the CS policy expression."},
    "NSERR_CS_INVALBACKUP":{"errno":"0x2e5", "desc":"Content-Switching or Cache-Redirection vservers cannot be used as a backupvserver."},
    "NSERR_CACHE_MEM_LIMIT_EXCEEDING":{"errno":"0x2e6", "desc":"The IC memory configured for all the admin partitions that are defined on the appliance, must be limited to the IC memory that is configured on the default partition."},
    "NSERR_PI_TO_PE_CRD":{"errno":"0x2e7", "desc":"Advanced expressions based  policies cannot be bound to a classic CR vserver."},
    "NSERR_PE_TO_PI_CRD":{"errno":"0x2e8", "desc":"Classic expression policies cannot be bound to a advanced CR vserver."},
    "NSERR_INVAL_ARG_CRPL_LBVS":{"errno":"0x2e9", "desc":"LB vserver cannot be bound to the CR vserver along with a CR policy."},
    "NSERR_CRPEPOLICY_SETNOACTION":{"errno":"0x2ea", "desc":"Cache-Redirection classic policy does not support action"},
    "NSERR_CACHE_MEM_LIMIT_NOT_CONFIGURED":{"errno":"0x2eb", "desc":"Set the IC memory on the default partition before setting the IC memory for an admin partition."},
    "NSERR_INVALID_BIND_PIPOL_CS":{"errno":"0x2ec", "desc":"The Advanced Policy cannot be bound to a CS vserver"},
    "NSERR_INVALID_BIND_PIPOL_CR":{"errno":"0x2ed", "desc":"The Advanced Policy cannot be bound to a CR vserver"},
    "NSERR_MEDIAC_MEMORY_ALLOC_FAILED":{"errno":"0x2ee", "desc":"Memory allocation for media classification failed"},
    "NSERR_CRD_CLASSIC_APPFW_POL":{"errno":"0x2ef", "desc":"Binding classic appfw policy to CR vserver is not supported."},
    "NSERR_CSPOL_VPN_BIND":{"errno":"0x2f4", "desc":"Invalid bind, VPN vserver is already set as a target Vserver on a CS action."},
    "NSERR_CSACT_VPN":{"errno":"0x2f5", "desc":"VPN vserver cannot be set as a target Vserver since CS policies are bound to it."},
    "NSERR_CSPOL_ACT_VPN":{"errno":"0x2f7", "desc":"CS policy cannot be bound to the vserver.CS action must be a LB vserver."},
    "NSERR_VPNSERVER_NOTEXIST":{"errno":"0x2f8", "desc":"The VPN Vserver does not exist"},
    "NSERR_VPNREFERRED_IN_CSBINDING":{"errno":"0x2f9", "desc":"Cannot remove VPN Vserver which is referred in CS policy bindings."},
    "NSERR_DEFAULTVPN_NOT_BOUND":{"errno":"0x2fa", "desc":"Default VPN mentioned is not bound "},
    "NSERR_HDXINVAL":{"errno":"0x2fb", "desc":"HDX servicetype cannot have WildCard IP and Port  or 0 IP."},
    "NSERR_CSW_ACTION_INCOMPTIBLE":{"errno":"0x2fc", "desc":"Incompatible Content Switching action provided. During set operation the old and the new action should have compatible fields. eg, target LB vserver to target LB vserver. "},
}

NS_DSK_CACHE_ERRORS = {
    "NSERR_IC_CACHE_NOT_ENB":{"errno":"0x2f0", "desc":"FEO enabled but IC needs to be enabled for most FEO features to work."},
    "NSERR_DISK_ENGG_NOT_RUNNING":{"errno":"0x2f1", "desc":"Disk Engine is not running, Save the config and reboot."},
    "NSERR_DISK_ENGG_DISABLED":{"errno":"0x2f2", "desc":"To take Disk Engine down, Save the config and reboot."},
    "NSERR_IC_DISK_CACHE_PARAM_NOT_SET":{"errno":"0x2f3", "desc":"Disk Cache not enabled. Set -enableDiskCache parameter to YES."},
}

NS_0x300_ERRORS = {
    "NSERR_RNAT_INV":{"errno":"0x301", "desc":"Reverse NAT not applicable for default route."},
    "NSERR_INVALID_IF":{"errno":"0x302", "desc":"Invalid interface name/number."},
    "NSERR_MGRLIMIT_REACHED":{"errno":"0x303", "desc":"Maximum manager limit reached."},
    "NSERR_SP_INVALD_TABLE":{"errno":"0x304", "desc":"SP table entries should be in increasing order."},
    "NSERR_RNAT_NATIP_EXISTS":{"errno":"0x305", "desc":"RNAT to the target network with specified NAT IP already exists."},
    "NSERR_RNAT_EXISTS":{"errno":"0x306", "desc":"RNAT to the target network already exists."},
    "NSERR_RNAT_NOT_EXISTS":{"errno":"0x307", "desc":"RNAT to the target network does not exist."},
    "NSERR_RNAT_NATIP_NOT_EXISTS":{"errno":"0x308", "desc":"RNAT to the target network with specified NAT IP doesn't exist."},
    "NSERR_RNAT_INVALID_NATIP":{"errno":"0x309", "desc":"NAT IP is not valid."},
    "NSERR_RNAT_XACLWITHTTL":{"errno":"0x30a", "desc":"Acl with ttl can not be used in NAT64/RNAT/RNAT6/ForwardingSession/LSN rule."},
    "NSERR_ARP_DISABLED":{"errno":"0x310", "desc":"IP has arp disabled."},
    "NSERR_ARP_SEC_NOT_OWNEDIP":{"errno":"0x311", "desc":"Secondary can not arp for this IP."},
    "NSERR_CPE_RULE_INVAL":{"errno":"0x312", "desc":"Invalid rule."},
    "NSERR_INVAL_FLOWTYPE":{"errno":"0x313", "desc":"Only authorization, audit, VPN session and traffic policies can be bound to aaa user or group."},
    "NSERR_INVAL_POLICY_TYPE":{"errno":"0x314", "desc":"Response rule is invalid in an authorization policy."},
    "NSERR_CPE_RULE_ACTION_INVAL":{"errno":"0x315", "desc":"Request action is valid only for request rule."},
    "NSERR_CPE_DEF_SET_INVAL":{"errno":"0x316", "desc":"Default policy cannot be set."},
    "NSERR_INVAL_FORCECLEANUP":{"errno":"0x317", "desc":"Invalid forcecleanup value."},
    "NSERR_INVAL_AAA_GROUP":{"errno":"0x318", "desc":"Invalid authorizationgroup value."},
    "NSERR_INVAL_PROXY":{"errno":"0x319", "desc":"Invalid allprotocolproxy value."},
    "NSERR_INVAL_HTTTPPROXY":{"errno":"0x320", "desc":"Invalid HTTP proxy value."},
    "NSERR_INVAL_FTPPROXY":{"errno":"0x321", "desc":"Invalid FTP proxy value."},
    "NSERR_INVAL_SOCKPROXY":{"errno":"0x322", "desc":"Invalid SOCKS proxy value."},
    "NSERR_INVAL_GOPHERPROXY":{"errno":"0x323", "desc":"Invalid GOPHER proxy value."},
    "NSERR_INVAL_SSLPROXY":{"errno":"0x324", "desc":"Invalid SSL proxy value."},
    "NSERR_INVAL_AAAGRP_MAX":{"errno":"0x325", "desc":"Max 5 groups can be specified in authorizationgroup."},
    "NSERR_INVAL_MAX_PORT_NUM":{"errno":"0x326", "desc":"Maximum 16 ports can be specified in httpport."},
    "NSERR_INVAL_HTTPPORT":{"errno":"0x327", "desc":"Invalid port."},
    "NSERR_INVAL_VPNVSERER_POLTYPE":{"errno":"0x328", "desc":"Only authentication and traffic policies can be bound to a VPN vserver."},
    "NSERR_INVAL_VPNGLOBAL_POLTYPE":{"errno":"0x329", "desc":"Only authentication and traffic policies can be bound to VPN global."},
    "NSERR_CPE_REM_INUSE":{"errno":"0x32a", "desc":"Bound policy cannot be removed."},
    "NSERR_PROXY_CONFLICT":{"errno":"0x32b", "desc":"Proxy server for all protocols already configured."},
    "NSERR_PROXY_INVAL":{"errno":"0x32c", "desc":"Domain names allowed only if proxy type is browser"},
    "NSERR_PXYEXCPT_INVAL":{"errno":"0x32d", "desc":"Proxy exception allowed only if proxy type is browser"},
    "NSERR_CPE_POLTYPE_NO_CSE":{"errno":"0x32e", "desc":"Policy type does not support client security expressions in rule"},
    "NSERR_SESSACT_CSE_INCOMPATIBLE":{"errno":"0x32f", "desc":"Session action and rule are incompatible"},
    "NSERR_NOMEM_CSE":{"errno":"0x330", "desc":"Not enough memory while adding client security expressions"},
    "NSERR_INCOMPAT_FS_RULE":{"errno":"0x331", "desc":"File system expressions supported in authorization policy only"},
    "NSERR_INCOMPAT_FS_MIX":{"errno":"0x332", "desc":"Incompatible expressions mixed with file system expressions in rule"},
    "NSERR_DR_ENABLE":{"errno":"0x333", "desc":"Dynamic routing can be enabled on only one IP per subnet"},
    "NSERR_MAX_DISTANCE":{"errno":"0x334", "desc":"Only null interface routes can have distance equal to 255"},
    "NSERR_NULL_ROUTE_DISTANCE":{"errno":"0x335", "desc":"It is not possible to set the administrative distance/cost metric for a null interface route"},
    "NSERR_BAD_ACTION_TCP_PROFILE_TYPE":{"errno":"0x336", "desc":"TCP profile cannot be set to this service type"},
    "NSERR_BAD_ACTION_HTTP_PROFILE_TYPE":{"errno":"0x337", "desc":"HTTP profile cannot be set to this service type"},
    "NSERR_SP_INVALID_THRESHOLD":{"errno":"0x338", "desc":"Invalid base threshold value"},
    "NSERR_VIP_ROUTE_EXISTS":{"errno":"0x339", "desc":"VIP exists for this host route"},
    "NSERR_ACTION_BOUND":{"errno":"0x340", "desc":"Action bound to policy can not be deleted."},
    "NSERR_MAX_IPLIMIT":{"errno":"0x341", "desc":"Maximum limit for bound IP to this resource record reached, remaining IP's destined for this resource record will be discarded."},
    "NSERR_BAD_PREFIX_LEN":{"errno":"0x33a", "desc":"Invalid rnat/lsn network prefix len it must be 0-128"},
    "NSERR_INV_NETADDR":{"errno":"0x33b", "desc":"Invalid IPv6 network address"},
    "NSERR_MIN_DISTANCE":{"errno":"0x33c", "desc":"Static route cannot have distance less than 1"},
    "NSERR_IPSEC_PROFILE_INUSE":{"errno":"0x33d", "desc":"Profile is in use by an ip tunnel."},
    "NSERR_IPSEC_INVALID_PROFILE_NAME":{"errno":"0x33e", "desc":"Invalid profile name."},
    "NSERR_SPOTTED":{"errno":"0x33f", "desc":"Spotted IP cannot be used here"},
    "NSERR_IPSEC_PBR_ONLY_IP_SUPPORTED":{"errno":"0x342", "desc":"Only IP range is supported"},
    "NSERR_IPSEC_IP_NOT_CONTIGUOUS":{"errno":"0x343", "desc":"Invalid IP range. The IP range does not cover all the IP's for a given subnet mask"},
    "NSERR_INVAL_USER_ACCOUNTING":{"errno":"0x344", "desc":"Invalid userAccounting value.  userAccounting value must be a radiusPolicy."},
    "NSERR_RDP_PROFILE_INUSE":{"errno":"0x345", "desc":"Profile is in use."},
    "NSERR_RDP_INVALID_PROFILE_NAME":{"errno":"0x346", "desc":"Invalid profile name."},
    "NSERR_RDP_INVALID_RDP_FILE_NAME":{"errno":"0x347", "desc":"RDP file name should have .rdp extension and some special characters for RDP file name are not supported."},
    "NSERR_RDP_INVALID_SERVERPROFILE_NAME":{"errno":"0x348", "desc":"Invalid server profile name."},
    "NSERR_RDP_SERVERPROFILE_ALREADY_IN_USE":{"errno":"0x349", "desc":"Server profile is already in use."},
    "NSERR_AUTO_PROXY_URL_INVALID":{"errno":"0x34a", "desc":"Invalid Autoproxy URL"},
    "NSERR_AUTO_PROXY_NO_BROWSER":{"errno":"0x34b", "desc":"Autoproxy URL is allowed only if proxy type is Browser."},
    "NSERR_AUTO_PROXY_CONFLICT":{"errno":"0x34c", "desc":"Both Autoproxy URL and manual proxy parameters (allprotocolproxy, http proxy, ftp proxy, proxy exception list, ...) cannot be configured at same time."},
    "NSERR_RDP_INVALID_HOST_LEN":{"errno":"0x350", "desc":"Invalid Host length. Atleast 3 characters expected"},
    "NSERR_RDP_NEED_IP":{"errno":"0x351", "desc":"RDP IP is needed"},
    "NSERR_IPSEC_INV_PROF":{"errno":"0x352", "desc":"For IPSEC tunnels, profile name cannot be 'none'"},
    "NSERR_RDP_NEED_PSK":{"errno":"0x356", "desc":"PSK is needed"},
    "NSERR_IPSEC_ONLY_V1":{"errno":"0x35a", "desc":"Responder Only config is supported with IKEv1"},
    "NSERR_RDP_LISTENER_SPECIFY_PORT":{"errno":"0x35b", "desc":"Invalid Listener. Specify Port"},
    "NSERR_RDP_INVALID_LISTENER_HOST":{"errno":"0x35c", "desc":"Invalid Listener. Specify valid host, atleast 3 characters expected"},
    "NSERR_RDP_LISTENER_INVALID_PORT":{"errno":"0x35d", "desc":"Invalid Listener. Specify valid Port"},
    "NSERR_PROXY_NOT_ALLOWED":{"errno":"0x35e", "desc":"Proxy feature not licensed"},
}

NS_ACL_ERRORS = {
    "NSERR_ACL_NOT_EXISTS":{"errno":"0x360", "desc":"ACL rule does not exist"},
    "NSERR_ACL_EXISTS":{"errno":"0x361", "desc":"IP address has existing ACL rule"},
    "NSERR_ACLPIP_WOSRCDST":{"errno":"0x362", "desc":"Peer IP can't be given without src/dst flag"},
    "NSERR_ACL_SAMEIP_PIP":{"errno":"0x363", "desc":"IP address and peer IP can't be same"},
    "NSERR_ACL_INVAL_PEERIP":{"errno":"0x364", "desc":"Invalid peer IP"},
    "NSERR_ACL_IPPIP_EXISTS":{"errno":"0x365", "desc":"ACL with identical parameter specification already exists"},
    "NSERR_XACLDELERROR":{"errno":"0x366", "desc":"ACL has already been removed"},
    "NSERR_XACLADDERROR":{"errno":"0x367", "desc":"Src/DstPort or RedirectPort can be specified only if protocol is TCP (6) or UDP (17)"},
    "NSERR_XACL_PRIORITY_EXISTS":{"errno":"0x368", "desc":"ACL with this priority already exists"},
    "NSERR_XACL_ICMP_REQD":{"errno":"0x369", "desc":"ICMP type / code can be specified only if protocol is ICMP(1)"},
    "NSERR_NOLOOPBACK":{"errno":"0x36a", "desc":"ACL cannot be configured on the loopback interface"},
    "NSERR_INVICMPTYPE":{"errno":"0x36b", "desc":"Invalid ICMP type"},
    "NSERR_INVICMPCODE":{"errno":"0x36c", "desc":"Invalid ICMP code"},
    "NSERR_XACLRNATDEL":{"errno":"0x36d", "desc":"ACL is bounded to RNAT/LSN,cannot be removed"},
    "NSERR_XACLMODCFGINFO":{"errno":"0x36e", "desc":"ACL modified, apply ACLs to activate change"},
    "NSERR_XACLFWDSESSIONDEL":{"errno":"0x36f", "desc":"ACL is bounded to FORWARDSESSION,cannot be removed"},
}

NS_PBR6_ERRORS = {
    "NSERR_PBR6_IPPIP_EXISTS":{"errno":"0x370", "desc":"PBR6 with identical parameter specification already exists"},
    "NSERR_PBR6_DELERROR":{"errno":"0x371", "desc":"PBR6 has already been removed"},
    "NSERR_PBR6_ADDERROR":{"errno":"0x372", "desc":"Port can be specified only if protocol is TCP (6) or UDP (17)"},
    "NSERR_PBR6_PRIORITY_EXISTS":{"errno":"0x373", "desc":"PBR6 with this priority already exists"},
    "NSERR_PBR6_ICMP_REQD":{"errno":"0x374", "desc":"ICMPv6 type/code can be specified only if protocol is ICMPv6 (1)"},
    "NSERR_PBR6_UNSPECADDR":{"errno":"0x375", "desc":"unspecified address (::) can not be configured in PBR6"},
    "NSERR_PBR6_MODCFGINFO":{"errno":"0x376", "desc":"PBR6 modified, apply pbr6 to activate change"},
    "NSERR_PBR6_PREFIXLEN":{"errno":"0x377", "desc":"Prefix length should not be configured in PBR6. (Use range instead)"},
    "NSERR_PBR6_SPECIFY_NEXTHOPVLAN":{"errno":"0x378", "desc":"Nexthop VLAN should be specified with Link local gateway address"},
    "NSERR_PBR6_INVALID_GATEWAY":{"errno":"0x379", "desc":"Invalid PBR6 Gateway"},
    "NSERR_PBR6_INVALID_NEXTHOP_VLAN":{"errno":"0x37a", "desc":"Invalid Nexthop VLAN ID"},
    "NSERR_PBR6_MAX_RULE_EXCEEDED":{"errno":"0x37b", "desc":"Number of PBR6s on the system exceeds Maximum"},
}

NS_ACL6_ERRORS = {
    "NSERR_ACL6_IPPIP_EXISTS":{"errno":"0x380", "desc":"ACL6 with identical parameter specification already exists"},
    "NSERR_ACL6_DELERROR":{"errno":"0x381", "desc":"ACL6 has already been removed"},
    "NSERR_ACL6_ADDERROR":{"errno":"0x382", "desc":"Port can be specified only if protocol is TCP (6) or UDP (17)"},
    "NSERR_ACL6_PRIORITY_EXISTS":{"errno":"0x383", "desc":"ACL6 with this priority already exists"},
    "NSERR_ACL6_ICMP_REQD":{"errno":"0x384", "desc":"ICMPv6 type/code can be specified only if protocol is ICMPv6 (58)"},
    "NSERR_ACL6_UNSPECADDR":{"errno":"0x385", "desc":"unspecified address (::) can not be configured in ACL6"},
    "NSERR_ACL6_MODCFGINFO":{"errno":"0x386", "desc":"ACL6 modified, apply ACLs6 to activate change"},
    "NSERR_ACL6_PREFIXLEN":{"errno":"0x387", "desc":"Prefix length should not be configured in ACL6. (Use range instead)"},
    "NSERR_ACL6_RNAT_NOT_ALLOWED":{"errno":"0x388", "desc":"Action must be ALLOW to bind ACL6 to RNAT"},
    "NSERR_ACL6RNAT_DELERROR":{"errno":"0x389", "desc":"This ACL6 is associated with rnat6/nat64/forwardingsession/lsn config, Remove rnat6/nat64/forwardingsession/lsn first"},
    "NSERR_RNAT6_INVALID_REDPORT":{"errno":"0x38a", "desc":"Invalid option for SET/UNSET,redirect port can be specified only for acl6 based RNAT"},
    "NSERR_ACL6_RNAT_EXISTS":{"errno":"0x38b", "desc":"ACL6 based rnat is already exist for this acl6(Duplicate config)"},
    "NSERR_NET_RNAT6_EXISTS":{"errno":"0x38c", "desc":"network based rnat is already exist for this network address(Duplicate config)"},
    "NSERR_RNAT_VIP_PORT_ALLOC_FAIL":{"errno":"0x38d", "desc":"ERROR : Port allocation for VIP v6 address Failed "},
    "NSERR_ACL6_RNAT_NAT64_NOT_ALLOWED":{"errno":"0x38e", "desc":"ERROR : Acl6 already bound to nat64 config "},
    "NSERR_ACL_SRCMAC_MASK_LENGTH":{"errno":"0x38f", "desc":"SrcMacMask length should be 12 "},
    "NSERR_ACL_INVALID_NAME":{"errno":"0x5a4", "desc":"ERROR : ACL name length should be >=1 and <=128"},
    "NSERR_ACL_SRCMAC_MASK_PAIR":{"errno":"0x5af", "desc":"SrcMacMask should Contain consecutive 1s or 0s per octet and pair of 0s should not be present after pair of 1s"},
}

NS_PBR_ERRORS = {
    "NSERR_PBR_NEXTHOP_NOTDIRECT":{"errno":"0x390", "desc":"PBR Nexthop should be direct"},
    "NSERR_PBR_NOLOOPBACK":{"errno":"0x391", "desc":"PBR cannot be configured on the loopback interface"},
    "NSERR_PBRDELERROR":{"errno":"0x392", "desc":"This PBR has already been removed"},
    "NSERR_PBR_IPPIP_EXISTS":{"errno":"0x393", "desc":"PBR with identical parameter specification already exists"},
    "NSERR_PBR_PRIORITY_EXISTS":{"errno":"0x394", "desc":"PBR with this priority already exists"},
    "NSERR_PBRMODCFGINFO":{"errno":"0x396", "desc":"PBR modified, use 'apply pbrs' to commit this operation"},
    "NSERR_PBR_NEXTHOP_REQD":{"errno":"0x397", "desc":"PBR Nexthop is required"},
    "NSERR_PBR_L2_CONFIG_INFO":{"errno":"0x398", "desc":"L2 based PBRs work only for routed traffic"},
    "NSERR_PBRMODCFG_L2_INFO":{"errno":"0x399", "desc":"L2 based PBRs work only for routed traffic: PBR modified, use 'apply pbrs' to commit this operation"},
    "NSERR_PBR_NO_MONITOR_GATEWAY":{"errno":"0x39a", "desc":"Monitor can't be configured when nexthop is configured as gateway name"},
    "NSERR_PBR_INVALID_IPORGATEWAY":{"errno":"0x39b", "desc":"Invalid Nexthop IPaddress/Gateway name"},
    "NSERR_PBR_MAX_RULE_EXCEEDED":{"errno":"0x39c", "desc":"Number of PBRs on the system exceeds Maximum"},
    "NSERR_PBR_NEXTHOP_TUNNEL_REQD":{"errno":"0x39d", "desc":"PBR Nexthop or IpTunnel is required"},
    "NSERR_PBR_DENY_MSR":{"errno":"0x39e", "desc":"MSR cannot be enabled on PBR with DENY config"},
    "NSERR_ACL_MAC_MASK_INVALID":{"errno":"0x39f", "desc":"SrcMacMask should contain only 1/0s, use 0s for matching and 1s for not matching"},
    "NSERR_PBR_IPSEC_ALREADY_BOUND":{"errno":"0x5a5", "desc":"Use IKEv1 in IPSec profile. For IPSEC tunnels with IKEv2, Only one PBR is allowed to be bound to a tunnel"},
    "NSERR_PBR_REMOVED":{"errno":"0x5a6", "desc":"PBR is removed"},
    "NSERR_PBR_L2PARAM_GRE":{"errno":"0x5b0", "desc":"PBR is having L2PARAM. Cannot have GRE as nexthop."},
    "NSERR_PBR_VXLAN":{"errno":"0x5b1", "desc":"VXLAN cannot be a nexthop."},
    "NSERR_PBR_TUNNELBOUNDTONETBRIDGE":{"errno":"0x3a5", "desc":"Tunnel is already bound to Netbridge"},
    "NSERR_PBR_SETNEXTHOP_TUNNEL":{"errno":"0x4c1", "desc":"Tunnel is bound to PBR. Cannot set NextHop"},
}

NS_FWDSESSION_ERRORS = {
    "NSERR_FWDSESSION_NAME_EXISTS":{"errno":"0x3a0", "desc":"A forwarding session with same name exists"},
    "NSERR_FWDSESSION_NW_EXISTS":{"errno":"0x3a1", "desc":"A forwarding session with same network exists"},
    "NSERR_FWDSESSION_ACL_EXISTS":{"errno":"0x3a2", "desc":"This acl is already configured"},
    "NSERR_FWDSESSION_ACL_NOT_EXISTS":{"errno":"0x3a3", "desc":"Specified ACL is not configured"},
    "NSERR_FWDSESSION_CONN_FAILOVER":{"errno":"0x3a4", "desc":"Connection fail-over not supported for v6 forwarding sessions"},
}

NS_TD_ERRORS = {
    "NSERR_TD_EXISTS":{"errno":"0x3b0", "desc":"The specified traffic domain is already configured."},
    "NSERR_TD_VLAN":{"errno":"0x3b1", "desc":"The specified VLAN/VXLAN/bridge group is already bound to another traffic domain. These entities can belong to only one traffic domain."},
    "NSERR_TD_NOTEXIST":{"errno":"0x3b2", "desc":"The specified traffic domain is not configured."},
    "NSERR_TD_MISMATCH_WITH_L3VLAN":{"errno":"0x3b3", "desc":"L3 VLANs can not be bound to a traffic domain."},
    "NSERR_TD_MISMATCH":{"errno":"0x3b4", "desc":"The binding entities have incompatible traffic domain identifiers."},
    "NSERR_TD_NOSUPP":{"errno":"0x3b5", "desc":"This feature is not supported in a non-default traffic domain."},
    "NSERR_TD_CONFIG_NOT_ALLOWED":{"errno":"0x3b6", "desc":"This configuration option is not supported in a non-default traffic domain."},
    "NSERR_TD_IP_NOTEXIST":{"errno":"0x3b7", "desc":"The IP address is not configured for the specified traffic domain."},
    "NSERR_TD_VLAN_NOTEXIST":{"errno":"0x3b8", "desc":"The specified VLAN is not configured."},
    "NSERR_TD_DEFVLAN":{"errno":"0x3b9", "desc":"Default VLAN cannot be bound/unbound to/from traffic domain."},
    "NSERR_TD_BDG_NOTEXIST":{"errno":"0x3ba", "desc":"The specified bridge group is not configured."},
    "NSERR_TD_VLAN_BDG_EXIST":{"errno":"0x3bb", "desc":"The specified VLAN is bound to a bridge group."},
    "NSERR_TD_SERVER_MISMATCH":{"errno":"0x3bc", "desc":"The specified virtual server already bound to a service in a different traffic domain."},
    "NSERR_DIFF_TD_NALLOWED_LLB":{"errno":"0x3bd", "desc":"Not allowed for LLB: Services bound to the specified virtual server must be in same traffic domain."},
    "NSERR_DUPIP":{"errno":"0x3be", "desc":"IP address duplication with VMAC address detected. Please try a different IP address."},
    "NSERR_VMAC_VLAN":{"errno":"0x3bf", "desc":"Traffic domain can be either VLAN based or VMAC based."},
    "NSERR_TD_SYNCVLAN":{"errno":"0x3c0", "desc":"SYNC VLAN cannot be bound/unbound to/from traffic domain."},
    "NSERR_TD_NOT_VLAN":{"errno":"0x3c1", "desc":"The specified VLAN/VXLAN/bridge group is not bound to given traffic domain."},
    "NSERR_SYNCNSVLAN_TD":{"errno":"0x3cf", "desc":"VLAN  bound to traffic domain cannot be configured as SYNC/NS VLAN."},
}

NS_RNAT_ERRORS = {
    "NSERR_RNAT_NAME_EXISTS":{"errno":"0x3d0", "desc":"A RNAT with same name exists"},
    "NSERR_VLAN_IPV6_LL_N_ALLOW":{"errno":"0x3c2", "desc":"IP address cannot be link-local address"},
    "NSERR_VLAN_INTF_BOUND_NSVLAN":{"errno":"0x3c3", "desc":"Cannot unbind interface from nsvlan"},
    "NSERR_VLAN_INVALID":{"errno":"0x3c4", "desc":"Incorrect vlan specified"},
    "NSERR_SYNC_VLAN_IPBOUND":{"errno":"0x3c5", "desc":"Ipaddress binding/unbinding is not allowed on sync or default vlan"},
    "NSERR_VLAN_SUBNET_ALREADY_BOUND":{"errno":"0x3c6", "desc":"Subnet already bound to this vlan"},
    "NSERR_UNABLE_GET_VLAN_IP":{"errno":"0x3c7", "desc":"Unable to get vlan of the IPaddress"},
    "NSERR_IP_VLAN_BOUND":{"errno":"0x3c8", "desc":"Ipaddress already bound to a vlan"},
    "NSERR_VLAN_UNABLE_ADD":{"errno":"0x3c9", "desc":"Unable to add vlan"},
    "NSERR_DEFVLAN":{"errno":"0x3ca", "desc":"Default VLAN or NSVLAN cannot be modified"},
    "NSERR_IPV6_ROUTING_BRIDGEGRP":{"errno":"0x3cb", "desc":"vlan is part of a bridge group. Cannot enable routing"},
    "NSERR_VLAN_SDXMGMTVLAN_CLUSTER":{"errno":"0x3cc", "desc":"Operation not permitted. vlan is SDX management vlan in a cluster"},
    "NSERR_ACL_INUSE_RNAT":{"errno":"0x3cd", "desc":"This ACL is used for RNAT/NAT64/LSN/FORWARDINGSESSION. Action should be ALLOW"},
    "NSERR_RNAT_CM_TCPPROXY":{"errno":"0x3ce", "desc":"TCPPROXY should be disabled for connection failover to work properly."},
    "NSERR_RNAT_DYN_PERM_RT ":{"errno":"0x96d", "desc":"RNAT cannot be configured on DYNAMIC/PERMANENT route"},
    "NSERR_RNAT_SRCIPPERSISTENCY_NOTSUPCLU ":{"errno":"0x4c2", "desc":"RNAT SourceIPPersistency is not supported in Cluster."},
}

NS_NET_ERRORS = {
    "NSERR_ACL_TIMED_OUT":{"errno":"0x3d1", "desc":"ACL timed out"},
    "NSERR_MSR_ADVT_NULL_RT":{"errno":"0x3d2", "desc":"Cannot monitor or advertise NULL route"},
    "NSERR_DEF_RT_UNSET":{"errno":"0x3d3", "desc":"Unset operation on default route not allowed"},
    "NSERR_ACTIVE_PERM_DIR_NULL_RT":{"errno":"0x3d5", "desc":"Unset operation on active or permanent or direct or null routes not allowed"},
    "NSERR_DHCP_RT":{"errno":"0x3d6", "desc":"Unset operation on DHCP route not allowed"},
    "NSERR_LB_RT":{"errno":"0x3d7", "desc":"Unset operation on LB route not allowed"},
    "NSERR_MSR_STATIC_RT":{"errno":"0x3d8", "desc":"Cannot set MSR on a non-static route"},
    "NSERR_ADV_DEF_RT":{"errno":"0x3d9", "desc":"Advertise on default route not allowed"},
    "NSERR_VLAN_RT":{"errno":"0x3da", "desc":"Cannot delete this route. Network is bound to VLAN"},
    "NSERR_PERM_RT":{"errno":"0x3db", "desc":"A permanent route cannot be deleted"},
    "NSERR_NOENTRY_RT":{"errno":"0x3dc", "desc":"Entry not found in the routing table"},
    "NSERR_DIR_RT":{"errno":"0x3dd", "desc":"Cannot add a direct route"},
    "NSERR_LOOP_RT":{"errno":"0x3de", "desc":"Cannot add a route in loopback network"},
    "NSERR_GW_NWID_BROADADDR":{"errno":"0x3df", "desc":"Gateway cannot be network id or broadcast address"},
    "NSERR_MON_ADV_NULL_RT":{"errno":"0x3e0", "desc":"Cannot set MSR or advertise on null gateway"},
    "NSERR_HA_PEER_IP":{"errno":"0x3e2", "desc":"Cannot add IP address. This is peer's NSIP"},
    "NSERR_NON_LOCAL_IP":{"errno":"0x3e3", "desc":"IP address is already configured on a node in the cluster"},
    "NSERR_ADD_NSIP":{"errno":"0x3e4", "desc":"Adding NSIP not allowed"},
    "NSERR_VRID_VIP_ONLY":{"errno":"0x3e5", "desc":"VRID can be set only on VIP"},
    "NSERR_ARP_ICMP_SNIP_NSIP":{"errno":"0x3e6", "desc":"ARP and ICMP cannot be disabled on SNIP/NSIP/MIP/CLIP"},
    "NSERR_IPADDR_DISABLE":{"errno":"0x3e7", "desc":"IP address state of SNIP/NSIP/CLIP cannot be disabled"},
    "NSERR_NODE_NOEXIST":{"errno":"0x3e8", "desc":"Cluster node does not exist"},
    "NSERR_CLIP_SPOTTED_IP":{"errno":"0x3e9", "desc":"CLIP should be striped"},
    "NSERR_IP_MGMTACCESS":{"errno":"0x3ea", "desc":"Management Access cannot be enabled on this IP address"},
    "NSERR_IPTUN_MULTICAST":{"errno":"0x3eb", "desc":"Vlan on which to send the packet needs to be specified for multicast remote endpoints"},
    "NSERR_IPTUNNEL_INVALIDNETMASK":{"errno":"0x3ec", "desc":"IP tunnel netmask should be 255.255.255.255."},
    "NSERR_IPTUNNEL_VLAN":{"errno":"0x3ed", "desc":"Vlan can be specified only for multicast remote endpoints"},
    "NSERR_IPTUN_INV_LIP":{"errno":"0x3ee", "desc":"Invalid local IP address. Either the local IP address is not configured or local IP address has to be one among SNIP|VIP|MIP"},
    "NSERR_VXLAN_LIP_NOT_SNIP":{"errno":"0x3ef", "desc":"Invalid local IP address. For VXLAN local IP address has to be SNIP"},
    "NSERR_INVALID_IPTUNNEL_NAME":{"errno":"0x3f0", "desc":"Invalid IPTunnel name"},
    "NSERR_IPTUNNEL_PREFXLEN_GT_128":{"errno":"0x3f1", "desc":"IP tunnel prefix length should not be more than 128"},
    "NSERR_TUN_PBR_DEP":{"errno":"0x3f2", "desc":"Cannot remove tunnel. A PBR is depending on this tunnel"},
    "NSERR_TUN_NOEXIST":{"errno":"0x3f3", "desc":"Tunnel does not exist"},
    "NSERR_INV_DROPFRAGCPUTHRESH":{"errno":"0x3f4", "desc":"Invalid dropFragCpuThreshold parameter. Should >=1 and <=100"},
    "NSERR_SRCIP_NOEXIST":{"errno":"0x3f5", "desc":"SrcIP does not exist"},
    "NSERR_TUN_ON_DEF_ROUTE":{"errno":"0x3f6", "desc":"Cannot add tunnel on default route"},
    "NSERR_VLAN_NOT_SNIP_MIP_VIP":{"errno":"0x3f7", "desc":"IP address has to be either SNIP, MIP or VIP"},
    "NSERR_ACL_PROTO_TCP":{"errno":"0x3f8", "desc":"Protocol should be TCP for ESTABLISHED flag to be set"},
    "NSERR_HA_VERSION_MISMATCH":{"errno":"0x3f9", "desc":"HA version mismatch between primary and secondary"},
    "NSERR_HA_SYNC_VLAN":{"errno":"0x3fa", "desc":"Syncvlan should be L2 VLAN. No IP address should be bound to this VLAN"},
    "NSERR_LOOP_FIS":{"errno":"0x3fb", "desc":"Loopback interface cannot be bound to Failover Interface Set (FIS)"},
    "NSERR_VLAN_LOOP":{"errno":"0x3fc", "desc":"Loopback interface cannot be unbound from default VLAN"},
    "NSERR_VLAN_TAGG_INTF_NOSUPP":{"errno":"0x3fd", "desc":"VLAN tagging is not supported on this platform/interface"},
    "NSERR_VLAN_BDG_NOTBOUND":{"errno":"0x3fe", "desc":"The VLAN is not bound to specified bridgegroup"},
    "NSERR_PERMANENT_ARP_ND6_ENTRY":{"errno":"0x3ff", "desc":"Can't remove permanent ARP/ND6 entry"},
    "NSERR_HA_VER_MISMATCH_PROP_SYNC":{"errno":"0x5a7", "desc":"HA version mismatch. Prop and sync not allowed"},
    "NSERR_VXLAN_TUNN_BOUND":{"errno":"0x5b2", "desc":"Cannot remove IPtunnel. One or more VXLAN is bound to this iptunnel."},
    "NSERR_HOSTRT_UNSET":{"errno":"0x5d1", "desc":"Unset of OSPFArea and HostRtGw is allowed only for VIP"},
    "NSERR_BDGGRP_L3VLAN":{"errno":"0x96c", "desc":"L3VLAN cannot be bound to a bridgegroup"},
    "NSERR_BDGGRP_ROUTING":{"errno":"0x9c9", "desc":"Routing is enabled on the specified VLAN. Cannot bind this VLAN to the bridgegroup"},
    "NSERR_RM_RT_DIR_PERM_DHCP":{"errno":"0x9ca", "desc":"DIRECT/PERMANENT/DHCP routes cannot be removed."},
    "NSERR_ADD_IP_STRIPED_EXISTS":{"errno":"0x9cb", "desc":"Trying to add a striped IP address as a spotted IP."},
    "NSERR_DIS_IP_NOT_USR_DEF":{"errno":"0x9cc", "desc":"Enable/Disbaling this IP address not allowed as VIP is not user-defined"},
    "NSERR_DIS_IP_NOT_VIP":{"errno":"0x9cd", "desc":"Enable/Disabling this IP address not allowed as it is not VIP"},
    "NSERR_DEL_NSIP":{"errno":"0x9ce", "desc":"Cannot delete NSIP"},
    "NSERR_DEL_DHCP_AQRD":{"errno":"0x9cf", "desc":"Cannot delete DHCP acquired IP address"},
    "NSERR_USR_DEF_NO":{"errno":"0xa3a", "desc":"Not a user-defined IP address"},
    "NSERR_TUNL_DEPENDENCY":{"errno":"0xa3b", "desc":"Existing tunnel depends on this IP address"},
    "NSERR_MGMT_NSIP_CLIP":{"errno":"0xa3c", "desc":"Management access on NSIP and CLIP should always be enabled"},
    "NSERR_INV_ICMP_RESP":{"errno":"0xa3d", "desc":"Invalid icmpResponse value"},
    "NSERR_INV_ARP_RESP":{"errno":"0xa3e", "desc":"Invalid arpResponse value"},
    "NSERR_INTERNAL_ERR_REGN":{"errno":"0xa3f", "desc":"Internal error while registration of service. Service name in use"},
    "NSERR_CANT_SET_IP_DEL_IN_PROG":{"errno":"0x9ec", "desc":"Delete IP address is in progress."},
    "NSERR_INAT_USE_PROXY":{"errno":"0x95a", "desc":"Useproxyport cannot be disabled when either of publicIP or private IP is IPV6"},
    "NSERR_GSLB_ADNS_CONFGRD":{"errno":"0x95b", "desc":"GSLB/ADNS/RADIUS is already configured on this IP address"},
    "NSERR_NW_ADDR_ZERO":{"errno":"0x95c", "desc":"Network address cannot be zero"},
    "NSERR_NW_ADDR_LOOP":{"errno":"0x95d", "desc":"Network address cannot be loopback"},
    "NSERR_UNABLE_DEFVLAN_INFO":{"errno":"0x95e", "desc":"Unable to get default VLAN info."},
    "NSERR_HA_INC_SYNC":{"errno":"0x95f", "desc":"SyncVlan is not supported in HA-INC mode"},
    "NSERR_IP_NWADDR":{"errno":"0x960", "desc":"IPaddress cannot be network address"},
    "NSERR_IP_BCASTADDR":{"errno":"0x961", "desc":"IPaddress cannot be broadcast address"},
    "NSERR_ACL_BOUND_LSN":{"errno":"0x962", "desc":"This ACL is already bound to LSN"},
    "NSERR_SUBNET_BOUND_ANTHR_VLAN":{"errno":"0x963", "desc":"Either the subnet is not directly connected or subnet already bound to another VLAN"},
    "NSERR_BGP_AS_NO_EXIST":{"errno":"0x964", "desc":"BGP instance with given AS number does not exist."},
    "NSERR_BGP_RUNNING":{"errno":"0x965", "desc":"Another BGP instance is already running."},
    "NSERR_DEL_ADNS_IP":{"errno":"0x966", "desc":"Cannot delete this IP address as ADNS is configured on this."},
    "NSERR_DEL_REF_IP":{"errno":"0x967", "desc":"Cannot delete this IP address as it is used in GSLB/IPSET/Other entities"},
    "NSERR_SNMP_CANNOT_EN_ON_IP":{"errno":"0x969", "desc":"SNMP cannot be enabled on this IP address"},
    "NSERR_CANNOT_EN_ON_IPADDR":{"errno":"0x96a", "desc":"SNMP/TELNET/FTP/SSH/GUI/SECURE GUI/RESTRICTED-IP cannot be enabled on this IP address"},
    "NSERR_ACL_ESTABLISHED_SET":{"errno":"0x96e", "desc":"For RNAT/NAT64 ACL established flag cannot be set"},
    "NSERR_DEL_RADIUS_IP":{"errno":"0x96f", "desc":"Cannot delete this IP address as RADIUS is configured on this."},
    "NSERR_CANNOT_EN_ON_IP":{"errno":"0x970", "desc":"TELNET/FTP/SSH/GUI/SECURE GUI/RESTRICTED-IP cannot be enabled on this IP address"},
}

NS_CLI_ERRORS = {
    "NSERR_TCPCONNFAIL":{"errno":"0x400", "desc":"Connection failed"},
    "NSERR_LOGINFAIL":{"errno":"0x401", "desc":"Login failed"},
    "NSERR_NOLOGIN":{"errno":"0x402", "desc":"Not logged in"},
    "NSERR_AUTHTIMEOUT":{"errno":"0x403", "desc":"Not logged in or connection timed out"},
    "NSERR_NOT_PRIMARY":{"errno":"0x404", "desc":"You are connected to a secondary node; configuration changes made in this session will not be propagated to, or saved on, other nodes"},
    "NSERR_REMOTEOP":{"errno":"0x405", "desc":"Operation cannot be performed from remote login"},
    "NSERR_CONNLOST":{"errno":"0x406", "desc":"Connection with NetScaler lost"},
    "NSERR_RPCDATAMISMATCH":{"errno":"0x407", "desc":"Communication error (RPC data-size mismatch)"},
    "NSERR_RPCBADREPLY":{"errno":"0x408", "desc":"Communication error (bad RPC reply)"},
    "NSERR_UNABLETOPROMPT":{"errno":"0x409", "desc":"Unable to display secondary prompt"},
    "NSERR_LOGIN_CHALLENGED":{"errno":"0x40A", "desc":"Login challenged"},
    "NSERR_LOGOUT_SAVE":{"errno":"0x40B", "desc":"You are leaving without saving changes. Save changes now (Y/N)? [N]:"},
    "NSERR_CLEAR_CONFIG":{"errno":"0x40C", "desc":"Are you sure you want to clear the configuration(Y/N)? [N]:"},
    "NSERR_REBOOT":{"errno":"0x40D", "desc":"Are you sure you want to restart NetScaler (Y/N)? [N]:"},
    "NSERR_SHUTDOWNNS":{"errno":"0x40E", "desc":"Are you sure you want to completely stop NetScaler (Y/N)? [N]:"},
    "NSERR_REBOOT_SAVE":{"errno":"0x40F", "desc":"Configuration not Saved. Are you sure you want to restart NetScaler (Y/N)? [N]:"},
    "NSERR_USERABORT":{"errno":"0x410", "desc":"User requested abort"},
    "NSERR_EOF":{"errno":"0x411", "desc":"EOF"},
    "NSERR_INTERRUPT":{"errno":"0x412", "desc":"Interrupted"},
    "NSERR_INTERNAL":{"errno":"0x413", "desc":"Internal error"},
    "NSERR_NOT_CLIP":{"errno":"0x414", "desc":"You are connected to NSIP of a cluster node; configuration changes made in this session will not be propagated to, or saved on, other cluster nodes"},
    "NSERR_EULA_NOTACCEPTED":{"errno":"0x415", "desc":"End User License Agreement not accepted. Login from CLI/GUI to accept it."},
    "NSERR_FORCE_PWDCHANGE":{"errno":"0x416", "desc":"ForcePasswordChange is enabled. Please login from CLI/GUI to change the default nsroot password"},
    "NSERR_PWD_EXISTS":{"errno":"0x417", "desc":"Default nsroot password is not allowed. Please enter a new password."},
    "NSERR_STRMAXLEN_255":{"errno":"0x418", "desc":"String length exceeds maximum. Allowed maximum length is 255 bytes."},
    "NSERR_STRMAXLEN_32":{"errno":"0x419", "desc":"String length exceeds maximum. Allowed maximum length is 32."},
    "NSERR_NOPREFIX_LENGTH":{"errno":"0x41A", "desc":"Prefix length must be given with network"},
    "NSERR_INVALIDPOLLVAL":{"errno":"0x41B", "desc":"Minpoll value should not be greater than maxpoll"},
    "NSERR_SHELL_ACCESS":{"errno":"0x41C", "desc":"User has shell access"},
    "NSERR_NORESPONSE":{"errno":"0x420", "desc":"No response from NetScaler"},
    "NSERR_IOERROR":{"errno":"0x421", "desc":"I/O error"},
    "NSERR_ENV":{"errno":"0x422", "desc":"Environment error"},
    "NSERR_CMDSFAILED":{"errno":"0x423", "desc":"Some commands failed"},
    "NSERR_ALLCMDSFAILED":{"errno":"0x424", "desc":"All commands failed"},
    "NSERR_INTMINVAL_CLT_IDLETIMEOUT":{"errno":"0x425", "desc":"Integer value below minimum for client idle timeout."},
    "NSERR_INTMINVAL_SRV_IDLETIMEOUT":{"errno":"0x426", "desc":"Integer value below minimum for server idle timeout."},
    "NSERR_INVALID_TCP_OPTION_TYPE":{"errno":"0x427", "desc":"Invalid tcp option type value. Allowed type values are 0 to 254"},
    "NSERR_LICEXPIRED":{"errno":"0x42A", "desc":"Features(s) license expired"},
    "NSERR_FEATDISABLED":{"errno":"0x42B", "desc":"Feature(s) not enabled"},
    "NSERR_LESS_PE":{"errno":"0x42C", "desc":"Operation not permitted. PE pool is not enough to enable additional management CPU"},
    "NSERR_MAXLIMIT":{"errno":"0x430", "desc":"Maximum resource limit reached"},
    "NSERR_SET_NOSUPPORT":{"errno":"0x431", "desc":"Set operation not supported"},
    "NSERR_INVALIDVALUE":{"errno":"0x432", "desc":"Invalid value"},
    "NSERR_INVALIDNAME":{"errno":"0x433", "desc":"Invalid name; names must begin with an alphanumeric character or underscore and must contain only alphanumerics, '_', '#', '.', ' ', ':', '@', '=' or '-'"},
    "NSERR_INVALIDPASSWORD":{"errno":"0x434", "desc":"Invalid password. Password must contain atleast one lower case character, one upper case character, one numeric character and one special character when strong password is enabled."},
    "NSERR_INVALIDMINPASSWORDLENGTH  ":{"errno":"0x435", "desc":"Minimum password length should be greater than or equal to 4 when strong password is enabled"},
    "NSERR_ENABLINGPASSWORDCOMPLEXITY  ":{"errno":"0x436", "desc":"Strong Password now enabled. Please ensure all the existing user passwords adhere to this restriction. Minimum Password Length is set to 4 as default."},
    "NSERR_INVALIDPASSWORDLENGTH  ":{"errno":"0x437", "desc":"Password length should adhere to minimum password length value in system parameter settings."},
    "NSERR_CANNOTSETMINPASSWORDLENGTH  ":{"errno":"0x438", "desc":"Strong Password needs to be enabled to set the Minimum Password Length value."},
    "NSERR_NOSUCHCMD":{"errno":"0x440", "desc":"No such command"},
    "NSERR_CMDAMBIGUOUS":{"errno":"0x441", "desc":"Ambiguous command name"},
    "NSERR_NOSUCHARG":{"errno":"0x442", "desc":"No such argument"},
    "NSERR_ARGVALMISSING":{"errno":"0x443", "desc":"Required argument value missing"},
    "NSERR_ARGSMUTEX":{"errno":"0x444", "desc":"Arguments cannot both be specified"},
    "NSERR_ARGPREREQ":{"errno":"0x445", "desc":"Argument pre-requisite missing"},
    "NSERR_ARGSTOOFEW":{"errno":"0x446", "desc":"Too few arguments"},
    "NSERR_ARGMISSING":{"errno":"0x447", "desc":"Required argument missing"},
    "NSERR_ARGORDER":{"errno":"0x448", "desc":"Argument(s) out of order"},
    "NSERR_ARGVALBAD":{"errno":"0x449", "desc":"Invalid argument value"},
    "NSERR_ARGVALSEQ":{"errno":"0x44A", "desc":"Arguments cannot have the same value"},
    "NSERR_ARGAMBIGUOUS":{"errno":"0x44B", "desc":"Ambiguous argument name"},
    "NSERR_SYNCGSLBCONFIG":{"errno":"0x44C", "desc":"Please confirm whether you want to sync-config (Y/N)? [N]:"},
    "NSERR_SYNCGSLBCONFIG_WARN":{"errno":"0x44D", "desc":"GSLB configuration will be removed from the slave site and reapplied. Syncing the GSLB configuration might cause configuration loss on other sites and also traffic disruptions might occur during this process."},
    "NSERR_ARGVALSNEQ":{"errno":"0x450", "desc":"Arguments must have the same value"},
    "NSERR_ARGVALAMBIGUOUS":{"errno":"0x451", "desc":"Ambiguous argument value"},
    "NSERR_STRMAXLEN":{"errno":"0x452", "desc":"String length exceeds maximum"},
    "NSERR_STRMINLEN":{"errno":"0x453", "desc":"String too short"},
    "NSERR_INTMAXVAL":{"errno":"0x454", "desc":"Integer value exceeds maximum"},
    "NSERR_INTMINVAL":{"errno":"0x455", "desc":"Integer value below minimum"},
    "NSERR_INVALIDIP":{"errno":"0x456", "desc":"Invalid IP address"},
    "NSERR_INVALIDNETMASK":{"errno":"0x457", "desc":"Invalid netmask"},
    "NSERR_TOOMANYVALS":{"errno":"0x458", "desc":"Argument has too many values"},
    "NSERR_BADRANGE":{"errno":"0x459", "desc":"Range minimum exceeds range maximum"},
    "NSERR_EXPRQUOTES":{"errno":"0x45A", "desc":"Expression must be enclosed in quotes"},
    "NSERR_BADQUOTES":{"errno":"0x45B", "desc":"Unmatched quote"},
    "NSERR_INVALIDRANGE":{"errno":"0x45C", "desc":"Invalid range specification"},
    "NSERR_MISMATCHRANGES":{"errno":"0x45D", "desc":"Ranges are different sizes"},
    "NSERR_MULTIRANGES":{"errno":"0x45E", "desc":"Only one range allowed per argument"},
    "NSERR_NOMATCHCHAR":{"errno":"0x45F", "desc":"Unmatched character"},
    "NSERR_NEEDREBOOT":{"errno":"0x460", "desc":"The configuration must be saved and the system rebooted for these settings to take effect"},
    "NSQ_SAVECONFIG":{"errno":"0x461", "desc":"Do you want to save the new configuration?"},
    "NSERR_NOTSAVED":{"errno":"0x462", "desc":"The configuration changes were not saved - they will be lost on the next reboot"},
    "NSERR_CMDEXEC":{"errno":"0x463", "desc":"Error(s) occurred - some or all changes may not be applied"},
    "NSQ_REBOOT":{"errno":"0x464", "desc":"Do you want to reboot the system now?"},
    "NSERR_NOREBOOT":{"errno":"0x465", "desc":"The configuration changes will not take effect until the system is rebooted"},
    "NSERR_PGMFAILED":{"errno":"0x466", "desc":"External program failed"},
    "NSERR_CTXMODE":{"errno":"0x467", "desc":"Contextual CLI mode"},
    "NSERR_CMDINCOMPLETE":{"errno":"0x468", "desc":"Incomplete command"},
    "NSERR_CMDOUTOFCTX":{"errno":"0x469", "desc":"Command not valid here"},
    "NSERR_CONFIGSAVED":{"errno":"0x46A", "desc":"The running configuration has been saved"},
    "NSERR_CONFIGCLEARED":{"errno":"0x46B", "desc":"The running configuration has been cleared"},
    "NSERR_REBOOTING":{"errno":"0x46C", "desc":"NetScaler is rebooting now"},
    "NSERR_NOCONFIGSAVE":{"errno":"0x46D", "desc":"The running configuration has not changed"},
    "NSERR_REGEXNOANCHOR":{"errno":"0x46F", "desc":"First character of regular expression must be '^'"},
    "NSERR_REGEXNOMATCH":{"errno":"0x470", "desc":"Regular expression does not match"},
    "NSERR_REGEXINVALID":{"errno":"0x471", "desc":"Invalid regular expression"},
    "NSERR_REGEXNOTALLOWED":{"errno":"0x472", "desc":"Regular expression not allowed"},
    "NSERR_REGEXNOCMD":{"errno":"0x473", "desc":"No matches"},
    "NSERR_INVALIDIPV6_FORMAT":{"errno":"0x474", "desc":"Invalid IPv6 address"},
    "NSERR_INVALIDIPV6_TWO_DOUBECOLON":{"errno":"0x475", "desc":"Double-colon can appear only once in an IPv6 address"},
    "NSERR_INVALIDIPV6_NOPREFIX_LENGTH":{"errno":"0x476", "desc":"Prefix length must be given with an IPv6 address"},
    "NSERR_INVALIDIPV6_PREFIX_VALUE":{"errno":"0x477", "desc":"Prefix length must be in the range of 0-128"},
    "NSERR_TERMNAMEINVALID":{"errno":"0x478", "desc":"Invalid term name"},
    "NSERR_TERMINVALID":{"errno":"0x479", "desc":"Invalid syntax in term"},
    "NSERR_FORCEFAILOVER":{"errno":"0x47a", "desc":"Please confirm whether you want force-failover (Y/N)? [N]:"},
    "NSERR_FORCEFAIL_HEALTH_WARN":{"errno":"0x47b", "desc":"Force Failover may cause configuration loss, peer health not optimum. Reason(s):"},
    "NSERR_HELLOTIME_MULTIPLE":{"errno":"0x47c", "desc":"Invalid value. Hellotime Interval must be a multiple of 200"},
    "NSERR_FORCESYNCSAVE":{"errno":"0x47d", "desc":"Do you want to save the config after sync (Y/N)? [Y]:"},
    "NSERR_ERROUTFILENAME":{"errno":"0x47e", "desc":"Character '/' not allowed in outfilename"},
    "NSERR_RNATIPDEL":{"errno":"0x47f", "desc":"address is bound to rnat config, can not be removed"},
    "NSERR_INVALIDALIAS":{"errno":"0x480", "desc":"Invalid alias"},
    "NSERR_NOSUCHALIAS":{"errno":"0x481", "desc":"No such alias"},
    "NSERR_ALIASEXISTS":{"errno":"0x482", "desc":"Alias already exists"},
    "NSERR_NOSUCHFILE":{"errno":"0x483", "desc":"No such file"},
    "NSERR_NOTREGFILE":{"errno":"0x484", "desc":"Not a file"},
    "NSERR_DEPRCMD":{"errno":"0x485", "desc":"Command deprecated"},
    "NSERR_DEPRARG":{"errno":"0x486", "desc":"Argument deprecated"},
    "NSERR_NOTLOGFILE":{"errno":"0x487", "desc":"Not a NetScaler log file"},
    "NSERR_NOPLENFORIPV6RANGE":{"errno":"0x488", "desc":"Prefix length cannot be specified for an IPv6 range"},
    "NSERR_INVALIDINT":{"errno":"0x489", "desc":"Integer not in range"},
    "NSERR_CMDAMBIGUOUS_USECOMPLETIONSOPTIONS":{"errno":"0x48A", "desc":"Ambiguous (use cmd completion for options)"},
    "NSERR_METADATA_INVAL_ENTITYTYPE":{"errno":"0x48B", "desc":"Invalid Entity Type"},
    "NSERR_SETNOTEXIST":{"errno":"0x48C", "desc":"set operation does not exist"},
    "NSERR_SETARGNOTEXIST":{"errno":"0x48d", "desc":"set operation for one of the modified argument does not exist"},
    "NSERR_INVALID_DS":{"errno":"0x48e", "desc":"Invalid datasource"},
    "NSERR_NOSUCHCOUNTER":{"errno":"0x48F", "desc":"No such counter"},
    "NSERR_INVALIDIPMASK":{"errno":"0x490", "desc":"Invalid IP address mask"},
    "NSERR_INVALIDIPPAT":{"errno":"0x491", "desc":"Invalid IP address pattern"},
    "NSERR_BADRC":{"errno":"0x492", "desc":"Unexpected return code"},
    "NSERR_INVALIDRANGETYPE":{"errno":"0x493", "desc":"Inappropriate range values for value type"},
    "NSERR_INVALIDRANGEVAL":{"errno":"0x494", "desc":"Invalid range value"},
    "NSERR_INVALIDIPV6_PREFIX_LENGTH":{"errno":"0x495", "desc":"Prefix length must not be given"},
    "NSERR_ENTITYDELETE_FAIL":{"errno":"0x496", "desc":"Can not delete active entity"},
    "NSERR_DONE":{"errno":"0x497", "desc":"This is the last result"},
    "NSERR_RNATIPDEL2":{"errno":"0x498", "desc":"An RNAT address requires an IP address to exist"},
    "NSERR_INCOMPATIBLEIP":{"errno":"0x49d", "desc":"Private IP and public IP must be either IPv4 or IPv6"},
    "NSERR_TRANSCR_IP":{"errno":"0x49e", "desc":"For transparent CR vserver, you cannot specify IP address"},
    "NSERR_PASSWORD_MISMATCH":{"errno":"0x49f", "desc":"Passwords entered do not match"},
    "NSERR_LEADING_TRAILING_SPACES":{"errno":"0x41d", "desc":"Leading or Trailing spaces in string"},
    "NSERR_SAVENOTDONE":{"errno":"0x41e", "desc":"The running configuration is not saved"},
    "NSERR_FIPSCONFMISMATCH_REBOOT":{"errno":"0x41f", "desc":"There is a mismatch of FIPS mode setting in system parameter and sysctl, please save the configuration and reboot the system to have consistency."},
    "NSERR_INVALIDIP_VSVRTYPE  ":{"errno":"0x49a", "desc":"Invalid IP address or Vserver Type "},
    "NSERR_HELLOTIME_DEADINTERVAL_COMBINATION":{"errno":"0x499", "desc":"The Hello Interval must be set to 200 msec when dead interval is less than 3 sec"},
    "NSERR_MAXSESSION ":{"errno":"0x49b", "desc":"Maxsession cannot be set for this user"},
    "NSERR_NEEDREPLICATE":{"errno":"0x49c", "desc":"This command will not be propagated to the other cluster nodes as you are connected to the NSIP of this cluster node"},
    "NSERR_HDOSP_DEPRECATED":{"errno":"0xF4D", "desc":"HTTP DOS protection feature has been deprecated in favour of AppQoE"},
    "NSERR_PQ_DEPRECATED":{"errno":"0xF1F", "desc":"Priority Queuing feature has been deprecated in favour of AppQoE"},
    "NSERR_IOH_DEPRECATED":{"errno":"0xF1E", "desc":"Sure Connect feature has been deprecated in favour of AppQoE"},
    "NSERR_NOT_PRIVATE_EXPORT":{"errno":"0x42D", "desc":"Private entities can not be exported"},
\
    "NSERR_OBJECT_IN_USE":{"errno":"0x42E", "desc":"Object in use, cannot delete"},
    "NSERR_CERBUNDLE_NOT_FOUND":{"errno":"0x42F", "desc":"Certbundle name not found in mapping file"},
    "NSERR_CERTBUNDLE_CANNOT_OPEN_PID":{"errno":"0x43E", "desc":"Cannot open nscertforgerd pid file"},
    "NSERR_FAILED_TO_APPLY":{"errno":"0x43F", "desc":"Failed to apply new cert bundle"},
}

NS_CFE_ERRORS = {
    "NSERR_NOSUCHIOCTL":{"errno":"0x4a0", "desc":"Command not implemented on server"},
    "NSERR_NOTARGETS":{"errno":"0x4a1", "desc":"No configured targets"},
    "NSERR_CANTRECOVER":{"errno":"0x4a2", "desc":"Configuration possibly inconsistent.  Please check with the \"show configstatus\" command or reboot."},
    "NSERR_IGNOREDIOCTL":{"errno":"0x4a3", "desc":"The command was ignored."},
    "NSERR_REMOTECLOSE":{"errno":"0x4a4", "desc":"The remote side closed the connection."},
    "NSERR_INVALID_TARGET":{"errno":"0x4a5", "desc":"The specified target does not exist"},
    "NSERR_FILE_ERROR":{"errno":"0x4a6", "desc":"File operation failed"},
    "NSERR_COMMENT_DROPPED":{"errno":"0x4a7", "desc":"Failed to retain all comments"},
    "NSERR_AGGREQ_TIMEOUT":{"errno":"0x4a8", "desc":"Request to Aggregator timed out"},
    "NSERR_AGGREAD":{"errno":"0x4a9", "desc":"Failed to read data from Aggregator"},
    "NSERR_RPC_CMD_DUP":{"errno":"0x4aa", "desc":"Found unexpected RPC duplicate command"},
    "NSERR_RPC_CMD_NONDUP":{"errno":"0x4ab", "desc":"Found unexpected RPC command"},
    "NSERR_CFE_PE_COMM":{"errno":"0x4ac", "desc":"Communication error with the packet engine"},
    "NSERR_AGG_CONFAIL":{"errno":"0x4ad", "desc":"Failed to connect to the aggregator"},
    "NSERR_CFE_PE_TIMOUT":{"errno":"0x4ae", "desc":"No response from the packet engine"},
    "NSERR_AGG_INVALIDRESPONSE":{"errno":"0x4af", "desc":"Invalid response from the aggregator"},
    "NSERR_NONTPSVR":{"errno":"0x4b0", "desc":"Cannot enable ntpd when there is no ntp server configured"},
    "NSERR_AGG_SENDFAIL":{"errno":"0x4b1", "desc":"Failed to send to aggregator"},
    "NSERR_CFE_ASLEARN_COMM":{"errno":"0x4b2", "desc":"Communication error with aslearn"},
    "NSERR_READONLY_SESSION":{"errno":"0x4b3", "desc":"Session is read-only; connect to the Cluster IP address to modify the configuration"},
    "NSERR_WRONG_PE_STATE":{"errno":"0x4b4", "desc":"The packet engine is in the wrong state to receive this command"},
    "NSERR_CFE_VALIDATION_FAILED":{"errno":"0x4b5", "desc":"Config validation failed"},
    "NSERR_XPATH_INTERNAL":{"errno":"0x4b6", "desc":"XPATH Internal Error"},
    "NSERR_CFE_CALLHOME_COMM":{"errno":"0x4b7", "desc":"Communication error with callhome"},
    "NSERR_BIND_NOENT":{"errno":"0x4b8", "desc":"No such bind resource"},
    "NSERR_PPNETMASK":{"errno":"0x4b9", "desc":"Netmask length 31 supports only point to point communications"},
    "NSERR_CFE_CLFSYNCD_COMM":{"errno":"0x4ba", "desc":"Communication error with cluster filesync server"},
    "NSERR_DB_INTERNAL":{"errno":"0x4bb", "desc":"Config DB Internal Error"},
    "NSERR_MIPDEPRECATED":{"errno":"0x4bc", "desc":"MIP is deprecated. Please use SNIP"},
    "NSERR_KEKEXISTS":{"errno":"0x4bd", "desc":"Cannot create KEK. KEK already exists."},
    "NSERR_VAL_INCONSITENT":{"errno":"0x4be", "desc":"Validation inconsistent between PE and configd."},
    "NSERR_CALLHOME_LOW_HB_CUSTOM_INTERVAL":{"errno":"0x4bf", "desc":"Setting a low heartbeat interval will result in frequent CallHome uploads"},
}

NS_NITRO_ERRORS = {
    "NSERR_NITRO_INVALID_OBJECTNAME":{"errno":"0x4d0", "desc":"Invalid object name"},
    "NSERR_NITRO_INVALID_JSON_INPUT":{"errno":"0x4d1", "desc":"Invalid JSON input"},
    "NSERR_NITRO_INVALID_JSON_DATATYPE":{"errno":"0x4d2", "desc":"Invalid JSON data type"},
    "NSERR_NITRO_INVALID_XML_INPUT":{"errno":"0x4d3", "desc":"Invalid XML input"},
    "NSERR_NITRO_INVALID_DATATYPE":{"errno":"0x4d4", "desc":"Invalid NITRO data type"},
    "NSERR_NITRO_INVALID_METHOD":{"errno":"0x4d5", "desc":"Invalid method name. It should be either post, put, get, stat or delete"},
    "NSERR_NITRO_PARSE_ERROR":{"errno":"0x4d6", "desc":"NITRO parse error"},
    "NSERR_NITRO_CMDEXEC_FAILED":{"errno":"0x4d7", "desc":"NITRO command Execution failed"},
    "NSERR_NITRO_INVALID_ACTION":{"errno":"0x4d8", "desc":"Invalid nitro action or operation"},
    "NSERR_NITRO_ROLLBACK_FAILED":{"errno":"0x4d9", "desc":"Rollback failed. Manually correct the configuration"},
    "NSERR_NITRO_ROLLBACK_NOT_SUPPORTED":{"errno":"0x4da", "desc":"Rollback not supported for this action"},
    "NSERR_NITRO_BULK_FAILED":{"errno":"0x4db", "desc":"Bulk operation failed"},
    "NSERR_NITRO_BASIC_AUTH_DISABLED":{"errno":"0x4dc", "desc":"Authentication Failed: Use of Basic Authentication is Disabled."},
    "NSERR_NITRO_TECHSUPPORT_ARCHIVE_CREATION_FAILED":{"errno":"0x4de", "desc":"Creation of techsupport collector archive failed."},
    "NSERR_NITRO_TECHSUPPORT_ARCHIVE_UPLOAD_FAILED":{"errno":"0x4df", "desc":"Failed to upload the techsupport collector archive."},
    "NSERR_NSAPP_TEMPLATE_EXISTS":{"errno":"0x4e0", "desc":"Template already exists"},
    "NSERR_NSAPP_INVALID_TEMPLATE":{"errno":"0x4e1", "desc":"Invalid Template"},
    "NSERR_NSAPP_DIR_ERROR":{"errno":"0x4e2", "desc":"Couldnot open directory"},
    "NSERR_NSAPP_FILE_ERROR":{"errno":"0x4e3", "desc":"Can not open the file"},
    "NSERR_NSAPP_INVALID_APP_INPUT":{"errno":"0x4e4", "desc":"Invalid Application input"},
    "NSERR_NSAPP_EXCEEDED_FILELENGTH":{"errno":"0x4e5", "desc":"File length exceeded 256 characters"},
    "NSERR_NSAPP_ENDPOINT_INUSE":{"errno":"0x4e6", "desc":"Public endpoint in use"},
    "NSERR_NSAPP_PROTOCOL_MISMATCH":{"errno":"0x4e7", "desc":"Protocol mismatch with existing configuration"},
    "NSERR_NSAPP_INVALID_VARNAME":{"errno":"0x4e8", "desc":"Invalid variable name"},
    "NSERR_NSAPP_ZIP_FILE":{"errno":"0x4e9", "desc":"Error in zip format"},
    "NSERR_NSAPP_MAXEP_REACHED":{"errno":"0x4ea", "desc":"Only one endpoint can be configured"},
    "NSERR_NSAPP_NOT_EXIST":{"errno":"0x4eb", "desc":"Application does not exist"},
    "NSERR_NSAPP_INVALID_SERVICETYPE":{"errno":"0x4ec", "desc":"Invalid servicetype - HTTP/HTTPS/SSL are only allowed"},
    "NSERR_NSAPP_TEMPLATE_FORMAT_ERROR":{"errno":"0x4ed", "desc":"Template format error"},
    "NSERR_NSAPP_APP_WITHOUT_APPUNITS":{"errno":"0x4ee", "desc":"Application without appunits can not be exported"},
    "NSERR_NSAPP_SERVICRGROUP_EXISTS":{"errno":"0x4ef", "desc":"Service group with this name already exists"},
    "NSERR_NSAPP_VARIABLE_NOT_EXISTS":{"errno":"0x4f0", "desc":"Variables do not exist in this template file"},
}

NS_LB_ERRORS = {
    "NSERR_SLESSLB_LBMETHOD_NOTSUPPORTED":{"errno":"0x500", "desc":"Incompatible LB method for sessionless vserver"},
    "NSERR_SLESSLB_PERSIST_NOTSUPPORTED":{"errno":"0x501", "desc":"Incompatible persistence method for sessionless vserver"},
    "NSERR_SLESSLB_TYPE_NOTSUPPORTED":{"errno":"0x502", "desc":"Sessionless vserver must be of type ANY, DNS or UDP"},
    "NSERR_SLESSLB_MODE_NOTSUPPORTED":{"errno":"0x503", "desc":"Sessionless vserver must have MAC or IPTUNNEL mode set"},
    "NSERR_SLESSLB_SVC_USIPNOTSET":{"errno":"0x504", "desc":"Service bound to a sessionless vserver must have UseSourceIP mode enabled"},
    "NSERR_WILDCARDVIP_LBMETHOD_INVAL":{"errno":"0x506", "desc":"Invalid LB method for a wildcard vserver"},
    "NSERR_WILDCARDVIP_PERSIST_INVAL":{"errno":"0x507", "desc":"Invalid persistence policy for a wildcard vserver"},
    "NSERR_LB_SO_THRESHOLD":{"errno":"0x508", "desc":"Spill-over threshold should be a non-zero value"},
    "NSERR_CONNFAILOVER_USIP":{"errno":"0x509", "desc":"Service must have Use Source IP option set in order to be bound to a connection failover enabled virtual server"},
    "NSERR_CONNFAILOVER_SERVICE":{"errno":"0x50a", "desc":"Connection failover can only be enabled on a virtual server of service type ANY"},
    "NSERR_LB_SO_DYNAMICCON_THRESHOLD":{"errno":"0x50B", "desc":"Spill-over threshold cannot be set for dynamic connection spill-over method"},
    "NSERR_LB_SO_ADDRVIP":{"errno":"0x50C", "desc":"DYNAMICCONNECTION spill-over cannot be set on a non-LB vserver"},
    "NSERR_CONNFAILOVER_NOTFOR_SLESS":{"errno":"0x50d", "desc":"Connection Failover is not supported for sessionless lb vserver\n"},
    "NSERR_NEWSVC_PERCENT_CAPPED":{"errno":"0x50e", "desc":"Percentage value of requests capped at 100"},
    "NSERR_SIP_NOCALLID":{"errno":"0x510", "desc":"Missing Call-ID header field"},
    "NSERR_SIP_NOVIA":{"errno":"0x511", "desc":"Missing Via header field"},
    "NSERR_SIP_NOCSEQ":{"errno":"0x512", "desc":"Missing CSeq header field"},
    "NSERR_SIP_NOTO":{"errno":"0x513", "desc":"Missing To header field"},
    "NSERR_SIP_NOFROM":{"errno":"0x514", "desc":"Missing From header field"},
    "NSERR_SIP_NOMAX_FORWARDS":{"errno":"0x515", "desc":"Missing Max-Forwards header field"},
    "NSERR_SIP_SERVICE_UNAVAILABLE":{"errno":"0x516", "desc":"Service unavailable"},
    "NSERR_SVC_NOT_BOUND ":{"errno":"0x517", "desc":"Service not bound to Vserver"},
    "NSERR_SVCTYPE_MISMATCH ":{"errno":"0x518", "desc":"Service type mismatch between the vserver and service"},
    "NSERR_CH_CON_NOT_ALLOWED ":{"errno":"0x519", "desc":"CONNECTION header cannot be set"},
    "NSERR_LBPROFILE_DBS ":{"errno":"0xdf4", "desc":"DBSLB setting of LB profile cannot be changed with vservers associated with it"},
    "NSERR_LBPROFILE_EXIST":{"errno":"0xdf5", "desc":"LB profile already exists"},
    "NSERR_LBPROFILE_NOENT":{"errno":"0xdf6", "desc":"LB profile doesn't exist"},
    "NSERR_LBPROFILE_NOMEM":{"errno":"0xdf7", "desc":"Cannot allocate memory for LB profile"},
    "NSERR_LBPROFILE_VSERVERSET":{"errno":"0xdf8", "desc":"Cannot set vserver params which is associated with LB profile"},
    "NSERR_CH_INCOMPLETE_HDR ":{"errno":"0x520", "desc":"Custom Header string should end with CRLF"},
    "NSERR_SPILLOVERDISABLED":{"errno":"0x521", "desc":"No spillover on the vserver due to max client setting '0' on a bound service"},
    "NSERR_MAXTIMEEXCEEDED":{"errno":"0x522", "desc":"Maximum time value for interval or responsetimeout or downtime is exceeded, rounding to maximum"},
    "NSERR_SCINVALPROTO":{"errno":"0x523", "desc":"Cannot bind SC policy to non-HTTP service or vserver"},
    "NSERR_ROOTREC":{"errno":"0x524", "desc":"Atleast one nameserver record should exist for the root domain"},
    "NSERR_ROOT_GLUEREC":{"errno":"0x525", "desc":"Root domain nameserver address record should have atleast one ip address"},
    "NSERR_VIPINSERT_NOT_SUPPORTED":{"errno":"0x54c", "desc":"Vserver IP and port header insertion option not supported on this vserver."},
    "NSERR_VSVR_ALRDY_BOUND":{"errno":"0x526", "desc":"This vserver is already bound to a WLM"},
    "NSERR_INVALID_WLM_BINDING":{"errno":"0x527", "desc":"Only LB vservers are allowed to bound to WLM"},
    "NSERR_VSVR_NOT_BOUND ":{"errno":"0x528", "desc":"Vserver not bound to WLM"},
    "NSERR_WLM_EXISTS":{"errno":"0x529", "desc":"WLM already configured on this IP, port"},
    "NSERR_INVALID_TIMEOUT":{"errno":"0x52a", "desc":"Invalid persistence timeout: default timeout assigned"},
    "NSERR_CONNFAILOVER_INCMODE":{"errno":"0x52b", "desc":"Stateful connection failover cannot be enabled in INC mode"},
    "NSERR_CONNFAILOVER_TCPB":{"errno":"0x52c", "desc":"Stateful connection failover cannot be enabled on a vserver that binds services with TCP buffering enabled"},
    "NSERR_CONNFAILOVER_TCPB_SVC_BIND":{"errno":"0x52e", "desc":"Service with TCP buffering enabled cannot be bound to a vserver with stateful connection failover enabled"},
    "NSERR_CONNFAILOVER_TCPB_SVC_PARAM":{"errno":"0x52f", "desc":"TCP buffering cannot be enabled on a service bound to a vserver with stateful connection failover enabled"},
    "NSERR_CONNFAILOVER_SERVICE_STATEFULL":{"errno":"0x530", "desc":"Stateful connection failover cannot be enabled on a vserver of this service type"},
    "NSERR_CONNFAILOVER_SSL_SVC_BIND":{"errno":"0x531", "desc":"SSL TCP service cannot be bound to a TCP vserver with stateful connection failover enabled"},
    "NSERR_CONNFAILOVER_HA_INC_NODE":{"errno":"0x532", "desc":"Ha node with INC mode enabled cannot be added to the system that has vserver(s) with stateful connection failover enabled"},
    "NSERR_CONNFAILOVER_SSL_SVC":{"errno":"0x533", "desc":"Stateful connection failover cannot be enabled on a vserver that binds services of type SSL_TCP"},
    "NSERR_INVALID_PERSISTENCE":{"errno":"0x534", "desc":"Invalid Persistence type"},
    "NSERR_RTSPSESSION_INVALID":{"errno":"0x535", "desc":"Invalid RTSP session entry"},
    "NSERR_LB_METHOD_SAMEAS_BACKUP_METHOD":{"errno":"0x536", "desc":"Backup load balancing method cannot be the same as the primary load balancing method"},
    "NSERR_SERVER_EXIST":{"errno":"0x537", "desc":"Server already exists"},
    "NSERR_LB_SO_HEALTH":{"errno":"0x538", "desc":"HEALTH spill-over cannot be set on a non-LB vserver"},
    "NSERR_REQ_RULE_MISSING":{"errno":"0x539", "desc":"Request Rule is required, when Response rule is specified."},
    "NSERR_CONNFAILOVER_BINDLO":{"errno":"0x53a", "desc":"Loopback service cannot be bound to vserver with connection failover enabled \n"},
    "NSERR_CONNFAILOVER_SETWITHLO":{"errno":"0x53b", "desc":"Connection Failover cannot be set to STATEFUL/STATELESS on vserver with bound loopback service\n"},
    "NSERR_REDIRECT_URL_NOT_APPLICABLE":{"errno":"0x53c", "desc":"Redirect URL cannot be configured on this vserver."},
    "NSERR_STATEFUL_CONNFAILOVER_IPV6":{"errno":"0x53d", "desc":"Stateful connection failover cannot be enabled on an IPv6 vserver"},
    "NSERR_CONNFAILOVER_NOT_SUPPORTED":{"errno":"0x53e", "desc":"Connection Failover is not supported for pattern based vservers"},
    "NSERR_NOBIND_ONPUSH":{"errno":"0x53f", "desc":"Bindings not allowed on push vserver"},
    "NSERR_PUSH_VSVR":{"errno":"0x540", "desc":"Option cannot be set on push vserver"},
    "NSERR_ONLY_HTTPSSL":{"errno":"0x541", "desc":"Option can only be set on http/ ssl vserver"},
    "NSERR_PUSH_BIND_EXISTS":{"errno":"0x542", "desc":"A push vserver is already bound. Unbind before binding new vserver"},
    "NSERR_SET_PUSHVS_ONLY":{"errno":"0x543", "desc":"Push vserver should be of type push or ssl_push only"},
    "NSERR_SLESS_NO_SUPPORT":{"errno":"0x544", "desc":"Not supported for sessionless vservers"},
    "NSERR_CONNFAILOVER_V6SERVICE":{"errno":"0x545", "desc":"Connection Failover cannot be set to STATEFUL on vserver with IPv6 services bound"},
    "NSERR_CONNFAILOVER_VSERVER":{"errno":"0x546", "desc":"IPV6 service cannot be bound to vserver with connection failover set to STATEFUL"},
    "NSERR_LISTEN_POLICY_BIND":{"errno":"0x547", "desc":"Error in binding listen policy to vserver(normal vserver already present)"},
    "NSERR_NO_LISTEN_POLICY_FOR_DUMMYVS":{"errno":"0x548", "desc":"Cannot bind listen policy to dummy vservers"},
    "NSERR_LISTEN_POLICY_BIND_PRESENT":{"errno":"0x549", "desc":"Error in binding listen policy to vserver(vserver with new priority already present)"},
    "NSERR_NO_LISTEN_PRI":{"errno":"0x54a", "desc":"Error in binding listen priority to normal vserver"},
    "NSERR_NORMAL_VS_NONE_LISTENPOL":{"errno":"0x54b", "desc":"The vserver already has None Listen Policy\n"},
    "NSERR_NO_LISPRI_FOR_NONE_LISPOL":{"errno":"0x54d", "desc":"None listenpolicy doesnot have listen priority\n"},
    "NSERR_INVALID_POLICY_STRING":{"errno":"0x54e", "desc":"Invalid listenpolicy entered\n"},
    "NSERR_NODATALENOFFFORVS":{"errno":"0x54f", "desc":"Dataoffset and datalength are not required for this vserver\n"},
    "NSERR_LBGRPPERSISWITHRDP":{"errno":"0x505", "desc":"Persistency is not applicable for RDP vserver or LB group which has RDP vserver part of it"},
    "NSERR_CS_SOTHRESHOLD":{"errno":"0x55a", "desc":" Spillover threshold must be given with spillover method  in Content Switching vserver"},
    "NSERR_INVALID_INSERTVSERVERIPPORT":{"errno":"0x570", "desc":"V6TOV4MAPPING is not applicable to ipv4 vserver"},
    "NSERR_LB_SERVER_NOTEXIST":{"errno":"0x56c", "desc":"The Target LB Vserver does not exist"},
    "NSERR_BOUNDTO_CSACT":{"errno":"0x55b", "desc":"The Vserver referred by Content Switching action cannot be removed"},
    "NSERR_BOUNDTO_CSPOLICY":{"errno":"0x55c", "desc":"The Content Switching Action bound to Content Switching Policy cannot be removed"},
    "NSERR_INVALID_MULTIPLEBIND":{"errno":"0x55d", "desc":"Multiple Bind not supported for Content Switching Advanced policies without action"},
    "NSERR_CSPOLICY_HASACTION":{"errno":"0x55e", "desc":"LB vserver/gotoPriorityExpression/invoke not allowed during bind when content swtiching policy already has an action."},
    "NSERR_CS_NOTSUPPORT_LB":{"errno":"0x55f", "desc":"The Protocol of given LB vserver is not supported by Content Switching action"},
    "NSERR_ACTION_NOTNOOP_CS":{"errno":"0x56a", "desc":"Do not provide gotoPriorityExpression/invoke because policy has action "},
    "NSERR_CSPOLICY_NOACTION":{"errno":"0x56b", "desc":"Either LB vserver or GotoPriorityExpression or Invoke must be provided while binding a Content Switching policy without action."},
    "NSERR_CSPEPOLICY_SETNOACTION":{"errno":"0x56d", "desc":"Content Switching classic policy does not support action"},
    "NSERR_POLICY_USED_FOR_INVOKE":{"errno":"0x56e", "desc":"Do not give target LB beacuse the policy has been bound to multiple entities"},
    "NSERR_SPECIFY_BACKUP_NODE":{"errno":"0x571", "desc":"Please specify the backup node."},
    "NSERR_SAME_NODES":{"errno":"0x572", "desc":"Owner and backup nodes need to different."},
    "NSERR_INCOMPATIBLE_POLICY_SERVER_TYPE":{"errno":"0x56f", "desc":"Content switching vserver service type is not compatible with given policy expression"},
    "NSERR_PEPOLICY_BIND_NOTALLOWED":{"errno":"0x573", "desc":"Binding of classic content switching policy to content switching policylabel is not allowed"},
    "NSERR_TCPKA_IDLETIME_TOO_LOW":{"errno":"0x574", "desc":"Connection idle time cannot be lower than keep-alive probe interval"},
    "NSERR_OWNER_NODE_NOT_IN_CLUSTER":{"errno":"0x575", "desc":"Owner node is not in the cluster config or is NOT ACTIVE"},
    "NSERR_BACKUP_NODE_NOT_IN_CLUSTER":{"errno":"0x576", "desc":"Backup node is not in the cluster config or is NOT ACTIVE"},
    "NSERR_SPOTTED_VSERVER_NOT_SUPPORTED_IN_STANDALONE":{"errno":"0x577", "desc":"Spotted vserver configuration not supported in standalone or HA deplyoment"},
    "NSERR_SPOTTED_CONFIG_NO_MATCH":{"errno":"0x578", "desc":"Spotted config of the backup verser does not match the vserver"},
    "NSERR_OPTION_NOT_SUPPORTED":{"errno":"0x579", "desc":"Skip persistency is supported only for ANY and UDP service types"},
    "NSERR_OPTION_NOT_SUPPORTED_IP":{"errno":"0x57a", "desc":"BYPASS is not supported for IP based vservers"},
    "NSERR_OWNER_NODE_NOT_SET":{"errno":"0x57b", "desc":"Owner node should be specified for cluster"},
    "NSERR_INVALID_RENAME":{"errno":"0x57c", "desc":"Rename is supported only for Advanced policies"},
    "NSERR_INVAL_LOCAL_NAMSVR_TYPE":{"errno":"0x57d", "desc":"Only UDP based local nameservers are allowed"},
    "NSERR_INVALID_TFTPORT":{"errno":"0x57e", "desc":"Invalid port for tftp vserver"},
    "NSERR_NO_RENAME":{"errno":"0x57f", "desc":"No Rename Supported"},
    "NSERR_USE_BINDCR_CMD":{"errno":"0x58", "desc":"Use Bind CR command to bind CR Vserver instead of Bind CS"},
    "NSERR_NOENT_AS_PROFILE":{"errno":"0x580", "desc":"No such Autoscale profile"},
    "NSERR_LBREFFERED_IN_CSBINDING":{"errno":"0x581", "desc":"Cannot remove LB Vserver which is reffered in CS policy bindings"},
    "NSERR_DEFAULTLB_NOT_BOUND":{"errno":"0x582", "desc":"default LB mentioned is not bound"},
    "NSERR_NG_BIND_ENTITY":{"errno":"0x583", "desc":"Error binding the node group to an entity"},
    "NSERR_ENTITY_BOUND_TO_ANOTHER_NG":{"errno":"0x584", "desc":"The specified entity is already bound to a different node group"},
    "NSERR_ENTITY_ALREADY_BOUND":{"errno":"0x585", "desc":"The specified entity is already bound to this node group"},
    "NSERR_ENTITY_NOT_BOUND_TO_NG":{"errno":"0x586", "desc":"The specified entity is not bound to any node group"},
    "NSERR_NG_NOT_FOUND":{"errno":"0x587", "desc":"Nodegroup is not found"},
    "NSERR_NG_HAS_BINDINGS":{"errno":"0x588", "desc":"Nodegroup cannot be deleted, it has entities bound to it"},
    "NSERR_VSERVER_CANNOT_BIND":{"errno":"0x589", "desc":"Vserver cannot bind to the nodegroup"},
    "NSERR_VSERVER_CANNOT_UNBIND":{"errno":"0x58a", "desc":"Vserver cannot unbind to the nodegroup"},
    "NSERR_NG_CANNOT_BE_STRICT":{"errno":"0x58b", "desc":"Nodegroup cannot be made strict as there are no nodes bound to it, but entities are bound"},
    "NSERR_NG_STRICT_AND_ZERODEPTH":{"errno":"0x58c", "desc":"Cannot bind an entity to a strict nodegroup with no nodes bound to it"},
    "NSERR_UNBINDING_LAST_NODE_FROM_STRICT_NG":{"errno":"0x58d", "desc":"Cannot unbind the last node from a strict nodegroup with entities bound to it"},
    "NSERR_NG_ALREADY_ADDED":{"errno":"0x58e", "desc":"Nodegroup is already added"},
    "NSERR_NG_ENTITY_NOMEM":{"errno":"0x58f", "desc":"No memory to establish entity to nodegroup association"},
    "NSERR_NG_MAX_CONFIGURED":{"errno":"0x590", "desc":"Cannot add nodegroup; maximum number of nodegroups already added"},
    "NSERR_INVAL_CS_ACTION":{"errno":"0x591", "desc":"Action given is not a CS action"},
    "NSERR_SET_CSACTION_DISALLOWED":{"errno":"0x592", "desc":"Set disallowed for CS action from Target LB/targetVserver to Target Expression and vice versa"},
    "NSERR_RETAIN_VLAN":{"errno":"0x593", "desc":"macmoderetainvlan applicable only for wildcard(IP and port) macmode vserver"},
    "NSERR_BIND_BDGGROUP_SYNCVLAN":{"errno":"0x594", "desc":"Sync vlan cannot be bound to bridgegroup"},
    "NSERR_DEL_SYNCVLAN":{"errno":"0x595", "desc":"Sync vlan cannot be deleted"},
    "NSERR_CSPEPOL_PARTITION_NOT_ALLOWED":{"errno":"0x596", "desc":"Current NON-default partition only supports Advanced Polices."},
    "NSERR_LESSTHAN_PPE":{"errno":"0x59e", "desc":"Max/Min Reusepool connections should be greater than or equal to running Packet Engines."},
    "NSERR_MCLIMITS":{"errno":"0x50f", "desc":"Dummy error to avoid issues when upgrade done from 9.3. "},
    "NSERR_SIP_BAD_REQUEST":{"errno":"0x597", "desc":"Invalid SIP request."},
    "NSERR_SIP_NO_CONTENT_LEN":{"errno":"0x598", "desc":"No content length present."},
    "NSERR_SIP_RET_MAX_INCOM_LEN":{"errno":"0x599", "desc":"SIP InComp max limit reached."},
    "NSERR_SIP_RET_RETRY":{"errno":"0x59a", "desc":"SIP packet retry."},
    "NSERR_SIP_RET_NO_MEM":{"errno":"0x59b", "desc":"SIP no memory available."},
    "NSERR_SIP_RET_HEADER_NOT_COMPLETE":{"errno":"0x59c", "desc":"Incomplete SIP headers."},
    "NSERR_SIP_RET_FAILURE":{"errno":"0x59d", "desc":"SIP operation failed."},
    "NSERR_CS_GSLB_DEFAULT":{"errno":"0x59f", "desc":"Default vserver type mismatch"},
    "NSERR_CS_GSLB_DNSRT_MISMATCH":{"errno":"0x51a", "desc":"DNSrecordType of CS GSLB vserver and Target Vserver should be same."},
    "NSERR_CS_GSLB_INVALID_TARGET":{"errno":"0x51b", "desc":"CS Vserver of type GSLB can only have GSLB vserver as Target."},
    "NSERR_CS_GSLB_POLICY_NO_ACTION":{"errno":"0x51c", "desc":"CS Policy has no action or CS action doesn't have targetVserver"},
    "NSERR_GSLB_SVC_ALREADY_BOUND_TO_CS":{"errno":"0x51d", "desc":"GSLB service bound to targetVserver is already bound to CS vserver"},
    "NSERR_CS_POLICY_NO_RULE":{"errno":"0x51e", "desc":"Binding CS policy to CS GSLB vserver requires rule"},
    "NSERR_VIP_BACKUP_ISCSGSLB":{"errno":"0x51f", "desc":"CS GSLB vserver cannot be backup of a non- CS GSLB vserver"},
    "NSERR_VSR_BOUND":{"errno":"0x52d", "desc":"Service/servicegroup is bound to one or more vserver. Please unbind and retry the operation. Also check 'allowBoundSvcRemoval' option in lb parameter to change this behaviour."},
}

NS_PQ_ERRORS = {
    "NSERR_PQ_BINDVIP":{"errno":"0x550", "desc":"Cannot bind same priority policy to VIP"},
    "NSERR_PQ_INVALPRIO":{"errno":"0x551", "desc":"Invalid priority value"},
    "NSERR_PQ_2BIGRULE":{"errno":"0x552", "desc":"Rule argument too big"},
    "NSERR_PQ_INVALWT":{"errno":"0x553", "desc":"Invalid weight value"},
    "NSERR_PQ_POLEXIST":{"errno":"0x554", "desc":"Policy name already in use"},
    "NSERR_PQ_NOPOL":{"errno":"0x555", "desc":"No such PQ policy exists"},
    "NSERR_PQ_2MANYREF":{"errno":"0x556", "desc":"Cannot remove a policy which is bound to VIP"},
    "NSERR_PQ_NOLBVIP":{"errno":"0x557", "desc":"No such LB vserver exists"},
    "NSERR_PQ_PHSCONFIG":{"errno":"0x558", "desc":"Cannot configure PQ on VIP if physical service has PQ configuration"},
    "NSERR_PQ_NOBIND":{"errno":"0x559", "desc":"Cannot unbind PQ Policy which is not bound"},
}

NS_LB2_ERRORS = {
    "NSERR_ADDRPRESENT":{"errno":"0x560", "desc":"Address(s) is invalid or already present in this action, will be discarded."},
    "NSERR_PERSISTENCE_PERSISTAVP_NOTDEFINED":{"errno":"0x561", "desc":"Persist Avp Number Must be defined For diameter Persistency"},
    "NSERR_MAX_DIAMETER_AVP_EXCEEDED":{"errno":"0x562", "desc":"Maximum number of diameter Persist Avp Codes exceeded"},
    "NSERR_AUTOSCALE_MIN_GT_MAX":{"errno":"0x563", "desc":"Minimum Autoscale member count exceeds the maximum value"},
    "NSERR_MEMBERPORT_REQD":{"errno":"0x564", "desc":"Member Port option has to be specified when autoScale option CLOUD is chosen"},
    "NSERR_COOKIEINSERT_NOTSET":{"errno":"0x565", "desc":"Persistence type is not COOKIEINSERT."},
}

NS_SSL_ERRORS = {
    "NSERR_SSL_CERT":{"errno":"0x600", "desc":"Invalid certificate"},
    "NSERR_SSL_PKEY":{"errno":"0x601", "desc":"Invalid private key, or PEM pass phrase required for this private key"},
    "NSERR_SSL_NOMATCH":{"errno":"0x602", "desc":"Certificate and private key do not match"},
    "NSERR_SSL_CERTTYPE":{"errno":"0x603", "desc":"Invalid cetificate type"},
    "NSERR_SSL_NOCERT":{"errno":"0x604", "desc":"Certificate does not exist"},
    "NSERR_SSL_REFEXT":{"errno":"0x605", "desc":"Certificate is referenced by a CRL, OCSP responder, vserver, service, monitor, SSL profile, another certificate, or a policy expression using XML_ENCRYPT() or XML_DECRYPT()"},
    "NSERR_SSL_BIND":{"errno":"0x606", "desc":"Certificate binding does not exist"},
    "NSERR_SSL_LINK":{"errno":"0x607", "desc":"Certificate can't be linked to the same certificate"},
    "NSERR_SSL_NEED_SSLPROTO":{"errno":"0x608", "desc":"Object's protocol type is not SSL"},
    "NSERR_SSL_NOLINK":{"errno":"0x609", "desc":"Certificate does not have any CA link"},
    "NSERR_SSL_BINDOR":{"errno":"0x60A", "desc":"Current certificate replaces the previous binding"},
    "NSERR_SSL_NOSVRCERT":{"errno":"0x60B", "desc":"Certificate is not a server certificate"},
    "NSERR_SSL_ISSUBMIS":{"errno":"0x60C", "desc":"Issuer certificate mismatch"},
    "NSERR_SSL_CRL":{"errno":"0x60D", "desc":"Invalid CRL "},
    "NSERR_SSL_NOCRL":{"errno":"0x60E", "desc":"CRL does not exist"},
    "NSERR_SSL_DHCOUNT":{"errno":"0x60F", "desc":"DH Refresh count should be 0 or >=500"},
    "NSERR_SSL_SESSTO":{"errno":"0x610", "desc":"Session timeout should be > 0"},
    "NSERR_SSL_ERSACOUNT":{"errno":"0x611", "desc":"eRSA Refresh count should be 0 or >=500"},
    "NSERR_SSL_DH_SIZE":{"errno":"0x612", "desc":"DH params of size greater than 2048 bits not supported"},
    "NSERR_DHPATH":{"errno":"0x613", "desc":"DH file path mandatory if DH enabled"},
    "NSERR_CERTHEADER":{"errno":"0x614", "desc":"Cert header tag mandatory if cert enabled"},
    "NSERR_SESSHEADER":{"errno":"0x615", "desc":"Sess header tag mandatory if sess enabled"},
    "NSERR_CIPHER_PERM":{"errno":"0x616", "desc":"Default ciphers/aliases cannot be added or removed"},
    "NSERR_SSL_ERSADISABLED":{"errno":"0x617", "desc":"Setting eRSA count when eRSA is disabled"},
    "NSERR_SSL_DHDISABLED":{"errno":"0x618", "desc":"Setting DH count when DH is disabled"},
    "NSERR_SSL_SESSDISABLED":{"errno":"0x619", "desc":"Setting session timeout when session reuse is disabled"},
    "NSERR_SSL_PKEY_SIZE":{"errno":"0x61A", "desc":"Certificate with key size greater than RSA4096 or DSA2048 bits not supported"},
    "NSERR_SSL_NOT_APPLICABLE":{"errno":"0x61B", "desc":"Option is not applicable for this type of service"},
    "NSERR_CERTDNHEADER ":{"errno":"0x61C", "desc":"Cert DN tag mandatory if cert-DN enabled"},
    "NSERR_CERTISSUERHEADER":{"errno":"0x61D", "desc":"Cert issuer tag mandatory if cert-issuer enabled"},
    "NSERR_CIPHERHEADER ":{"errno":"0x61E", "desc":"Cipher tag mandatory if cipher header enabled"},
    "NSERR_SSL_INTERNALERR":{"errno":"0x61F", "desc":"Internal Error"},
    "NSERR_SSL_NOCACERT":{"errno":"0x620", "desc":"cacert does not exists"},
    "NSERR_SSL_REFRESHDIS":{"errno":"0x621", "desc":"crl refresh disabled"},
    "NSERR_SSL_SVRPORTNEEDED":{"errno":"0x622", "desc":"Server/port information is needed for enabling auto refresh"},
    "NSERR_SSL_BASEOBJNEEDED":{"errno":"0x623", "desc":"baseDN is required for enabling auto refresh"},
    "NSERR_SSL_CIPHER_REDIRECT":{"errno":"0x624", "desc":"Send Internal Cipher mismatch error page"},
    "NSERR_SSL_NODSA":{"errno":"0x625", "desc":"Loading of certificate and key of type DSA(DSS) is not supported with FIPS"},
    "NSERR_SSL_FIPSREFEXT":{"errno":"0x626", "desc":"The FIPS key is referenced by a certificate"},
    "NSERR_SSL_NOFIPSKEY":{"errno":"0x627", "desc":"No such FIPS key"},
    "NSERR_NOFIPSCARD":{"errno":"0x628", "desc":"Operation not permitted - no FIPS card present in the system"},
    "NSERR_FIPSCARDNOTCONF":{"errno":"0x629", "desc":"Operation not permitted - FIPS card is not configured"},
    "NSERR_SSL_SSLV2_REDIRECT":{"errno":"0x62A", "desc":"Send Internal SSL protocol mismatch error page"},
    "NSERR_SSL_MODSIZE64":{"errno":"0x62B", "desc":"Modulus size in bytes should be multiple of 64"},
    "NSERR_SSL_NONFIPSKEY":{"errno":"0x62C", "desc":"Configuration of non-FIPS key on FIPS system not allowed"},
    "NSERR_NFIPS_FIPS_UPD":{"errno":"0x62D", "desc":"Cannot update a non-FIPS certificate with a FIPS certificate"},
    "NSERR_FIPS_NFIPS_UPD":{"errno":"0x62E", "desc":"Cannot update a FIPS certificate with a non-FIPS certificate"},
    "NSERR_SSL_ISSUER_NOTIN_GLBCERTLIST":{"errno":"0x62F", "desc":"Unable to find the CA certificate for the CRL"},
    "NSERR_SSL_CRLSIGCHECK_FAIL":{"errno":"0x630", "desc":"Signature check on the CRL failed"},
    "NSERR_SSL_PORTREWRITE":{"errno":"0x631", "desc":"SSL port rewrite can be enabled only when SSL redirect is enabled"},
    "NSERR_SSL_SSLV2_RENEG_CLIENT_CERT":{"errno":"0x632", "desc":"Send Internal error page for SSLv2 protocol and client authentication with session renegotiation"},
    "NSERR_SSL_BRKLINK":{"errno":"0x633", "desc":"All incompatible CA links/Cert bindings were broken during the update operation"},
    "NSERR_SSL_CERT_NOT_YET_VALID":{"errno":"0x634", "desc":"The specified certificate is not yet valid"},
    "NSERR_SSL_CERT_EXPIRED":{"errno":"0x635", "desc":"The certificate has expired"},
    "NSERR_SSL_EXPIRED_BRKLINK":{"errno":"0x636", "desc":"All incompatible CA links were broken during the update operation. (Note: the certificate has expired)"},
    "NSERR_SSL_NYVALID_BRKLINK":{"errno":"0x637", "desc":"All incompatible CA links were broken during the update operation. (Note: the certificate is not yet valid)"},
    "NSERR_SSL_OCSP_RESPCERT":{"errno":"0x638", "desc":"No such responder certificate."},
    "NSERR_SSL_OCSP_SIGNCERT":{"errno":"0x639", "desc":"No such signing certificate."},
    "NSERR_SSL_NO_SESS_TKT":{"errno":"0x63A", "desc":"SESSION TKTS not Supported on FIPS platform"},
    "NSERR_SSL_OCSP_AIA":{"errno":"0x640", "desc":"Invalid AIA value"},
}

NS_SSL2_ERRORS = {
    "NSERR_SSL_FIPSCARDLOCKED":{"errno":"0xe00", "desc":"FIPS card locked due to three unsuccessful login attempts"},
    "NSERR_SSL_DOMINCOMPAT":{"errno":"0xe01", "desc":"Certificate is registered to a different domain; use the 'no domain check' option to force the operation"},
    "NSERR_SSL_NOMTHDCHANGE":{"errno":"0xe02", "desc":"Cannot change refresh method of CRL"},
    "NSERR_SSL_URLSRVRNEEDED":{"errno":"0xe03", "desc":"Either URL or server-IP required on CRL"},
    "NSERR_SSL_INVALID_URL":{"errno":"0xe04", "desc":"Invalid URL"},
    "NSERR_SSL_MIXPARAMS":{"errno":"0xe05", "desc":"LDAP and HTTP parameters cannot both be specified"},
    "NSERR_SSL_PKEY_MINSIZE":{"errno":"0xe06", "desc":"Certificate of size smaller than 512 bits not supported"},
    "NSERR_SSL_SYNCINPROGRESS":{"errno":"0xe07", "desc":"Another synchronization is already in process, please try again later"},
    "NSERR_SSL_SYNCFAILED":{"errno":"0xe08", "desc":"Synchronization failed, please try again"},
    "NSERR_SSL_CIPHGRP_REFCNT":{"errno":"0xe09", "desc":"Cipher group has bound entities or is referenced by an SSL vserver or SSL service"},
    "NSERR_SSL_CVM_NODSA":{"errno":"0xe0A", "desc":"Loading DSA(DSS) certificate and key not supported on this platform"},
    "NSERR_CERTHASHHEADER":{"errno":"0xe0B", "desc":"CertHash header tag mandatory if certHash is enabled"},
    "NSERR_SSL_CRLINREFRESH":{"errno":"0xe0C", "desc":"CRL refresh in progress, details cannot be displayed"},
    "NSERR_SSL_CRLMEM_EXCEEDS":{"errno":"0xe0D", "desc":"CRL memory exhausted. Cannot load any more CRL's"},
    "NSERR_SSL_CRLINDELETION":{"errno":"0xe0E", "desc":"CRL deletion in progress, details cannot be displayed"},
    "NSERR_SSL_INDELETE_NOREFRESH":{"errno":"0xe0F", "desc":"CRL deletion in progress, cannot be refreshed"},
    "NSERR_SSL_INREFRESH_NODELETE":{"errno":"0xe10", "desc":"CRL refresh in progress, cannot be removed"},
    "NSERR_NOMIX":{"errno":"0xe11", "desc":"Cannot specify both HTTP data insertion and SSL actions"},
    "NSERR_NOPOLICY_NONTRSVC":{"errno":"0xe12", "desc":"Cannot bind SSL policy to SSL backend service"},
    "NSERR_SSL_SSLPOL_BIND_CONST":{"errno":"0xe13", "desc":"Cannot bind non-SSL policy to SSL vserver/service"},
    "NSERR_SSL_NO_USABLE_CIPHERS":{"errno":"0xe14", "desc":"No usable ciphers configured on the SSL vserver/service"},
    "NSERR_SSL_CERT_NOT_CA":{"errno":"0xe15", "desc":"Not a CA certificate"},
    "NSERR_SSL_CACERT_NO_CRLSIGN":{"errno":"0xe16", "desc":"Specified certificate is either not a CA cert, or does not have privileges to issue CRLs"},
    "NSERR_SSL_CRL_EXPIRED":{"errno":"0xe17", "desc":"CRL has expired"},
    "NSERR_SSL_CRL_NOTYET_VALID":{"errno":"0xe18", "desc":"CRL is not yet valid"},
    "NSERR_SSL_PARSING_DELTA_CRL_EXTN":{"errno":"0xe19", "desc":"Parsing of Delta-CRL extension failed"},
    "NSERR_SSL_DELTA_CRL_MISSING_BASE_CRL":{"errno":"0xe1A", "desc":"Base-CRL for the specified Delta-CRL is missing"},
    "NSERR_NOFIPSCIPHER":{"errno":"0xe1B", "desc":"Specified cipher/cipher-alias is not FIPS-approved"},
    "NSERR_NOFIPSCIPHERGRP":{"errno":"0xe1C", "desc":"Cipher group does not contain all FIPS-approved ciphers"},
    "NSERR_NONFIPSCIPHERTOGRP":{"errno":"0xe1D", "desc":"Cannot add non FIPS approved cipher to cipher group"},
    "NSERR_NONFIPSALIASTOGRP":{"errno":"0xe1E", "desc":"Cannot add non FIPS approved cipher alias to cipher group"},
    "NSERR_NONFIPSGROUPTOGRP":{"errno":"0xe1F", "desc":"Cannot add non FIPS cipher group to another cipher group"},
    "NSERR_SSL_IMPORT_FIPSKEY_NAME_MISMATCH":{"errno":"0xe20", "desc":"Specified FIPS key name does not match with the exported FIPS key name"},
    "NSERR_SSL_PKEY_SIZE_CA":{"errno":"0xe21", "desc":"CA certificate of size greater than 4096 bits not supported"},
    "NSERR_SSL_CRL_PORT_MISMATCH":{"errno":"0xe22", "desc":"Port specified in URL does not match -port parameter"},
    "NSERR_SSL_PKEY_SIZE_VPX":{"errno":"0xe23", "desc":"Certificate with key size greater than RSA512 or DSA512 bits not supported"},
    "NSERR_SSL_DH_SIZE_VPX":{"errno":"0xe24", "desc":"DH params of size greater than 512 bits not supported"},
    "NSERR_NOENT_CIPHER":{"errno":"0xe25", "desc":"No such cipher/cipherAlias/cipherGroup"},
    "NSERR_FIPSFWWRONGMAJOR":{"errno":"0xe26", "desc":"The current firmware's major version is not supported for update operation"},
    "NSERR_FIPSFWWRONGMINOR":{"errno":"0xe27", "desc":"The current firmware's minor version is not supported for update operation"},
    "NSERR_FIPSFWUPDATED":{"errno":"0xe28", "desc":"The current firmware is already updated to 4.6.1"},
    "NSERR_SSL_PENDING_CMDS":{"errno":"0xe29", "desc":"Other commands (card health monitoring/traffic) are pending to FIPS card. Please try the firmware update command after some time"},
    "NSERR_FIPSFWUPDATEDOREBOOT":{"errno":"0xe2A", "desc":"Operation not permitted - FIPS card firmware update done, please reboot the system"},
    "NSERR_SSL_SNI_NOTENABLE":{"errno":"0xe2B", "desc":"SNI feature not enabled on the vserver/service"},
    "NSERR_SSL_NO_CN":{"errno":"0xe2C", "desc":"CommonName not present in certificate, it is must for a certificate to use for SNI"},
    "NSERR_SSL_DUP_SNICERT":{"errno":"0xe2D", "desc":"Trying to bind SNI certificate with duplicate CommonName, operation failed"},
    "NSERR_SSL_SNI_NOTVALID_SERV":{"errno":"0xe2E", "desc":"Operation not permitted - SNI feature not supported on SSL backend/internal service"},
    "NSERR_SSL_NOT_SUPPORTED_ON_PLATFORM":{"errno":"0xe2F", "desc":"Feature not supported on this platform"},
    "NSERR_OCSP_REFERENCES":{"errno":"0xe30", "desc":"OCSP responder is bound to a vserver/certkey pair.  Use unbind ssl certkey."},
    "NSERR_OCSP_SIGNER_NOKEY":{"errno":"0xe31", "desc":"Signing certificate must also have a private key."},
    "NSERR_SSL_NOT_SUPPORTED":{"errno":"0xe32", "desc":"OCSP responder must be an HTTP server; SSL is not supported."},
    "NSERR_OCSP_TOO_MANY_RESPONDERS":{"errno":"0xe33", "desc":"Too many OCSP responders configured to add another.  Please delete some and try again."},
    "NSERR_OCSP_NO_DNS_SERVER_CONFIGURED":{"errno":"0xe34", "desc":"Unable to resolve DNS name."},
    "NSERR_SSL_DUP_SNICERT_BRKLINK":{"errno":"0xe35", "desc":"Some of the existing SNI cert bindings are broken due to presence of certificate with duplicate Common Name."},
    "NSERR_SSL_NO_CN_BRLLINK":{"errno":"0xe36", "desc":"All exitsing SNI Cert bindings are broken during update operation due to missing Common Name."},
    "NSERR_NGFIPSRESETREBOOT":{"errno":"0xe37", "desc":"Operation not permitted - FIPS card was reset, please reboot the system"},
    "NSERR_NGFIPSINITREBOOT":{"errno":"0xe38", "desc":"Operation not permitted - FIPS card was initialized, please reboot the system"},
    "NSERR_FIPSCMDTIMEOUT":{"errno":"0xe39", "desc":"Operation timedout on the FIPS card, please try again"},
    "NSERR_SSL_SIMTIMEOUT":{"errno":"0xe3a", "desc":"Operation timed out or repeated, please wait for 10 mins and redo the SIM/HA configuration steps."},
    "NSERR_SSL_NGFIPS_QFULL":{"errno":"0xe3b", "desc":"FIPS card command queue full. Please try again later"},
    "NSERR_SSL_NOMEM_VSVRSRVLISTNODE":{"errno":"0xe3c", "desc":"Failed to allocate memory for CertkeyVserverServList Node."},
    "NSERR_SSL_CERTKEY_SIZE64":{"errno":"0xe3d", "desc":"Certificate with key size (modulus) that is not multiple of 512 bits is not supported"},
    "NSERR_SNI_ATK":{"errno":"0xe3e", "desc":"Host header field in the HTTP request does not match with the SNI domain name"},
    "NSERR_SNI_NOHOSTHDR":{"errno":"0xe3f", "desc":"Host header missing in the HTTP header for SNI enabled session"},
    "NSERR_CRL_SHMEM_ALLOC_FAIL":{"errno":"0xe40", "desc":"Crl node allocation in the shared mem is failed"},
    "NSERR_SSL_PE_NO_SET_UNSET":{"errno":"0xe41", "desc":"Set/Unset operation not supported for classic SSL polices"},
    "NSERR_SSL_NOT_CTL_POL":{"errno":"0xe42", "desc":"Not a control policy"},
    "NSERR_SSL_NOT_DATA_POL":{"errno":"0xe43", "desc":"Not a data policy"},
    "NSERR_SSL_TYPE_REQD":{"errno":"0xe44", "desc":"Type is required"},
    "NSERR_SSL_NOT_PI_POL":{"errno":"0xe45", "desc":"Advanced policy attributes specified with classic policy"},
    "NSERR_SSL_PE_POL_POL_LBL":{"errno":"0xe46", "desc":"Cannot bind classic policy to policy label"},
    "NSERR_SSL_CERT_MISSING_PARAM":{"errno":"0xe47", "desc":"Required parameters missing in the certificate. Please check the certificate for completeness"},
    "NSERR_SSL_NOMEM_CERTKEY_OCSPRESP_LISTNODE":{"errno":"0xe48", "desc":"Failed to allocate memory for CertkeyOCSPRespList Node."},
    "NSERR_SSL_OCSP_DUPLICATE":{"errno":"0xe49", "desc":"An ocspResponder is already bound with the specified priority."},
    "NSERR_SSL_BIND_CP":{"errno":"0xe4a", "desc":"Binding of SSL classic policy is not supported, use equivalent advanced SSL policy"},
    "NSERR_SSL_ADD_CP":{"errno":"0xe4b", "desc":"Adding SSL classic policy is not supported, use equivalent advanced rule"},
    "NSERR_SSL_BUNDLE_IC_FILE_EXISTS":{"errno":"0xe4c", "desc":"Certificate file for intermediate certificate already exists."},
    "NSERR_SSL_BUNDLE_SCERT_MISSING":{"errno":"0xe4d", "desc":"Server certificate must be placed first in certificate bundle file."},
    "NSERR_SSL_BUNDLE_CERT_MISSING":{"errno":"0xe4e", "desc":"No certificates present in the certificate bundle file."},
    "NSERR_SSL_BUNDLE_FAILED":{"errno":"0xe4f", "desc":"Processing of certificate bundle file failed."},
    "NSERR_SSL_BUNDLE_PARSE_ERR":{"errno":"0xe50", "desc":"Unable to parse the certificate bundle file."},
    "NSERR_SSL_BUNDLE_MAX_CERT":{"errno":"0xe51", "desc":"Exceeded maximum Intermediate certificates limit of 9."},
    "NSERR_SSL_BUNDLE_MAX_KEY":{"errno":"0xe52", "desc":"Only one private-key is allowed in the certificate bundle file."},
    "NSERR_SSL_BUNDLE_IC_FILE_CREATE_FAILED":{"errno":"0xe53", "desc":"Intermediate certificate file creation failed."},
    "NSERR_SSL_SKIPCA_OPNOTPER":{"errno":"0xe54", "desc":"skipCA is not permitted for this entity."},
    "NSERR_SSL_ISSUER_MISMATCH":{"errno":"0xe55", "desc":"Certificate Issuer mismatch"},
    "NSERR_SSL_SET_POLICY_ACTION_TYPE":{"errno":"0xe56", "desc":"Action type cannot be changed from the previous configured action type"},
    "NSERR_SSL_DTLS_NOTSUPP":{"errno":"0xe57", "desc":"Virtual server of type DTLS is not supported on this platform"},
    "NSERR_SSL_INVALID_CN_NAME":{"errno":"0xe58", "desc":"Invalid Common Name."},
    "NSERR_SSL_ECC_NOT_SUPPORTED":{"errno":"0xe59", "desc":"ECDHE ciphers supported only on FE SSL entities on VPX,MPX and BE MPX"},
    "NSERR_SSL_NO_PROTOCOL_ENABLED":{"errno":"0xe5a", "desc":"SSL or TLS protocols not enabled on the service."},
    "NSERR_DTLS_PROFILE_REFEXT":{"errno":"0xe5c", "desc":"DTLS profile is referenced by a vserver or front-end service."},
    "NSERR_SSL_NO_ECC_CURVES":{"errno":"0xe5d", "desc":"No ECC curves bound for ECDHE ciphers."},
    "NSERR_CRYPTODEV_MAX_LIMIT":{"errno":"0xe5e", "desc":"Crypto Device count exceeds maximum available."},
    "NSERR_SSL_PROFILE_ATTACHED":{"errno":"0xe5f", "desc":"Operation not permitted. Use set ssl profile for setting these parameters."},
    "NSERR_SSL_PROFILE_USED":{"errno":"0xe60", "desc":"Profile is being used by Virtual Server, Service or Monitor."},
    "NSERR_SSL_PROFILE_NOT_VAILD_PARAM":{"errno":"0xe61", "desc":"Specified parameters are not applicable for this type of SSL profile."},
    "NSERR_IMPORT_SSL_INVALID_DHFILE_ERROR_OBJECT":{"errno":"0xe62", "desc":"Import failed:DH file being imported is invalid."},
    "NSERR_IMPORT_SSL_INVALID_CRLFILE_ERROR_OBJECT":{"errno":"0xe63", "desc":"Import failed:CRL file being imported is invalid."},
    "NSERR_IMPORT_SSL_INVALID_CERTFILE_ERROR_OBJECT":{"errno":"0xe64", "desc":"Import failed:Certificate file being imported is invalid"},
    "NSERR_IMPORT_SSL_INVALID_KEYFILE_ERROR_OBJECT":{"errno":"0xe65", "desc":"Import failed:Key file being imported is invalid"},
    "NSERR_FIPSFW_FILEPATH":{"errno":"0xe66", "desc":"Invalid firmware file path"},
    "NSERR_FIPSFW_FILEOPEN":{"errno":"0xe67", "desc":"Unable to open firmware file"},
    "NSERR_FIPSFW_FILEIO":{"errno":"0xe68", "desc":"Read error occurred for firmware file"},
    "NSERR_FIPSFW_FSTAT":{"errno":"0xe69", "desc":"Failed to get status of firmware file"},
    "NSERR_FIPSFW_AUTH_FILEPATH":{"errno":"0xe6a", "desc":"Invalid firmware signature file path"},
    "NSERR_FIPSFW_AUTH_FILEOPEN":{"errno":"0xe6b", "desc":"Unable to open firmware signature file"},
    "NSERR_FIPSFW_AUTH_FILEIO":{"errno":"0xe6c", "desc":"Read error occurred for firmware signature file"},
    "NSERR_FIPSFW_AUTH_FSTAT":{"errno":"0xe6d", "desc":"Failed to get status of firmware signature file"},
    "NSERR_FIPSFW_BEGIN_ERROR":{"errno":"0xe6e", "desc":"Firmware update process failed BEGIN command"},
    "NSERR_FIPSFW_UPDATE_ERROR":{"errno":"0xe6f", "desc":"Firmware update process failed UPDATE command"},
    "NSERR_FIPSFW_END_ERROR":{"errno":"0xe70", "desc":"Firmware update process failed END command"},
    "NSERR_FIPSFW_STATE_ERROR":{"errno":"0xe71", "desc":"Firmware update process failed, invalid state"},
    "NSERR_FIPSFW_INVALID_CHUNK_TYPE":{"errno":"0xe72", "desc":"Firmware update process failed, invalid chunk type"},
    "NSERR_SSL_OCSP_WITH_CK_HSMKEY":{"errno":"0xe73", "desc":"Configuration of OCSP signing certificate with external HSM key not supported."},
    "NSERR_SSL_HSMKEY_DEFLOCATION":{"errno":"0xe74", "desc":"Input HSM Key Simple file not present under the default directory /var/opt/nfast/kmdata/local/"},
    "NSERR_SSL_HSMKEY_IDENT_MISMATCH":{"errno":"0xe75", "desc":"HSM Key Name must be same as HSM Key Ident"},
    "NSERR_SSL_HSMKEY_DTLS":{"errno":"0xe76", "desc":"HSM Key bind with DTLS Vserver is not supported."},
    "NSERR_SSL_HSMKEY_BUNDLE":{"errno":"0xe77", "desc":"Addition of certificate-bundle with external HSM Key is not supported."},
    "NSERR_CPE_EXPRESSION_PARTITION_INVALID":{"errno":"0xe78", "desc":"Classic expression is not supported in current partition."},
    "NSERR_AP_INVALID_EXPRESSION":{"errno":"0xe79", "desc":"Expression value not supported."},
    "NSERR_SSL_DH_BUSY":{"errno":"0xe7a", "desc":"DH Param in use. Please try later..."},
    "NSERR_FIPSFW22_MINKEYSIZE":{"errno":"0xe7b", "desc":"Key size less than 2048 is not supported on FIPS Firmware Version 2.2."},
    "NSERR_SSL_MAXSAN":{"errno":"0xe7c", "desc":"Maximum number of SANs reached"},
    "NSERR_SSL_BADSNICERT":{"errno":"0xe7d", "desc":"Bad SNI certificate"},
    "NSERR_SSL_AESGCM_SHA2_NOT_SUPPORTED":{"errno":"0xe7e", "desc":"SHA2 ciphers not supported on VPX and FIPS"},
    "NSERR_SSL_NOCIPHERGRP":{"errno":"0xe7f", "desc":"Cipher Group does not exist."},
    "NSERR_SSL_SVCVSR_NOT_FOUND":{"errno":"0xe80", "desc":"No SSL vserver/service found with this name."},
    "NSERR_SSL_DEF_DTLS_PROFILE":{"errno":"0xe81", "desc":"Cannot modify default DTLS profile."},
    "NSERR_SSL_NOSSLV2REDIRECTOPT_ON_FIPS":{"errno":"0xe82", "desc":"Sslv2 Redirect option is not permitted on MPX-FIPS platform."},
    "NSERR_SSL_OP_ON_NONFIPS_NOT_PERM":{"errno":"0xe83", "desc":"Operation permitted only on MPX-FIPS platform."},
    "NSERR_SSL_LOAD_KEYS":{"errno":"0xe84", "desc":"Loading of internal keys failed."},
    "NSERR_SSL_PASSWORD_DECODE":{"errno":"0xe85", "desc":"Decode of the encrypted passphrase failed."},
    "NSERR_SSL_NOCERT_FILE":{"errno":"0xe86", "desc":"Certificate file name not specified."},
    "NSERR_SSL_DEFAULT_CERT_DEL":{"errno":"0xe87", "desc":"Cannot delete internal default certificate."},
    "NSERR_SSL_FIPS_CERT":{"errno":"0xe88", "desc":"FIPS certificate cannot be bound as a CA certificate, install the certificate without the FIPS key."},
    "NSERR_SSL_CERTKEY_HSM":{"errno":"0xe89", "desc":"Cannot bind a certificate with HSM key to a service."},
    "NSERR_SSL_DEFAULT_CERT_BIND":{"errno":"0xe8a", "desc":"Cannot bind internal default certificate."},
    "NSERR_SSL_CMD_DEPRECATED":{"errno":"0xe8b", "desc":"Command deprecated, operation not applicable to this platform."},
    "NSERR_SSL_NO_LIC":{"errno":"0xe8c", "desc":"Only export ciphers are allowed without proper SSL license."},
    "NSERR_SSL_DTLS_NA":{"errno":"0xe8d", "desc":"Command arguments does not apply to vserver/service of type DTLS."},
    "NSERR_SSL_ECC_SUPPORT":{"errno":"0xe8e", "desc":"ECC curve is not supported for this entity/platform."},
    "NSERR_SSL_PROFILE_FE":{"errno":"0xe8f", "desc":"Cannot bind front-end profile to a back-end SSL service."},
    "NSERR_SSL_PROFILE_BE":{"errno":"0xe90", "desc":"Cannot bind back-end profile to a front-end SSL vserver."},
    "NSERR_SSL_OP_ON_FIPS_WOFW22_NOT_PERM":{"errno":"0xe91", "desc":"Operation not permitted on MPX-FIPS platform without FIPS firmware version 2.2 or higher."},
    "NSERR_SSL_NONSSL_VSERVER":{"errno":"0xe92", "desc":"Vserver is not of type SSL."},
    "NSERR_SSL_UDP_DTLS":{"errno":"0xe93", "desc":"Cannot bind policy to vserver of type DTLS."},
    "NSERR_SSL_TLS11_12_SUPPORT":{"errno":"0xe94", "desc":"Enabling of TLSv1.1/1.2 is not supported on this entity/platform."},
    "NSERR_SSL_HSM_KEY_SVC_SVCGRP":{"errno":"0xe95", "desc":"Binding of certificate with HSM key is not supported on back-end service, serviceGroup or monitors."},
    "NSERR_DTLS_PROFILE":{"errno":"0xe96", "desc":"Cannot bind DTLS profile to a SSL vserver."},
    "NSERR_SSL_PROFILE_NO_USABLE_CIPHERS":{"errno":"0xe97", "desc":"No usable ciphers configured for some of the SSL vserver/service binded to this profile"},
    "NSERR_SSL_CIPHGRP_NO_USABLE_CIPHERS":{"errno":"0xe98", "desc":"No usable ciphers configured for some of the SSL vserver/service binded to this cipher group"},
    "NSERR_SSL_PROFILE_UNSET_DEFAULT":{"errno":"0xe99", "desc":"Unsetting a default SSL Profile is not allowed"},
    "NSERR_SSL_DEFAULT_PROFILE_ENABLED":{"errno":"0xe9a", "desc":"Disabling ssl default profile is not allowed"},
    "NSERR_SSL_PROFILE_DEFAULT_DISABLED":{"errno":"0xe9b", "desc":"Operation not permitted. To do this Enable default ssl profile by setting 'set ssl parameter -defaultProfile E'"},
    "NSERR_SSL_PROFILE_DEFAULT_ENABLED":{"errno":"0xe9c", "desc":"Operation not permitted. Use profile command to do this operation"},
    "NSERR_SSL_CIPHER_EXIST_HIGHER_PRI":{"errno":"0xe9d", "desc":"Specified cipher is already bound with higher priority"},
    "NSERR_SSL_DEFAULT_PROFILE_PERM":{"errno":"0xe9e", "desc":"Default ssl profile can not be removed"},
    "NSERR_SSL_DH_SIZE_16B":{"errno":"0xe9f", "desc":"DH params of size is not 16B aligned"},
    "NSERR_SSL_NOCIPHERREDIRECTOPT":{"errno":"0xea0", "desc":"The cipher redirect option is not supported for SSL Service"},
    "NSERR_SSL_NOCLIENTAUTHOPT":{"errno":"0xea1", "desc":"The client auth option is not supported for SSL Service"},
    "NSERR_SSL_NOSSLV2REDIRECTOPT":{"errno":"0xea2", "desc":"The SSLv2 redirect option is not supported for SSL Service"},
    "NSERR_SSL_NONONFIPSCIPHERSOPT":{"errno":"0xea3", "desc":"The nonFipsCiphers option is not applicable any more"},
    "NSERR_SSL_NOCIPHERREDIRECTOPT_ON_FIPS":{"errno":"0xea4", "desc":"Cipher Redirect option is not permitted on MPX-FIPS platform."},
    "NSERR_SSL_NOSSL2PROTOOPT_ON_FIPS":{"errno":"0xea5", "desc":"Ssl2 protocol option is not permitted on MPX-FIPS platform."},
    "NSERR_SSL_CANNOT_BIND_VSERVER":{"errno":"0xea6", "desc":"Front end service cannot be bound to a vserver."},
    "NSERR_SSL_SERVERAUTHNOTSUPP":{"errno":"0xea7", "desc":"ServerAuth Operation is not supported for front end service."},
    "NSERR_SSL_SERVERAUTH_SNI_REQUIRED":{"errno":"0xea8", "desc":"Argument pre-requisite missing serverAuth == ENABLED or SNIEnable == ENABLED"},
    "NSERR_SSL_CN_REQUIRED":{"errno":"0xea9", "desc":"Argument pre-requisite missing commonName"},
    "NSERR_SSL_DTLSPROFNOTSUPP":{"errno":"0xeaa", "desc":"Cannot set DTLS Profile Name for a ssl service."},
    "NSERR_SSL_PUSHENCNOTSUPP":{"errno":"0xeab", "desc":"Push encryption trigger is not supported for SSL Service."},
    "NSERR_N3FIPS_MINKEYSIZE":{"errno":"0xeac", "desc":"Key size less than 2048 is not supported on N3FIPS"},
    "NSERR_N3FIPS_MAXKEYSIZE":{"errno":"0xead", "desc":"Key size more than 3072 is not supported on N3FIPS"},
    "NSERR_N3FIPS_MINEXPSIZE":{"errno":"0xeae", "desc":"N3FIPS only supports F4(65537) as an exponent"},
    "NSERR_SSL_OCSPNAMENOTSUPP":{"errno":"0xeaf", "desc":"Ocsp responder name should not start with INTERNAL."},
    "NSERR_SSL_OCSP_NOT_VALID_PARAM":{"errno":"0xeb0", "desc":"Specified parameters are not applicable for this type of ocsp responder."},
    "NSERR_SSL_NOOCSPSTAP":{"errno":"0xeb1", "desc":"Ocsp stapling option is not supported for SSL Service."},
    "NSERR_SSL_CREATE_AIA_OCSP_RESP_FAILED":{"errno":"0xeb2", "desc":"Failed to create/bind Internal Ocsp responder(using certkey AIA URL)."},
    "NSERR_N3FIPDEXUPGRADE":{"errno":"0xeb3", "desc":"N3FIPS VPX does not support upgrade firmware operation"},
    "NSERR_N3FIP_MAXKEYNUM":{"errno":"0xeb4", "desc":"Maximum Fips keys limit reached"},
    "NSERR_FIPSCARDCONFIGED":{"errno":"0xeb5", "desc":"Fips is already configured, please reset first to set fips again"},
    "NSERR_N3FIPSCHANGELIC":{"errno":"0xeba", "desc":"N3FIPS license is changed, please reboot the system"},
}

NS_GENTOOL_ERRORS = {
    "NSERR_SSL_CONFFILE":{"errno":"0x641", "desc":"Error in SSL conf file"},
    "NSERR_SSL_NOCONFFILE":{"errno":"0x642", "desc":"Unable to load SSL configuration info"},
    "NSERR_SSL_SIGFAIL":{"errno":"0x643", "desc":"Signing operation failed"},
    "NSERR_SSL_INVALFORMAT":{"errno":"0x644", "desc":"Invalid format"},
    "NSERR_SSL_OUTFILE":{"errno":"0x645", "desc":"Problem in writing output file"},
    "NSERR_SSL_VERIFY_FAIL":{"errno":"0x646", "desc":"Signature verification failed"},
    "NSERR_SSL_FILECREATE":{"errno":"0x647", "desc":"Unable to create output file"},
    "NSERR_SSL_MINKEYSIZE":{"errno":"0x648", "desc":"Key size less than 1024 is not supported on FIPS Firmware Version 1.1."},
    "NSERR_SSL_INVALID_REQ":{"errno":"0x649", "desc":"Invalid certificate request"},
    "NSERR_SSL_GENTOOL":{"errno":"0x64A", "desc":"Internal failure in SSL cert/key generation tool"},
    "NSERR_SSL_PEM_ONLY":{"errno":"0x64B", "desc":"Only PEM format private key can be encrypted"},
    "NSERR_SSL_PASSMISMATCH":{"errno":"0x64C", "desc":"Password verification failed"},
    "NSERR_SSL_PASSREQ":{"errno":"0x64D", "desc":"Password required for private key"},
    "NSERR_SSL_INVALPASS":{"errno":"0x64E", "desc":"Invalid password"},
    "NSERR_SSL_MAXKEYSIZE":{"errno":"0x64F", "desc":"Maximum allowed key size is 2048"},
    "NSERR_SSL_GNTOOLARG_MISSING":{"errno":"0x650", "desc":"Required argument missing"},
    "NSERR_SSL_INVAL_PUBEXP":{"errno":"0x651", "desc":"Invalid public exponent value"},
    "NSERR_SSL_INVALID_VALUE":{"errno":"0x652", "desc":"Invalid value"},
    "NSERR_SSL_MISSING_KVAL":{"errno":"0x653", "desc":" Value missing for the argument"},
    "NSERR_SSL_INVAL_DHGEN":{"errno":"0x654", "desc":"Invalid DH generator value"},
    "NSERR_SSL_NOFILE_CERTREQ":{"errno":"0x655", "desc":"No such certificate request file exists"},
    "NSERR_SSL_REQ_NOMATCH":{"errno":"0x656", "desc":"Certificate Request (CSR) and private key do not match"},
    "NSERR_SSL_PKCS12":{"errno":"0x657", "desc":"Problem in input PKCS12 file"},
    "NSERR_SSL_NOFILE_CAPVTKEY":{"errno":"0x658", "desc":"No such CA key file present"},
    "NSERR_SSL_NOFILE_CACERT":{"errno":"0x659", "desc":"No such CA certificate file exists"},
    "NSERR_SSL_NOFILE_SERIAL":{"errno":"0x65A", "desc":"No such serial file exists"},
    "NSERR_SSL_NOFILE_PKCS12":{"errno":"0x65B", "desc":"No such PKCS12 file exists"},
    "NSERR_SSL_READ_CACERT":{"errno":"0x65C", "desc":"In reading input CA certficate file"},
    "NSERR_READ_CERT":{"errno":"0x65D", "desc":"Error in reading input certficate file"},
    "NSERR_IMP_EXP_NOT_TOGETHER":{"errno":"0x65E", "desc":"Import and export can not be specified together"},
    "NSERR_NOFILE_CERT":{"errno":"0x65F", "desc":"No such certificate file exists"},
    "NSERR_NOFILE_KEY":{"errno":"0x660", "desc":"No such key file exists"},
    "NSERR_CACERTPKEY_MISMATCH":{"errno":"0x661", "desc":"CA certificate not matching with CA private-key"},
    "NSERR_WRONG_REV_ENTRY":{"errno":"0x662", "desc":"Invalid revocation entry in CA's database"},
    "NSERR_WRONG_REV_DATE":{"errno":"0x663", "desc":"Invalid revocation data in CA's database"},
    "NSERR_WRONG_SERIAL_NO":{"errno":"0x664", "desc":"Invalid serial number in CA's database"},
    "NSERR_CREATE_DATABASE_ENTRY":{"errno":"0x665", "desc":"Revocation entry creation failed"},
    "NSERR_ALREADY_REVKD":{"errno":"0x666", "desc":"Certificate already revoked"},
    "NSERR_LOAD_PKEY":{"errno":"0x667", "desc":"Private key loading failed"},
    "NSERR_CERTPKEY_NEEDED":{"errno":"0x668", "desc":"Both certificate and private key are needed for export"},
    "NSERR_PKCS12_NEEDED":{"errno":"0x669", "desc":"PKCS12 file missing for import"},
    "NSERR_ERR_FILEEXISTS":{"errno":"0x66A", "desc":"Cannot create output file. File already exists"},
    "NSERR_FIPSKEY_KEYFILE_OPTION":{"errno":"0x66B", "desc":"Both -keyFileName and -fipsKeyName cannot be specified"},
    "NSERR_OUTFILELENBIG":{"errno":"0x66C", "desc":"Output file name too long"},
    "NSERR_SSL_DEFPATH":{"errno":"0x66D", "desc":"Output filepath should be under the partition's default SSL directory"},
    "NSERR_SSL_CRL_DEFPATH":{"errno":"0x66E", "desc":"Output CRL filepath should be under the partition's default CRL directory"},
    "NSERR_SSL_DEFLOCATION":{"errno":"0x66F", "desc":"Input file(s) not present or not accessible in current partition"},
    "NSERR_DHREQD":{"errno":"0x6FF", "desc":"DH required"},
    "NSERR_SSL_CRL_DEFLOCATION":{"errno":"0x672", "desc":"Input CRL file not present or not accessible in current partition"},
    "NSERR_SSL_NOFIPS_KEY":{"errno":"0x673", "desc":"No such FIPS key"},
    "NSERR_SSL_IMPROPER_SERIALFILE":{"errno":"0x674", "desc":"Invalid serial file"},
    "NSERR_SSL_SERIAL_NUM_REVOKED":{"errno":"0x675", "desc":"Certificate serial number match with another certificate already revoked in the CRL"},
    "NSERR_SSL_MAXRSAKEYSIZE":{"errno":"0x676", "desc":"Maximum allowed key size is 4096"},
    "NSERR_SSL_MUSTBEPEM":{"errno":"0x677", "desc":"The input file must be in PEM or SIM format."},
    "NSERR_SSL_CANTBEPEM":{"errno":"0x678", "desc":"The input file cannot be in PEM format."},
    "NSERR_SSL_BAD_LABEL":{"errno":"0x679", "desc":"The keylabel cannot be 'public' or 'private'."},
    "NSERR_SSL_HSMKEY_LOAD":{"errno":"0x680", "desc":"Unable to Load Key in external Hardware Security Module (HSM)."},
    "NSERR_SSL_HSMKEY_PPE":{"errno":"0x681", "desc":" Internal error while adding HSM key."},
    "NSERR_ERR_SSL_HSMKEY_EXISTS":{"errno":"0x682", "desc":"HSM Key already exists."},
    "NSERR_ERR_SSL_HSMKEY_DELETE":{"errno":"0x683", "desc":"Unable to Delete Key in external Hardware Security Module (HSM)."},
    "NSERR_ERR_SSL_HSMKEY_NOENT":{"errno":"0x684", "desc":"No such resource."},
    "NSERR_ERR_SSL_HSMKEY_REFEXT":{"errno":"0x685", "desc":"The HSM key is referenced by a certificate"},
    "NSERR_ERR_SSL_HSMKEY_NOTEXISTS":{"errno":"0x686", "desc":"No such HSM key."},
    "NSERR_ERR_SSL_HSMKEY":{"errno":"0x687", "desc":"HSM Key Unknown Error, Probably debugging."},
    "NSERR_ERR_SSL_GW_NOTUP":{"errno":"0x688", "desc":"Gateway daemon is booting up please wait for 20 to 30 secs."},
    "NSERR_ERR_SSL_HSMKEY_FIPS":{"errno":"0x689", "desc":"Operation not permitted on a MPX-FIPS System."},
    "NSERR_ERR_SSL_SANCERT_DUP":{"errno":"0x68A", "desc":"Duplicate domain cert cannot be added."},
    "NSERR_SSL_ECDSA_SUPPORT":{"errno":"0x68B", "desc":"ECDSA Certifciates are not supported for this entity/platform."},
    "NSERR_SSL_ECDSA_CURVE_SUPPORT":{"errno":"0x68C", "desc":"The EC curve in the ECDSA Certifciate is not supported."},
    "NSERR_SSL_LINK_LOOP":{"errno":"0x68D", "desc":"Certificate can't be linked. This is creating a loop."},
    "NSERR_SSL_N3FIPSREBOOT":{"errno":"0x68E", "desc":"N3FIPS InitHSM is not done, Please reboot again"},
    "NSERR_SSL_N3FIPS_FILECREATE":{"errno":"0x68F", "desc":"FIPS config folder /nsconfig/fips is not present, please create it manually and reboot the system, after reboot reset and set fips again"},
    "NSERR_SSL_SIGHASH_SUPPORT":{"errno":"0x690", "desc":"List contains unsupported SigHash type for this entity/platform."},
}

NS_GSLB_ERRORS = {
    "NSERR_BAD_DNS_OPTION":{"errno":"0x700", "desc":"Invalid DNS option specified"},
    "NSERR_DNS_BAD_CACHETYPE":{"errno":"0x701", "desc":"Only forward cache type can bind to DNS vserver"},
    "NSERR_DNS_NOTAVAIL":{"errno":"0x702", "desc":"No such DNS vserver exists"},
    "NSERR_DNS_BAD_VSTYPE":{"errno":"0x703", "desc":"DNS vserver can only be address-based"},
    "NSERR_GSLB_SITELKUP_FAILED":{"errno":"0x704", "desc":"GSLB site not found"},
    "NSERR_GSLBBOUNDTO_CSACT":{"errno":"0x705", "desc":"The GSLB Vserver referred by Content Switching action cannot be removed"},
    "NSERR_GSLBREFFERED_IN_CSBINDING":{"errno":"0x706", "desc":"Cannot remove GSLB Vserver which is reffered in CS policy bindings"},
    "NSERR_NOAREC":{"errno":"0x709", "desc":"Address record for host name not available"},
    "NSERR_INVALTTL":{"errno":"0x70E", "desc":"Invalid TTL value"},
    "NSERR_CNAMEEXISTS":{"errno":"0x70F", "desc":"Alias name record exists for the host name"},
    "NSERR_INVAL_SVCOPTION":{"errno":"0x710", "desc":"Option not applicable for this service"},
    "NSERR_GSLBBIND_EXISTS":{"errno":"0x711", "desc":"GSLB binding exists for the given host"},
    "NSERR_NOT_LOCALREMOTE":{"errno":"0x712", "desc":"Site information must be specified for a GSLB service"},
    "NSERR_COUNT_MISMATCH":{"errno":"0x713", "desc":"Address record count does not match the number of services bound to the GSLB vserver"},
    "NSERR_IP_MISMATCH":{"errno":"0x714", "desc":"IP addresses of bound GSLB services and the address records do not match"},
    "NSERR_SVCIP_REPEAT":{"errno":"0x715", "desc":"A GSLB service with the same IP address is already bound to the GSLB vserver"},
    "NSERR_NOT_REMOTE":{"errno":"0x716", "desc":"Service bound to GSLB VIP with -gslb remote is a local service"},
    "NSERR_NOT_LOCAL":{"errno":"0x717", "desc":"Service bound to GSLB VIP with -gslb local is not a local service"},
    "NSERR_PROXY_REC":{"errno":"0x718", "desc":"A proxy record cannot be assigned to the domain"},
    "NSERR_NOPROXY_AREC":{"errno":"0x719", "desc":"Proxy address records cannot be bound to a GSLB vserver"},
    "NSERR_SVC_GSLBBIND_EXISTS":{"errno":"0x71B", "desc":"GSLB binding exists - unbind the GSLB vserver first"},
    "NSERR_SVCTYPEMISMATCH":{"errno":"0x71C", "desc":"Service type mismatch with existing service/vserver"},
    "NSERR_INVALID_PUBIP_OPTION":{"errno":"0x71E", "desc":"The public IP and public port are valid only for GSLB local service"},
    "NSERR_INVAL_NAME_SYNTAX":{"errno":"0x71F", "desc":"Invalid domain name syntax"},
    "NSERR_GSLB_BACKUP":{"errno":"0x720", "desc":"Backup VIP is backup of other GSLB VIP. Please unset the existing association and try again"},
    "NSERR_IS_BACKUP":{"errno":"0x721", "desc":"Backup VIP is backup of other VIP. Please unset the existing association and try again"},
    "NSERR_GSLB_HAS_BACKUP":{"errno":"0x722", "desc":"GSLB VIP has a backup. Please unset the backup and try the operation again"},
    "NSERR_GSLB_REQUIRES_INDEPENDENT_BACKUP":{"errno":"0x723", "desc":"Backup VIP to GSLB VIP must not be backup of any other VIP. Please unset the backup and try the operation again"},
    "NSERR_GSLB_NOQUALIFIER":{"errno":"0x724", "desc":"At least one qualifier should be given for the location"},
    "NSERR_GSLB_NONAME":{"errno":"0x725", "desc":"The qualifier does not exist in the repository"},
    "NSERR_GSLB_CUSTOM_NOSPACE":{"errno":"0x726", "desc":"Too many custom locations"},
    "NSERR_GSLB_STATIC_NOSPACE":{"errno":"0x72C", "desc":"Too many static locations"},
    "NSERR_GSLBSITENAME_EXISTS":{"errno":"0x727", "desc":"A GSLB site with the same name exists"},
    "NSERR_GSLBSITEIP_EXISTS":{"errno":"0x728", "desc":"A GSLB site with the same IP address exists"},
    "NSERR_NO_GSLBSITE":{"errno":"0x729", "desc":"The GSLB site does not exist"},
    "NSERR_LOCAL_EXISTS":{"errno":"0x72A", "desc":"The local site already exists"},
    "NSERR_NO_GSLBSVC":{"errno":"0x72B", "desc":"The GSLB service does not exist"},
    "NSERR_NO_GSLBVIP":{"errno":"0x72D", "desc":"The GSLB vserver does not exist"},
    "NSERR_NO_DMN":{"errno":"0x72F", "desc":"The domain does not exist"},
    "NSERR_DMN_NOTBOUND":{"errno":"0x730", "desc":"The domain is not bound to this VIP"},
    "NSERR_GSLBDOMAIN_BOUND":{"errno":"0x732", "desc":"The domain is already bound to a GSLB vserver"},
    "NSERR_NOT_GSLBENT":{"errno":"0x734", "desc":"Operation not permitted on a non-GSLB entity"},
    "NSERR_GSLBDOMAIN_PERM":{"errno":"0x735", "desc":"Operation not permitted on a GSLB-configured domain"},
    "NSERR_GSLB_MAXQUAL":{"errno":"0x736", "desc":"Maximum qualifiers allowed is six"},
    "NSERR_GSLB_MAXLOCLENGTH":{"errno":"0x737", "desc":"Maximum allowed location length is 256 characters"},
    "NSERR_GSLBVIP_PERM":{"errno":"0x738", "desc":"Operation not permitted on a GSLB vserver"},
    "NSERR_GSLBSVC_PERM":{"errno":"0x739", "desc":"Operation not permitted on a GSLB service"},
    "NSERR_GSLB_MAXSITES":{"errno":"0x73A", "desc":"Maximum number of sites is 32"},
    "NSERR_GSLB_QUALTOOLONG":{"errno":"0x73B", "desc":"The qualifier is too long"},
    "NSERR_GSLB_PERSISTIDEXISTS":{"errno":"0x73C", "desc":"The persistence ID is already being used by a GSLB vserver"},
    "NSERR_GSLB_INVLD_LDNSTO_INTVL":{"errno":"0x73E", "desc":"Minimum LDNS entry timeout interval is 30 secs"},
    "NSERR_VIP_BACKUP_ISGSLB":{"errno":"0x740", "desc":"GSLB vserver cannot be backup of a non-GSLB vserver"},
    "NSERR_GSLB_PUBIP_PUBPORT_EXISTS":{"errno":"0x741", "desc":"The public IP and public port are being used by another GSLB service"},
    "NSERR_GSLBLOCALSVC_ENADIS_NOTALLOWED":{"errno":"0x742", "desc":"GSLB local service status not changed - please enable or disable the corresponding LB vserver instead"},
    "NSERR_GSLBLOCALSVR_ENADIS_NOTALLOWED":{"errno":"0x743", "desc":"Server status not changed - the server has a GSLB local service"},
    "NSERR_INVALID_PERSISTID":{"errno":"0x744", "desc":"Invalid persistence ID"},
    "NSERR_PERM_PERSISTID":{"errno":"0x745", "desc":"The persistence ID is required for persistence or spillover-persistency to be set"},
    "NSERR_INVALID_LOCALSITEIP":{"errno":"0x746", "desc":"Invalid GSLB local site IP address"},
    "NSERR_INVALID_REMOTESITEIP":{"errno":"0x747", "desc":"Invalid GSLB remote site IP address"},
    "NSERR_INVALID_SITETYPE":{"errno":"0x748", "desc":"Invalid GSLB site type"},
    "NSERR_INVALID_BACKUPIP":{"errno":"0x749", "desc":"Invalid backup IP for the GSLB domain"},
    "NSERR_GSLBVIP_MAXSVC":{"errno":"0x74A", "desc":"Cannot bind more than 32 services to a GSLB vserver"},
    "NSERR_INVALID_JITTER":{"errno":"0x74B", "desc":"RTT tolerance value must be between 1 and 100"},
    "NSERR_GSLBLOCSVC_DIS_NOTALLOWD":{"errno":"0x74C", "desc":"Cannot add GSLB local service with state set to DISABLED"},
    "NSERR_DUMMYBKUP_NOTALLOWD":{"errno":"0x74D", "desc":"A backup vserver with no IP address and port must be of type GSLB"},
    "NSERR_GSLBSVC_BIND_NOTALLOWD":{"errno":"0x74E", "desc":"Cannot bind GSLB service to a vserver with valid IP and port"},
    "NSERR_NSMAP_VERSION":{"errno":"0x74F", "desc":"Unrecognized NetScaler file version"},
    "NSERR_NSMAP_FORMAT":{"errno":"0x750", "desc":"Unrecognized file format specified"},
    "NSERR_NSMAP_EOF":{"errno":"0x751", "desc":"End of file has been reached"},
    "NSERR_NSMAP_PARSE":{"errno":"0x752", "desc":"File parsing error"},
    "NSERR_NSMAP_READ":{"errno":"0x753", "desc":"Error reading file"},
    "NSERR_NSMAP_WRITE":{"errno":"0x754", "desc":"Error writing file"},
    "NSERR_NSMAP_IOCTL":{"errno":"0x755", "desc":"Error occurred while transferring information to NetScaler"},
    "NSERR_NSMAP_OUTPUTFILE":{"errno":"0x756", "desc":"Error opening output file for writing"},
    "NSERR_NSMAP_INPUTFILE":{"errno":"0x757", "desc":"Error opening input file for reading"},
    "NSERR_NSMAP_REQUIRED_FIELD":{"errno":"0x758", "desc":"Required field missing"},
    "NSERR_NSMAP_DBFILE":{"errno":"0x759", "desc":"Error opening database file"},
    "NSERR_NSMAP_DBINSERT":{"errno":"0x75A", "desc":"Error inserting entry into the database"},
    "NSERR_NSMAP_DBSEARCH":{"errno":"0x75B", "desc":"Error searching the database"},
    "NSERR_GSLBPROXM_LICENCE_ABSENT":{"errno":"0x75C", "desc":"Cannot set proximity methods without GSLB proximity license"},
    "NSERR_GSLB_SITEPERSISTENCE_HTTPONLY":{"errno":"0x75D", "desc":"Site persistence is valid only for HTTP or SSL GSLB services"},
    "NSERR_GSLB_NOSITEPFX":{"errno":"0x75E", "desc":"Site prefix compulsory if site persistence is HTTPRedirect"},
    "NSERR_GSLB_SITEPREFIX_SIZE":{"errno":"0x760", "desc":"Site prefix size exceeds maximum"},
    "NSERR_GSLB_SITEDOMAIN_SIZE":{"errno":"0x761", "desc":"Site domain cannot be created - name length exceeds maximum"},
    "NSERR_GSLB_SITEDOMAIN_SYNTAX":{"errno":"0x762", "desc":"Site domain cannot be created - name is invalid"},
    "NSERR_GSLB_SITEDOMAIN_REFERS":{"errno":"0x763", "desc":"Site domain cannot be deleted - it has external DNS references"},
    "NSERR_GSLBDOMAIN_REFERS":{"errno":"0x764", "desc":"GSLB domain cannot be deleted - it has external DNS references"},
    "NSERR_GSLB_ARECORD_EXISTS":{"errno":"0x765", "desc":"GSLB record cannot be created - another A record is configured with the same name"},
    "NSERR_GSLB_SITECOOKIE_TIMEOUT_RANGE":{"errno":"0x766", "desc":"Invalid GSLB site cookie timeout"},
    "NSERR_GSLBDOMAIN_SYNTAX":{"errno":"0x767", "desc":"GSLB domain cannot be created - name is invalid"},
    "NSERR_GSLB_SO_PERM":{"errno":"0x768", "desc":"Spill-over cannot be set on a GSLB vserver"},
    "NSERR_GSLB_DEPRCOOKIETOUT":{"errno":"0x769", "desc":"Ignored deprecated cookietimeout setting since it has been made a per-domain configuration"},
    "NSERR_DNS_NAMESVR_SYNTAX":{"errno":"0x76a", "desc":"Invalid name server syntax"},
    "NSERR_DNS_ORIGSVR_SYNTAX":{"errno":"0x76b", "desc":"Invalid origin server syntax"},
    "NSERR_DNS_CONTACT_SYNTAX":{"errno":"0x76c", "desc":"Invalid contact name syntax"},
    "NSERR_DNS_MX_SYNTAX":{"errno":"0x76d", "desc":"Invalid mail exchange syntax"},
    "NSERR_DNS_CNAME_SYNTAX":{"errno":"0x76e", "desc":"Invalid canonical name syntax"},
    "NSERR_DNS_ALIAS_SYNTAX":{"errno":"0x770", "desc":"Invalid alias name syntax"},
    "NSERR_GSLB_NOLOCALVIP":{"errno":"0x771", "desc":"Cannot create GSLB local service - add the local vserver first"},
    "NSERR_GSLB_LOCALSVCEXISTS":{"errno":"0x772", "desc":"Cannot delete the vserver - corresponding GSLB local service still exists"},
    "NSERR_GSLBLOCALSVC_PERM":{"errno":"0x773", "desc":"Operation not permitted on GSLB local service"},
    "NSERR_DNS_INVAL_REVDOMNAME_SYNTAX":{"errno":"0x774", "desc":"Invalid reverse domain name syntax"},
    "NSERR_DNS_ALIASREC":{"errno":"0x775", "desc":"Alias name cannot have any record"},
    "NSERR_GSLBLOCSVC_DELAYEDCLEAN_NOTALLOWD":{"errno":"0x776", "desc":"Down state flush cannot be set on GSLB local service"},
    "NSERR_NO_BKP_VIP":{"errno":"0x777", "desc":"Set a backup Vserver, to enable it."},
    "NSERR_GSLB_NOSUCH_LDNSENTRY":{"errno":"0x778", "desc":"LDNS entry not present"},
    "NSERR_MAX_DNS_VIEW":{"errno":"0x779", "desc":"Number of DNS views exceeds limit"},
    "NSERR_GSLB_SITE_IP_EXISTS":{"errno":"0x77a", "desc":"GSLB Site IP already exists"},
    "NSERR_GSLB_LAST_MIP":{"errno":"0x77b", "desc":"MIP is not removed. At least one MIP is required"},
    "NSERR_RM_GSLB_SITE":{"errno":"0x77c", "desc":"IP cannot be removed as it is being used by the GSLB local site"},
    "NSERR_GSLB_IPRM_LAST_MIP":{"errno":"0x77d", "desc":"GSLB Site IP removed. MIP is not removed. At least one MIP is required"},
    "NSERR_GSLB_SVC_PUB_PORT_ERR":{"errno":"0x77e", "desc":"Cannot modify public port for remote GSLB service"},
    "NSERR_REC_HAS_REF":{"errno":"0x77f", "desc":"DNS record has references"},
    "NSERR_DNS_VIEW_REF":{"errno":"0x780", "desc":"The dns view cannot be removed as it has dependencies"},
    "NSERR_GSLB_SITE_PERSISTENCE_MATCH":{"errno":"0x781", "desc":"Mismatch in gslb site persistence type with other bound services"},
    "NSERR_GSLB_SITE_PERSISTENCE_CONFLICTS":{"errno":"0x782", "desc":"Site persistence  conflicts with other services bound to the gslb vip(s)"},
    "NSERR_DNS_POLICY_INVAL":{"errno":"0x783", "desc":"Invalid DNS policy"},
    "NSERR_GSLBVIP_CNAME_MISMATCH":{"errno":"0x784", "desc":"GSLB vserver cannot be bound with cname based and ip based services at the same time"},
    "NSERR_GSLBVIP_CNAME_UNSUPPORTED_LBMETHODS":{"errno":"0x785", "desc":"GSLB vserver having cname services cannot have dynamic load balancing methods"},
    "NSERR_GSLB_SERVICE_MON_NOIPPORT":{"errno":"0x786", "desc":"Cannot bind monitor with zero ip or  port to a cname gslb service"},
    "NSERR_GSLB_SERVICE_MON_SET_NOIPPORT":{"errno":"0x787", "desc":"Cannot set ip or port to zero when monitor is bound to a cname gslb service."},
    "NSERR_GSLB_CNAME_SERVICE_SET":{"errno":"0x788", "desc":"Setting of these parameters on cname gslb service is not allowed"},
    "NSERR_GSLB_CNAME_VSERVER_SET":{"errno":"0x789", "desc":"Setting of these parameters on gslb vserver having cname services is not allowed"},
    "NSERR_GSLBVIP_CNAME_UNSUPPORTED_BKUP_LBMETHODS":{"errno":"0x78a", "desc":"GSLB vserver having cname services cannot have dynamic backup load balancing methods"},
    "NSERR_GSLBVIP_CNAME_UNSUPPORTED_EDR":{"errno":"0x78b", "desc":"GSLB vserver having cname services cannot have empty down response disabled"},
    "NSERR_GSLBVIP_CNAME_UNSUPPORTED_MIR":{"errno":"0x78c", "desc":"GSLB vserver having cname services cannot have multiple ip response enabled"},
    "NSERR_GSLBSVC_VIEW_NEXIST":{"errno":"0x78d", "desc":"View is not bound to the GSLB service"},
    "NSERR_DNS_TTL_MORE_THAN_MAX_ALLOWED":{"errno":"0x78e", "desc":"DNS RECORD TTL value greater than max TTL allowed"},
    "NSERR_GSLB_LB_MAXSITES":{"errno":"0x78f", "desc":"Maximum number of LB sites is 1024"},
    "NSERR_GSLB_HASCHILDREN":{"errno":"0x790", "desc":"Cannot remove site that has child site(s)"},
    "NSERR_GSLB_PARENTISCHILD":{"errno":"0x791", "desc":"Parent site cannot be a child to another site"},
    "NSERR_MAX_STREAM_SELECTORS":{"errno":"0x792", "desc":"Number of selectors exceeds limit"},
    "NSERR_MAX_STREAM_IDENTIFERS":{"errno":"0x793", "desc":"Number of identifiers exceeds limit"},
    "NSERR_NO_SUCH_SELECTOR":{"errno":"0x794", "desc":"The given selector does not exist"},
    "NSERR_NO_SUCH_IDENTIFIER":{"errno":"0x795", "desc":"The given identifier does not exist"},
    "NSERR_RLT_TIMESLICE_INVALID_VAL":{"errno":"0x796", "desc":"Time slice should be a multiple of 10"},
    "NSERR_ILLEGAL_SUBNET_MASK":{"errno":"0x797", "desc":"Incorrect subnet mask value"},
    "NSERR_STREAM_SELECTOR_INUSE":{"errno":"0x798", "desc":"The selector is being referenced by one or more identifiers"},
    "NSERR_IDENTIFIER_INUSE":{"errno":"0x799", "desc":"The identifier is being referenced by one or more policies"},
    "NSERR_SELECTOR_CANNOT_CHANGE_ATTRIB_TYPE":{"errno":"0x79A", "desc":"Cannot change request type selector to response type"},
    "NSERR_GSLB_IGN_TRIGMON":{"errno":"0x79B", "desc":"Trigger monitor setting assumed ALWAYS for GSLB local site"},
    "NSERR_SELECTOR_NOT_MORE_THAN_2_IPV6_EXP":{"errno":"0x79C", "desc":"Cannot exceed more than two IPV6 expressions in a selector"},
    "NSERR_REPEATED_MONITORS":{"errno":"0x79D", "desc":"Monitors cannot be repeated"},
    "NSERR_ALL_MONITORS_DISABLED":{"errno":"0x79E", "desc":"All monitors in selected list are disabled."},
    "NSERR_GSLB_AAAARECORD_EXISTS":{"errno":"0x79F", "desc":"GSLB record cannot be created - another AAAA record is configured with the same name"},
    "NSERR_GSLBVIP_HETEROGENEOUS_SERVICE_IPVERSION":{"errno":"0x7A0", "desc":"Heterogeneous service binding is not allowed for GSLB vserver"},
    "NSERR_VIEWIP_IPV6":{"errno":"0x7A1", "desc":"View IP setting is not allowed for IPv6 GSLB service."},
    "NSERR_BACKUPIP_IPV6":{"errno":"0x7A2", "desc":"IPv4 backup IP setting is not allowed for IPv6 GSLB vserver."},
    "NSERR_BACKUP_VIP_MISMATCH":{"errno":"0x7A3", "desc":"Both primary and secondary vservers should be of same DNSRecordType"},
    "NSERR_GSLB_DOMAIN_CONVERSION":{"errno":"0x7A4", "desc":"Cannot associate gslb domain to the service."},
    "NSERR_GSLB_IPV4_BACKUPIP":{"errno":"0x7A5", "desc":"IPv6 service binding is not allowed along with IPv4 backup IP."},
    "NSERR_CANNOT_ADD_SELECTOR":{"errno":"0x7A6", "desc":"Cannot set a new selector when the identifier with no selector is bound to a policy."},
    "NSERR_SEL_CONFLICTING_ATTRIBUTES":{"errno":"0x7A7", "desc":"Conflicting attributes in the new and current selector sets."},
    "NSERR_GSLBVIP_CNAME_BACKUPIP":{"errno":"0x7A8", "desc":"GSLB vserver having cname services cannot have backup IP"},
    "NSERR_GSLB_HETEROGENEOUS_SITEIP":{"errno":"0x7A9", "desc":"Heterogeneous IPv6 and IPv4 GSLB site IPs not allowed."},
    "NSERR_DNS_MAX_AAAA_REC":{"errno":"0x7AA", "desc":"Cannot exceed more than 5 IPv6 addresses."},
    "NSERR_DNS_MAX_A_REC":{"errno":"0x7AB", "desc":"Cannot exceed more than 25 IP addresses."},
    "NSERR_GSLB_RECTYPE_SERVICE":{"errno":"0x7AD", "desc":"Cannot set the record type while services bound to the GSLB vserver."},
    "NSERR_GSLB_RECTYPE_DOMAIN":{"errno":"0x7AE", "desc":"Cannot set the record type while domains bound to the GSLB vserver."},
    "NSERR_GSLB_RECTYPE_BACKUP_VIP":{"errno":"0x7AF", "desc":"Cannot set the record type while GSLB vserver has backup vserver."},
    "NSERR_GSLB_BKPVIP_RECTYPE":{"errno":"0x7B0", "desc":"Cannot set the record type while GSLB vserver is a backup vserver."},
    "NSERR_GSLBVIP_NAPTR_UNSUPPORTED_SVCTYPE":{"errno":"0x7B1", "desc":"GSLB vserver of NAPTR DNS record type can have only ANY as service type."},
    "NSERR_BACKUPIP_IPV4":{"errno":"0x7B2", "desc":"IPv6 backup IP setting is not allowed for IPv4 GSLB vserver."},
    "NSERR_GSLB_IPV6_BACKUPIP":{"errno":"0x7B3", "desc":"IPv4 service binding is not allowed along with IPv6 backup IP."},
    "NSERR_GSLB_DB_REQ_TOO_BIG":{"errno":"0x7B4", "desc":"Static proximity Database request is too big."},
    "NSERR_GSLB_DB_QUEUE_MAXED":{"errno":"0x7B5", "desc":"Static proximity Database queue is full."},
    "NSERR_GSLB_DB_SERVER":{"errno":"0x7B6", "desc":"Static proximity database server is not running."},
    "NSERR_GSLB_DB_TIMEOUT":{"errno":"0x7B7", "desc":"Static proximity database server is not responding."},
    "NSERR_GSLB_DB_CLOSED":{"errno":"0x7B8", "desc":"Connection to static proximity database server is closed."},
    "NSERR_GSLB_COORDINATES":{"errno":"0x7B9", "desc":"Both longitude and latitude should be specified or not."},
    "NSERR_INVALID_IPV6_PREFIXLEN":{"errno":"0x7BA", "desc":"Invalid IPv6 prefix length."},
    "NSERR_GSLBDOMAIN_CANME_RECORD_EXISTS":{"errno":"0x7BB", "desc":"Cname record can't be created. Another record exists for the configured domain."},
    "NSERR_GSLBDOMAIN_AAAA_CNAME_EXISTS":{"errno":"0x7BC", "desc":"Cname record exists for the configured domain."},
    "NSERR_GSLB_NON_PARENT_REMOTESITE":{"errno":"0x7BD", "desc":"Cannot have a gslb remote site, other than the parent site, configured on an LB node"},
    "NSERR_ZONE_EXISTS":{"errno":"0x7BE", "desc":"Zone already configured."},
    "NSERR_INVAL_KEYFLAGS":{"errno":"0x7BF", "desc":"Invalid flags value in DNSKEY"},
    "NSERR_DNSKEY_NONEXISTS":{"errno":"0x7C0", "desc":"Zone has no DNSKEY's"},
    "NSERR_NORECS_IN_ZONE":{"errno":"0x7C1", "desc":"No records in zone"},
    "NSERR_SIGNFAILED":{"errno":"0x7C2", "desc":"RSA Sign operation returned error"},
    "NSERR_DIGESTINIT_FAILED":{"errno":"0x7C3", "desc":"Digest init before RSA Sign operation returned error"},
    "NSERR_DIGESTUPDATE_FAILED":{"errno":"0x7C4", "desc":"Digest update before RSA Sign operation returned error"},
    "NSERR_KEYEXISTS":{"errno":"0x7C5", "desc":"The DNSKEY is already added for this zone"},
    "NSERR_NOPASVKEYS":{"errno":"0x7C6", "desc":"No Passive DNSKEY's in zone"},
    "NSERR_DNS_MAXKEYSIZE":{"errno":"0x7C7", "desc":"Maximum allowed public key size is 1024 and private key size is 4096"},
    "NSERR_NODATA_TO_SIGN":{"errno":"0x7c8", "desc":"No data to sign the record"},
    "NSERR_CNAME_SITE_NOTEXISTS":{"errno":"0x7c9", "desc":"Site name must be specified for cname based GSLB service."},
    "NSERR_DNS_NOSOA_NONS":{"errno":"0x7cA", "desc":"No SOA or NS records for the zone"},
    "NSERR_DNS_PROXY_ZONE":{"errno":"0x7cB", "desc":"Cannot sign/unsign a proxy zone"},
    "NSERR_NOACTVKEYS":{"errno":"0x7CC", "desc":"No active DNSKEY's in zone"},
    "NSERR_NOTIFYPERIOD":{"errno":"0x7cd", "desc":"Notification period must be less than the expiry period"},
    "NSERR_LOAD_PUBKEY":{"errno":"0x7ce", "desc":"Public key loading failed"},
    "NSERR_DNSKEYGEN_UNSUPPORTED_ALGO":{"errno":"0x7cf", "desc":"Unsupported algorithm"},
    "NSERR_DNSKEYGEN_ERR_PUBFILE_OPEN":{"errno":"0x7d0", "desc":"Error opening public key file"},
    "NSERR_DNSKEYGEN_ERR_PRIVFILE_OPEN":{"errno":"0x7d1", "desc":"Error opening private key file"},
    "NSERR_DNSKEYGEN_ERR_DSFILE_OPEN":{"errno":"0x7d2", "desc":"Error opening delegation signer (DS) file"},
    "NSERR_GSLB_OPT_NOTSUPPORTED":{"errno":"0x7d3", "desc":"gslb option is not supported, GSLB site is mandatory for GSLB services"},
    "NSERR_GSLB_GFS_NOT_SUPPORTED":{"errno":"0x7d4", "desc":"Graceful shutdown is not supported for GSLB services."},
    "NSERR_NSMAP_IMPORTFILE":{"errno":"0x7d5", "desc":"Error reading the imported file. See /var/log/ns.log file for more details."},
    "NSERR_DNS_CNAMELOOP":{"errno":"0x7d6", "desc":"Addition of this CNAME record leads to a CNAME loop"},
    "NSERR_NEWSVC_NOT_4GSLB":{"errno":"0x7d7", "desc":"startup settings not applicable to GSLB vservers"},
    "NSERR_NON_CLUSTER_SYSTEM":{"errno":"0x7d8", "desc":"The option is only supported for clustering systems."},
    "NSERR_PM_MON_NOT_ENABLED":{"errno":"0x7d9", "desc":"Path monitoring must be enabled to enable this option."},
    "NSERR_GSLB_BACKUP_PERS_DEPRICATED":{"errno":"0x7dA", "desc":"GSLB Backup Persistence is deprecated. Please use Spillover Persistence instead."},
    "NSERR_DNS_SIGNFAIL":{"errno":"0x7dB", "desc":"DNSSEC Sign operation failed"},
    "NSERR_DNS_NEED_PROXY":{"errno":"0x7dC", "desc":"Zone needs to be in proxy mode"},
    "NSERR_DNSSEC_OFFLOAD_NOSUPPORT":{"errno":"0x7dD", "desc":"DNNSEC Offload is not supported in this platform."},
    "NSERR_DNS64_ACT_INVAL":{"errno":"0x7dE", "desc":"Invalid DNS64 action."},
    "NSERR_DNS64_NOT_SUPPORTED_VS":{"errno":"0x7dF", "desc":"Specified policy can be bound only to DNS/DNS_TCP vserver."},
    "NSERR_DNS64_INVAL_PREFIX":{"errno":"0x7e0", "desc":"Specified Prefix is either not allowed or Prefix length is not in [96,64,56,48,40,32]."},
    "NSERR_GSLB_DB_REPEAT_REQUEST":{"errno":"0x7e1", "desc":"Location database request need to be repeated"},
    "NSERR_GSLBSITE_CONN_NOTSUPPORTED":{"errno":"0x7e2", "desc":"This may cause GSLB site MEP connection issues in some earlier releases."},
    "NSERR_DNS64_TIMEOUT_ROUNDOFF":{"errno":"0x7e3", "desc":"Timeout threshold is rounded off to nearest multiple of 10 less then the given value."},
    "NSERR_USIP_EV_NO_MEM_WARNING":{"errno":"0x7e4", "desc":"Service marked unusable due to lack of memory to post APBR rules for USIP."},
    "NSERR_GSLB_SITE_PREFIX_CONFLICT":{"errno":"0x7fc", "desc":"Site prefix conflicts with another service bound to the gslb vip"},
    "NSERR_USIP_EV_NO_MEM_WARNING_DEL":{"errno":"0x7e5", "desc":"APBR rule on switch not deleted due to lack of memory to post APBR rules for USIP."},
    "NSERR_USIP_EV_NO_SVC_GRP_MEM_WARNING":{"errno":"0x7e6", "desc":"One or more APBR rules were not configured on the switch due to lack of memory."},
    "NSERR_USIP_EV_NO_SVC_GRP_MEM_WARNING_DEL":{"errno":"0x7e7", "desc":"One or more APBR rules were not deleted on the switch due to lack of memory."},
    "NSERR_DNSKEY_MISMATCH":{"errno":"0x7e8", "desc":"The Key specified is not valid for this zone"},
    "NSERR_INVALID_REMOTE_CLIP":{"errno":"0x7e9", "desc":"Invalid remote GSLB site CLIP. CLIP belong to the local gslb site"},
    "NSERR_IPV6_CLIP_NOTSUPPORTED":{"errno":"0x7ea", "desc":"IPV6 CLIP is not supported"},
    "NSERR_NON_DEFAULT_DBFILE_LOC":{"errno":"0x7eb", "desc":"In case of HA setup and cluster system, the command might fail on other nodes if an identical copy of the file is not present at the same location."},
    "NSERR_LOC64_FROM_TO_TYPE":{"errno":"0x7ec", "desc":"IP From and IP To in location specification are of different IP type."},
    "NSERR_DNS_NOSOA_NONS_ZONE_NO_PROXY_MODE":{"errno":"0x7ed", "desc":"Cannot delete SOA or NS records for a zone that is not deployed in proxy mode."},
    "NSERR_DNS_ACTION_DROP_DEPRECATED":{"errno":"0x7ef", "desc":"Drop is deprecated. Please use Drop action type under Responder feature."},
    "NSERR_DNS_ACTION_REWRITE_RESPONSE_DEPRECATED":{"errno":"0x7f7", "desc":"Rewrite Response is deprecated. Please use replace_dns_answer_section action type under Rewrite feature."},
    "NSERR_IDENTIFIER_INVAL_THRESHOLD":{"errno":"0x7f8", "desc":" Stream Identifier min and max threshold cannot both be zero and min threshold cannot be greater than max threshold"},
    "NSERR_IDENTIFIER_INVAL_SORT":{"errno":"0x7f9", "desc":"Stream Identifier sort option is invalid"},
    "NSERR_NO_SUCH_DNSPROF":{"errno":"0x7fa", "desc":"DNS profile does not exist"},
    "NSERR_DNS_PROFILE_SVC_TYPE":{"errno":"0x7fb", "desc":"DNS profile cannot be set to this service type"},
    "NSERR_CSGSLB_POLICY_SET_NOTALLOWED":{"errno":"0x7fe", "desc":"Policy bound to CS GSLB vserver must have a gslb targetvserver"},
    "NSERR_CS_POLICY_SET_NOTALLOWED":{"errno":"0x7fd", "desc":"Policy bound to non CS GSLB vserver must not have a gslb targetvserver"},
    "NSERR_GSLB_ECS_DISABLED_VALIDATION_ENABLED":{"errno":"0xbab", "desc":"ECS is disabled: Enabling only ECS address validation will not have any effect if ECS is not enabled."},
    "NSERR_ECS_INVALID_ADDR_LEN":{"errno":"0xbad", "desc":"ECS address uses more octets than required or the address has non-zero bits set beyond SOURCE PREFIX-LENGTH"},
    "NSERR_GSLB_ECS_MIR_BOTH_SET":{"errno":"0x2fd", "desc":"ECS option is mutually exclusive with MIR"},
    "NSERR_GSLB_ECS_IPV6_DISABLED":{"errno":"0x2fe", "desc":"IPv6PT is disabled, DNS queries with an IPv6 ECS address will be dropped"},
    "NSERR_GSLB_ECS_LBMETHOD_NOT_SP":{"errno":"0x2ff", "desc":"Enabling ECS without setting LB method to Static Proximity will not result in optimal responses for ECS-enabled queries"},
    "NSERR_NO_ECS_REC":{"errno":"0x5DA", "desc":"No record available for the given ECS subnet"},
    "NSERR_REM_FAIL_NOMEM":{"errno":"0x5DB", "desc":"Removal is unsuccessful because of an internal error"},
    "NSERR_EN_AUTOSYNC_DEFAULT_PARTITION_WARNING":{"errno":"0x5DC", "desc":"Enabling automaticConfigSync parameter in default partition will have no effect"},
}

NS_SVPN_ERRORS = {
    "NSCFG_INFO ":{"errno":"0x801", "desc":"Sending the /cfg information"},
    "NSCS_INFO":{"errno":"0x802", "desc":"Backend server info exists"},
    "NSCSPROBE_INFO ":{"errno":"0x803", "desc":"Probe to backend server pending"},
    "NSAPPPROBE_INFO":{"errno":"0x804", "desc":"Client side connection being closed"},
    "NSCFG_MP_INFO":{"errno":"0x840", "desc":"Sending the /mp_cfg Information"},
    "NSERR_NOINTRANETIP":{"errno":"0x841", "desc":"No Intranet IP available"},
    "NSERR_ALREADYLOGEDIN":{"errno":"0x842", "desc":"The user is already logged-in"},
    "NSERR_URLINUSE":{"errno":"0x843", "desc":"Bound URL/bookmark cannot be removed."},
    "NSERR_VPNAPPINUSE":{"errno":"0x844", "desc":"Bound VPN application cannot be removed."},
    "NSERR_NOTSUPP_TRANS_INTERCPT":{"errno":"0x845", "desc":"Transparent interception is not yet supported."},
    "NSERR_CLNT_CERT_RENEG":{"errno":"0x846", "desc":"Client SSL certificate renegotiation failed"},
    "NSERR_DEFAULTCMDPLCY":{"errno":"0x847", "desc":"Default command policy cannot be removed"},
    "NSERR_CLNT_CERT_REQD":{"errno":"0x848", "desc":"Client SSL certificate is required"},
    "NSERR_INVAL_CERTFIELD":{"errno":"0x849", "desc":"Invalid certificate field"},
    "NSERR_VPNAPP_PROXY_IPRANGE":{"errno":"0x810", "desc":"Proxy interception does not support IP ranges" },
    "NSERR_VPNAPP_PROXY_NETMASK":{"errno":"0x811", "desc":"Proxy interception does not support netmasks" },
    "NSERR_VPNAPP_PROXY_DSTPORT_RANGE":{"errno":"0x812", "desc":"Proxy interception does not support destination port ranges"},
    "NSERR_VPNAPP_PROXY_PROTOCOL":{"errno":"0x813", "desc":"Proxy interception supports only TCP"},
    "NSERR_VPNAPP_PROXY_HOSTNAME":{"errno":"0x814", "desc":"Proxy interception does not support hostname interception"},
    "NSERR_VPNAPP_TRANS_SRCIP":{"errno":"0x815", "desc":"Transparent interception does not support source IP"},
    "NSERR_VPNAPP_TRANS_SRCPORT":{"errno":"0x816", "desc":"Transparent interception does not support source port"},
    "NSERR_VPNAPP_NO_INTERCEPTION_TYPE":{"errno":"0x817", "desc":"Intranet application requires an interception type"},
    "NSERR_VPNAPP_CLIAPP_PORT":{"errno":"0x818", "desc":"Both client application name and destination port cannot be specified"},
    "NSERR_VPNAPP_CLIAPP_PROTO":{"errno":"0x819", "desc":"Protocol can not be specified when client application name is present"},
    "NSERR_VPNAPP_PROXY_CLIAPP":{"errno":"0x81a", "desc":"Proxy interception does not support client application based interception"},
    "NSERR_VPNAPP_MISSING_PROTO":{"errno":"0x81b", "desc":"Protocol must be specified"},
    "NSERR_VPNAPP_MISSING_ARG":{"errno":"0x81c", "desc":"One of destIP, IPRange or hostname has to be specified"},
    "NSERR_VPNAPP_TOO_MANY_ARG":{"errno":"0x81d", "desc":"At most one of destIP, IPRange or hostname may be specified"},
    "NSERR_FS_AUTHFAIL":{"errno":"0x81e", "desc":""},
    "NSERR_NSIPV6NOTPRESENT":{"errno":"0x81f", "desc":"No IPV6 Netscaler IP has been configured"},
    "NSERR_REMOVE_SESSION":{"errno":"0x830", "desc":"No IPV6 Netscaler IP has been configured"},
    "NSERR_STAWI_EXIST":{"errno":"0xcb2", "desc":"A STA or WI DBS configuration exists. Unset it first"},
    "NSERR_INVALID_SSO_ACTION":{"errno":"0x833", "desc":"Invalid sso action"},
    "NSERR_INVALID_TMTRAFFIC_ACTION":{"errno":"0x834", "desc":"Invalid tm traffic action"},
    "NSERR_INVALFSSO":{"errno":"0x835", "desc":"SSO should be turned on for setting formsso action"},
    "NSERR_INVALIDURL":{"errno":"0x836", "desc":"Action url should be root relative url"},
    "NSERR_INVALID_FLOWTYPE_FORAPPFLOW":{"errno":"0x84E", "desc":"Flowtype needs to be REQUEST or ICA_REQUEST or OTHERTCP_REQUEST for appflow policy when bound to VPN vservers"},
    "NSERR_TOO_MANY_SERVERS":{"errno":"0x84F", "desc":"Too many servers bound"},
    "NSERR_BLOCKING_ATTR_WARNING_FOR_VPN_APPFLOW":{"errno":"0xb91", "desc":"Policy will not apply to VPN traffic if it has blocking attributes"},
    "NSERR_SAMLIDP_ACTION":{"errno":"0xb9f", "desc":"Invalid SAML IDP Action"},
    "NSERR_SAML_ACTION_AUTHNCTX":{"errno":"0xba0", "desc":"None option is mutually exclusive with other Authentication Class References"},
    "NSERR_ABSOLUTE_URL":{"errno":"0xba1", "desc":"URL has to be an absolute URL"},
    "NSERR_INVALID_AG_BIND":{"errno":"0xba2", "desc":"SSLVPN vserver can be bound to only SSL type CS vserver"},
    "NSERR_NO_VSERVER":{"errno":"0xba3", "desc":"Please specify the associated vserver name"},
    "NSERR_SSSO_NOT_LICENSED":{"errno":"0xba4", "desc":"This feature needs enterprise or platinum license."},
    "NSERR_MULT_AGBIND":{"errno":"0xba5", "desc":"Only one VPN vserver can be bound to a CS vserver."},
    "NSERR_VPN_VSERV_PROTOCOL_NOT_ALLOWED":{"errno":"0xba6", "desc":"VPN/Authentication Vserver of service type 'HTTP' is not allowed."},
    "NSERR_SET_NOT_ALLOWED_ON_ICAONLY_BIT":{"errno":"0xba7", "desc":"Changing 'ICAonly' parameter is not allowed in Cluster Deployment."},
    "NSERR_IIP_INVALID_RANGE":{"errno":"0xba8", "desc":"The given intranet IP binding does not exist"},
    "NSERR_SSLVPN_LICENSE":{"errno":"0xba9", "desc":"Feature not licensed [SSLVPN]"},
    "NSERR_SAMLIDP_NO_ART_BINDING":{"errno":"0xbaa", "desc":"Artifact binding is not supported in SAML IDP"},
    "NSERR_SAMLIDP_REDIR_INVALID_SIGN":{"errno":"0xbae", "desc":"signAssertion option can only be set to ASSERTION in Redirect binding"},
    "NSERR_VPN_AUTH_BIND":{"errno":"0xbaf", "desc":"Authentication vserver can not be bound to a CS vserver if VPN vserver is already bound to it."},
    "NSERR_AUTH_VPN_BIND":{"errno":"0xbb0", "desc":"VPN vserver can not be bound to a CS vserver if Authentication vserver is already bound to it."},
    "NSERR_SVPN_INVALID_URL":{"errno":"0xbb1", "desc":"URL must be an absolute url with a trailing slash"},
    "NSERR_MULT_AUTHBIND":{"errno":"0xbb2", "desc":"Only one Authentication vserver can be bound to a CS vserver."},
    "NSERR_SVPN_INVALID_ICONURL":{"errno":"0xbb3", "desc":"Only the following image types i.e. .png, .jpeg, .jpg and .giff are allowed as bookmark icons."},
}

NS_POL_ERRORS = {
    "NSERR_INVALIDPOL":{"errno":"0x805", "desc":"Binding invalid policy"},
    "NSERR_NOPOL":{"errno":"0x806", "desc":"No such policy exists"},
    "NSERR_RULEURL":{"errno":"0x807", "desc":"Rule or URL required"},
    "NSERR_DELMC":{"errno":"0x808", "desc":"Delay or maxConn argument required"},
    "NSERR_ACP":{"errno":"0x809", "desc":"Alternate content path not required"},
    "NSERR_ACS":{"errno":"0x80A", "desc":"Alternate content service not required"},
    "NSERR_NOSET_CEXP":{"errno":"0x80B", "desc":"No support to set compound expression value"},
    "NSERR_CEXP_DEPTH":{"errno":"0x80C", "desc":"Maximum recursive depth reached"},
    "NSERR_NOVPNAPP":{"errno":"0x80D", "desc":"No such intranet application exists"},
    "NSERR_NOSET_CSE":{"errno":"0x80E", "desc":"Changing rule to/from client security expression is not allowed when policy is in use"},
    "NSERR_INVAL_POLNAME":{"errno":"0x80F", "desc":"Invalid policy Name"},
    "NSERR_UNBIND_INVALIDPOL":{"errno":"0x831", "desc":"Policy not bound"},
    "NSERR_EXCEED_MAX_POL_LIMIT":{"errno":"0x832", "desc":"32 authentication policies are already bound"},
    "NSERR_INTERNAL_PI_ERROR":{"errno":"0x837", "desc":"Internal policy error"},
    "NSERR_NEG_POL_VIOL1        ":{"errno":"0x838", "desc":"Only negotiate and certificate policies can be bound together"},
    "NSERR_NEG_POL_VIOL2        ":{"errno":"0x839", "desc":"Negotiate policy in primary can be bound only along with ldap policy (with authentication turned off) in secondary"},
    "NSERR_NEG_POL_VIOL3        ":{"errno":"0x83A", "desc":"Negotiate policy in secondary can be bound only along with certificate policy in primary"},
    "NSERR_SAML_POL_VIOL1        ":{"errno":"0x84A", "desc":"SAML policy can only be the last in the cascade or the only one in the cascade"},
    "NSERR_SAML_POL_VIOL2        ":{"errno":"0x84B", "desc":"SAML policy in primary can be bound only along with ldap policy (with authentication turned off) in secondary"},
    "NSERR_SAML_POL_VIOL3        ":{"errno":"0x84C", "desc":"SAML policy cannot be bound to secondary cascade"},
    "NSERR_SAML_DISABLED        ":{"errno":"0x84D", "desc":"SAML policy binding is disabled"},
    "NSERR_LDAP_POL_VIOL1       ":{"errno":"0x828", "desc":"Only LDAP policies may be bound for group extraction."},
    "NSERR_LDAP_POL_VIOL2       ":{"errno":"0x829", "desc":"An LDAP policy bound for group extraction must set -authentication DISABLED."},
    "NSERR_NON_SELECTOR_POLICY":{"errno":"0x83B", "desc":"Only selector based policies can be bound to sql vserver"},
    "NSERR_BAD_SELECTOR":{"errno":"0x83C", "desc":"Selector does not match content group type"},
    "NSERR_BAD_CONTENTGROUP":{"errno":"0x83D", "desc":"Contentgroup not compatible"},
    "NSERR_SQL_POL_GLOBAL_BINDPOINT":{"errno":"0x83E", "desc":"Datastream cache policies cannot have global/override bindpoint"},
    "NSERR_APPQOE_INVALID_ACP":{"errno":"0x83F", "desc":"Alternate content path is invalid"},
    "NSERR_APPQOE_CLTRATE":{"errno":"0x826", "desc":"Client detect rate is not required"},
    "NSERR_APPQOE_DOSTHRESH_NREQ":{"errno":"0x827", "desc":"DoS attack threshold is not required"},
    "NSERR_APPQOE_DOSTHRESH_REQ":{"errno":"0x82a", "desc":"DoS attack threshold is required"},
    "NSERR_APPQOE_ACS_REQ":{"errno":"0x82b", "desc":"Alternate content service is required"},
    "NSERR_APPQOE_ACP_REQ":{"errno":"0x82c", "desc":"Alternate content path is required with alternate content service"},
    "NSERR_CMPTYPE_MISMATCH":{"errno":"0x82d", "desc":"Compression policy may not take effect due to global parameter type mismatch"},
    "NSERR_APPQOE_VSVR_CONFIG_CONFLICT":{"errno":"0x82E", "desc":"AppQoE policy cannot be bound to vserver configured for PQ/SC"},
    "NSERR_APPQOE_SVC_CONFIG_CONFLICT":{"errno":"0x82F", "desc":"AppQoE policy cannot be bound to vserver with services configured for SC/HDOSP"},
    "NSERR_APPQOE_UNSUPPORTED_PROTO":{"errno":"0x85E", "desc":"Specified policy can be bound only to HTTP/SSL vserver"},
    "NSERR_APPQOE_UNSUPPORTED_VSVR":{"errno":"0x85F", "desc":"Specified policy can be bound only to LB vserver types"},
    "NSERR_AUTHN_CLASSIC_INVALID_ARG":{"errno":"0x861", "desc":"Invalid arguments for classic authentication policy binding"},
    "NSERR_AUTHN_ADVANCE_INVALID_ARG":{"errno":"0x862", "desc":"Invalid arguments for advanced authentication policy binding"},
    "NSERR_RENAME_NOT_PERMITTED":{"errno":"0x863", "desc":"Rename operation not permitted"},
    "NSERR_PI_AUTHZPLCY_NOT_SUPPORTED":{"errno":"0x864", "desc":"advanced authorization policy cannot be bound to aaa user/group"},
    "NSERR_SAML_2FACTOR_CONFLICT":{"errno":"0x865", "desc":"SAML 2-Factor policy should always be at the beginning of cascade"},
    "NSERR_AUDIT_SYSADVPLCY_BOUND":{"errno":"0x866", "desc":"Cannot bind Classic Syslog Policy to System global if Advanced Syslog Policy is already bound to SyslogGlobal"},
    "NSERR_AUDIT_SYSCLASSICPLCY_BOUND":{"errno":"0x867", "desc":"Cannot bind Advanced Syslog Policy to SyslogGlobal if Classic Syslog Policy is already bound to System Global"},
    "NSERR_CLASSIC_TMSESSPOL_ALREADY_BOUND":{"errno":"0x868", "desc":"Advanced TM Session Policy cannot be bound if Classic TM Session Policy is already bound to any entity (i.e. aaa user, aaa group, authentication vserver, tm global)"},
    "NSERR_ADVANCED_TMSESSPOL_ALREADY_BOUND":{"errno":"0x869", "desc":"Classic TM Session Policy cannot be bound if Advanced TM Session Policy is already bound to any entity (i.e. aaa user, aaa group, authentication vserver, tm global)"},
    "NSERR_AUDIT_NSADVPLCY_BOUND":{"errno":"0x907", "desc":"Cannot bind Classic Nslog Policy to System global if Advanced Nslog Policy is already bound to NslogGlobal"},
    "NSERR_AUDIT_NSCLASSICPLCY_BOUND":{"errno":"0x908", "desc":"Cannot bind Advanced Nslog Policy to NslogGlobal if Classic Nslog Policy is already bound to System Global"},
    "NSERR_CLASSIC_AUTHNPOL_ALREADY_BOUND":{"errno":"0x8ab", "desc":"Advanced authentication Policy cannot be bound if Classic authentication Policy is already bound to system global"},
    "NSERR_ADVANCED_AUTHNPOL_ALREADY_BOUND":{"errno":"0x8ac", "desc":"Classic authentication Policy cannot be bound if Advanced authentication Policy is already bound to system global"},
    "NSERR_NEXTFACTOR_ATTRIBMAP_MISMATCH":{"errno":"0x8ad", "desc":"Bind functionality not supported for current bind-entity and nextFactor"},
    "NSERR_CLASSIC_VPNTRAFFICPOL_ALREADY_BOUND":{"errno":"0x8ae", "desc":"Advanced VPN Traffic Policy cannot be bound if Classic VPN Traffic Policy is already bound to any entity (i.e. aaa user, aaa group, vpn vserver, vpn global)"},
    "NSERR_ADVANCED_VPNTRAFFICPOL_ALREADY_BOUND":{"errno":"0x8af", "desc":"Classic VPN Traffic Policy cannot be bound if Advanced VPN Traffic Policy is already bound to any entity (i.e. aaa user, aaa group, vpn vserver, vpn global)"},
    "NSERR_CLASSIC_AUTHPOL_ALREADY_BOUND":{"errno":"0x8b0", "desc":"Advanced Authorization Policy cannot be bound if Classic Authorization Policy is already bound to any entity (i.e. aaa user, aaa group)"},
    "NSERR_ADVANCED_AUTHPOL_ALREADY_BOUND":{"errno":"0x8b1", "desc":"Classic Authorization Policy cannot be bound if Advanced Authorization Policy is already bound to any entity (i.e. aaa user, aaa group)"},
    "NSERR_CLASSIC_VPNSESSPOL_ALREADY_BOUND":{"errno":"0x8b2", "desc":"Advanced VPN Session Policy cannot be bound if Classic VPN Session Policy is already bound to any entity (i.e. aaa user, aaa group, vpn vserver, vpn global)"},
    "NSERR_ADVANCED_VPNSESSPOL_ALREADY_BOUND":{"errno":"0x8b3", "desc":"Classic VPN Session Policy cannot be bound if Advanced VPN Session Policy is already bound to any entity (i.e. aaa user, aaa group, vpn vserver, vpn global)"},
    "NSERR_INVALID_AUTHN_SET_ACTION_SUBTYPE":{"errno":"0x8b4", "desc":"Setting action for advanced authentication policy not allowed for different action subtype"},
    "NSERR_CLASSIC_AUTH_POLICY_DEPRECATED":{"errno":"0x8b5", "desc":"Classic authentication policies are deprecated. Please use advanced authentication policies (i.e. add/set authentication policy)"},
    "NSERR_CLASSIC_PREAUTH_POLICY_DEPRECATED":{"errno":"0x8b6", "desc":"Classic Pre-authentication policies are deprecated. Please use advanced authentication policies (i.e. add/set authentication epaaction, add/set authentication policy)"},
}

NS_VLAN_ERRORS = {
    "NSERR_INTERFACEBOUND":{"errno":"0x820", "desc":"Interface is already bound to this VLAN"},
    "NSERR_IFACE_NO_UNBIND":{"errno":"0x821", "desc":"Untagged interface cannot be removed from default VLAN. To remove, bind to other VLAN."},
    "NSERR_IFACE_MAX_VLANS":{"errno":"0x822", "desc":"Maximum number of tagged VLANs bound to the interface exceeded or the binding of this VLAN is not allowed on the interface."},
    "NSERR_VLAN_RTEXIST":{"errno":"0x823", "desc":"An existing route relies on the presence of this vlan"},
    "NSERR_VLAN_LLEXIST":{"errno":"0x824", "desc":"An existing link-local ip relies on the presence of this vlan"},
    "NSERR_BOUNDTONSVLAN":{"errno":"0x825", "desc":"Interface/Channel bound to NSVLAN"},
    "NSERR_VLAN_TD_CONFIGURED":{"errno":"0x968", "desc":"TD is configured on this bridgegroup/vlan. Cannot delete this"},
    "NSERR_VLAN_BOUNDTO_NETBRIDGE":{"errno":"0x4c0", "desc":"Vlan bound to Netbridge cannot be removed"},
}

NS_VXLAN_ERRORS = {
    "NSERR_VXLAN_INCOMP":{"errno":"0xa30", "desc":"Vlan extension and IP address - both cannot be configured on vxlan"},
    "NSERR_VXLAN_TUN_BOUND":{"errno":"0xa31", "desc":"Tunnel is already bound to this vxlan"},
    "NSERR_INV_MCAST":{"errno":"0xa32", "desc":"Another multicast group already configured for this vxlan"},
    "NSERR_TUN_NOT_BOUND":{"errno":"0xa33", "desc":"Tunnel not bound to this vxlan"},
    "NSERR_IP_NOT_BOUND":{"errno":"0xa34", "desc":"IP/IPv6 address not bound to this vxlan"},
    "NSERR_INV_TUN":{"errno":"0xa35", "desc":"Tunnel should be of VXLAN type"},
    "NSERR_NO_VXLAN":{"errno":"0xa36", "desc":"Vxlan is not configured"},
    "NSERR_VLAN_EXT":{"errno":"0xa37", "desc":"Vlan already extended by a different vxlan"},
    "NSERR_VXLAN_TD":{"errno":"0xa38", "desc":"Vxlan is bound to a traffic domain"},
    "NSERR_VXLAN_ROTUING":{"errno":"0xa39", "desc":"Vlan extension and routing - both cannot be configured on vxlan"},
    "NSERR_VXLANMAP_INUSE":{"errno":"0xab7", "desc":"This vlan-to-vxlan map table is in use by a netbridge/pbr-tunnel"},
    "NSERR_VXLAN_TBL_BOUND":{"errno":"0xab2", "desc":"Vxlan is in use by a vlan-to-vxlan map table"},
    "NSERR_TUN_MAP_TBL":{"errno":"0xab3", "desc":"The tunnel currently applies vlan-to-vxlan mappings"},
    "NSERR_VXLAN_INUSE":{"errno":"0xab4", "desc":"Vxlans that have vlan extensions or IP addresses or routing cannot be used in mapping table"},
    "NSERR_NETBDG_VXLAN_VLAN":{"errno":"0xab5", "desc":"Vlan-to-vxlan map table and vlan - both cannot be configured on a netbridge"},
    "NSERR_NO_VXLANMAP":{"errno":"0xab6", "desc":"Vlan-to-vxlan map table is not configured"},
    "NSERR_VXLANMAP_TUN_NOSUP":{"errno":"0xaba", "desc":"Incompatible tunnel type for vlan-to-vxlan map table"}
}

NS_0x850_ERRORS = {
    "NSERR_MONITOR_INTERVAL":{"errno":"0x850", "desc":"Monitor interval must be greater than response timeout"},
    "NSERR_MONITOR_DESTIP":{"errno":"0x851", "desc":"Destination IP must be specified for transparent, tunneled or tos monitors"},
    "NSERR_MONITOR_CODES":{"errno":"0x852", "desc":"Too many response codes, only 16 allowed"},
    "NSERR_MONITOR_REF":{"errno":"0x853", "desc":"Monitor must be unbound before it can be deleted"},
    "NSERR_MONITOR_BUILTIN":{"errno":"0x854", "desc":"Built-in monitors cannot be deleted"},
    "NSERR_MONITOR_BOUND":{"errno":"0x855", "desc":"The monitor is already bound to the service"},
    "NSERR_MONITOR_TYPE":{"errno":"0x856", "desc":"Invalid monitor type"},
    "NSERR_MONITOR_LOCAL":{"errno":"0x857", "desc":"Monitor object cannot be bound to local service"},
    "NSERR_TIMEOUT_RANGE":{"errno":"0x858", "desc":"Timeout value out of range; enter a value between 2 minutes and 1440 minutes"},
    "NSERR_INVALIDHASHLEN":{"errno":"0x859", "desc":"Hashlength should be between 1 and 4096 (inclusive)"},
    "NSERR_NOTAUTHORIZED":{"errno":"0x85A", "desc":"Not authorized to execute this command"},
    "NSERR_MONITOR_DEFAULT":{"errno":"0x85B", "desc":"No operations allowed with the default monitor"},
    "NSERR_MONITOR_LDNS_ADD_PERM":{"errno":"0x85C", "desc":"Cannot add monitor of ldns type"},
    "NSERR_MONITOR_LDNS_BIND_PERM":{"errno":"0x85D", "desc":"Cannot bind ldns monitor"},
    "NSERR_BACKUP_LOOP":{"errno":"0x860", "desc":"The VIP is already a backup in the chain"},
    "NSERR_SECURE_UDP":{"errno":"0x86A", "desc":"Secure mode not supported for this protocol"},
    "NSERR_MONITOR_WRONG_TYPE":{"errno":"0x86B", "desc":"Existing monitor is of different type than given"},
    "NSERR_LRTM_PERM":{"errno":"0x86C", "desc":"Enabling LRTM on this monitor type is not permitted"},
    "NSERR_MONITOR_SCRIPTNAME":{"errno":"0x86D", "desc":"Invalid script name for user monitor"},
    "NSERR_MONITOR_DISPATCHERIP":{"errno":"0x86F", "desc":"Invalid dispatcher IP for user monitor"},
    "NSERR_MONITOR_USERPERM":{"errno":"0x870", "desc":"Operation not permitted for a user monitor"},
    "NSERR_MONITOR_NOCODES":{"errno":"0x871", "desc":"A response code is required for this monitor type"},
    "NSERR_INVAL_MON":{"errno":"0x872", "desc":"Attempt to bind invalid monitor type"},
    "NSERR_TYPE_EXISTS":{"errno":"0x873", "desc":"Only one monitor of this type can be bound to a service"},
    "NSERR_MONITOR_UNBIND_DEFAULT":{"errno":"0x874", "desc":"Default monitor cannot be unbound from a service"},
    "NSERR_MONITOR_BIND_DEFAULT":{"errno":"0x875", "desc":"Default monitor cannot be bound explicitly to a service"},
    "NSERR_MONITOR_DISABLE_DEFAULT":{"errno":"0x876", "desc":"Default monitor cannot be disabled or enabled"},
    "NSERR_DRTM_PERM":{"errno":"0x877", "desc":"Dynamic response timeout is not permitted on this monitor type"},
    "NSERR_MON_DTRM_DEVIATION":{"errno":"0x878", "desc":"Response timeout of the monitor has been changed to interval - 1"},
    "NSERR_MONITOR_INVALID_VALUE":{"errno":"0x879", "desc":"Time parameter must be a multiple of 10"},
    "NSERR_MONITOR_NOT_BOUND":{"errno":"0x87A", "desc":"Monitor not bound to service"},
    "NSERR_INVALID_MONITOR":{"errno":"0x87B", "desc":"Monitor does not exist"},
    "NSERR_MONITOR_NO_SUCHIPADDR":{"errno":"0x87C", "desc":"Some IP addresses were not present"},
    "NSERR_MONITOR_SCRIPT_ARG_SIZE":{"errno":"0x87D", "desc":"Combined argument size too long"},
    "NSERR_METRICTABLE_NOENT":{"errno":"0x87E", "desc":"Metric table does not exist"},
    "NSERR_METRICTABLE_EXIST":{"errno":"0x87F", "desc":"Metric table exists"},
    "NSERR_DEL_METRICTABLE_PERMANENT":{"errno":"0x880", "desc":"Permanent metric table cannot be deleted"},
    "NSERR_MAX_METRIC_BINDING":{"errno":"0x881", "desc":"Maximum of 10 SNMP type metric can be bound to the monitor"},
    "NSERR_METRIC_NOENT":{"errno":"0x882", "desc":"Metric does not exist"},
    "NSERR_METRIC_EXISTS":{"errno":"0x883", "desc":"Metric exists"},
    "NSERR_OID_EXIST":{"errno":"0x884", "desc":"SNMP OID exists"},
    "NSERR_SNMP_OID_INVAL":{"errno":"0x885", "desc":"SNMP OID is invalid"},
    "NSERR_METRICTABLE_RDONLY":{"errno":"0x886", "desc":"No operations allowed on read only metric table"},
    "NSERR_THRESHOLD_ZERO":{"errno":"0x887", "desc":"This metric will not be used for CUSTOM LB as its threshold value is zero"},
    "NSERR_LDAP_MONITOR_INCOMPLETE":{"errno":"0x888", "desc":"bindDN or baseDN must be specified before LDAP monitor can be used"},
    "NSERR_MYSQL_MONITOR_INCOMPLETE":{"errno":"0x889", "desc":"userName or database must be specified before MYSQL monitor can be used"},
    "NSERR_POP3_MONITOR_INCOMPLETE":{"errno":"0x88A", "desc":"userName must be specified before POP3 monitor can be used"},
    "NSERR_NNTP_MONITOR_INCOMPLETE":{"errno":"0x88B", "desc":"group must be specified before NNTP monitor can be used"},
    "NSERR_FTPEXTENDED_MONITOR_INCOMPLETE":{"errno":"0x88C", "desc":"fileName must be specified before FTP-EXTENDED monitor can be used"},
    "NSERR_SNMP_MONITOR_INCOMPLETE":{"errno":"0x88D", "desc":"snmpOID or snmpCommunity must be specified before SNMP monitor can be used"},
    "NSERR_CITRIX_XML_SERVICE":{"errno":"0x88E", "desc":"application must be specified before CITRIX-XML-SERVICE monitor can be used"},
    "NSERR_CITRIX_WEB_INTERFACE":{"errno":"0x88F", "desc":"sitePath must be specified before CITRIX-WEB-INTERFACE monitor can be used"},
    "NSERR_LDNS_MON_CANT_DISABLE":{"errno":"0x890", "desc":"Atleast one ldns monitor needs to be enabled"},
    "NSERR_RES_RETRY_ON_IP_SVR":{"errno":"0x891", "desc":"Resolve retry can be set only on domain based servers"},
    "NSERR_IP_ON_DBS_SVR":{"errno":"0x892", "desc":"IP Address cannot be set on a domain based server"},
    "NSERR_MONITOR_FAILURERETRIES":{"errno":"0x894", "desc":"Monitor retries must be greater than monitor failureRetries"},
    "NSERR_MONITOR_IP":{"errno":"0x896", "desc":"The server/monitor destination ip address is not appropriate for this monitor"},
    "NSERR_MONITOR_SUBNET":{"errno":"0x897", "desc":"The server/monitor destination ip address should be in a directly connected subnet for this monitor"},
    "NSERR_MONITOR_STATIC":{"errno":"0x898", "desc":"A static/permanent MAC entry is configured for the server/monitor destination ip address"},
    "NSERR_TOSID_NOT_SET":{"errno":"0x899", "desc":"Tos id must be specified for tos enabled vserver/monitor"},
    "NSERR_FAILURERETRIES_NOT_SUPPORTED":{"errno":"0x89A", "desc":"The failure retries is not supported for this monitor type. Resetting the value of failure retries to 0(Disabled)."},
    "NSERR_SUCCESSRETRIES_NOT_SUPPORTED":{"errno":"0x89B", "desc":"The success retries is not supported for this monitor type. Resetting the value of success entries to 1(Disabled)."},
    "NSERR_SETVS_INVAL_MYSQLPARAMS":{"errno":"0x89C", "desc":"This parameter is only applicable to a MYSQL vserver."},
    "NSERR_SETVS_INVAL_PROTOCOL_PARAMS":{"errno":"0x89D", "desc":"The parameters are only applicable to  HTTP or SSL vservers."},
    "NSERR_SETVS_INVAL_PROTOCOLS_PARAMS":{"errno":"0x89E", "desc":"The parameters are only applicable to  HTTP , SSL or RTSP vservers."},
    "NSERR_DDC_VALIDATE_CRED_REQUIRED":{"errno":"0x89F", "desc":"Username, password and ddc domain are required for Xen Desktop monitor\n"},
    "NSERR_CITRIX_WI_EXTENDED_MONITOR_INCOMPLETE":{"errno":"0x8A0", "desc":"userName, password, sitepath and domain must be specified before CITRIX-WI-EXTENDED monitor can be used"},
    "NSERR_SETVS_INVAL_MSSQLPARAMS":{"errno":"0x8A1", "desc":"This parameter is only applicable to a MSSQL vserver."},
    "NSERR_DRTM_MON_BOUNDED_SVC":{"errno":"0x8A2", "desc":"In a cluster system, deviation can't be set/unset on any already bound monitor."},
    "NSERR_MONITOR_RESP_TO_THRESH":{"errno":"0x8A3", "desc":"Response timeout threshold is rounded off to nearest multiple of 10 less than the given value"},
    "NSERR_PASSIVE_ON_LOAD_ONLY":{"errno":"0x8A4", "desc":"PASSIVE option can be set only on LOAD monitors."},
    "NSERR_SETVS_INVAL_ORACLEPARAMS":{"errno":"0x8A5", "desc":"This parameter is only applicable to a ORACLE vserver."},
    "NSERR_RADIUS_ACCOUNTING_MONITOR_INCOMPLETE":{"errno":"0x8A6", "desc":"Secret key must be specified before RADIUS ACCOUNTING monitor can be used"},
    "NSERR_MONITOR_SCRIPT_ARG_CNT":{"errno":"0x8A7", "desc":"Too many script arguments"},
    "NSERR_INVALID_DBSLB_BIND":{"errno":"0x8A8", "desc":"More than one bind not possible on one service for DBSLB "},
    "NSERR_USER_NONETPROF":{"errno":"0x8A9", "desc":"Netprofile cannot be set on scriptable monitors, so ignoring the configured netprofile for this monitor. "},
    "NSERR_MONITOR_NO_SSLPROFILE_BOUND":{"errno":"0x8AA", "desc":"No SSL profile is attached to monitor. Attach SSL profile first"},
}

NS_0x900_ERRORS = {
    "NSERR_SVCPORTTYPE":{"errno":"0x901", "desc":"Service exists with the same port and service type"},
    "NSERR_VIP_IN_GROUP":{"errno":"0x902", "desc":"vserver is bound to a group. Set persistence parameters on group to change them for all vservers in group or unbind vserver from group and set on individual vserver."},
    "NSERR_UNSUPPORTED_BKP":{"errno":"0x903", "desc":"This backup/primary persistence combination is not supported"},
    "NSERR_NONHTTPSSL_VIPINGRP":{"errno":"0x904", "desc":"Cookie persistence cannot be applied - group has non HTTP/SSL type of vserver"},
    "NSERR_NONHTTP_VIPINGRP":{"errno":"0x905", "desc":"Cookie persistence cannot be applied - group has non-HTTP type of vserver"},
    "NSERR_USE_PROPER_RM_CMD":{"errno":"0x906", "desc":"Use remove IP option instead"},
    "NSERR_LBMETHOD_NOT_SUPPORTED":{"errno":"0x911", "desc":"LB method not supported for LLB/PBR"},
    "NSERR_PERSISTENCE_NOT_SUPPORTED":{"errno":"0x912", "desc":"Persistence not supported for LLB/PBR"},
    "NSERR_VSERVER_PARAMETERS":{"errno":"0x913", "desc":"Vserver arguments not valid for LLB/PBR VIP"},
    "NSERR_SERVICE_PARAMETERS":{"errno":"0x914", "desc":"Service parameters are invalid for LLB/PBR VIP"},
    "NSERR_LBVIP_DELETE":{"errno":"0x915", "desc":"Vserver cannot be removed with out removing LB/PBR route"},
    "NSERR_CACHEPOLICY_RESPACTION_INVAL":{"errno":"0x916", "desc":"Integrated caching action cannot be applied on a response"},
    "NSERR_CACHELICENSE_FAILED":{"errno":"0x917", "desc":"The license for Integrated Caching feature was not enabled due to an internal error"},
    "NSERR_LBVIP_MULTIROUTES":{"errno":"0x918", "desc":"VIP can't be associated with multiple LB/PBR routes"},
    "NSERR_LBMAC_INVAL":{"errno":"0x919", "desc":"MAC/IPTUNNEL mode can be set only for a VIP with wildcard IP or with service type ANY or for a sessionless VIP"},
    "NSERR_CACHESTATS_OBJ_NOTPRESENT":{"errno":"0x920", "desc":"No object in cache matching the specified attributes"},
    "NSERR_CACHEPOLICY_NOTACTIVE":{"errno":"0x921", "desc":"Integrated caching policy is not active"},
    "NSERR_CACHE_BUILTINS_NOT_SOURCED":{"errno":"0x922", "desc":"Failed sourcing cache builtins, Disabling IC"},
    "NSERR_CACHEPOLICY_PRIORITY_INVAL":{"errno":"0x923", "desc":"Invalid priority"},
    "NSERR_ROUTE6_DEFAULT_ONLY":{"errno":"0x924", "desc":"Only default route configuration supported"},
    "NSERR_ROUTE6_DEFAULT_EXISTS":{"errno":"0x925", "desc":"Configured route already exists"},
    "NSERR_ROUTE6_INVALID_GATEWAY":{"errno":"0x926", "desc":"Invalid gateway"},
    "NSERR_ROUTE6_MAX":{"errno":"0x927", "desc":"Already maximum number of routes configured"},
    "NSERR_ROUTE6_NOT_EXIST":{"errno":"0x928", "desc":"Route does not exist"},
    "NSERR_IPV6_INVALID_ADDR":{"errno":"0x929", "desc":"Incorrect IPv6 address type"},
    "NSERR_LBVIP_IPV6TOV4":{"errno":"0x930", "desc":"Changing IP from IPv6 to IPv4 not permitted"},
    "NSERR_IPV6_NSIPTOVIP":{"errno":"0x931", "desc":"Configuring NSIP as VIP not permitted"},
    "NSERR_IPV6_VIPTONSIP":{"errno":"0x932", "desc":"Configuring VIP as NSIP not permitted"},
    "NSERR_IPV6_SCOPE":{"errno":"0x933", "desc":"Incorrect IPv6 address scope. (Default: global)"},
    "NSERR_LBVIP_IPV4TOV6":{"errno":"0x934", "desc":"Changing IP from IPv4 to IPv6 not permitted"},
    "NSERR_IPV6_LINKLOCALTOVIP":{"errno":"0x935", "desc":"Configuring Link-Local address as VIP not permitted"},
    "NSERR_IPV6_MAPIPONNSIP":{"errno":"0x936", "desc":"Mapped IP should not be configured for NSIP (Ignoring mapped ip)"},
    "NSERR_SECUREIPPORTADDRINUSE":{"errno":"0x937", "desc":"Internal secure service exists with the same port and service type. Please use this for secure access"},
    "NSERR_IPV6_INVALID_PREFIX":{"errno":"0x938", "desc":"Link-local prefix length is not equal to 64"},
    "NSERR_ND6_LINKLOCAL_VLAN":{"errno":"0x939", "desc":"Vlan is necessary with IPv6 Link-local address"},
    "NSERR_INVALID_IPV6_PREFIXLFT":{"errno":"0x93A", "desc":"Invalid IPv6 prefix life time. prefix valid life time must be greater than or equal to preferred life time"},
    "NSERR_IPV6_ND_TIMEOUT":{"errno":"0x93B", "desc":"Can not SET/UNSET ndtimeouts, when ra_learning is enabled."},
    "NSERR_ND6_VLAN_INTF":{"errno":"0x940", "desc":"Interface/channel not a member of given vlan"},
    "NSERR_PERSIST_TIMEOUT_TO_DEFAULT":{"errno":"0x941", "desc":"Unsetting Persistency, changing timeout to default"},
    "NSERR_LB_GROUP_NOT_EXIST":{"errno":"0x942", "desc":"LB group does not exist"},
    "NSERR_LB_VSERVER_ALREADY_BOUND":{"errno":"0x943", "desc":"Vserver is already bound to a LB group"},
    "NSERR_ROUTE6_INVALID_LINKLOCAL_GATEWAY_VLAN":{"errno":"0x944", "desc":"Vlan ID must be specified for linklocal gateway"},
    "NSERR_ROUTE6_NO_GWORIF":{"errno":"0x945", "desc":"Either Gateway or Interface (vlan) should be specified for route"},
    "NSERR_ROUTE6_VLAN_MONITOR":{"errno":"0x946", "desc":"Monitor should not be given for vlan route"},
    "NSERR_LBMETHOD_LEASTREQ_NOT_SUPPORTED":{"errno":"0x947", "desc":"LeastRequest LB method not supported for this service type"},
    "NSERR_IPV6_MULTIPLE_LLIP":{"errno":"0x948", "desc":"Multiple link-local IPs to a Vlan is not allowed"},
    "NSERR_IPV6_TOOMANY_PREFIXES":{"errno":"0x949", "desc":"Too many prefixes to a Vlan, maxmimum 5 prefixes are allowed"},
    "NSERR_RAPREFIX_BOUNDTOVLAN":{"errno":"0x94A", "desc":"Router Advertisement prefix is bound to vlan"},
    "NSERR_LB_VSERVER_NOT_BOUND":{"errno":"0x94B", "desc":"Given vserver is not bound to this LB group"},
    "NSERR_VSERVER_BOUND_TO_NG":{"errno":"0x94C", "desc":"Cannot delete vserver that is bound to a nodegroup"},
    "NSERR_LRONLACPONLY":{"errno":"0x94E", "desc":"Link Redundancy can be set only on LACP Channels"},
    "NSERR_CACHE_POLICY_CONTENTGRPMISMATCH":{"errno":"0x94F", "desc":"Type of Content Group and Policy does not Match."},
    "NSERR_NONHTTPNOSQL_VS":{"errno":"0x950", "desc":"Specified policy can be bound only to HTTP/SSL/MYSQL/MSSQL/PROXY vserver."},
    "NSERR_SMPP_CUSTOM_SVRID_LEN_NOT_SUPPORTED":{"errno":"0x951", "desc":"CustomServerID length for SMPP protocol must be 2"},
    "NSERR_SMPP_CUSTOM_SVRID_NOT_EXIST":{"errno":"0x952", "desc":"CustomServerID is mandatory for SMPP protocol"},
    "NSERR_SMPP_CUSTOM_SVRID_EXIST":{"errno":"0x953", "desc":"CustomServerID already exists, it should be unique for SMPP protocol"},
    "NSERR_SIP_DUPLICATE_SRC_PORT":{"errno":"0x954", "desc":"RNAT source port and RNAT secure source port must be different"},
    "NSERR_SIP_DUPLICATE_DST_PORT":{"errno":"0x955", "desc":"RNAT destination port and RNAT secure destination port must be different"},
    "NSERR_IP_ADDR_ICMP_DIS_NOT_ALLOWED":{"errno":"0x956", "desc":"Disabling ICMP for an IP(v6) address is not allowed "},
    "NSERR_IP_ADDR_ND6_DIS_NOT_ALLOWED":{"errno":"0x957", "desc":"disabling neighbor discovery for an ipv6 address is not allowed"},
    "NSERR_IP_ADDR_STATE_DIS_NOT_ALLOWED":{"errno":"0x958", "desc":"state disable is not allowed for an IP(v6) address"},
    "NSERR_ND6_LOOP_LL_NOT_ALLOW":{"errno":"0x959", "desc":"Loopback/self or link-local IP addresses not allowed"},
    "NSERR_PERSISTENCE_NOT_SUPPORTED_ON_GROUP":{"errno":"0x971", "desc":"Vserver level persistency is enabled on the group. Set Persistence parameters on bound vservers."},
}


NS_CLUSTER_ERRORS = {
    "NSERR_CLNOTEXIST ":{"errno":"0x990", "desc":"Cluster does not exist"},
    "NSERR_TOOMANYCLS ":{"errno":"0x991", "desc":"This node is already added to another cluster"},
    "NSERR_RMLOCALNODE":{"errno":"0x992", "desc":"Local Node cannot be deleted"},
    "NSERR_BKPLANEENABLED":{"errno":"0x993", "desc":"Cluster Backplane is enabled on this interface"},
    "NSERR_LOCALNODE_NOTCONFIGURED":{"errno":"0x994", "desc":"Clustering cannot be enabled as the local node is not a member of the cluster."},
    "NSERR_HACL_CANNOT_COEXIST":{"errno":"0x995", "desc":"Clustering and HA cannot coexist."},
    "NSERR_CLACPKEYNOTCRT":{"errno":"0x996", "desc":"LACP key for Node/cluster is not correct"},
    "NSERR_CLNODE_EXIST":{"errno":"0x997", "desc":"already in cluster"},
    "NSERR_BKPLANEDISABLED":{"errno":"0x998", "desc":"Disabling Cluster backplane interface"},
    "NSERR_CLAGTHROUGHPUT":{"errno":"0x999", "desc":"Currently throughput settings are not allowed on CLAG"},
    "NSERR_LICMISMATCH":{"errno":"0x99A", "desc":"License mismatch between Configuration Coordinator and local node"},
    "NSERR_CLIP_INVALIDNETMASK":{"errno":"0x99B", "desc":"CLIP netmask should be 255.255.255.255."},
    "NSERR_BKPLANELACPDELETE":{"errno":"0x99C", "desc":"This is the last interface in LACP channel configured as backplane"},
    "NSERR_LINKSETMEMBER":{"errno":"0x99D", "desc":"Interface/Channel is Linkset member."},
    "NSERR_CONFIG_PARAM":{"errno":"0x99E", "desc":"Setting up of netscaler parameter ignored using this command in HA/Cluster mode. Use 'set nsparam' command for this purpose."},
    "NSERR_CLIP_INVALIDPREFIXLEN":{"errno":"0x99F", "desc":"CLIP prefix length should be 128."},
    "NSERR_CLUSTER_L2NOTSUPP":{"errno":"0x9A0", "desc":"L2 Mode not supported in Cluster mode."},
    "NSERR_LINKSET_ONEPERNODE":{"errno":"0x9A1", "desc":"Linkset can have only one Interface/Channel per Node"},
    "NSERR_LINKSET_NOTBOUND":{"errno":"0x9A2", "desc":"Interface/Channel not bound to Linkset"},
    "NSERR_LINKSET_IDINVALID":{"errno":"0x9A3", "desc":"Linkset name should be of form LS/<id>, id range:1-32"},
    "NSERR_CLUSTER_NBNOTSUPP":{"errno":"0x9A4", "desc":"CloudBridge is not supported in Cluster mode."},
    "NSERR_CLUSTER_VPNNOTSUPP":{"errno":"0x9A5", "desc":"SSLVPN is not supported in Cluster mode."},
    "NSERR_CLUSTER_AAANOTSUPP":{"errno":"0x9A6", "desc":"AAA is not supported in Cluster mode."},
    "NSERR_CLUSTER_IPSECNOTSUPP":{"errno":"0x9A7", "desc":"IPSEC is not supported in Cluster mode."},
    "NSERR_LINKSET_LAMEMBER":{"errno":"0x9A8", "desc":"Interface part of a Channel"},
    "NSERR_CLIP_LOCALNODE_NOTCONFIGURED":{"errno":"0x9A9", "desc":"CLIP cannot be added as the local node is not a member of the cluster."},
    "NSERR_CLVERSIONMISMATCH":{"errno":"0x9AA", "desc":"Cluster version mismatch between Configuration Coordinator and local node"},
    "NSERR_CLUSTER_CMNOTSUPP":{"errno":"0x9AB", "desc":"Connection Mirroring is not supported in Cluster mode"},
    "NSERR_ARP_CLAG_OWNERNODE_MANDATORY":{"errno":"0x9AC", "desc":"Owner Node should be specified for CLAG."},
    "NSERR_ARP_OWNERNODE_MANDATORY":{"errno":"0x9AD", "desc":"Owner Node should be specified."},
    "NSERR_NOOPCCO":{"errno":"0x9AE", "desc":"Operation not permitted on the Configuration Coordinator."},
    "NSERR_SPOTTED_CONFIG_PRESENT":{"errno":"0x9AF", "desc":"Operation not permitted as the node is part of spotted entity configuration."},
    "NSERR_NOT_CLUSTER_IP":{"errno":"0x9B0", "desc":"IP address should be a CLIP address."},
    "NSERR_CLUSTER_NNRES":{"errno":"0x9B1", "desc":"Error in communication with other nodes in the cluster"},
    "NSERR_LAST_CLUSTER_IP_REMOVAL":{"errno":"0x9B2", "desc":"A NetScaler cluster must have a minimum of one cluster IP address. This is the last available cluster IP address and hence it cannot be deleted."},
    "NSERR_CONFIG_PARAM_INVALID":{"errno":"0x9B3", "desc":"Configured Param(s) too small for Cluster. Parameter value(s) will be bumped to OVS node count."},
    "NSERR_CLUSTER_INVALIDNODE":{"errno":"0x9B4", "desc":"Owner node value should be between 0 and 31, both inclusive."},
    "NSERR_LRONCLACPONLY":{"errno":"0x9B5", "desc":"Link Redundancy can be set only in Cluster LACP Channels"},
    "NSERR_MULTIBIND_NOT_SUPPINCLUSTER":{"errno":"0x9B6", "desc":"Multiple Bindings in Single Bind Command not Supported in Cluster."},
    "NSERR_CLUSTER_FISNAMES_DUPNOTALLOWED":{"errno":"0x9B7", "desc":"In a cluster setup, the FIS name on each node must be unique."},
    "NSERR_CLUSTER_CLAG_NOLOCALINTF":{"errno":"0x9B8", "desc":"CLA cannot be bound to the FIS as the CLA does not contain a local interface."},
    "NSERR_FIS_MAX_LIMIT":{"errno":"0x9B9", "desc":"An appliance can have a maximum of 64 failover interface sets (FIS). This appliance or ownernode (cluster) already has maximum number of allowable FIS."},
    "NSERR_BOUND_TO_FIS":{"errno":"0x9BA", "desc":"Interface bound to FIS."},
    "NSERR_CHANNEL_OPEN_FAILED":{"errno":"0x9BB", "desc":"Unable to open channel"},
    "NSERR_NOT_BOUND_TO_FIS":{"errno":"0x9BC", "desc":"Interface not bound to this FIS"},
    "NSERR_CLUSTER_INC_NOTSUPP":{"errno":"0x9BD", "desc":"Feature not supported when cluster is configured in INC mode"},
    "NSERR_CONFIG_NG_CHANGED":{"errno":"0xfff", "desc":"Config NodeGroup changed, force cluster sync should be fired on newly added node to be in sync"},
    "NSERR_STRIPED_IP_EXIST":{"errno":"0x9BE", "desc":"Striped SNIPs/MIPs must be removed when transitioning to cluster-inc"},
    "NSERR_WRONG_NG":{"errno":"0x9BF", "desc":"All cluster nodes should be bound to DEFAULT_NG before transitioning to cluster-inc "},
    "NSERR_NG_REQUIRED":{"errno":"0x9C0", "desc":"The nodegroup parameter is mandatory when the -inc parameter is enabled"},
    "NSERR_NG_CHANGE":{"errno":"0x9C1", "desc":"NodeGroup can be changed only for transition from cluster to cluster-inc"},
    "NSERR_NG_INVALID":{"errno":"0x9C2", "desc":"Invalid nodegroup"},
    "NSERR_NOT_LAST_NODE":{"errno":"0x9C3", "desc":"The -flushall parameter can be enabled only when there is one node in the nodegroup"},
    "NSERR_MULTI_NG_BINDING_EXIST":{"errno":"0x9C4", "desc":"More than one Nodegroup has nodes bound to it"},
    "NSERR_INVALID_NC_CONFIG":{"errno":"0x9C5", "desc":"The owner group parameter is applicable only when the INC parameter is enabled on the cluster instance"},
    "NSERR_FIPSCL_CANNOT_COEXIST":{"errno":"0x9C6", "desc":"Clustering and FIPs configuration cannot coexist."},
    "NSERR_LS_CLAG_INTF_SAME_NG":{"errno":"0x9C7", "desc":"All interfaces of LinkSet/CLAG should belong to same nodegroup"},
    "NSERR_NODE_BINDING_INC":{"errno":"0x9C8", "desc":"Node cannot be bound to Default nodeGroup on cluster-inc setup"},
    "NSERR_IP_OWNERDOWN_PARAM":{"errno":"0x9DA", "desc":"OwnerDownResponse allowed only for spotted SNIP on cluster"},
    "NSERR_INVALID_LS":{"errno":"0x96b", "desc":"Invalid linkset"},
    "NSERR_IP_ALREADY_OWNED":{"errno":"0x9ed", "desc":"Cannot add ip address as the address is already owned by cluster or peer node"},
    "NSERR_LS_UNABLE_GET_VLAN":{"errno":"0x9ee", "desc":"Unable to get the current vlan of this linkset."},
    "NSERR_LS_NOT_BOUND_VLAN":{"errno":"0x9ef", "desc":"Linkset not a member of this vlan"},
    "NSERR_CL_UNSUPPORTED_PROTO":{"errno":"0x9f0", "desc":"Retain connections on joining a new node is not supported for this protocol"},
    "NSERR_CL_UNSUPPORTED_IN_NCORE":{"errno":"0x9f1", "desc":"This feature/option is not supported in n-core"},
    "NSERR_NO_SETTING_PROP":{"errno":"0x9f2", "desc":"This setting will not be propagated to other nodes."}
}

NS_NNM_ERRORS = {
    "NSERR_NNM_FAILED":{"errno":"0x9e0", "desc":"General NNM failure"},
    "NSERR_NNM_CONN_CLEANED":{"errno":"0x9e1", "desc":"NNM connection was cleaned"},
    "NSERR_NNM_CONN_FAILED":{"errno":"0x9e2", "desc":"NNM connection failed"},
    "NSERR_NNM_NO_CONN":{"errno":"0x9e3", "desc":"NNM connection was not found"},
    "NSERR_NNM_CONN_DROPPED":{"errno":"0x9e4", "desc":"NNM connection dropped"},
    "NSERR_NNM_EINJECT":{"errno":"0x9e5", "desc":"NNM error injection"},
    "NSERR_NNM_VERSION_UNSUPPORTED":{"errno":"0x9e6", "desc":"NNM group payload version is unsupported"},
    "NSERR_NNM_TIMEOUT_MSG":{"errno":"0x9e7", "desc":"NNM timeout unable to send message"},
    "NSERR_NNM_TIMEOUT_ACK":{"errno":"0x9e8", "desc":"NNM timeout waiting for ACK"},
    "NSERR_NNM_MCAST":{"errno":"0x9e9", "desc":"NNM multicast/broadcast failed"},
    "NSERR_NNM_PENDING":{"errno":"0x9ea", "desc":"NNM operation is in a pending state (e.g., ACK held)"}
}

NS_INTERNAL_NAMESERVER_ERRORS = {
    "NSERR_NAME_SVR_EXISTS":{"errno":"0xa01", "desc":"Name server already exists."},
    "NSERR_NAME_SVR_IDNS_NEMPTY":{"errno":"0xa02", "desc":"Name servers already configured."},
    "NSERR_NAME_SVR_IVALPOLICY":{"errno":"0xa03", "desc":"Invalid LB method for vserver-based name server."},
    "NSERR_NAME_SVR_IVALPROTO":{"errno":"0xa04", "desc":"Invalid service type for vserver-based name server."},
    "NSERR_NAME_SVR_ADD_NEXIST_VIP":{"errno":"0xa05", "desc":"vserver does not exist."},
    "NSERR_NAME_SVR_NEXIST":{"errno":"0xa06", "desc":"Name server does not exist."},
    "NSERR_NAME_SVR_IDNS_PERM":{"errno":"0xa07", "desc":"Operation on internal entity not permitted"},
    "NSERR_NAME_SVR_IP_EXISTS":{"errno":"0xa08", "desc":"Name server exists with this IP address"},
    "NSERR_NAME_SVR_TYPE_NEXIST_VIP":{"errno":"0xa09", "desc":"vserver of given type does not exist."}
}

NS_SSLVPN_AAA_ERRORS = {
    "NSERR_ERR_AAA_LICENSE":{"errno":"0xa40", "desc":"MaxAAAUsers value more than allowed by license, ignored."},
    "NSERR_USR_NOINTRAIP":{"errno":"0xa41", "desc":"No intranet IP bound to user"},
    "NSERR_USR_NOTCONFIGURED":{"errno":"0xa42", "desc":"User does not exist"},
    "NSERR_INVAL_AAA_GRP":{"errno":"0xa43", "desc":"Group does not exist"},
    "NSERR_INVAL_COMBNATION":{"errno":"0xa44", "desc":"NONE and ALL cannot be used simultaneously"},
    "NSERR_INVAL_MIP_IIP":{"errno":"0xa45", "desc":"Both Mapped IP and Intranet IP must be specified"},
    "NSERR_INVAL_MIPOFF_IIPOFF":{"errno":"0xa46", "desc":"Mapped IP and Intranet IP cannot be OFF at the same time"},
    "NSERR_USEREXIST":{"errno":"0xa47", "desc":"User already exists"},
    "NSERR_GROUPEXIST":{"errno":"0xa48", "desc":"Group already exists"},
    "NSERR_USERALREADYBOUND":{"errno":"0xa49", "desc":"User is already bound to the group"},
    "NSERR_NO_RADIUS_IP":{"errno":"0xa4a", "desc":"ServerIP is not configured in radius params"},
    "NSERR_NO_TACACS_IP":{"errno":"0xa4b", "desc":"ServerIP is not configured in  tacacs params"},
    "NSERR_USERNOTBOUND":{"errno":"0xa50", "desc":"User is not bound to the group"},
    "NSERR_ENTITYNOTBOUND":{"errno":"0xa51", "desc":"Entity not bound"},
    "NSERR_GROUPNOTEXIST":{"errno":"0xa52", "desc":"Group does not exist"},
    "NSERR_INVALIDLOGLEVEL":{"errno":"0xa53", "desc":"NONE cannot be combined with other options"},
    "NSERR_DH_MISCONFIG":{"errno":"0xa54", "desc":"The first hop and second hop can not be enabled on the same vserver"},
    "NSERR_DH_IPPORT":{"errno":"0xa55", "desc":"The SG second hop ip and port are required"},
    "NSERR_DHINUSE":{"errno":"0xa56", "desc":"Bound double hop server cannot be removed"},
    "NSERR_INVAL_AAAGLOBAL_POLTYPE":{"errno":"0xa57", "desc":"Only preauthentication policies can be bound to AAA global"},
    "NSERR_NO_LDAP_IP":{"errno":"0xa58", "desc":"ServerIP is not configured in ldap params"},
    "NSERR_AAATM_LIC":{"errno":"0xa59", "desc":"Feature not licensed [AAA]"},
    "NSERR_AAATM_DISABLED":{"errno":"0xa5a", "desc":"Feature(s) not enabled [AAA]"},
    "NSERR_NO_AUTH_HOST":{"errno":"0xa5b", "desc":"No Authentication Host specified"},
    "NSERR_AUTH_ON":{"errno":"0xa5c", "desc":"Turn authentication off first"},
    "NSERR_KILLPENDING":{"errno":"0xa5d", "desc":"Another kill command in progress"},
    "NSERR_AAATM_NO_AUTH_VS":{"errno":"0xa5e", "desc":"No Authentication vserver name specified or the server does not exist"},
    "NSERR_AAATM_401AUTH_ON":{"errno":"0xa5f", "desc":"Turn off 401 based authentication first"},
    "NSERR_UNAUTHRZED":{"errno":"0xa60", "desc":"Unauthorized"},
    "NSERR_KILL_INPROGRESS":{"errno":"0xa61", "desc":"A kill session command is in progress. Try again later"},
    "NSERR_WI_FRM_NOTEXIST":{"errno":"0xa62", "desc":"Farm does not exist"},
    "NSERR_WI_FRM_LAST":{"errno":"0xa63", "desc":"At least one Farm should be configured: can not remove last farm"},
    "NSERR_WI_NOTINST":{"errno":"0xa64", "desc":"Web interface not installed"},
    "NSERR_WI_GENFAILED":{"errno":"0xa65", "desc":"Unable to generate website"},
    "NSERR_WI_SITE_EXIST":{"errno":"0xa66", "desc":"Site already exists"},
    "NSERR_WI_SITE_NOTEXIST":{"errno":"0xa67", "desc":"Site does not exist"},
    "NSERR_WI_SITE_INVAL_AGURL":{"errno":"0xa68", "desc":"Invalid agURL"},
    "NSERR_WI_SITE_INVAL_STAURL":{"errno":"0xa69", "desc":"Invalid staURL"},
    "NSERR_WI_SITE_ONLY_MPX":{"errno":"0xa6a", "desc":"WI can only be installed on NetScaler nCore builds"},
    "NSERR_WI_INSTFAILED":{"errno":"0xa6b", "desc":"Installation failed. Please check the log file /var/log/wicmd.log"},
    "NSERR_WI_MAXSITE_EXCD":{"errno":"0xa6c", "desc":"Maximum number of WI Sites exceeded. Please check the log file /var/log/wicmd.log"},
    "NSERR_WI_STAWITHOUTAGURL":{"errno":"0xa6d", "desc":"STAUrl cannot be specified without AGUrl."},
    "NSERR_WI_AGURLWITHOUTSTA":{"errno":"0xa6e", "desc":"AGUrl cannot be specified without STAUrl."},
    "NSERR_WI_RELWITHOUTAGURL":{"errno":"0xa6f", "desc":"SessionReliability cannot be ON without AGUrl."},
    "NSERR_WI_AUTHWITHOUTAGURL":{"errno":"0xa70", "desc":"AuthenticationPoint cannot be specified without AGUrl."},
    "NSERR_WI_TWOTKTWITHOUTREL":{"errno":"0xa71", "desc":"UseTwoTickets cannot be ON without SessionReliability."},
    "NSERR_WI_TWOTKTWITHOUTSECSTA":{"errno":"0xa72", "desc":"UseTwoTickets cannot be ON without SecondSTAUrl."},
    "NSERR_WI_SECSTASAME":{"errno":"0xa73", "desc":"SecondSTAUrl should be different from StaURL."},
    "NSERR_WI_LICENSE":{"errno":"0xa74", "desc":"Web Interface on NS Feature not licensed."},
    "NSERR_WI_SECSTAWITHOUTSTA":{"errno":"0xa75", "desc":"SecondSTAUrl cannot be specified without STAUrl."},
    "NSERR_AUTH_NEGOTIATE":{"errno":"0xa76", "desc":"Negotiate authentication required"},
    "NSERR_WI_INSTSITESREDUCED":{"errno":"0xa77", "desc":"Memory available is not sufficient for the passed maxSites value"},
    "NSERR_WI_INCOMPATIBLEAUTHPOINT":{"errno":"0xa78", "desc":"WI Authentication methods can not be specified unless authentication point is WI"},
    "NSERR_WI_SITE_WITHIN_SITE":{"errno":"0xa79", "desc":"One WI site can not be completely within another WI site"},
    "NSERR_WI_SITE_TRANSLATION_NOEXIST":{"errno":"0xa7a", "desc":"Translation Map does not exist"},
    "NSERR_WI_SITE_TRANSLATION_LAST":{"errno":"0xa7b", "desc":"Can't Unbind Last Translation Map"},
    "NSERR_WI_SITE_NOAGURL":{"errno":"0xa7c", "desc":"AGURL is not set"},
    "NSERR_AGSVC_AUTHFAIL":{"errno":"0xa7d", "desc":"AG-Service request with invalid AAAC cookie"},
    "NSERR_TM_INVALID_PERS_CONFIG":{"errno":"0xa7e", "desc":"Please specify both persistentCookie and persistentCookieValidity parameters"},
    "NSERR_WI_SMARTCARD_NOT_SUPPORTED":{"errno":"0xa7f", "desc":"SmartCard AGAuthentication method is not supported with sites created using wi package"},
    "NSERR_WI_SEARCH_NOT_SITEWEB":{"errno":"0xa80", "desc":"Show Search Attribute supported only for site type XenAppWeb"},
    "NSERR_KCD_ACCOUNT_NOT_EXISTS":{"errno":"0xa81", "desc":"The KCD account does not exist"},
    "NSERR_KCD_KEYTAB_NOT_EXISTS":{"errno":"0xa82", "desc":"The keytab file does not exist"},
    "NSERR_KCD_VS_PRINCIPLE_NOT_FOUND":{"errno":"0xa83", "desc":"The Vserver principle not found"},
    "NSERR_KCD_REM_INUSE":{"errno":"0xa84", "desc":"KCD account is in use and cannot be removed"},
    "NSERR_KCD_TOO_MANY_VS_PRINCIPLE":{"errno":"0xa85", "desc":"Too many host principles"},
    "NSERR_WI_REFRESH_NOT_SITEWEB":{"errno":"0xa86", "desc":"Show Refresh Attribute supported only for site type XenAppWeb"},
    "NSERR_WI_UIMODE_NOT_SITEWEB":{"errno":"0xa87", "desc":"User Interface Mode  Attribute supported only for site type XenAppWeb"},
    "NSERR_WI_UILAYOUT_NOT_SITEWEB":{"errno":"0xa88", "desc":"User Interface Layout  Attribute supported only for site type XenAppWeb"},
    "NSERR_WI_MESSAGESTRS_NOT_SITEWEB":{"errno":"0xa89", "desc":"App Welcome Message, Welcome Message, Footer Text, Login Sys Message, Pre Login Button, Pre Login Message, Pre Login Title Attributes supported only for site type XenAppWeb"},
    "NSERR_AAATM_AUTHN_PROFILE_CONF":{"errno":"0xa90", "desc":"Please turn ON authentication or authn401 setting in order to use authentication profile"},
    "NSERR_NEGACTION_UNAME_DOM":{"errno":"0xa91", "desc":"Domain must either be specified either explicitly or in the username"},
    "NSERR_NO_PRODUCTION_FARM":{"errno":"0xa92", "desc":"WI site will not be fuctional till a production farm is bound"},
    "NSERR_SAML_FORM_CONFLICT":{"errno":"0xa93", "desc":"Traffic cannot have both SAML SSO and Form SSO on same action"},
    "NSERR_MAXLOGIN_FAILLOGIN_CONFLICT":{"errno":"0xa94", "desc":"Please specify both max login attempts and fail login timeout"},
    "NSERR_KCD_ACCOUNT_EXIST":{"errno":"0xa95", "desc":"The KCD account does not exist"},
    "NSERR_KCD_ACCOUNT_NOTCONFIGURED":{"errno":"0xa96", "desc":"The KCD account is not configured"},
    "NSERR_NEGACTION_KEYTAB_CONFLICT":{"errno":"0xa97", "desc":"Action should have either keytab file or domain, username and password. Domain need not be specified if UPN is given for username"},
    "NSERR_KEYTAB_INVALID_ENC":{"errno":"0xa98", "desc":"Unsupported encryption type in keytab file"},
    "NSERR_HTTP_SSL_PROXY_CONFLICT":{"errno":"0xa99", "desc":"Cannot configure both HTTP and SSL proxy"},
    "NSERR_INVALIDIP_PORT":{"errno":"0xa9a", "desc":"Invalid IP or Port"},
    "NSERR_ADVEPA_NOTSUPP":{"errno":"0xa9b", "desc":"VServer does not support advanced EPA scans"},
    "NSERR_ADVEPA_NOPROFILE":{"errno":"0xa9c", "desc":"EPA profile with this name does not exist"},
    "NSERR_ADVEPA_INUSE":{"errno":"0xa9d", "desc":"Bound EPA profile cannot be removed."},
    "NSERR_ADVEPA_EXISTS":{"errno":"0xa9e", "desc":"EPA profile exists."},
    "NSERR_ADVEPA_BOUND":{"errno":"0xa9f", "desc":"EPA profile already bound to vserver."},
    "NSERR_ADVEPA_NOTBOUND":{"errno":"0xaa0", "desc":"EPA profile not bound to vserver."},
    "NSERR_ADVEPA_ON":{"errno":"0xaa1", "desc":"Advanced EPA is ON, can not bind classic preauthentication policy."},
    "NSERR_DEVICEPROFILE_ADDRM_FAIL":{"errno":"0xaa2", "desc":"There has been a design change in the support of OPSWAT specific EPA scans. EPA Profile Configuration is no longer needed. Please refer to support documents for complete details."},
    "NSERR_DEVICEPROFILE_INTERNAL_ERR":{"errno":"0xaa3", "desc":"An Internal Error occurred while operating on the Device Profile, please contact your Admin"},
    "NSERR_AAA_SESS_INVALID_INDEX":{"errno":"0xaa4", "desc":"Invalid attribute index. Attribute index should be between 1 and 16 both included"},
    "NSERR_AAATM_FORCETIMEOUT":{"errno":"0xaa5", "desc":"Force timeout setting of START or RESET must accompany a desired time in minutes"},
    "NSERR_KCDACCOUNT_KEYTAB":{"errno":"0xaa6", "desc":"Keytab file cannot be specified along with other parameters in kcdaccount"},
    "NSERR_KCDACCOUNT_REALM":{"errno":"0xaa7", "desc":"Realm must be specified by itself or extracted from delegated username/keytab"},
    "NSERR_WEBAUTH_FULLEXP":{"errno":"0xaa8", "desc":"Please specify full request expression"},
    "NSERR_WI_INVALID_SETTING_FOR_AUTHPOINT":{"errno":"0xaa9", "desc":"Setting is Invalid for given Authpoint"},
    "NSERR_WI_SETTING_VALIDONLYFOR_XENAPPWEB":{"errno":"0xaaa", "desc":"Setting is Invalid for SiteType other than XenAppWeb"},
    "NSERR_WI_PARAMETER_UPGARDE_ERROR":{"errno":"0xaab", "desc":"Migration of WebInterface.conf parameter to CLI didn't happen successfully"},
    "NSERR_SAMLIDP_ENC_CERT":{"errno":"0xaac", "desc":"Encryption option requires ServiceProvider (SP) certificate."},
    "NSERR_WF_NOT_INST":{"errno":"0xaad", "desc":"Web Front is not installed"},
    "NSERR_WF_INSTFAILED":{"errno":"0xaae", "desc":"Installation failed. Please check the log file /var/log/wfcmd.log"},
    "NSERR_AAA_TOOMANY_EXP":{"errno":"0xaaf", "desc":"Number of expressions found exceeds allowed limit"},
    "NSERR_SAML_REDIR_CONFLICT":{"errno":"0xab0", "desc":"Signature and Digest algorithms are incompatible for Redirect Binding"},
    "NSERR_SET_MAXAAAUSER_NOT_ALLOWED":{"errno":"0xab1", "desc":"Set maxaaaUser not allowed per partition"},
    "NSERR_AAATM_INCOMP_NO_PROFILE":{"errno":"0xab8", "desc":"Profile does not exist or does not have Host configured"},
    "NSERR_RENAME_AUTHN_LABEL_NOT_PERMITTED":{"errno":"0xab9", "desc":"Rename of authentication policyLabel not permitted if it referred as nextFactor"},
    "NSERR_ERR_AAA_LICENSE_LOW":{"errno":"0xabb", "desc":"MaxAAAUsers value less than allowed by license, ignored."}
}

NS_PARTITION_ERRORS = {
    "NSERR_MAX_PARTITION":{"errno":"0xac0", "desc":"Maximum allowed partition limit reached"},
    "NSERR_PARTITION_NAME_EXIST":{"errno":"0xac1", "desc":"Partition name already exist"},
    "NSERR_NO_PARTITION":{"errno":"0xac3", "desc":"Partition does not exist"},
    "NSERR_DEL_PARTITION_BUSY":{"errno":"0xac4", "desc":"Partition is busy, can't delete"},
    "NSERR_DEL_PARTITION_INUSE":{"errno":"0xac5", "desc":"Partition is in use, can't delete"},
    "NSERR_NO_DEL_DFLT_PARTITION":{"errno":"0xac6", "desc":"Default Partition can't be delete"},
    "NSERR_RM_PARTITION_CONFIRM":{"errno":"0xac7", "desc":"Are you sure you want to remove partition (Y/N)? [N]:"},
    "NSERR_NOT_SUPPORTFORPARTITION":{"errno":"0xac8", "desc":"This feature is not supported on partition"},
    "NSERR_AP_CONFIG_NOT_ALLOWED":{"errno":"0xac9", "desc":"This configuration option is not supported on non-default partition"},
    "NSERR_VLAN_BDGGRP_PARTITION_EXIST":{"errno":"0xaca", "desc":"VLAN or VXLAN or BridgeGroup bound to a partition can not be deleted."},
    "NSERR_AP_DEFVLAN":{"errno":"0xacb", "desc":"Default VLAN cannot be bound/unbound to/from a partition."},
    "NSERR_VLAN_BDGGRP_PARTITION":{"errno":"0xacc", "desc":"The specified VLAN or BridgeGroup is bound to other partition."},
    "NSERR_PQ_ARG_UNSUPPORTED_PARTITION":{"errno":"0xacd", "desc":"PQ feature is not supported in non-default partition."},
    "NSERR_SC_ARG_UNSUPPORTED_PARTITION":{"errno":"0xace", "desc":"SC feature is not supported in non-default partition."},
    "NSERR_MAX_PARTITIONS_ZEBOS":{"errno":"0xacf", "desc":"Maximum allowed partition limit for routing reached"},
    "NSERR_AP_SYNCVLAN":{"errno":"0xad1", "desc":"SYNC VLAN cannot be bound/unbound to/from a partition."},
    "NSERR_AP_VLAN_BDG_EXIST":{"errno":"0xad2", "desc":"The specified VLAN cannot be bound to a partition because it is bound to a bridge group."},
    "NSERR_AP_SDXMGMTVLAN":{"errno":"0xad3", "desc":"The SDX management VLAN cannot be bound/unbound to/from a partition."},
    "NSERR_AP_DEFAULT_PARTITION_CONFIG":{"errno":"0xad4", "desc":"This configuration is allowed only from the default partition."},
    "NSERR_AP_MEM_DECR":{"errno":"0xad5", "desc":"Partition's memory limit cannot be reduced less than currently used memory"},
    "NSERR_AP_MISMATCH":{"errno":"0xad6", "desc":"The specified entity is configured in some other partition."},
    "NSERR_AP_PVID_IF_NOT_ALLOWED":{"errno":"0xad7", "desc":"The specified VLAN cannot be configured as untagged member of interface because it is bound to partition."},
    "NSERR_AP_VLAN_BINDING_NOT_ALLOWED":{"errno":"0xad8", "desc":"The specified VLAN cannot be bound to a partition because it is configured as untagged member of interface."},
    "NSERR_AP_NOT_SUPPORTFORSHAREDVLAN":{"errno":"0xad9", "desc":"This feature is not supported on shared vlan."},
    "NSERR_AP_SHAREDVLAN_CONFIG_NOT_ALLOWED_INCLUSTER":{"errno":"0xada", "desc":"Configuring vlan as shared is not supported on cluster."},
    "NSERR_AP_SHAREDVLAN_BDG":{"errno":"0xadb", "desc":"Shared vlan cannot be bound/unbound to/from a bridge group."},
    "NSERR_AP_SHAREDVLAN_TD":{"errno":"0xadc", "desc":"Shared vlan cannot be bound/unbound to/from a Traffic domain."},
    "NSERR_AP_INVALID_VMAC":{"errno":"0xadd", "desc":"Partition MAC address cannot have multicast bit set."},
    "NSERR_AP_VMAC_EXIST":{"errno":"0xade", "desc":"Another admin-partition with the same partition MAC address exist."},
    "NSERR_AP_VMAC_BUSY":{"errno":"0xadf", "desc":"Partition's MAC address can not be unset when shared vlans are bound to it."},
    "NSERR_AP_XS_CONN_FAILED":{"errno":"0xae0", "desc":"Unable to communicate with the XenStore."},
    "NSERR_AP_XS_NO_VMAC":{"errno":"0xae1", "desc":"No partition MAC address is configured for the VPX on SDX."},
    "NSERR_AP_XS_VMAC_NOTEXIST":{"errno":"0xae2", "desc":"The specified partition MAC address is not configured for the VPX on SDX."},
    "NSERR_AP_XS_VMAC_EXHAUSTED":{"errno":"0xae3", "desc":"All partition MAC addresses configured for the VPX on SDX are in use."},
    "NSERR_AP_ARP_VLAN_NOT_SPECIFIED":{"errno":"0xae4", "desc":"VLAN must be specified while adding ARP entry within partition."},
    "NSERR_AP_SHAREDVLAN_PART_EXIST":{"errno":"0xae5", "desc":"This VLAN already bound to the specified  partition."},
    "NSERR_PARTITION_ID_EXIST":{"errno":"0xae6", "desc":"Partition-id is already in use by another partition."},
    "NSERR_SYNCNSVLAN_AP":{"errno":"0xae7", "desc":"VLAN  bound to Admin Partition cannot be configured as SYNC/NS VLAN."},
    "NSERR_AP_NSVLAN":{"errno":"0xae8", "desc":"NSVLAN  cannot be bound to Admin Partition."},
    "NSERR_VXLAN_VLAN_DIFF_PARTITION":{"errno":"0xaef", "desc":"VXLAN and VLAN belong to different partitions."},
    "NSERR_AP_VXLAN_TUNNEL_NOT_ALLOWED":{"errno":"0xaf0", "desc":"IPtunnel of type vxlan cannot be configured in non default partition"},
    "NSERR_VXLAN_CONFIG_INPART":{"errno":"0xaf1", "desc":"This vxlan config not supported in non-default partition."},
    "NSERR_VXLAN_OTHER_PARTITION":{"errno":"0xaf2", "desc":"Specified vxlan is already bound to some other partition."},
    "NSERR_VXLAN_VLAN_BIND":{"errno":"0xaf3", "desc":"When vxlan extends vlan, these operations should be done on vlan"},
    "NSERR_VXLAN_IP_BINDING_CURPART":{"errno":"0xaf4", "desc":"IP binding to vxlan should be done in vxlan partition alone"},
    "NSERR_VXLAN_BOUNDTO_PARTITION":{"errno":"0xaf5", "desc":"Specified vxlan is already bound to the partition."},
    "NSERR_DYNROUTING_PARTITION":{"errno":"0xaf6", "desc":"Dynamic Routing should be enabled or disabled in vlan/vxlan partition"},
    "NSERR_AP_SHAREDVLAN_VXLAN":{"errno":"0xaf7", "desc":"Shared vlan cannot be bound/unbound to/from a vxlan."},
    "NSERR_AP_VLAN_VXLAN_EXIST":{"errno":"0xaf8", "desc":"The specified VLAN cannot be shared to a partition because it is extended by a vxlan ."},
    "NSERR_AP_STATIC_ARP_ND6_VXLAN_NOT_ALLOWED":{"errno":"0xaf9", "desc":"Static arp/nd6 entries cannot be added with vxlan in non default partition"},
    "NSERR_AP_MEM_MIN_LIMIT":{"errno":"0xafa", "desc":"Partition's memory limit cannot be less than 5MB"},
}

NS_REWRITE_ERRORS = {
    "NSERR_RW_ACT_INVAL":{"errno":"0xb01", "desc":"Invalid rewrite action"},
    "NSERR_RW_UNDEFACT_INVAL":{"errno":"0xb02", "desc":"Invalid undef action or log action"},
    "NSERR_ACTFLOWMISMATCH":{"errno":"0xb03", "desc":"Flow types of target and string expression are incompatible"},
    "NSERR_RONLY_TAR_EXPR":{"errno":"0xb04", "desc":"Target must be a simple reference to an unmodified portion of the message"},
    "NSERR_DATASET_BINDFAIL":{"errno":"0xb05", "desc":"Unable to bind the pattern to dataset/patset"},
    "NSERR_DATASET_UNBINDFAIL":{"errno":"0xb06", "desc":"Pattern does not exist in dataset/patset"},
    "NSERR_DATASET_NOTPRESENT":{"errno":"0xb07", "desc":"Dataset/Patset does not exist"},
    "NSERR_RSP_ACT_INVAL":{"errno":"0xb08", "desc":"Invalid responder action"},
    "NSERR_RSP_POLICY_FLOWTYPE_REQ":{"errno":"0xb09", "desc":"Responder policy must be a request policy"},
    "NSERR_TAR_FLOWTYPE_NRES":{"errno":"0xb0a", "desc":"Flow type of target should not be response type"},
    "NSERR_RSP_CONFIG_LOCK":{"errno":"0xb0b", "desc":"Responder configuration is temporarily disabled"},
    "NSERR_RSP_ACT_MUST_BE_NOOP":{"errno":"0xb0c", "desc":"Non-terminating policy must have NOOP action"},
    "NSERR_PATSET_INVALID_REGEX":{"errno":"0xb0d", "desc":"Patset contains invalid regex."},
    "NSERR_DATASET_BINDFAIL_DUP_INDEX":{"errno":"0xb0e", "desc":"Pattern index already in use, try using other index"},
    "NSERR_PATSET_BINDFAIL_PATLEN_LT_WU_MINLEN":{"errno":"0xb11", "desc":"Patset search on a body target not allowed if any of the patset patterns are < 3 or > 112 bytes in length"},
    "NSERR_TARGET_NOT_ALLOWED_IN_RULE":{"errno":"0xb12", "desc":"Expression involving Target not allowed in rule."},
    "NSERR_RW_TARGET_NOT_ALLOWED_IN_STRBUILDER":{"errno":"0xb13", "desc":"Expression involving Target not allowed in StringBuilder expression."},
    "NSERR_PIT_INVAL":{"errno":"0xb14", "desc":"Invalid Packet data"},
    "NSERR_INVAL_INVOKEPOINT":{"errno":"0xb15", "desc":"Invalid invoke point"},
    "NSERR_PIT_MAX_PACKET":{"errno":"0xb16", "desc":"Packet size exceeds maximum size"},
    "NSERR_REFINE_SEARCH_INVALID":{"errno":"0xb17", "desc":"Regular expression for patterns not allowed when refine search is specified"},
    "NSERR_EXTEND_INVALID":{"errno":"0xb18", "desc":"Extend not allowed for non-body expressions"},
    "NSERR_NON_EXTEND_EXPR":{"errno":"0xb19", "desc":"Non extend expressions are not allowed"},
    "NSERR_EXTEND_INVAL_PIRL":{"errno":"0xb1a", "desc":"Extend not allowed in the string builder expression"},
    "NSERR_INVAL_TAR_EXPR":{"errno":"0xb1b", "desc":"Invalid target expression"},
    "NSERR_INVAL_PATTERN_SEARCH_SET":{"errno":"0xb1c", "desc":"Cannot set both pattern and search"},
    "NSERR_INVAL_SEARCH_ARGS":{"errno":"0xb1d", "desc":"Invalid argument: search supports text, xpath, xpath_json, xpath_html, regex and patset"},
    "NSERR_RSP_ACT_MUST_BE_RESET_DROP":{"errno":"0xb1e", "desc":"Policy action must be DROP|RESET"},
    "NSERR_INVAL_SEARCH_SYNTAX":{"errno":"0xb1f", "desc":"Invalid search syntax"},
    "NSERR_INVAL_SEARCH_XPATH_SYNTAX":{"errno":"0xb20", "desc":"Invalid xpath syntax"},
    "NSERR_INVAL_SEARCH_PATSET_SYNTAX":{"errno":"0xb21", "desc":"Invalid patset syntax"},
    "NSERR_INVAL_SEARCH_REGEX_SYNTAX":{"errno":"0xb22", "desc":"Invalid regex syntax"},
    "NSERR_RW_REQ_BODY_NOT_ALLOWED":{"errno":"0xb23", "desc":"Request body based expression is not allowed"},
    "NSERR_RENAME_NOTSUPPORTED":{"errno":"0xb24", "desc":"Renaming this entity is not supported as entity based expression is configured"},
    "NSERR_ENTITY_REMOVAL_NOTALLOWED":{"errno":"0xb25", "desc":"Removing this entity is not allowed as entity based expression is configured"},
    "NSERR_PI_ENTITY_EXISTS":{"errno":"0xb26", "desc":"Advanced expression entity with same name already exists."},
    "NSERR_INCOMPATIBLE_CALLOUT_CHANGE":{"errno":"0xb27", "desc":"Incompatible callout change for in-use callout."},
    "NSERR_STRINGMAP_NOTPRESENT":{"errno":"0xb28", "desc":"String map does not exist"},
    "NSERR_HTTP_PROFILE_ACTION_NOT_ALLOWED":{"errno":"0xb29", "desc":"Responder action using HTTP protocol expressions is not allowed in HTTP profile"},
    "NSERR_RSP_ACT_MUST_BE_DROP_NOOP_RESPONDWITH":{"errno":"0xb2A", "desc":"Policy action must be DROP|NOOP|RESPONDWITH"},
    "NSERR_RSP_ACT_MUST_BE_DROP_NOOP":{"errno":"0xb53", "desc":"Policy action must be DROP|NOOP"},
    "NSERR_RSP_UNDEF_ACT_MUST_BE_DROP_NOOP":{"errno":"0xb2B", "desc":"Policy undef action must be DROP|NOOP"},
    "NSERR_INCOMPATIBLE_UNDEF":{"errno":"0xb2C", "desc":"Incompatible global undef action for SIP policy"},
    "NSERR_PIT_ACTION_EVAL_INVAL":{"errno":"0xb2d", "desc":"Action cannot be evaluated due to wrong input type."},
    "NSERR_DATASET_INVALID":{"errno":"0xb32", "desc":"Invalid dataset element"},
    "NSERR_DATASET_BINDFAIL_DUP_PATTERN":{"errno":"0xb33", "desc":"Pattern already bound to dataset/patset, try using other pattern"},
    "NSERR_TIMER_ACT_INVAL":{"errno":"0xb34", "desc":"Invalid timer action"},
    "NSERR_TIMER_ENTITY_INUSE":{"errno":"0xb35", "desc":"Timer entity name already in use"},
    "NSERR_TIMER_ENTITY_GLOBAL_BINDPOINT_INVAL":{"errno":"0xb36", "desc":"Invalid global bindpoint"},
    "NSERR_PATSET_BUILTIN":{"errno":"0xb37", "desc":"Built-in Patsets cannot be modified or deleted"},
    "NSERR_CROSS_MAX_LIMIT":{"errno":"0xb38", "desc":"Maximum value can be 2147483647"},
    "NSERR_INVALID_IPV4_FORMAT":{"errno":"0xb39", "desc":"Value should be in IPv4 format"},
    "NSERR_INVALID_IPV4_MAX_FIELD_VALUE":{"errno":"0xb40", "desc":"Maximum value of an IPv4 field can be 255"},
    "NSERR_INVALID_IPV6_FORMAT":{"errno":"0xb41", "desc":"Invalid IPv6 address format"},
    "NSERR_INVALID_NUMERIC_FORMAT":{"errno":"0xb42", "desc":"Value should be in decimal or hexadecimal format"},
    "NSERR_DATASET_PATTERN_ALREADY_BOUND":{"errno":"0xb43", "desc":"Specified pattern is already bound to dataset/patset"},
    "NSERR_PI_CIRCULAR_REFERENCE_DETECTED":{"errno":"0xb44", "desc":"Circular reference detected"},
    "NSERR_INVALID_ULONG_FORMAT":{"errno":"0xb45", "desc":"Value should be in unsigned long format like 23445, 88888999"},
    "NSERR_INVALID_MAC_ADDRESS_FORMAT":{"errno":"0xb46", "desc":"Value should be in mac address format like ff:ff:ff:ff:ff:ff"},
    "NSERR_INVALID_DOUBLE_FORMAT":{"errno":"0xb47", "desc":"Value should be in double format like 223, 22.3, 234e2"},
    "NSERR_CROSS_ULONG_MAX_LIMIT":{"errno":"0xb48", "desc":"Maximum value can be 18446744073709551615"},
    "NSERR_CA_ACT_INVAL":{"errno":"0xb49", "desc":"Invalid ContentAccelerator action"},
    "NSERR_INVAL_AVP_INSERT_EXPR":{"errno":"0xb4a", "desc":"Rewrite policy has invalid action. For Diameter bind points use DIAMETER.NEW_AVP() in action and for Radius bind points use RADIUS.NEW_AVP() in action as stringBuilderExpr expression to insert/replace AVP"},
    "NSERR_INVAL_AVP_LOOKUP_EXPR":{"errno":"0xb4b", "desc":"Rewrite policy has invalid action. For Diameter/Radius bind points, use AVP lookup expression as target expression. e.g. RADIUS.REQ.AVP(127)/DIAMETER.REQ.AVP(9000)/AVP_START/AVP_END"},
    "NSERR_INVAL_DELETE_AVP_EXPR":{"errno":"0xb4c", "desc":"Rewrite policy has invalid action. Deletion of AVP should be done using AVP based expression like RADIUS.REQ.AVP(33)/DIAMETER.REQ.AVP(9999)"},
    "NSERR_INVAL_NEW_MESSAGE_EXPR":{"errno":"0xb4d", "desc":"Responder policy has invalid action. Use expressions like DIAMETER.NEW_ANSWER/DIAMETER_NEW_REDIRECT as target expression to create new diameter message and RADIUS.NEW_ANSWER/RADIUS.NEW_ACCESSREJECT for RADIUS message"},
    "NSERR_INVAL_DIAMETER_REDIRECT_ACTION":{"errno":"0xb4e", "desc":"Binding Invalid Diameter action. Use DIAMETER.NEW_REDIRECT as target expression to create new redirect message"},
    "NSERR_INVAL_DIAMETER_ACTION":{"errno":"0xb4f", "desc":"Invalid action for Diameter bind point."},
    "NSERR_CA_URL_INVAL":{"errno":"0xb50", "desc":"URL length more than 2000"},
    "NSERR_PIT_CONNECTION_ERROR":{"errno":"0xb51", "desc":"Connection error"},
    "NSERR_INVAL_SEARCH_AVP":{"errno":"0xb52", "desc":"AVP code should be a number"},
    "NSERR_DATASET_PATTERN_LIMIT_OVERFLOW":{"errno":"0xb54", "desc":"Cannot bind more than 5000 patterns to a patset/dataset"},
    "NSERR_INVAL_RADIUS_AVPCODE":{"errno":"0xb55", "desc":"RADIUS AVP code should be in 0-255 number range"},
    "NSERR_INVAL_RADIUS_RESPONSE":{"errno":"0xb56", "desc":"Invalid RADIUS response code"},
    "NSERR_RESP_ACT_REASON_PHRASE_REQUIRED":{"errno":"0xb57", "desc":"Please also specify a reason phrase with a user-defined HTTP status code."},
    "NSERR_RESP_ACT_RESPONSE_CODE_REASON_PHRASE_NOT_ALLOWED":{"errno":"0xb58", "desc":"responseStatusCode and reasonPhrase options are allowed only for respondwithhtmlpage and redirect action types."},
    "NSERR_RESP_ACT_INVALID_REDIRECT_CODE":{"errno":"0xb59", "desc":"For redirect action type the response status code must be in the range 300-399."},
    "NSERR_RESP_ACT_INVALID_HTTP_STATUS_CODE":{"errno":"0xb5A", "desc":"Invalid HTTP status code."},
    "NSERR_RESP_ACT_EMPTY_REASON_PHRASE_NOT_ALLOWED":{"errno":"0xb5B", "desc":"Empty reasonPhrase string not allowed."},
    "NSERR_RSP_ACT_MUST_BE_DROP_NOOP_RESPONDWITH_RESET":{"errno":"0xb5C", "desc":"Policy action must be DROP|NOOP|RESPONDWITH|RESET"},
    "NSERR_MAX_STREAMING_PATTERN_LIMIT":{"errno":"0xb5D", "desc":"Maximum number of streaming patterns exceeded."}
}

NS_URLTRANS_ERRORS = {
    "NSERR_URLTRANS_MAX_ENTITIES":{"errno":"0xb90", "desc":"Number of URL Transformation entities exceeds limit"},
    "NSERR_URLTRANS_INVAL_PROFILE":{"errno":"0xb92", "desc":"Invalid URL Transformation profile"},
    "NSERR_URLTRANS_ACTION_INUSE":{"errno":"0xb93", "desc":"Action name is already in use"},
    "NSERR_URLTRANS_PRIORITY_EXISTS":{"errno":"0xb94", "desc":"An object with this priority already exists"},
    "NSERR_URLTRANS_REQ_PCRE_ERR":{"errno":"0xb95", "desc":"Invalid PCRE expression under 'reqUrlFrom'"},
    "NSERR_URLTRANS_RESP_PCRE_ERR":{"errno":"0xb96", "desc":"Invalid PCRE expression under 'resUrlFrom'"},
    "NSERR_URLTRANS_REQ_INTO_ERR":{"errno":"0xb97", "desc":"Invalid expression under 'reqUrlInto'"},
    "NSERR_URLTRANS_RESP_INTO_ERR":{"errno":"0xb98", "desc":"Invalid expression under 'resUrlInto'"},
    "NSERR_URLTRANS_COOKIE_INTO_ERR":{"errno":"0xb99", "desc":"Invalid expression under 'cookieDomainInto'"},
    "NSERR_URLTRANS_COOKIE_PCRE_ERR":{"errno":"0xb9a", "desc":"Invalid PCRE expression under 'cookieDomainFrom'"},
    "NSERR_URLTRANS_TOO_MANY_BACKREFS":{"errno":"0xb9b", "desc":"More than 5 back references in PCRE expression"},
    "NSERR_URLTRANS_MISSING_FROM":{"errno":"0xb9c", "desc":"Each 'Into' expression must have a corresponding 'From' pattern"},
    "NSERR_URLTRANS_NOT_SUPPORTED_VS":{"errno":"0xb9d", "desc":"Specified policy can be bound only to HTTP/SSL/PROXY vserver"},
    "NSERR_URLTRANS_BAD_COMMENT":{"errno":"0xb9e", "desc":"Invalid comment"}
}

NS_CENTRALMGMTSERVER_ERRORS = {
    "NSERR_CENTRALMGMTSERVER_REGFAILED":{"errno":"0x7ff", "desc":"Registration of device failed"},
    "NSERR_CENTRALMGMTSERVER_REQARGMISSING":{"errno":"0xbac", "desc":"Required argument missing"}
}

NS_GSLB2_ERRORS = {
    "NSERR_DNS_VIEW_NOENT":{"errno":"0xbc0", "desc":"DNS View does not exist"},
    "NSERR_GSLB_LOC_NOMEM":{"errno":"0xbc1", "desc":"Memory allocation for location failed."},
    "NSERR_DNS_PRIO_INVAL_VALUE":{"errno":"0xbc2", "desc":"Cannot bind DNS Policy with priority > 65535"},
    "NSERR_DNSPROF_EXISTS":{"errno":"0xbc3", "desc":"DNS Profile already exists."},
    "NSERR_DNSPROF_DEF":{"errno":"0xbc4", "desc":"Cannot remove default DNS Profile."},
    "NSERR_GSLB_LOC_EXISTS":{"errno":"0xbc5", "desc":"Custom Location Overlaps with an already existing location."},
    "NSERR_GSLB_LOC_NOENT":{"errno":"0xbc6", "desc":"Custom Location does not exist."},
    "NSERR_GSLB_NOMEM":{"errno":"0xbc7", "desc":"Not enough memory for GSLB operation."},
    "NSERR_DNS_INT_POL":{"errno":"0xbc8", "desc":"Internal Policy is not allowed to bind if builtin parameter is not set with any value."},
    "NSERR_GSLB_MEP":{"errno":"0xbc9", "desc":"Cannot enable MEP (Network Metric / Persistency Exchange) on a Child Site."},
    "NSERR_IP_ROUTE_EXISTS":{"errno":"0xbca", "desc":"Host route enabled on this IP, cannot be used for GSLB Site IP."},
    "NSERR_DNS_VIEW_EXISTS":{"errno":"0xbcb", "desc":"DNS View already exists"},
    "NSERR_NAME_VSVR_PERM":{"errno":"0xbcc", "desc":"Operation not permitted on a Vserver based Nameserver."},
    "NSERR_DNS_POL_INTERNAL":{"errno":"0xbcd", "desc":"Cannot remove or unbind internal DNS policy"},
    "NSERR_DNS_NOMEM":{"errno":"0xbce", "desc":"Not enough memory for DNS Operation"},
    "NSERR_GSLB_NAPTR_SERVICE_SET":{"errno":"0xbcf", "desc":"Setting of these parameters on naptr gslb service is not allowed"},
    "NSERR_GSLB_NAPTR_REPLACEMENT_UNSET":{"errno":"0xbd1", "desc":"Unsetting of naptr replacement is not allowed if the gslb service is bound to gslb vserver of NAPTR dnsrectype."},
    "NSERR_GSLBVIP_NAPTR_UNSUPPORTED_LBMETHODS":{"errno":"0xbd2", "desc":"GSLB vserver having NAPTR services can have only CUSTOM LOAD as lb method."},
    "NSERR_GSLB_NAPTR_VSERVER_SET":{"errno":"0xbd3", "desc":"Setting of these parameters on natpr gslb vserver is not allowed."},
    "NSERR_GSLB_NAPTR_DOMAIN_SIZE":{"errno":"0xbd4", "desc":"NAPTR domain cannot be created - name length exceeds maximum"},
    "NSERR_GSLB_NAPTR_DOMAIN_SYNTAX":{"errno":"0xbd5", "desc":"NAPTR domain cannot be created - name is invalid"},
    "NSERR_GSLB_NAPTR_REPLACEMENT_SUFFIX_SYNTAX":{"errno":"0xbd6", "desc":"Invalid NATPR Replacement Suffix"},
    "NSERR_GSLB_NON_NAPTR_SERVICE":{"errno":"0xbd7", "desc":"Operation permitted only on NAPTR GSLB service"},
    "NSERR_GSLB_USE_FORCESYNC":{"errno":"0xbd8", "desc":"Force sync option must be used in the 'sync gslb config' command to synchronize the configuration to other GSLB sites, or manually add the requisite configuration to other sites."},
    "NSERR_INVALID_WILDCARD_CONFIG":{"errno":"0xbd9", "desc":"Invalid Wildcard Configuration"}
}

NS_PI_ERRORS = {
    "NSERR_PI_LONGVSVRNAME":{"errno":"0xbe0", "desc":"The name of the label must be less than 32 characters"},
    "NSERR_PI_PRIORITY_EXISTS":{"errno":"0xbe1", "desc":"A policy is already bound to the specified priority"},
    "NSERR_PICON_GOTO_NOT_END":{"errno":"0xbe2", "desc":"GotoPriorityExpression for this policy has to be END"},
    "NSERR_INVAL_THRESHOLD":{"errno":"0xbe3", "desc":"Invalid threshold size value. Threshold size must be lesser than the sample size"},
    "NSERR_DEF_INVALID_UNBIND":{"errno":"0xbe4", "desc":"Default binding cannot be unbinded"},
    "NSERR_BAD_INIT_VALUE":{"errno":"0xbe5", "desc":"Invalid initial value"},
    "NSERR_INIT_VALUE_TOO_BIG":{"errno":"0xbe6", "desc":"Initial value is larger than the maximum allowed text length and the ifValueTooBig action is undef"},
    "NSERR_INIT_VALUE_TRUNCATED":{"errno":"0xbe7", "desc":"Initial value has been truncated to the maximum allowed text length because the ifValueTooBig action is truncate"},
    "NSERR_BAD_ASSIGN_LHS":{"errno":"0xbe8", "desc":"Invalid -var parameter: expect $variable-name for a ulong or text variable or $variable-name[key-expression] for a map variable."},
    "NSERR_BAD_OP_FOR_TYPE":{"errno":"0xbe9", "desc":"Op is not allowed for the variable type."},
    "NSERR_BAD_VAR_TYPE":{"errno":"0xbea", "desc":"Invalid type: expected one of ulong, text, or map."},
    "NSERR_ASSIGNMENT_LOG_UNSUPPORTED":{"errno":"0xbeb", "desc":"Log action is not supported with assignment action"},
    "NSERR_UNDEF_EXCEPTION":{"errno":"0xbec", "desc":"Undef exception raised."},
    "NSERR_NO_VARIABLE_VALUE":{"errno":"0xbed", "desc":"No value exists for the variable and key."},
    "NSERR_Q_S_DEPRECATED":{"errno":"0xbee", "desc":"The Q and S prefixes are deprecated - use HTTP.REQ and HTTP.RES instead"},
    "NSERR_UNSUPPORTED_VARIABLE_USE":{"errno":"0xbef", "desc":"Variables are not supported for use with DNS."},
    "NSERR_BAD_KEY_TYPE":{"errno":"0xbf0", "desc":"Invalid key type: expected type text"},
    "NSERR_BAD_SINGLETON_VAR":{"errno":"0xbf1", "desc":"Not a singleton variable"},
    "NSERR_BAD_MAP_VAR":{"errno":"0xbf2", "desc":"Not a map variable"},
    "NSERR_UNKNOWN_VARIABLE":{"errno":"0xbf3", "desc":"Variable is not configured."},
    "NSERR_MAP_WITHOUT_KEY":{"errno":"0xbf4", "desc":"Map variable used without a key."},
    "NSERR_SINGLETON_WITH_KEY":{"errno":"0xbf5", "desc":"Singleton variable used with a key."},
    "NSERR_BAD_TEXT_MAX_LENGTH":{"errno":"0xbf6", "desc":"Invalid text type: expected text(max-length), where max-length is an unsigned integer >= 1 and <= 64000."},
    "NSERR_BAD_MAP_TYPE_SYNTAX":{"errno":"0xbf7", "desc":"Invalid map type: expected map(key-type,value-type,max-entries), where max-entries is an unsigned long value <= 18446744073709551615 and greater than 0."},
    "NSERR_BAD_MAP_KEY_TYPE":{"errno":"0xbf8", "desc":"Map key type must be text."},
    "NSERR_BAD_MAP_VALUE_TYPE":{"errno":"0xbf9", "desc":"Map value type must be ulong or text."},
    "NSERR_BAD_KEY_VALUE_LENGTH":{"errno":"0xbfa", "desc":"Sum of the maximum map key and value lengths must be <= 64000."},
    "NSERR_BAD_MAP_SET_TYPE":{"errno":"0xbfb", "desc":"Invalid type parameter for set."},
    "NSERR_TRANSACTION_MAPS_NOT_SUPPORTED":{"errno":"0xbfc", "desc":"Maps with transaction scope are not supported."},
    "NSERR_TRANSACTION_EXPIRE_NOT_SUPPORTED":{"errno":"0xbfe", "desc":"Expiration with transaction scope variables is not supported."},
    "NSERR_INVOKE_NOT_SUPPORTED":{"errno":"0xbff", "desc":"Policy does not support invoke."},
    "NSERR_INVALPIEXPR":{"errno":"0xc01", "desc":"Invalid expression"},
    "NSERR_INVALINTOP":{"errno":"0xc02", "desc":"Expecting numeric arguments in this context for '-', '+', '*' or '/'"},
    "NSERR_INVALCOMPARE":{"errno":"0xc03", "desc":"Invalid arguments to compare operation"},
    "NSERR_INVALBOOLOP":{"errno":"0xc04", "desc":"The '!', '||' and '&&' operators can have only boolean argument(s)"},
    "NSERR_ARGNEG":{"errno":"0xc05", "desc":"Argument cannot be negative"},
    "NSERR_ARGEXCEED":{"errno":"0xc06", "desc":"Argument exceeds maximum allowed value"},
    "NSERR_ARGZERO":{"errno":"0xc07", "desc":"Operand or function argument should be non-zero"},
    "NSERR_MAXHEADER":{"errno":"0xc08", "desc":"Number of custom header exceeds limit"},
    "NSERR_INVALPICEXPR":{"errno":"0xc09", "desc":"Expression syntax error"},
    "NSERR_CEXPRLIMIT":{"errno":"0xc0a", "desc":"Expression too long"},
    "NSERR_EXPRLIMIT":{"errno":"0xc0b", "desc":"Expression too long"},
    "NSERR_SEXPRLIMIT":{"errno":"0xc0c", "desc":"String expression too long"},
    "NSERR_INVALPISEXPR":{"errno":"0xc0d", "desc":"String expression syntax error"},
    "NSERR_NOBIDI":{"errno":"0xc0e", "desc":"Bi-directional expression not allowed"},
    "NSERR_NOLAB":{"errno":"0xc0f", "desc":"Policy Label does not exist"},
    "NSERR_INTERNAL_LABEL_RM":{"errno":"0xc10", "desc":"Default Policy labels cannot be removed"},
    "NSERR_POLICY_FLOWTYPE_NONE":{"errno":"0xc11", "desc":"Policy should either be a request or response policy"},
    "NSERR_INVAL_PRIORITY":{"errno":"0xc12", "desc":"Priority should be in the range from 1 to 2147483647"},
    "NSERR_NUMERICEXPR":{"errno":"0xc13", "desc":"Expression should evaluate to numeric value"},
    "NSERR_BOOLEXPR":{"errno":"0xc14", "desc":"Expression should evaluate to true or false"},
    "NSERR_NOTBOUND":{"errno":"0xc15", "desc":"Cannot unbind a policy that is not bound"},
    "NSERR_POLICY_INUSE":{"errno":"0xc16", "desc":"Policy name already in use"},
    "NSERR_POLICY_SET_NOTALLOWED":{"errno":"0xc17", "desc":"Invalid rule/action for bound policy"},
    "NSERR_INVALID_BIND":{"errno":"0xc18", "desc":"Policy cannot be bound to specified policy label"},
    "NSERR_USE_INVOKE_RESULT":{"errno":"0xc19", "desc":"USE_INVOCATION_RESULT can be used only with invoke"},
    "NSERR_INVAL_EXPR_DATA_TYPE":{"errno":"0xc1a", "desc":"Invalid expression data type"},
    "NSERR_EXPR_CONST_ONLY":{"errno":"0xc1b", "desc":"Only constant parameters are allowed for function"},
    "NSERR_ALT_EXPR_STRING_ONLY":{"errno":"0xc1c", "desc":"Only string expressions are allowed for ALT"},
    "NSERR_ACTION_DEF_SET_INVAL":{"errno":"0xc1d", "desc":"Default action cannot be modified"},
    "NSERR_POLICY_DEF_SET_INVAL":{"errno":"0xc1e", "desc":"Default policy cannot be modified"},
    "NSERR_POLICY_LABEL_DEF_SET_INVAL":{"errno":"0xc1f", "desc":"Default policylabel cannot be modified"},
    "NSERR_INVAL_UNBIND":{"errno":"0xc20", "desc":"Policy not bound to specified policy label"},
    "NSERR_REGEX_INVALID":{"errno":"0xc21", "desc":"Invalid regular expression"},
    "NSERR_REGEX_BACKREF":{"errno":"0xc22", "desc":"Backreference in regular expression"},
    "NSERR_REGEX_RECURSIVE":{"errno":"0xc23", "desc":"Recursive regular expression present"},
    "NSERR_PIXL_EXPR_UNSAFE":{"errno":"0xc24", "desc":"Input expression is unsafe"},
    "NSERR_PI_ACTION_MAX_REF_REACHED":{"errno":"0xc25", "desc":"Cannot create policy. Binding limit for action reached (65536)"},
    "NSERR_PI_INVALID_UNSET":{"errno":"0xc26", "desc":"Cannot unset rule or action. No changes done"},
    "NSERR_EMPTY_STRING":{"errno":"0xc27", "desc":"Zero length string not allowed"},
    "NSERR_INVAL_BTW_ARGS":{"errno":"0xc28", "desc":"Arguments to BETWEEN are incorrect"},
    "NSERR_INVAL_ARG_SPECIFIED":{"errno":"0xc29", "desc":"GotoPriorityExpression, flowtype and invoke apply only to rewrite, responder and cache policies"},
    "NSERR_INVAL_ARG_CSPL":{"errno":"0xf0e", "desc":"Target vserver cannot be specified along with GotoPriorityExpression and invoke."},
    "NSERR_FLOWTYPE_NOT_APPLICABLE":{"errno":"0xc2a", "desc":"Flowtype applies only to rewrite, responder and cache policies"},
    "NSERR_INVAL_ARG_SPECIFIED_CS":{"errno":"0xc2b", "desc":"Flowtype and invoke apply only to Advanced policies."},
    "NSERR_INVAL_GOTOEXPR_CS":{"errno":"0xc2c", "desc":"GotoPriorityExpression applies only to Advanced policies"},
    "NSERR_REBIND_FAILED":{"errno":"0xc2d", "desc":"Rebinding of policy with new bind parameters failed. The policy is unbound."},
    "NSERR_SECOND_BIND":{"errno":"0xc2e", "desc":"A policy can be bound only once"},
    "NSERR_NONHTTP_VS":{"errno":"0xc2f", "desc":"Specified policy can be bound only to HTTP/SSL/PROXY vserver"},
\
    "NSERR_PI_LEX_FAILURE":{"errno":"0xd10", "desc":"Error in parsing"},
    "NSERR_PI_INVALIDNAME":{"errno":"0xF10", "desc":"Invalid policy entity name: names must begin with an ASCII alphabetic character or underscore and must contain only ASCII alphanumerics or underscores; words reserved for policy use may not be used"},
    "NSERR_PI_RST_CONN":{"errno":"0xF0F", "desc":"PI reset connection"},
    "NSERR_PI_EXPR_CSMSG":{"errno":"0xF11", "desc":"Advanced expression cannot have client security message"},
    "NSERR_INVAL_XPATH_EXPR":{"errno":"0xf12", "desc":"XPath Expression Compilation Failed"},
    "NSERR_XPATH_EXPR_NOT_SUPPORTED":{"errno":"0xf13", "desc":"Unsupported XPath"},
    "NSERR_TARGET_INVAL":{"errno":"0xf14", "desc":"Target Vserver cannot be specified for this policy"},
    "NSERR_NON_RESP_HTTP_VS_LIST":{"errno":"0xf15", "desc":"Specified policy can be bound only to HTTP/SSL/TCP/SSL_BRIDGE/FTP/DNS_TCP/RTSP/SSL_TCP/NNTP/MSSQL/MySQL/ORACLE/DIAMETER/RADIUS/ANY/PROXY vserver"},
    "NSERR_INVAL_VSERVER_BIND":{"errno":"0xf16", "desc":"Policy can be bound only to LB/CS vserver types"},
    "NSERR_APP_FREED_NSB":{"errno":"0xf17", "desc":"Application reset/drop connection and freed nsb"},
    "NSERR_MULT_BIND_INVAL":{"errno":"0xf18", "desc":"CVPN Policies cannot be bound to multiple entities"},
    "NSERR_CLASSIC_POLICY_ALREADY_BOUND":{"errno":"0xF19", "desc":"Cannot bind an advanced policy to a virtual server to which a classic policy is already bound"},
    "NSERR_ADVANCED_POLICY_ALREADY_BOUND":{"errno":"0xF20", "desc":"Cannot bind a classic policy to a virtual server to which an advanced policy is already bound"},
    "NSERR_MULT_UNBIND":{"errno":"0xF21", "desc":"Policy is bound to multiple global bindpoints. Please specify the appropriate bindpoint to unbind it."},
    "NSERR_UNKNOWN_CERTKEY":{"errno":"0xF22", "desc":"The specified certkey object has not been configured"},
    "NSERR_NO_RSA_PUBLIC_KEY":{"errno":"0xF23", "desc":"The specified certkey object does not include a certificate with an RSA public key"},
    "NSERR_NO_RSA_PRIVATE_KEY":{"errno":"0xF24", "desc":"The specified certkey object does not include an RSA private key"},
    "NSERR_CERTKEY_NAME_TOO_LONG":{"errno":"0xF25", "desc":"The certkey name exceeds the maximum 31 characters"},
    "NSERR_INVALID_UTF_8":{"errno":"0xF26", "desc":"Invalid UTF-8 string"},
    "NSERR_UNRECOG_CHARSET":{"errno":"0xF27", "desc":"Unrecognized character set"},
    "NSERR_INCOMPATIBLE_NAME_EXPR_CHANGE":{"errno":"0xF28", "desc":"Incompatible named expression change for in-use expression."},
    "NSERR_HEADER_EXPR_ONLY":{"errno":"0xF29", "desc":"Only classic expressions for headers allowed in EVAL_CLASSIC_EXPR"},
    "NSERR_RW_NOT_SUPPORTED_VS":{"errno":"0xF40", "desc":"Specified policy can be bound only to HTTP/SSL/TCP/SSL_TCP/DIAMETER/SSL_DIAMTER/SIP_UDP/RADIUS/PROXY vserver"},
    "NSERR_INVALID_KEYVALUE":{"errno":"0xf41", "desc":"The keyvalue argument is incorrect."},
    "NSERR_INVALID_RESOURCE_NAME":{"errno":"0xf42", "desc":"Resource of the given name does not exist"},
    "NSERR_INVALID_ACTION":{"errno":"0xF43", "desc":"Invalid action"},
    "NSERR_ASCII_ONLY_FUNCTION":{"errno":"0xF44", "desc":"Advanced expression function does not accept non-ASCII arguments"},
    "NSERR_INVALID_ENUM_VALUE":{"errno":"0xF45", "desc":"Invalid enumeration value"},
    "NSERR_INVALID_BINDPOINT":{"errno":"0xF46", "desc":"Invalid bind point."},
    "NSERR_NO_FIPS_FOR_XML_DECRYPT":{"errno":"0xF47", "desc":"A FIPS key cannot be used for XML decryption."},
    "NSERR_NO_CONFIGDB_DATA_SELECTED":{"errno":"0xF48", "desc":"No data selected from the configuration database."},
    "NSERR_HEADER_NAME_LENGTH_LIMIT":{"errno":"0xF49", "desc":"Custom header name is too long."},
    "NSERR_UNSUPPORTED_CVPN_SEARCH":{"errno":"0xF4A", "desc":"Patset, dataset, and xpath not supported for clientless VPN search."},
    "NSERR_INVALID_HEADER_NAME":{"errno":"0xF4B", "desc":"Header name contains invalid characters (one or more of ( ) < > @ , ; : \\ \" / [ ] ? = { } and space) as per the HTTP spec RFC 2616. This is allowed to for non-conformant HTTP messages, but may not be what you intended."},
    "NSERR_HEADER_NAME_TOO_LONG":{"errno":"0xF4c", "desc":"Header name is too long (maximum of 32 characters allowed)."},
    "NSERR_CSACTION_NOT_SUPPORTED":{"errno":"0xF4E", "desc":"Content Switching actions are not suported for classic content switching policies."},
    "NSERR_PI_EXPR_TOO_BIG":{"errno":"0xF4F", "desc":"Expression too long - maximum length is 8191"},
    "NSERR_PI_INVALID_FUNCTION_NAME":{"errno":"0xF6A", "desc":"Cannot use PI reserved word as a function name."},
    "NSERR_PI_FUNCTION_NAME_EXISTS":{"errno":"0xF6B", "desc":"Function with the same name already exists."},
    "NSERR_EXTENSION_INVALID_UPDATE_NAME":{"errno":"0xF6C", "desc":"Add the extension before updating."},
    "NSERR_PI_INVALID_EXTENSION_NAME":{"errno":"0xF6D", "desc":"Extension is not added."},
    "NSERR_EXTENSION_FUNCTION_PROTOTYPE_CHANGED":{"errno":"0xF6E", "desc":"Extension has different prototype of a function than that which is in use."},
    "NSERR_EXTENSION_FUNCTION_UPDATE_PROBLEM":{"errno":"0xF6F", "desc":"Problem in updating function that is in use."},
    "NSERR_EXTENSION_COMPILE_FAILURE":{"errno":"0xF7A", "desc":"Extension compilation error."},
    "NSERR_EXTENSION_LOAD_FAILURE":{"errno":"0xF7B", "desc":"Extension loading error."},
    "NSERR_PI_USED_FUNCTION_REMOVED":{"errno":"0xF7C", "desc":"Update attempted to remove a function that is in use."},
    "NSERR_EXTENSION_FUNCTION_MULTIPLE_DEFINITIONS":{"errno":"0xF7D", "desc":"Extension has multiple definitions of a function."},
    "NSERR_EXTENSION_INVALID_FUNCTION_PROTOTYPE":{"errno":"0xF7E", "desc":"Extension function's prototype is invalid."},
    "NSERR_EXTENSION_MAX_FUNCTION_ARGUMENT":{"errno":"0xF7F", "desc":"Maximum number of function arguments can be 3."},
    "NSERR_BAD_EXTENSION_TRACE_NAME":{"errno":"0xFC6", "desc":"Function or variable name can contain only alphanumerics and underscores and cannot begin with a digit."},
    "NSERR_BAD_EXTENSION_TRACE_ARRAYS":{"errno":"0xBD0", "desc":"traceFunctions or traceVariables cannot be specified with trace off."},
    "NSERR_PI_INVALID_GLOBAL_BINDTYPE":{"errno":"0xEF4", "desc":"Invalid global bindtype."},
    "NSERR_INVALID_POLICY_GLOBAL_BINDING":{"errno":"0xEF5", "desc":"Policy cannot be bound/unbound to/from the given global bindtype."},
    "NSERR_INVALID_PI_ANNOTATE":{"errno":"0x5b9", "desc":"Invalid PI annotation value"},
    "NSERR_INVALID_PI_ANNOTATE_LOGINSCHEMA":{"errno":"0x5ba", "desc":"Invalid loginSchema corresponding to PI annotation value"},
    "NSERR_ANGLE_BRACKETS_IN_TAGNAME":{"errno":"0xEF6", "desc":"Invalid syntax, angle brackets in tag specified"},
    "NSERR_INVALID_ENCRYPTION_KEY_ARGUMENT":{"errno":"0xEF7", "desc":"Invalid encryptionKey argument"},
    "NSERR_INVALID_HMAC_KEY_ARGUMENT":{"errno":"0xEF8", "desc":"Invalid hmacKey argument"},
    "NSERR_ENCRYPTION_KEY_NOTPRESENT":{"errno":"0xEF9", "desc":"Encryption key does not exist."},
    "NSERR_HMAC_KEY_NOTPRESENT":{"errno":"0xEFA", "desc":"HMAC key does not exist."},
    "NSERR_WARN_SHORT_HMAC_KEY":{"errno":"0xEFB", "desc":"Recommend that the HMAC keyValue be at least as long as the digest blocksize"},
    "NSERR_MULT_TYPE_UNBIND":{"errno":"0xEFC", "desc":"Policy is bound to multiple bindpoints. Please specify the appropriate bindpoint to unbind it."},
    "NSERR_EMPTY_CERTKEY":{"errno":"0xEFD", "desc":"The specified certkey name is empty or NULL."},
    "NSERR_NON_PROXY_HTTP_VS":{"errno":"0xEFE", "desc":"Specified policy can be bound only to PROXY/HTTP/SSL vserver"},
    "NSERR_EXTENSION_HAS_GENERIC_MBLB_API_NOT_FUNCTION_API":{"errno":"0xEFF", "desc":"Extension code already used for an Advanced Expression extension function cannot be used for a user protocol implementation."},
    "NSERR_EXTENSION_HAS_FUNCTION_API_NOT_GENERIC_MBLB_API":{"errno":"0xD60", "desc":"Extension code already used for a user protocol implementation cannot be used for an Advanced Expression extension function."},
    "NSERR_EXTENSION_INCORRECT_USER_PARAM_VALUE":{"errno":"0xD6B", "desc":"Incorrect parameter field's value. Value should be in <name>=<value> format."},
    "NSERR_EXTENSION_USER_PROTOCOL_IN_USE":{"errno":"0x5DE", "desc":"Can't update the extension as the user protocol using this extension is in use"},
    "NSERR_USER_VSERVER_EXCEED_PARAM_NAME_VALUE_LENGTH":{"errno":"0x5DF", "desc":"Parameter's name or value length exceeds maximum allowed length of 63 characters"}
}

NS_AS_ERRORS = {
    "NSERR_AS_NOSTARTURL":{"errno":"0xc30", "desc":"No such StartURL check"},
    "NSERR_AS_EXIST_STARTURL":{"errno":"0xc31", "desc":"The StartURL check is already in use"},
    "NSERR_AS_NODENYURL":{"errno":"0xc32", "desc":"No such DenyURL check"},
    "NSERR_AS_EXIST_DENYURL":{"errno":"0xc33", "desc":"The DenyURL check is already in use"},
    "NSERR_AS_NOCOOKIECONSISTENCY":{"errno":"0xc34", "desc":"No such CookieConsistency check"},
    "NSERR_AS_EXIST_COOKIECONSISTENCY":{"errno":"0xc35", "desc":"The CookieConsistency check is already in use"},
    "NSERR_AS_NOFIELDCONSISTENCY":{"errno":"0xc36", "desc":"No such FieldConsistency check"},
    "NSERR_AS_EXIST_FIELDCONSISTENCY":{"errno":"0xc37", "desc":"The FieldConsistency check is already in use"},
    "NSERR_AS_NOXSS":{"errno":"0xc38", "desc":"No such CrossSiteScripting check"},
    "NSERR_AS_EXIST_XSS":{"errno":"0xc39", "desc":"The CrossSiteScripting check is already in use"},
    "NSERR_AS_NOSQL":{"errno":"0xc3a", "desc":"No such SQLInjection check"},
    "NSERR_AS_EXIST_SQL":{"errno":"0xc3b", "desc":"The SQLInjection check is already in use"},
    "NSERR_AS_NOFIELDFORMAT":{"errno":"0xc3c", "desc":"No such FieldFormat check"},
    "NSERR_AS_EXIST_FIELDFORMAT":{"errno":"0xc3d", "desc":"The FieldFormat check is already in use"},
    "NSERR_AS_NOOBJECTEXPRESSION":{"errno":"0xc3e", "desc":"No such SafeObject check"},
    "NSERR_AS_EXIST_OBJECTEXPRESSION":{"errno":"0xc3f", "desc":"The SafeObject check is already in use"},
    "NSERR_AS_NOFIELDTYPE":{"errno":"0xc40", "desc":"No such FieldType. See /var/log/ns.log for more details."},
    "NSERR_AS_NOT_SUPPORTED_VS":{"errno":"0xc41", "desc":"Specified policy can be bound only to HTTP/SSL/PROXY vserver"},
    "NSERR_AS_BAD_ACTION_STARTURL":{"errno":"0xc42", "desc":"Invalid StartURL Action"},
    "NSERR_AS_BAD_ACTION_DENYURL":{"errno":"0xc43", "desc":"Invalid DenyURL Action"},
    "NSERR_AS_BAD_ACTION_COOKIECONSISTENCY":{"errno":"0xc44", "desc":"Invalid CookieConsistency Action"},
    "NSERR_AS_BAD_ACTION_FIELDCONSISTENCY":{"errno":"0xc45", "desc":"Invalid FieldConsistency Action"},
    "NSERR_AS_BAD_ACTION_XSS":{"errno":"0xc46", "desc":"Invalid CrossSiteScripting Action"},
    "NSERR_AS_BAD_ACTION_SQL":{"errno":"0xc47", "desc":"Invalid SQLInjection Action"},
    "NSERR_AS_BAD_ACTION_FIELDFORMAT":{"errno":"0xc48", "desc":"Invalid FieldFormat Action"},
    "NSERR_AS_BAD_ACTION_OBJECTEXPRESSION":{"errno":"0xc49", "desc":"Invalid SafeObject Action"},
    "NSERR_AS_BAD_ACTION_BUFFEROVERFLOW":{"errno":"0xc4a", "desc":"Invalid BufferOverflow Action"},
    "NSERR_AS_BAD_ACTION_CCARD":{"errno":"0xc4b", "desc":"Invalid CreditCard Action"},
    "NSERR_AS_FIELDFORMAT_MIN_GT_MAX":{"errno":"0xc4c", "desc":"Minimum FieldFormat length cannot exceed maximum FieldFormat length"},
    "NSERR_AS_FIELDTYPE_BAD_NAME_LEN":{"errno":"0xc4d", "desc":"Invalid FieldType name length"},
    "NSERR_AS_BAD_COMMENT_LEN":{"errno":"0xc4e", "desc":"Invalid comment length"},
    "NSERR_AS_FIELDTYPE_BAD_REGEX_LEN":{"errno":"0xc4f", "desc":"Invalid regex length"},
    "NSERR_AS_SECURITY_CHECK_REQUIRED":{"errno":"0xc50", "desc":"Security check required"},
    "NSERR_AS_FIELDTYPE_BUILTIN":{"errno":"0xc51", "desc":"Built-in FieldTypes cannot be modified or deleted"},
    "NSERR_AS_BAD_ACTION_CONTENT_TYPE":{"errno":"0xc52", "desc":"Invalid ContentType Action"},
    "NSERR_AS_BAD_DEFAULT_CHARSET":{"errno":"0xc53", "desc":"Invalid default character set"},
    "NSERR_AS_BAD_COOKIECONSISTENCY_NAME":{"errno":"0xc54", "desc":"Invalid Cookie name"},
    "NSERR_AS_BAD_ERRORURL":{"errno":"0xc55", "desc":"Invalid ErrorURL"},
    "NSERR_AS_BAD_ENCODING_URL":{"errno":"0xc56", "desc":"Invalid encoding for URL"},
    "NSERR_AS_BAD_ENCODING_FIELDNAME":{"errno":"0xc57", "desc":"Invalid encoding for field name"},
    "NSERR_AS_BAD_ENCODING_COOKIENAME":{"errno":"0xc58", "desc":"Invalid encoding for cookie name"},
    "NSERR_AS_BAD_ENCODING_OBJECTEXPRESSION_NAME":{"errno":"0xc59", "desc":"Invalid encoding for SafeObject name"},
    "NSERR_AS_BAD_ENCODING_EXPRESSION":{"errno":"0xc5a", "desc":"Invalid encoding for expression"},
    "NSERR_AS_BAD_ENCODING_REGEX":{"errno":"0xc5b", "desc":"Invalid encoding for regex"},
    "NSERR_AS_MODIFIED_URL":{"errno":"0xc5c", "desc":"Replaced character that is not printable ASCII with escaped equivalent in URL"},
    "NSERR_AS_MODIFIED_OBJECTEXPRESSION":{"errno":"0xc5d", "desc":"Replaced character that is not printable ASCII with escaped equivalent in expression"},
    "NSERR_AS_CFFIELD_BAD_FIELDNAME_LEN":{"errno":"0xc5e", "desc":"Invalid confidential form field name length"},
    "NSERR_AS_CFFIELD_BAD_URL_LEN":{"errno":"0xc5f", "desc":"Invalid confidential form field URL length"},
    "NSERR_AS_NOCFFIELD":{"errno":"0xc60", "desc":"No such confidential form field"},
    "NSERR_AS_BAD_CFF_NAME":{"errno":"0xc61", "desc":"Name may not contain leading/trailing spaces."},
    "NSERR_AS_BAD_CFF_URL":{"errno":"0xc62", "desc":"URL may not contain leading/trailing spaces."},
    "NSERR_AS_CFF_DUP":{"errno":"0xc63", "desc":"The confidential field is already in use."},
    "NSERR_AS_BAD_ACTION_XDOS":{"errno":"0xc64", "desc":"Invalid XML Dos Action"},
    "NSERR_AS_EXIST_XML_DOS_URL":{"errno":"0xc65", "desc":"The XML DoS URL check is already in use."},
    "NSERR_XML_URL_NOT_SUPPORTED":{"errno":"0xc66", "desc":"Only .* is supported for XML checks."},
    "NSERR_AS_NO_XDOS_URL":{"errno":"0xc67", "desc":"No such URL exist for XDOS check."},
    "NSERR_AS_INVALID_XML_DOS_CONF":{"errno":"0xc68", "desc":"Invalid configuration: xmlMaxFileSize can not be less than xmlMinFileSize when both checks are enabled."},
    "NSERR_AS_BAD_ACTION_XML_SQLINJECTION":{"errno":"0xc69", "desc":"Invalid XML - SQLInjection Action."},
    "NSERR_AS_BAD_ACTION_XML_XSS":{"errno":"0xc6a", "desc":"Invalid XML - CrossSiteScripting Action."},
    "NSERR_AS_BAD_ACTION_XML_WELLFORMEDNESS":{"errno":"0xc6b", "desc":"Invalid XML - Format Action."},
    "NSERR_AS_BAD_ACTION_PROFILE_TYPE":{"errno":"0xc6c", "desc":"Invalid Appsecure Profile Type."},
    "NSERR_AS_MODIFIED_FIELDNAME":{"errno":"0xc6d", "desc":"Replaced character that is not printable ASCII with escaped equivalent in form field name"},
    "NSERR_AS_BAD_ACTION_WSI":{"errno":"0xc6e", "desc":"Invalid XML WS-I Action."},
    "NSERR_AS_EXIST_XML_WSI_URL":{"errno":"0xc6f", "desc":"The XML WS-I URL check is already in use."},
    "NSERR_AS_NO_WSI_URL":{"errno":"0xc70", "desc":"No such URL exist for WS-I check."},
    "NSERR_AS_INVALID_XML_WSI_CONF":{"errno":"0xc71", "desc":"Invalid WS-I rule id in the list."},
    "NSERR_AS_OBJECTNAME_TOO_BIG":{"errno":"0xc72", "desc":"Object too big."},
    "NSERR_AS_OBJECT_NO_EXIST":{"errno":"0xc73", "desc":"Imported file does not exist [Please import the file before use]. See /var/log/ns.log for more details."},
    "NSERR_AS_SERVER_NAME_TOO_BIG":{"errno":"0xc74", "desc":"Server name too big."},
    "NSERR_AS_OBJECT_NOT_READABLE":{"errno":"0xc75", "desc":"Object not readable [Please make sure it exists]."},
    "NSERR_AS_NOPROFILE":{"errno":"0xc76", "desc":"No such profile."},
    "NSERR_AS_BAD_ACTION_XML_ATTACHMENT":{"errno":"0xc77", "desc":"Invalid XML - Attachment Action"},
    "NSERR_AS_BAD_ACTION_MSGVAL":{"errno":"0xc78", "desc":"Invalid XML Message Validation Action."},
    "NSERR_AS_EXIST_XML_MSGVAL_URL":{"errno":"0xc79", "desc":"The XML MSGVAL URL check is already in use."},
    "NSERR_AS_NO_MSGVAL_URL":{"errno":"0xc7a", "desc":"No such URL exist for MSGVAL check."},
    "NSERR_AS_INVALID_XML_MSGVAL_CONF":{"errno":"0xc7b", "desc":"Invalid MsgVal configuration."},
    "NSERR_AS_BIND_XML_MSGVAL_CONF":{"errno":"0xc7c", "desc":"Error in message validation binding. For More details see log messages. "},
    "NSERR_AS_IMPORT_FAILED":{"errno":"0xc7d", "desc":"Importing the resource failed"},
    "NSERR_AS_OBJECT_EXIST":{"errno":"0xc7e", "desc":"Object already exists"},
    "NSERR_AS_INVALID_OPTION":{"errno":"0xc7f", "desc":"Invalid option"},
    "NSERR_AS_REMOVE_FAILED":{"errno":"0xc80", "desc":"Problem in removing resource"},
    "NSERR_AS_NO_RESOURCE":{"errno":"0xc81", "desc":"No such resource. Object you are trying to update or remove does not exist."},
    "NSERR_AS_SHOW_FAILED":{"errno":"0xc82", "desc":"Problem in showing object"},
    "NSERR_AS_DEPENDENCY_FAILED":{"errno":"0xc83", "desc":"Problem in downloading dependencies"},
    "NSERR_AS_COMPILATION_FAILED":{"errno":"0xc84", "desc":"Problem compiling object. For more details see /var/log/ns.log file"},
    "NSERR_INVALID_OBJECT_NAME":{"errno":"0xc85", "desc":"Invalid name; names must begin with an alphanumeric character or underscore and must contain only alphanumerics, '_', '#', '.', ':', '@', '=' or '-'"},
    "NSERR_AS_IMPORT_DOWNLOAD_FAILED":{"errno":"0xc86", "desc":"Problem in importing the object. Please check the DNS NameServer/Route settings and try again. For more details see /var/log/ns.log file"},
    "NSERR_AS_RESOURCE_INUSE":{"errno":"0xc87", "desc":"Can not remove resource. Resource is in use"},
    "NSERR_AS_BAD_MAPPING_DATA":{"errno":"0xc88", "desc":"Mapping Data Corrupted"},
    "NSERR_AS_PROFILE_CHANGE_HTML":{"errno":"0xc89", "desc":"HTML checks will not be applicable when profile type is XML"},
    "NSERR_AS_PROFILE_CHANGE_XML":{"errno":"0xc8a", "desc":"XML checks will not be applicable when profile type is HTML"},
    "NSERR_AS_IMPORT_ALREADY_INPROCESS":{"errno":"0xc8b", "desc":"Import failed. Another resource with the same name being processed"},
    "NSERR_AS_INVALID_XML_ERROR_OBJECT":{"errno":"0xc8c", "desc":"Invalid XML error object"},
    "NSERR_AS_XML_WELLFORMEDNESS_DISABLED":{"errno":"0xc8d", "desc":"XML Security checks can not be performed, once an XML message is found not wellformed."},
    "NSERR_AS_INDIVIDUAL_IMPORT_LIMIT_EXCEEDED":{"errno":"0xc8e", "desc":"Import failed - importing file size greater than configured size limit"},
    "NSERR_AS_TOTAL_IMPORT_LIMIT_EXCEEDED":{"errno":"0xc8f", "desc":"Import failed - exceeding the configured total size limit on the imported objects"},
    "NSERR_AS_LEARNING_BUSY":{"errno":"0xc90", "desc":"Please wait for the learning database to finish updating"},
    "NSERR_AS_DEPRECATED_XML_WSI_RULE_R4003":{"errno":"0xc91", "desc":"WS-I Rule R4003 has been deprecated, it will be removed from the WS-I binding list."},
    "NSERR_AS_EXIST_XML_ATTACHMENT_URL":{"errno":"0xc92", "desc":"The XML Attachment URL check is already in use."},
    "NSERR_AS_NO_XML_ATTACHMENT_URL":{"errno":"0xc93", "desc":"No such URL exist for XML Attachment check."},
    "NSERR_AS_BAD_ACTION_SOAP_FAULT":{"errno":"0xc94", "desc":"Invalid SOAP Fault Filtering Action."},
    "NSERR_AS_XML_DOS_VALUE_OUT_OF_RANGE":{"errno":"0xc95", "desc":"XML DoS check value is not within the allowed range."},
    "NSERR_AS_XML_MSGVAL_CLI_ERROR":{"errno":"0xc96", "desc":"-XMLValidateResponse requires one of [-XMLValidateSOAPEnvelope, -XMLWSDL, -XMLRequestSchema, -XMLResponseSchema]"},
    "NSERR_AS_INVALID_CUSTOM_SETTINGS_OBJECT":{"errno":"0xc97", "desc":"Import failed. Please check syntax of signature object"},
    "NSERR_AS_SESSION_TIMEOUT_LIFETIME_CONFLICT":{"errno":"0xc98", "desc":"The session lifetime cannot be less than the session timeout"},
    "NSERR_AS_CLASSIC_POLICY_ALREADY_BOUND":{"errno":"0xc99", "desc":"Failed to bind advanced policy because a classic one is already bound globally or to a vserver. Binding classic and advanced policies at the same time is not allowed"},
    "NSERR_AS_ADVANCED_POLICY_ALREADY_BOUND":{"errno":"0xc9a", "desc":"Failed to bind classic policy because an advanced one is already bound globally or to a vserver or to a user defined policylabel. Binding classic and advanced policies at the same time is not allowed"},
    "NSERR_AS_CUSTOM_SETTINGS_NO_INJECTION_TYPE":{"errno":"0xc9b", "desc":"Failed to set signature object. One of the <injection> tags do not have 'type' attribute"},
    "NSERR_AS_NOCSRF_TAG":{"errno":"0xc9c", "desc":"No such CrossSiteRequestForgery check"},
    "NSERR_AS_EXIST_CSRF_TAG":{"errno":"0xc9d", "desc":"The CrossSiteRequestForgery check is already in use"},
    "NSERR_AS_BAD_ACTION_CSRF_TAG":{"errno":"0xc9e", "desc":"Invalid CSRF Tag Action"},
    "NSERR_AS_TURNING_TAGGING_OFF_CSRF_TAG_ON":{"errno":"0xc9f", "desc":"Must set CSRF tagging check to 'none' before disabling form tagging."},
    "NSERR_AS_TURNING_CSRF_TAG_ON_TAGGING_OFF":{"errno":"0xca0", "desc":"Form tagging must be enabled before turning on CSRF tag checks."},
    "NSERR_AS_IMPORT_LIMIT_LESS_THAN_IMPORT_DIR_SIZE":{"errno":"0xca1", "desc":"Import limit should be greater than the current total imported objects size."},
    "NSERR_AS_UNSUPPORTED_IMPORT_PROTOCOL":{"errno":"0xca2", "desc":"Unsupported import source protocol. Supported protocols are http, https and ftp"},
    "NSERR_AS_UNSUPPORTED_EXPORT_PROTOCOL":{"errno":"0xca3", "desc":"Unsupported export target protocol. Supported protocols are http and  https"},
    "NSERR_AS_EXPORT_FAILED":{"errno":"0xca4", "desc":"Export failed. Check /var/log/ns.log for details."},
    "NSERR_AS_BAD_LOCAL_FILE":{"errno":"0xca5", "desc":"Local file cannot use .. to backtrack up a directory."},
    "NSERR_AS_INVALID_REGEX_CUSTOM_OBJECT":{"errno":"0xca6", "desc":"Invalid regular expression in custom object. Reverting to default settings."},
    "NSERR_AS_BUILTIN_INVALID_OP":{"errno":"0xca7", "desc":"Invalid operation for built-in profile"},
    "NSERR_AS_INVALID_ADV_POLICY_STATE":{"errno":"0xca8", "desc":"Cannot bind advanced policy with state set to DISABLED"},
    "NSERR_AS_BUILTIN_NAMES_IN_CONF":{"errno":"0xca9", "desc":"Entities with names reserved for built-in profiles have been discarded"},
    "NSERR_AS_DEFAULT_PROFILE_IS_BYPASS ":{"errno":"0xcaa", "desc":"The default profile is set to bypass traffic. It can be set using the 'set appfw settings' command."},
    "NSERR_AS_NO_LEARN_DENYURL ":{"errno":"0xcab", "desc":"Learn is not supported as a denyURLAction."},
    "NSERR_AS_INVALID_XML_FILE_SIZE":{"errno":"0xcac", "desc":"Invalid configuration: xmlMinFileSize / xmlMaxFileSize can not be less than 4 or greater than 1000000000."},
    "NSERR_AS_NO_LEARN_BUFFEROVERFLOW ":{"errno":"0xcae", "desc":"Learn is not supported as a bufferOvewflowAction."},
    "NSERR_AS_NO_LEARN_XML_FORMAT":{"errno":"0xcaf", "desc":"Learn is not supported as an XMLFormatAction."},
    "NSERR_AS_NO_LEARN_XML_SQLINJECTION":{"errno":"0xcb3", "desc":"Learn is not supported as an XMLSQLInjectionAction."},
    "NSERR_AS_NO_LEARN_XML_MSGVAL":{"errno":"0xcb5", "desc":"Learn is not supported as an XMLValidationAction."},
    "NSERR_AS_NO_LEARN_XML_SOAP_FAULT":{"errno":"0xcb6", "desc":"Learn is not supported as an XMLSOAPFaultAction."},
    "NSERR_AS_IMPORT_INTERNAL_ERROR":{"errno":"0xcb7", "desc":"Internal error while importing resource."},
    "NSERR_AS_NETSVC_CONN_FAILED":{"errno":"0xcb8", "desc":"Critical internal error. please retry after some time."},
    "NSERR_AS_VALIDATION_FAILED":{"errno":"0xcb9", "desc":"Problem validating Imported object against specification. For more details see /var/log/ns.log file."},
    "NSERR_AS_CKI_TRANSFORM_DISABLED":{"errno":"0xcba", "desc":"This setting will not take effect until cookieTransforms is turned ON."},
    "NSERR_AS_NOXMLXSS":{"errno":"0xcbb", "desc":"No such XMLXSS check"},
    "NSERR_AS_EXIST_XMLXSS":{"errno":"0xcbc", "desc":"The XMLXSS check is already in use"},
    "NSERR_AS_NOXMLSQL":{"errno":"0xcbd", "desc":"No such XMLSQLInjection check"},
    "NSERR_AS_EXIST_XMLSQL":{"errno":"0xcbe", "desc":"The XMLSQLInjection check is already in use"},
    "NSERR_AS_NO_ENDTAG":{"errno":"0xcbf", "desc":"Missing end tag in the imported signature file."},
    "NSERR_AS_SIG_INVALID_RULEID":{"errno":"0xcc0", "desc":"Invalid rule id in imported signature."},
    "NSERR_AS_SIG_INVALID_RULE_VERSION":{"errno":"0xcc1", "desc":"Invalid version in imported signature."},
    "NSERR_AS_SIG_PARSE_ERROR":{"errno":"0xcc2", "desc":"Error parsing imported signatures."},
    "NSERR_AS_SIG_INVALID_ATTRIBUTE":{"errno":"0xcc3", "desc":"Imported signatures have invalid attributes"},
    "NSERR_AS_SIG_MULTIPLE_LOCATIONS":{"errno":"0xcc4", "desc":"Imported signature patterns has multiple locations"},
    "NSERR_AS_SIG_INVALID_STATE":{"errno":"0xcc5", "desc":"Error parsing imported signatures. Invalid parse state."},
    "NSERR_AS_CKI_ENCRYPT_METHOD_IS_NONE":{"errno":"0xcc6", "desc":"For security purposes, please set the NS encryptions parameter using the \"set ns encryptionParams\" command."},
    "NSERR_AS_UPDATE_FAILED":{"errno":"0xcc7", "desc":"Updating the resource failed"},
    "NSERR_AS_OBJECT_NOT_USED":{"errno":"0xcc8", "desc":"The specified object is not used"},
    "NSERR_AS_SIG_MULTIPLE_URLS":{"errno":"0xcc9", "desc":"Imported signature pattern location has multiple URLs"},
    "NSERR_AS_SIG_MULTIPLE_FIELD_NAMES":{"errno":"0xcca", "desc":"Imported signature pattern location has multiple field names"},
    "NSERR_AS_SIG_NO_FASTMATCH":{"errno":"0xccb", "desc":"A signature rule has no fastmatch pattern.  See log for details."},
    "NSERR_AS_PE_POLICY_NOTSUPPORTED":{"errno":"0xccc", "desc":"Not supported for classic policy."},
    "NSERR_AS_AUDITLOG_POLICY_NOTSUPPORTED":{"errno":"0xccd", "desc":"Not supported for auditlog policy."},
    "NSERR_AS_SIG_MULTIPLE_CREDIT_CARD_RULES":{"errno":"0xcce", "desc":"Imported signatures has multiple credit card patterns in Rule."},
    "NSERR_AS_TURNING_TAGGING_OFF_SESSIONLESS_FFC_ON":{"errno":"0xccf", "desc":"Must disable sessionless field consistency checks before disabling form tagging."},
    "NSERR_AS_TURNING_SESSIONLESS_FFC_ON_TAGGING_OFF":{"errno":"0xcd0", "desc":"Form tagging must be enabled before enabling sessionless field consistency checks."},
    "NSERR_AS_SIG_INVALID_CREDIT_CARD_PATTERN":{"errno":"0xcd1", "desc":"Imported Signatures has invalid Credit Card pattern."},
    "NSERR_AS_SIG_INVALID_SAFE_OBJECT_PATTERN":{"errno":"0xcd2", "desc":"Imported Signatures has invalid Safe Object pattern."},
    "NSERR_AS_IMPORT_INVALID_TAR_ARCHIVE":{"errno":"0xcd3", "desc":"Imported archive is invalid. Please provide valid tar.gz archive."},
    "NSERR_AS_SQLINJECTION_KEYWORD_INVALID_ATTRIBUTE":{"errno":"0xcd4", "desc":"Imported signatures has invalid SQL injection attributes."},
    "NSERR_AS_SPLSTRING_INVALID_ATTRIBUTE":{"errno":"0xcd5", "desc":"Imported signatures has invalid special string attributes."},
    "NSERR_AS_SQLINJECTION_KEYWORD_LITERAL_EXCEED_MAXLEN":{"errno":"0xcd6", "desc":"Maximum allowed length for type \"LITERAL\" for keyword is 255."},
    "NSERR_AS_SPLSTRING_LITERAL_EXCEED_MAXLEN":{"errno":"0xcd7", "desc":"Maximum allowed length for type \"LITERAL\" for special string is 255."},
    "NSERR_AS_XSLT_TRANFORM_LATEST":{"errno":"0xcd8", "desc":"Problem converting imported signature to the latest version. For more details see /var/log/ns.log file."},
    "NSERR_AS_XSLT_TRANFORM_USER":{"errno":"0xcd9", "desc":"Problem converting imported signature with the given xslt file. For more details see /var/log/ns.log file."},
    "NSERR_AS_SIG_RESP_BODY_EXPR_ERROR":{"errno":"0xcda", "desc":"Match type EXPRESSION is not supported in response rules."},
    "NSERR_AS_NOTRUSTEDLEARNINGCLIENT":{"errno":"0xcdb", "desc":"No Such Trusted Learning Client."},
    "NSERR_AS_EXIST_TRUSTEDLEARNINGCLIENT":{"errno":"0xcdc", "desc":"The Trusted Learning Client is already in use."},
    "NSERR_AS_POLICY_ALLOWED_BINDPOINT_NONE":{"errno":"0xcdd", "desc":"Only bindpoint none is allowed for this policy."},
    "NSERR_AS_XSS_DENIED_PATTERN_INVALID_ATTRIBUTE":{"errno":"0xcde", "desc":"Imported signatures has invalid denied pattern attribute."},
    "NSERR_AS_XSS_DENIED_PATTERN_EXCEED_MAXLEN":{"errno":"0xcdf", "desc":"Maximum allowed length for type \"LITERAL\" for denied pattern is 255."},
    "NSERR_AS_XSS_ALLOWED_PATTERN_INVALID_ATTRIBUTE":{"errno":"0xce0", "desc":"Imported signatures has invalid allowed pattern attribute."},
    "NSERR_AS_XSS_ALLOWED_PATTERN_EXCEED_MAXLEN":{"errno":"0xce1", "desc":"Maximum allowed length for type \"LITERAL\" for allowed pattern is 255."},
    "NSERR_AS_SIG_MULTIPLE_SUB_LOCATIONS":{"errno":"0xce2", "desc":"Imported signature pattern location has multiple sub locations"},
    "NSERR_AS_SIG_INTERNAL_ERROR":{"errno":"0xce3", "desc":"Internal error when configuring signatures."},
    "NSERR_AS_SIG_URL_TAG_ERROR":{"errno":"0xce4", "desc":"Signature file has <URL> tag in an improper location."},
    "NSERR_AS_SIG_HEADER_NAME_TAG_ERROR":{"errno":"0xce5", "desc":"Signature file has <HeaderName> tag in an improper location. See /var/log/ns.log for more details."},
    "NSERR_AS_SIG_COOKIE_NAME_TAG_ERROR":{"errno":"0xce6", "desc":"Signature file has <CookieName> tag in an improper location. See /var/log/ns.log for more details."},
    "NSERR_AS_SIG_FIELD_NAME_TAG_ERROR":{"errno":"0xce7", "desc":"Signature file has <FieldName> tag in an improper location."},
    "NSERR_AS_SIG_PATTERN_ADD_ERROR":{"errno":"0xce8", "desc":"Problem constructing signature pattern from file"},
    "NSERR_AS_SIG_NON_LITERAL_FASTMATCH":{"errno":"0xce9", "desc":"Signature file has \"fastmatch\" on a non-literal match. See /var/log/ns.log for more details"},
    "NSERR_AS_SIG_NEGATED_LITERAL_FASTMATCH":{"errno":"0xcea", "desc":"Signature file has \"fastmatch\" on a negated literal match."},
    "NSERR_AS_SIG_MEM_ALLOC_FAILED":{"errno":"0xceb", "desc":"Memory allocation failed while loading signatures."},
    "NSERR_AS_SIG_TOO_MANY_PATTERNS":{"errno":"0xcec", "desc":"Signature file has a rule with too many patterns."},
    "NSERR_AS_SIG_LITERAL_HEX_PARSE_ERROR":{"errno":"0xced", "desc":"Signature file has a pattern with hex byte syntax error."},
    "NSERR_AS_SIG_PCRE_COMPILE_ERROR":{"errno":"0xcee", "desc":"Signature file has an invalid PCRE."},
    "NSERR_INVALID_SIGNATURE_NAME":{"errno":"0xcef", "desc":"Invalid signature name; it must begin with an alphanumeric character or underscore and must contain only alphanumerics, '_', '.', or '-'"},
    "NSERR_AS_SIGNATURE_MERGE":{"errno":"0xcf0", "desc":"Problem merging imported signature rules with the existing signature rules. For more details see /var/log/ns.log file."},
    "NSERR_AS_RECORDER_MEM_ALLOC_ERROR":{"errno":"0xcf1", "desc":"Cannot allocate memory for requested recorder size."},
    "NSERR_AS_SIG_INVALID_FILE_VERSION":{"errno":"0xcf2", "desc":"Signature file has an invalid SignaturesFile 'version' value."},
    "NSERR_AS_AUTO_SIGNATURE_UPDATED_FAILED":{"errno":"0xcf3", "desc":"Updating of signatures failed. For more details see /var/log/ns.log file."},
    "NSERR_AS_NO_CONTENT_TYPE":{"errno":"0xcf4", "desc":"No Such content-type."},
    "NSERR_AS_POLICY_BINDING_NOTALLOWED":{"errno":"0xcf5", "desc":"Appfw policy can only be bound to spotted vservers that are associated to nodegroup which is bound to one/zero node."},
    "NSERR_AS_POLICY_SET_NOTALLOWED":{"errno":"0xcf6", "desc":"Set disallowed as advance profile can only be associated to policy that is either not bound or bound to spotted vservers."},
    "NSERR_AS_SIGNATURE_URL_NOT_ACCESSIBLE":{"errno":"0xcf7", "desc":"Signature URL set in 'set appfw settings' is not accessible. Please check the DNS NameServer/Route settings and try again."},
    "NSERR_AS_NODEGROUP_UNBIND_VSERVER_NOTALLOWED":{"errno":"0xcf8", "desc":"Unbinding vserver from nodegroup disallowed as vserver has appfw policy bound to it."},
    "NSERR_AS_NODEGROUP_BIND_NODE_NOTALLOWED":{"errno":"0xcf9", "desc":"Nodegroup could be associated with only one node if it has a vserver that has appfw policy bound to it."},
    "NSERR_AS_BUILT_IN_OBJECT_ERROR":{"errno":"0xcfa", "desc":"Cannot add or remove built in objects."},
    "NSERR_AS_SIGNATURE_VALIDATE_FAILED":{"errno":"0xcfb", "desc":"Imported signature is failed to validate against sha1 file. For more details see /var/log/ns.log file."},
    "NSERR_AS_INVALID_PARAMETER":{"errno":"0xcfd", "desc":"Sha1 parameter is allowed to use only with Import Appfw Signatures command"},
    "NSERR_AS_LEARNING_DB_ERROR":{"errno":"0xcfe", "desc":"Learning database is either corrupt or does not exist."},
    "NSERR_AS_VALIDATION_SIGNATURE_MAPPING_FAILED":{"errno":"0xcff", "desc":"SignatureMapping.xml is invalid. Failed to validate SignatureMapping.xml against its schema file."},
    "NSERR_AS_EXIST_CONTENT_TYPE":{"errno":"0xd04", "desc":"Content-type is already in use."},
    "NSERR_AS_SIG_MISSING_MAX_MATCH_LEN":{"errno":"0xd05", "desc":"Signature file has a rule with a response body pattern without the required maxMatchLength attribute"},
    "NSERR_AS_NOT_ALLOWED_CONTENT_TYPE":{"errno":"0xd06", "desc":"Content-types 'application/x-www-form-urlencoded' or 'multipart/form-data' or 'text/x-gwt-rpc' are allowed by default and do not need to be explicitly configured in the allowed list"},
    "NSERR_AS_TOTAL_IMPORT_SIZE_LIMIT_EXCEEDED":{"errno":"0xd07", "desc":"Update is successful but update operation of this import object exceeded total import size limit. Now total import size limit is changed to newer value."},
    "NSERR_AS_MAX_TOTAL_IMPORT_LIMIT_EXCEEDED":{"errno":"0xd08", "desc":"Update operation of this import object exceeded maximum total import size limit. Please remove the object."},
    "NSERR_INVALID_DEFAULT_SIGNATURE_NAME":{"errno":"0xd09", "desc":"Signature name must only be '*Default Signatures' or '*Xpath Injection Patterns'"},
    "NSERR_AS_SIG_OFFSET_GTE_DEPTH":{"errno":"0xd0a", "desc":"Signature file has a pattern with offset attribute greater than or equal to the depth attribute. See /var/log/ns.log for more details"},
    "NSERR_AS_SQLWILDCHAR_INVALID_ATTRIBUTE":{"errno":"0xd0b", "desc":"Imported signatures has invalid wild char attributes."},
    "NSERR_AS_WILDCHAR_LITERAL_EXCEED_MAXLEN":{"errno":"0xd0c", "desc":"Maximum allowed length for type \"LITERAL\" for wild char exceeded."},
    "NSERR_AS_SIG_EXCLAMATION_LITERAL":{"errno":"0xd0d", "desc":"Cannot have an exclamation point alone as a literal"},
    "NSERR_AS_REMOVE_FAILED_RENAME_FAILED":{"errno":"0xd0e", "desc":"Problem in removing resource - file rename failed"},
    "NSERR_AS_ARCHIVE_PROFILE_FAILED":{"errno":"0xd0f", "desc":"Some commands failed during archive profile. Please see /var/log/ns.log for more details."},
    "NSERR_AS_RESTORE_PROFILE_FAILED":{"errno":"0xd11", "desc":"Some commands failed during restore profile. Please see /var/log/ns.log for more details."},
    "NSERR_AS_EMPTY_CONTENT_TYPE":{"errno":"0xd18", "desc":"Empty content type"},
    "NSERR_AS_SIG_FASTMATCH_BAD_LOCATION":{"errno":"0xd1f", "desc":"A signature rule has fastmatch pattern in a bad location.  See log for details."},
    "NSERR_AS_SESSIONLESS_FFC_POST_ONLY":{"errno":"0xd20", "desc":"'POST ONLY' is same as option 'ON' in streaming "},
    "NSERR_AS_TURNING_TAGGING_OFF_FFC_ON":{"errno":"0xd21", "desc":"Form-tagging cannot be disabled and remains enabled as long as field consistency check is enabled."},
    "NSERR_AS_NO_CREDIT_CARD_NUMBER":{"errno":"0xd23", "desc":"No such credit card number."},
    "NSERR_AS_EXIST_CREDIT_CARD_NUMBER":{"errno":"0xd24", "desc":"Credit card number is already in use."},
    "NSERR_AS_NO_SUCH_IMPORTED_OBJECT":{"errno":"0xd25", "desc":"No such imported object."},
    "NSERR_AS_LEARNING_SQL_ERROR":{"errno":"0xd26", "desc":"SQL Error when performing learning operation"},
    "NSERR_AS_IMPORT_FILE_IS_EMPTY":{"errno":"0xd27", "desc":"Imported file is empty"},
    "NSERR_AS_IMPORT_OVERWRITE_OPTION_NOT_SUPPORTED":{"errno":"0xd28", "desc":"Overwrite option is not supported."},
    "NSERR_AS_BAD_INSPECT_CONTENT_TYPE":{"errno":"0xd29", "desc":"Invalid inspection content type"},
    "NSERR_AS_GEO_LOCATION_LOGGING_ENABLED":{"errno":"0xd30", "desc":"GeoLocationLogging only works when CEFLogging is enabled"},
    "NSERR_AS_NO_SUCH_WSDL_OBJECT":{"errno":"0xd31", "desc":"WSDL does not exist"},
    "NSERR_AS_NO_SUCH_XMLSCHEMA_OBJECT":{"errno":"0xd32", "desc":"XMLSchema does not exist"},
    "NSERR_AS_NO_SUCH_XMLERRORPAGE_OBJECT":{"errno":"0xd33", "desc":"XMLErrorPage does not exist"},
    "NSERR_AS_NO_SUCH_SIGNATURE_OBJECT":{"errno":"0xd34", "desc":"Signature does not exist"},
    "NSERR_AS_NO_SUCH_ARCHIVE_OBJECT":{"errno":"0xd35", "desc":"Archive does not exist"},
    "NSERR_AS_NO_SUCH_HTMLERRORPAGE_OBJECT":{"errno":"0xd36", "desc":"HTMLErrorPage does not exist"},
    "NSERR_AS_XSS_ALLOWED_TAG_INVALID_ATTRIBUTE":{"errno":"0xd41", "desc":"Xss allowed Tag has invalid attribute"},
    "NSERR_AS_XSS_ALLOWED_ATTR_INVALID_ATTRIBUTE":{"errno":"0xd42", "desc":"Xss allowed attribute has invalid attribute"},
    "NSERR_AS_SQL_TRANSFORM_INVALID_ATTRIBUTE":{"errno":"0xd43", "desc":"SQL transform has invalid attribute"},
    "NSERR_AS_SRC_NOT_DEFAULT":{"errno":"0xd4b", "desc":"Source should be \"DEFAULT\""},
    "NSERR_AS_SRC_INVALID":{"errno":"0xd4c", "desc":"Invalid source"},
    "NSERR_AS_IMPORT_NOT_DEFAULT_WITH_SHA1":{"errno":"0xd4d", "desc":"Name should be *Default Signatures when -sha1 is specified"},
    "NSERR_AS_WAR_UPDATE_FOLLOWED_BY_IMPORT":{"errno":"0xd4f", "desc":"Execute update command to push the object to packet engine so that the imported object is applied."},
    "NSERR_AS_CUSTOM_SETTINGS_SQL_MULTIPLE_INJECTION_TYPE":{"errno":"0xd5f", "desc":"Failed to set signature object. Multiple injection tags of sql type are not allowed"}
}

NS_CVPN_ERRORS = {
    "NSERR_NO_SUCH_PROFILE":{"errno":"0xcb0", "desc":"Profile does not exist"},
    "NSERR_PROFILE_IN_USE":{"errno":"0xcb1", "desc":"Profile in use"},
    "NSERR_NO_SAMLPROFILE":{"errno":"0xd37", "desc":"Please specify a SAML SSO profile."}
}

NS_VMAC_ERRORS = {
    "NSERR_INTERFACE_BOUND":{"errno":"0xd01", "desc":"Interface already bound"},
    "NSERR_VRID_INTERFACE_NOT_BOUND":{"errno":"0xd02", "desc":"Interface not bound"},
    "NSERR_NO_SUCH_INTERFACE":{"errno":"0xd03", "desc":"No such interface"},
    "NSERR_DYNAMIC_ENTRY":{"errno":"0xd12", "desc":"Dynamic Entry exists."},
    "NSERR_PRIO_INTFVRID":{"errno":"0xd13", "desc":"Invalid Priority for interface bound VRID"},
    "NSERR_INTFVRID":{"errno":"0xd14", "desc":"Binding interface is not allowed for Dynamic or IP bound VRID"},
    "NSERR_NOTSTATIC_VRID":{"errno":"0xd15", "desc":"Not a Configured VRID"},
    "NSERR_IPVRID":{"errno":"0xd16", "desc":"IP binding is not allowed for Interface VRID"},
    "NSERR_IPVRID_BOUND":{"errno":"0xd17", "desc":"VRID already bound to this IP"},
    "NSERR_NOVRID":{"errno":"0xd1a", "desc":"VRID doesn't exist"},
    "NSERR_INTF_TRACKINTF_BOUND":{"errno":"0xd22", "desc":"Interfaces can either be tracked or bound to a vrID."},
    "NSERR_VRRP_SHAREDVLAN_NOT_SUPPORTED":{"errno":"0xd50", "desc":"VRRP functionality is not supported on shared VLANs."}
}

NS_JAZZ_ERRORS = {
    "NSERR_BO_LAC_NOT_FOUND":{"errno":"0xd51", "desc":"Make sure that you have entered a valid License Access Code. Note that licenses can also be allocated in My Account on Citrix.com. For assistance, contact Citrix Customer Service"},
    "NSERR_JBOC_FAILED":{"errno":"0xd52", "desc":"License files cannot be saved. You must select a different directory or edit the permissions for this directory." },
    "NSERR_BO_SESSION_EXPIRED":{"errno":"0xd53", "desc":"Your session has expired."},
    "NSERR_BO_LAC_FULLY_ALLOCATED":{"errno":"0xd54", "desc":"All available licenses have been allocated for this License Access Code. Enter a different code or contact Citrix Customer Service."},
    "NSERR_BO_WEBKEY_NOT_SUPPORTED":{"errno":"0x55", "desc":"This license cannot be allocated automatically. To allocate it manually, go to My Account on Citrix.com"},
    "NSERR_JBOC_CITRIX_RESPONSE":{"errno":"0xd56", "desc":"This operation could not be completed. If you are trying to allocate a license, go to My Account on Citrix.com. For assistance, contact Citrix Customer Service."},
    "NSERR_JBOC_CITRIX_CONNECTION_FAILED":{"errno":"0xd57", "desc":"There is a network connection issue. Please try again later or go to My Account on Citrix.com"},
    "NSERR_BO_GENERIC":{"errno":"0xd58", "desc":"Your request could not be completed due to an error. Please contact Citrix support"},
    "NSERR_BO_SN_NOT_FOUND":{"errno":"0xd59", "desc":"Make sure that you have entered a valid Serial Number. Note that licenses can also be allocated in My Account on Citrix.com. For assistance, contact Citrix Customer Service"}
}

NS_BACKUP_ERRORS = {
    "NSERR_BACKUP_CONFINVALID":{"errno":"0xd61", "desc":"Configuration file is not valid or corrupted."},
    "NSERR_BACKUP_CREATEDIR":{"errno":"0xd62", "desc":"Unable to create directory ."},
    "NSERR_BACKUP_MISSING":{"errno":"0xd63", "desc":"Backup file does not exist."},
    "NSERR_BACKUP_CREATETAR":{"errno":"0xd64", "desc":"Unable to create backup tar file."},
    "NSERR_BACKUP_CONFMISSING":{"errno":"0xd65", "desc":"Configuration file not found."},
    "NSERR_BACKUP_FILEMISSING":{"errno":"0xd66", "desc":"Missing filename argument in the input."},
    "NSERR_BACKUP_INVALIDFILE":{"errno":"0xd67", "desc":"Invalid/Tampered backup file encountered."},
    "NSERR_BACKUP_EXTRACTTAR":{"errno":"0xd68", "desc":"Unable to extract backup tar file."},
    "NSERR_BACKUP_REMOVE":{"errno":"0xd69", "desc":"Unable to remove backup tar file."},
    "NSERR_BACKUP_MAXLIMIT":{"errno":"0xd6a", "desc":"Reached max limit of 50 for backup files. Remove older files to proceed."}
}

NS_FILEUPLOAD_ERRORS = {
    "NSERR_NO_DIR":{"errno":"0xd70", "desc":"Directory does not exist."},
    "NSERR_NO_FILE":{"errno":"0xd71", "desc":"File does not exist."},
    "NSERR_FILEEXT_NOTSUP":{"errno":"0xd72", "desc":"Unsupported file format. only txt/cert/req/xml/key type of files are allowed."},
    "NSERR_FILECONT_NOTSUP":{"errno":"0xd73", "desc":"Unsupported file content. file content should be base64 encoded."},
    "NSERR_FILEENC_NOTSUP":{"errno":"0xd74", "desc":"Unsupported encoding type. only BASE64 encoding is allowed."},
    "NSERR_NO_DEST":{"errno":"0xd75", "desc":"Destination path does not exist."},
    "NSERR_INVALID_DEST":{"errno":"0xd76", "desc":"User doesn't have permission for given Destination path."},
}

NS_SNMP_ERRORS = {
    "NSERR_INVALTHRESHOLD":{"errno":"0xd81", "desc":"Threshold value for this alarm is a percentage (1 - 100)"},
    "NSERR_WRONGTHRESHOLDS":{"errno":"0xd82", "desc":"Normal threshold must be lower than alarm threshold"},
    "NSERR_INVALID_SRCIP":{"errno":"0xd83", "desc":"Valid source IP: NSIP, SNIP, MIP. In cluster setup, valid source IP: CLIP, Striped SNIP. In non default partition, valid source IP: SNIP"},
    "NSERR_THRESHOLD_UNSETTABLE":{"errno":"0xd84", "desc":"Threshold value cannot be set/unset for this alarm"},
    "NSERR_TIME_UNSETTABLE":{"errno":"0xd85", "desc":"Time interval cannot be set/unset for this alarm"},
    "NSERR_WRONG_LOW_THRESHOLDS":{"errno":"0xd86", "desc":"Normal threshold must be higher than alarm threshold"},
    "NSERR_NOSNMPUSER":{"errno":"0xd87", "desc":"SNMP user doesn't exist"},
    "NSERR_WRONG_SNMPVERSION":{"errno":"0xd88", "desc":"Bind command allowed only for V3 traps"},
    "NSERR_V3TRAP_COMMUNITY":{"errno":"0xd89", "desc":"V3 traps cannot have community"},
    "NSERR_IPINUSE":{"errno":"0xd8A", "desc":"IP is used in SNMP trap configuration"},
    "NSERR_DEFAULTONLY":{"errno":"0xd8B", "desc":"Alarm not supported in non-default partition"},
    "NSERR_OWNERNODE":{"errno":"0xd8C", "desc":"Owner node not specified or invalid"},
    "NSERR_FIPS_SNMP":{"errno":"0xd8D", "desc":"Less secure SNMP configuration is not supported in FIPS mode"}
}

NS_HTML_INJECTION_ERRORS = {
    "NSERR_PREBODY_FILE_NOT_FOUND":{"errno":"0xF00", "desc":"Prebody file not found"},
    "NSERR_PREBODY_FILE_TOO_BIG":{"errno":"0xF01", "desc":"Prebody file too big"},
    "NSERR_PREBODY_FILE_READ_ERR":{"errno":"0xF02", "desc":"Prebody file read error"},
    "NSERR_POSTBODY_FILE_NOT_FOUND":{"errno":"0xF03", "desc":"Postbody file not found"},
    "NSERR_POSTBODY_FILE_TOO_BIG":{"errno":"0xF04", "desc":"Postbody file too big"},
    "NSERR_POSTBODY_FILE_READ_ERR":{"errno":"0xF05", "desc":"Postbody file read error"},
    "NSERR_HTML_INJECTION_VAR_EXISTS":{"errno":"0xF06", "desc":"HTML injection variable already exists"},
    "NSERR_HTML_INJECTION_VAR_NEXISTS":{"errno":"0xF07", "desc":"HTML injection variable does not exist"},
    "NSERR_HTML_INJECTION_VAR_NAME_TOO_LONG":{"errno":"0xF0B", "desc":"variable name too long"},
    "NSERR_HTML_INJECTION_INVALID_VAR_NAME":{"errno":"0xF0C", "desc":"Invalid variable name"},
    "NSERR_HTML_INJECTION_INCOMLETE_VAR_DEFINE":{"errno":"0xF0D", "desc":"Unpaired %% for variable name"},
}

NS_INAT_ERRORS = {
    "NSERR_PUBLICIP":{"errno":"0xf30", "desc":"Invalid Public IP address"},
    "NSERR_PRIVATEIP":{"errno":"0xf31", "desc":"Invalid Private IP address"},
    "NSERR_PROXYIP":{"errno":"0xf32", "desc":"Invalid Proxy IP address"},
    "NSERR_WILDCARDTCPVIP":{"errno":"0xf33", "desc":"TCPPROXY enabled when wildcard TCP Vserver already present"},
    "NSERR_WILDCARDANYVIP":{"errno":"0xf34", "desc":"INAT rule with wildcard ANY vserver, not allowed"},
    "NSERR_FTPVIPPRESENT":{"errno":"0xf35", "desc":"FTP enabled when FTP vserver already present"},
    "NSERR_V46_USIP":{"errno":"0xf36", "desc":"USIP is not allowed in mixed topology"},
    "NSERR_INCOMPATIBLE_IP":{"errno":"0xf37", "desc":"Private and Proxy IP should share the same IP Type"},
    "NSERR_ONLY_NAT46_SUPPORTED":{"errno":"0xf38", "desc":"Stateless mode only supported for IPv4->IPV6"},
    "NSERR_NAT46_PROXY_IP":{"errno":"0xf39", "desc":"Proxy IP is not supported in stateless mode"},
    "NSERR_NAT46_INVALID_PREFIXLEN":{"errno":"0xf3A", "desc":"Prefix length should be 32/40/48/56/64/96"},
    "NSERR_NAT46_INVALID_SETTING":{"errno":"0xf3B", "desc":"Invalid configuration for nat46"},
    "NSERR_NAT46_PRIVATEIP_EXISTS":{"errno":"0xf3C", "desc":"Private IP already configured in another nat46 rule"},
    "NSERR_TFTPVIPPRESENT":{"errno":"0xf3d", "desc":"TFTP enabled when TFTP vserver already present"},
    "NSERR_SETUNSETINAT_NOTSUPPORTED":{"errno":"0xf3E", "desc":"Setting and Unsetting mode of INAT not supported"},
}

NS_NETBRIDGE_ERRORS = {
    "NSERR_TNL_NETBRIDGED":{"errno":"0xf50", "desc":"Tunnel bound to netbridge"},
    "NSERR_TNL_GRE":{"errno":"0xf51", "desc":"Tunnel protocol is not GRE"},
    "NSERR_TNL_RIPMASK":{"errno":"0xf52", "desc":"Remote IP mask of the tunnel should be 255.255.255.255"},
    "NSERR_VLAN_NETBRIDGED":{"errno":"0xf53", "desc":"Vlan already bound to some netbridge"},
    "NSERR_MAX_NETBRIDGE_TUNNEL":{"errno":"0xf54", "desc":"reached maximum netbridge tunnel bindings"},
    "NSERR_TUN_BOUND":{"errno":"0xf55", "desc":"Tunnel already bound to this netbridge"},
    "NSERR_SUBNET_BOUND":{"errno":"0xf56", "desc":"Subnet already bound to this netbridge"},
    "NSERR_TUN_CONF_NETBRIDGE":{"errno":"0xf57", "desc":"Tunnel is not configured"},
    "NSERR_VLAN_CONF_NETBRIDGE":{"errno":"0xf58", "desc":"Vlan is not configured"},
    "NSERR_IP_INVAL_NETBRIDGE":{"errno":"0xf59", "desc":"IP is not binded to netbridge"},
    "NSERR_IPV6_INVAL_NETBRIDGE":{"errno":"0xf5a", "desc":"IPV6 is not binded to netbridge"},
    "NSERR_INV_NETBRIDGE_NAME":{"errno":"0xf5b", "desc":"Netbridge name should be >=1 and <=32"},
    "NSERR_GRE_IPSEC_LIP_NOT_GIVEN":{"errno":"0xf5c", "desc":"Local ip address has to be given for GRE, IPSEC and broadcast VXLAN tunnels"},
    "NSERR_NETBRIDGE_TUNNELBOUNDTOPBR":{"errno":"0xf5d", "desc":"Tunnel is a nexthop for PBR"},
    "NSERR_NETBRIDGE_UNSUPPORTEDTUNNELPAYLOAD":{"errno":"0xf5e", "desc":"GRE Payload should be ETHERNET or ETHERNETwithDOT1Q"},
    "NSERR_NETBRIDGE_ONEVLAN_ETHERNET":{"errno":"0xf5f", "desc":"Only one VLAN can be bound when GRE carries plain ETHERNET"},
    "NSERR_NETBRIDGE_TUNNELPAYLOAD_DIFFERENT":{"errno":"0x353", "desc":"All bound tunnels should have same GRE payload"},
}

NS_APPFLOW_ERRORS = {
    "NSERR_APPFLOW_INVALIDPORT":{"errno":"0xf60", "desc":"Invalid collector port"},
    "NSERR_NO_SUCH_COLLECTOR":{"errno":"0xf62", "desc":"No matching collector"},
    "NSERR_APPFLOW_NCORE_ONLY":{"errno":"0xf63", "desc":"The AppFlow feature is available only on Citrix NetScaler nCore."},
    "NSERR_APPFLOW_NONZERO_ACTION_REFCOUNT":{"errno":"0xf64", "desc":"The specified AppFlow collector is being used in an AppFlow action."},
    "NSERR_APPFLOW_COLLECTOR_NAME_INUSE":{"errno":"0xf65", "desc":"AppFlow collector name already in use."},
    "NSERR_APPFLOW_ACT_INVAL":{"errno":"0xf66", "desc":"No such AppFlow action exists."},
    "NSERR_APPFLOW_NETPROF_REQD":{"errno":"0xd90", "desc":"NetProfile required for AppFlow collector within partition."},
    "NSERR_PERF_COLLECTOR_LOGSTREAM":{"errno":"0x428", "desc":"Perf-only option is valid only with one Logstream collector attached to one appflow action."},
    "NSERR_APPFLOW_ULFD_PORT":{"errno":"0x4c3", "desc":"Logstream daemon listens only on 5557 port."},
    "NSERR_COLLECTOR_TRANSPORT_MISMATCH":{"errno":"0x4c4", "desc":"All collectors attached to an action should have the same transport type."},
}

NS_NETPROFILE_ERRORS = {
    "NSERR_IPSET_REF":{"errno":"0xf70", "desc":"IP set must be unbound before it can be removed"},
    "NSERR_NETPROFILE_REF":{"errno":"0xf71", "desc":"Netprofile must be unbound before it can be removed"},
    "NSERR_IPSET_BOUND":{"errno":"0xf72", "desc":"IP set is already bound to the network profile"},
    "NSERR_NO_SUCH_IPSET":{"errno":"0xf73", "desc":"IP set does not exist"},
    "NSERR_NO_SUCH_NETPROF":{"errno":"0xf74", "desc":"Netprofile does not exist"},
    "NSERR_OVERLAPPING_PORTRANGE":{"errno":"0xde6", "desc":"This range is overlapping the existing portrange."},
    "NSERR_NO_SUCH_PORTRANGE":{"errno":"0xde7", "desc":"Port range does not exist"},
    "NSERR_NO_SUCH_NATRULE":{"errno":"0xde8", "desc":"natRule does not exist"},
    "NSERR_NATRULE_EXIST":{"errno":"0xde9", "desc":"natrule already exist"},
}

NS_NAT64_ERRORS = {
    "NSERR_NAT64_ACL_EXISTS":{"errno":"0xf77", "desc":"ACL is bound to another NAT64 rule"},
}

NS_INTF_ERRORS = {
    "NSERR_1GSFPSPEEDLIMIT":{"errno":"0xf80", "desc":"1G SFP's are restricted to speed 1000 or AUTO only"},
    "NSERR_1GSFPDUPLEXLIMIT":{"errno":"0xf81", "desc":"1G SFP's are restricted to duplex FULL or AUTO only"},
    "NSERR_1GSPEEDLIMIT":{"errno":"0xf82", "desc":"1G port can not be configured as 10G speed"},
    "NSERR_1GDUPLEXLIMIT":{"errno":"0xf83", "desc":"1G port can not be configured as HALF duplex"},
    "NSERR_10GSPEEDLIMIT":{"errno":"0xf84", "desc":"10G ports on this platform can only be configured as speed 1G, 10G or AUTO only"},
    "NSERR_10GDUPLEXLIMIT":{"errno":"0xf85", "desc":"10G ports on this platform can only be configured as duplex FULL or AUTO only"},
    "NSERR_10GAUTONEGLIMIT":{"errno":"0xf86", "desc":"10G ports on this platform do not support AUTONEG"},
    "NSERR_10GSPEEDONLY":{"errno":"0xf87", "desc":"10G ports on this platform are restricted to speed 10000 or AUTO only"},
    "NSERR_FULLDUPLEXONLY":{"errno":"0xf88", "desc":"These ports do not support HALF duplex mode"},
    "NSERR_AUTOINVALSPEED":{"errno":"0xf89", "desc":"Static CLAG does not support speed as AUTO"},
    "NSERR_CLAGSPEEDREQ":{"errno":"0xf8a", "desc":"Static CLAG explicitly requires speed to be configured other than AUTO"},
    "NSERR_THROUGHPUTLIMIT":{"errno":"0xf8b", "desc":"Throughput limit error. Possible values: 1G port - 1000Mbps, 10G port - 10000Mbps, 40G port - 40000Mbps, Link Aggregation - 80000Mbps"},
    "NSERR_BANDWIDTHLIMIT":{"errno":"0xf8c", "desc":"Bandwidth limit error. Possible values: 1G port - 1000Mbps, 10G port - 10000Mbps, 40G port - 40000Mbps, Link Aggregation - 80000Mbps"},
    "NSERR_10GDAC_SPEEDLIMIT":{"errno":"0xf8d", "desc":"DAC port speed must be configured as 10G or AUTO"},
    "NSERR_VIF_LACP_CAUTION":{"errno":"0xf8e", "desc":"Dynamic LA works in only pass-through interface mode."},
    "NSERR_LA_SLAVE_LIMIT":{"errno":"0xf8f", "desc":"Trying to bind more interfaces than allowed limit"},
    "NSERR_SLAVE_MTU_MISMATCH":{"errno":"0xf93", "desc":"Interface MTU should be same as Channel MTU."},
    "NSERR_BKPLANE_MTU_MISMATCH":{"errno":"0xf94", "desc":"Interface MTU should be default or same as Backplane MTU."},
    "NSERR_MTU_NOTALLOWED":{"errno":"0xf95", "desc":"MTU change is not allowed on this interface."},
    "NSERR_BACKPLANE_MTU_LIMIT":{"errno":"0xf96", "desc":"Backplane Interface, Minimum user configured value for MTU is 1579."},
    "NSERR_INTERFACE_SLAVE_MTU_LIMIT":{"errno":"0xf97", "desc":"Interface is a part of channel, MTU change is not allowed."},
    "NSERR_PTP_CLUS_L3":{"errno":"0xf98", "desc":"Cluster INC Mode Enabled, PTP state change is not allowed."},
    "NSERR_40GDUPLEXLIMIT":{"errno":"0xf99", "desc":"40G ports on this platform can only be configured as duplex FULL or AUTO only"},
    "NSERR_40GSPEEDONLY":{"errno":"0xf9a", "desc":"40G ports on this platform are restricted to speed 40000 or AUTO only"},
    "NSERR_LRSET_FC_NOT_ALLOWED":{"errno":"0xf9c", "desc":"Flow Controle settings not allowed for link redundant set interface"},
    "NSERR_LRSET_LACP_SET_NOT_ALLOWED":{"errno":"0xf9d", "desc":"Dynamic LA(LACP) settings are not allowed for  link redundant set interface"},
    "NSERR_LRSET_LLDPSET_NOT_ALLOWED":{"errno":"0xf9e", "desc":"LLDP settings are not allowed for  link redundant set interface"},
    "NSERR_LRSET_SPEED_NOT_ALLOWED":{"errno":"0xf9f", "desc":"speed setting  not allowed for  link redundant set interface"},
    "NSERR_LRSET_PRIORITY_NOT_ALLOWED":{"errno":"0xfba", "desc":"lrset priority not allowed for  link redundant set master interface"},
    "NSERR_LRSET_THROUGHPUT_NOT_ALLOWED":{"errno":"0xfbb", "desc":"throughput setting not allowed for  link redundant set master interface"},
    "NSERR_LRSET_BW_SET_NOT_ALLOWED":{"errno":"0xfbc", "desc":"Bandwidth settings are not allowed for link redundant set interface"},
    "NSERR_LRSET_LAG_TYPE_NOT_ALLOWED":{"errno":"0xfbd", "desc":"Lagtype setting  not allowed for link redundant set interface"},
    "NSERR_LRSET_DUPLEX_NOT_ALLOWED":{"errno":"0xfbe", "desc":"Duplex setting not allowed for link redundant set interface"},
    "NSERR_LRSET_AUTO_NEG_NOT_ALLOWED":{"errno":"0xfbf", "desc":"Disabling autonegotiation not allowed for link redundant set interface"},
    "NSERR_JF_ESX_VERSION_SUPPORT":{"errno":"0xfe6", "desc":"Jumbo Frames are supported on ESX 5.5 version and onward"},
    "NSERR_TP_SETTINGS_NOT_ALLOWED":{"errno":"0xd39", "desc":"Trunk Port settings on this interface is not supported"},
    "NSERR_LACP_SETTINGS_ON_TP_NOT_ALLOWED":{"errno":"0xd3a", "desc":"LACP settings on Trunk Port is not allowed"},
    "NSERR_IP6_ADDRESS_SETTING_FAILED":{"errno":"0xd3b", "desc":"IPv6 Address can not be added because MTA table got exhausted"},
}

NS_NSTRACE_ERRORS = {
    "NSERR_ALREADY_RUNNING":{"errno":"0xf90", "desc":"One instance of nstrace is already running."},
    "NSERR_PKTSIZE_SMALL":{"errno":"0xf91", "desc":"Packet size must be integer number between 60 - 1514. (0 for full packet trace)"},
    "NSERR_CANNOT_CLOSE":{"errno":"0xf92", "desc":"can not stop nstrace."},
    "NSERR_NSTRACE_PERNIC_WARN":{"errno":"0xabc", "desc":"can not apply perNIC option with this trace format. Started nstrace without perNIC."},
    "NSERR_NSTRACE_INVALID_FILTER":{"errno":"0xfe0", "desc":"Invalid filter expression. nstrace will now start without filters"},
    "NSERR_NSTRACE_SENSITIVE_WARN":{"errno":"0x9eb", "desc":"The command uses option(s) that may capture confidential information, or keys that can be used to decrypt confidential information into a file. These files have to be stored in a secure environment"},
    "NSERR_LOW_DISK":{"errno":"0xa00", "desc":"Critically low disk space. Please clear disk space under /var"},
}

NS_SPOTTED_CONFIG_ERRORS = {
    "NSERR_NODECNT_EXCEED":{"errno":"0xfa0", "desc":"You cannot have more than 32 nodes in a nodegroup."},
    "NSERR_INVAL_VAL_IN_DB":{"errno":"0xfa1", "desc":"Invalid values exists in database."},
    "NSERR_NODE_IDX_EXCEED":{"errno":"0xfa2", "desc":"Node index cannot exceed 31."},
    "NSERR_INVALID_NODE":{"errno":"0xfa3", "desc":"Specified node does not exist."},
    "NSERR_INVALID_VSVR":{"errno":"0xfa4", "desc":"Specified type of virtual server cannot be bound to the nodegroup."},
    "NSERR_VSVR_NOT_EXISTS":{"errno":"0xfa5", "desc":"Specified virtual server does not exist."},
    "NSERR_VSVR_ALREADY_BOUND":{"errno":"0xfa6", "desc":"Specified virtual server is already bound to the nodegroup."},
    "NSERR_NOT_IN_SAME_NG":{"errno":"0xfa7", "desc":"Dependencies of the specified virtual server (such as backup virtual server) are not available in the virtual server's nodegroup."},
    "NSERR_NG_NOT_EXISTS":{"errno":"0xfa8", "desc":"Specified nodegroup does not exist."},
    "NSERR_NO_NODES_OR_BOUND":{"errno":"0xfa9", "desc":"Specified node is not valid or is already bound to the nodegroup."},
    "NSERR_NO_NODES_OR_UNBOUND":{"errno":"0xfaa", "desc":"Specified node is not valid or is not bound to this nodegroup."},
    "NSERR_DEPENDENCIES_EXCEED":{"errno":"0xfab", "desc":"Specified virtual server has more than 1024 dependencies."},
    "NSERR_VSVR_NOT_BOUND_OR_BOUND_TO_DIFFERENT":{"errno":"0xfac", "desc":"Specified virtual server is not bound to this nodegroup."},
    "NSERR_HAVE_DEPENDENCIES":{"errno":"0xfad", "desc":"Specified virtual server has dependencies on other entities that are not part of the nodegroup. Remove these dependencies from the virtual server to bind the virtual server and its dependencies to the nodegroup."},
    "NSERR_NG_CMDS_NOT_SUPPORTED_IN_STANDALONE":{"errno":"0xfae", "desc":"Nodegroup commands are supported only in a cluster setup."},
    "NSERR_BIND_VS_FAILS_IF_NO_NODES_AND_STRICT_OR_STICKY":{"errno":"0xfaf", "desc":"You cannot bind an entity to a nodegroup that has no nodes and that has the strict/sticky option enabled."},
    "NSERR_UNBIND_LASTNODE_FAILS_IF_BOUND_ENTITIES_AND_STRICT":{"errno":"0xfb0", "desc":"You cannot unbind the last node of a nodegroup that has entities bound to it and that has the strict option enabled."},
    "NSERR_SET_STRICT_FAILS_IF_NO_NODES_AND_BOUND_ENTITIES":{"errno":"0xfb1", "desc":"You cannot enable STRICT option for a nodegroup that has no nodes, but that has entities bound to it."},
    "NSERR_RM_FAILS_IF_BOUND_ENTITIES":{"errno":"0xfb2", "desc":"Specified nodegroup cannot be removed, because it has entities bound to it."},
    "NSERR_RM_NODE_FAILS_IF_BOUND_ENTITIES":{"errno":"0xfb3", "desc":"Specified cluster node cannot be removed, because it belongs to a nodegroup that has entities bound to it."},
    "NSERR_RM_CLUSTER_FAILS_IF_BOUND_ENTITIES":{"errno":"0xfb4", "desc":"Specified cluster instance cannot be removed, because one of its nodegroups have entities bound to it."},
    "NSERR_BIND_WILDCARDVIP_FAILS":{"errno":"0xfb5", "desc":"You cannot bind a wildcard vserver to a nodegroup."},
    "NSERR_SQL_QUERY_TRUNCATED":{"errno":"0xfb6", "desc":"Too long SQL query to perform the database query."},
    "NSERR_IDENT_ALREADY_BOUND":{"errno":"0xfb7", "desc":"Given identifier already bound."},
    "NSERR_IDENT_NOT_BOUND_OR_BOUND_TO_DIFFERENT":{"errno":"0xfb8", "desc":"Given identifier is not bound or bound to some other nodegroup."},
    "NSERR_IDENT_BOUND_TO_NG":{"errno":"0xfb9", "desc":"Cannot delete identifier that is bound to a nodegroup"},
    "NSERR_GSLB_NG_EXISTS":{"errno":"0xfc2", "desc":"Can not configure multiple GSLB nodegroups."},
    "NSERR_GSLB_SITE_TYPE_NOT_LOCAL":{"errno":"0xfc3", "desc":"Can only perform this operation on a local GSLB site."},
    "NSERR_NG_NOGSLB":{"errno":"0xfc4", "desc":"GSLB entities can not be bound to this nodegroup."},
    "NSERR_SERVICE_BOUND_TO_NG":{"errno":"0xfc5", "desc":"Cannot delete a service bound to a nodegroup."},
    "NSERR_GSLB_NG_NODE_COUNT":{"errno":"0xfc7", "desc":"This nodegroup must be bound to exactly ONE node"},
    "NSERR_GSLB_NG":{"errno":"0xfc8", "desc":"Only GSLB entities can be bound to this nodegroup."},
    "NSERR_VPN_BOUND_TO_NG":{"errno":"0xfc9", "desc":"Cannot bind more than one node to a nodegroup that has vpn vservers bound"},
    "NSERR_VPN_BOUND_TO_OTHER_NG":{"errno":"0xfca", "desc":"Cannot bind vpn vserver to this nodegroup as other vpn vservers are bound to different nodegroup"},
    "NSERR_VPN_BOUND_TO_NG1":{"errno":"0xfcb", "desc":"Cannot bind vpn vserver to a nodegroup that has more than one node bound"},
    "NSERR_UNBIND_LASTNODE_FAILS_IF_VPNVSERVER_BOUND":{"errno":"0xfcc", "desc":"You cannot unbind the last node of a nodegroup that has vpn vserver bound."},
    "NSERR_BIND_NODE_FAILS_IF_STICKY":{"errno":"0xfcd", "desc":"You cannot bind more than one node to a nodegroup that is sticky."},
    "NSERR_UNBIND_LASTNODE_FAILS_IF_BOUND_ENTITIES_AND_STICKY":{"errno":"0xfce", "desc":"You cannot unbind the last node of a nodegroup that has entities bound to it and that has the sticky option enabled."},
    "NSERR_SET_STRICT_FAILS_IF_STICKY":{"errno":"0xfcf", "desc":"You cannot enable STRICT option for a nodegroup that is sticky."},
    "NSERR_NG_BIND_ENTITY_MISMATCH":{"errno":"0xfe1", "desc":"Nodegroup with state option, supports only cluster nodes binding"},
    "NSERR_NG_SET_BOUND":{"errno":"0xfe2", "desc":"Can not set nodegroup, since already bound"},
    "NSERR_NODE_ALREADY_BOUND_TO_STATENG":{"errno":"0xfe3", "desc":"Node already bound to state specific nodegroup"},
    "NSERR_NODE_BOUND_TO_STATENG":{"errno":"0xfe4", "desc":"Can not set the state of the cluster node when bound to nodegroup with state option"},
    "NSERR_NG_STRICT_DISABLED":{"errno":"0xfe5", "desc":"You can not disable STRICT option for nodegroup with state option"},
    "NSERR_NO_TRUE_POLICY":{"errno":"0xfe7", "desc":"No policy evaluated to TRUE"},
}

NS_ICA_CLIENT_VERSION_ERRORS = {
    "NSERR_ICA_CLIENT_VERSION_UNKNOWN_CLIENT_TYPE":{"errno":"0xdd0", "desc":"Unknown ICA client type."},
    "NSERR_ICA_CLIENT_VERSION_DEFAULT_WHITELISTING":{"errno":"0xdd1", "desc":"Failed to initialize the ICA whitelist: Switched to default static ICA whitelisting"},
    "NSERR_ICA_CLIENT_VERSION_NOT_FOUND_IN_EXCEPTION_LIST":{"errno":"0xdd2", "desc":"The ICA client version you are requesting to remove from the exception list is not present in the exception list."},
    "NSERR_ICA_CLIENT_VERSION_INCORRECT_BASE_VERSION_FORMAT":{"errno":"0xdd3", "desc":"Invalid format for the ICA client base version entered."},
    "NSERR_ICA_CLIENT_VERSION_INCORRECT_EXCEPTION_LIST_FORMAT":{"errno":"0xdd4", "desc":"Invalid format for the ICA exception list entered."},
    "NSERR_ICA_CLIENT_VERSION_DUPLICATES_RECEIVED_TO_REMOVE":{"errno":"0xdd5", "desc":"Two or more of the same client versions entered in the ICA exception list."},
}

NS_ICA_LATENCY_PROFILE_ERRORS = {
    "NSERR_ICA_LATENCY_PROFILE_ACTIVE_CONNECTIONS":{"errno":"0xdd6", "desc":"Cannot remove the Latency profile as there are active ICA connections associated with this profile."},
}

NS_LSN_ERRORS = {
    "NSERR_LSN_NOPOOL":{"errno":"0xf78", "desc":"No such pool"},
    "NSERR_LSN_NOTRANSPRFL":{"errno":"0xf79", "desc":"No such transportprofile"},
    "NSERR_LSN_NOAPPSPRFL":{"errno":"0xf1a", "desc":"No such applicationprofile"},
    "NSERR_LSN_POOLNOTBOUND":{"errno":"0xfd4", "desc":"Pool not bound to group"},
    "NSERR_LSN_PRFLNOTBOUND":{"errno":"0xfd5", "desc":"Profile not bound to group"},
    "NSERR_LSN_NOTREADY":{"errno":"0xfd6", "desc":"LSN not initialized. Please check memory allocated to LSN."},
    "NSERR_LSN_MAXBINDINGS":{"errno":"0xfd7", "desc":"Maximum bindings allowed exceeded"},
    "NSERR_LSN_ACL_DETERMINISTICNAT":{"errno":"0xfd8", "desc":"Client with ACLs not allowed for deterministic nat"},
    "NSERR_LSN_ACLTYPE":{"errno":"0xfd9", "desc":"ACL with action other than ALLOW or establishedflag set"},
    "NSERR_LSN_ACLINUSE":{"errno":"0xfda", "desc":"ACL already bound to a LSN/RNAT rule"},
    "NSERR_64LIB_MEM_NOTSUFFICIENT":{"errno":"0xfdb", "desc":"Active memory less than minimum required for LSN and Subscriber Session Store"},
    "NSERR_LSN_NOBINDING":{"errno":"0xfdc", "desc":"No such binding"},
    "NSERR_LSN_NONETWORK":{"errno":"0xfdd", "desc":"No such network"},
    "NSERR_LSN_CLIENTGROUP":{"errno":"0xfde", "desc":"Please remove client's group first"},
    "NSERR_LSN_NOCLIENT":{"errno":"0xfdf", "desc":"No such client"},
    "NSERR_LSN_NOGLBLLOG":{"errno":"0xfe8", "desc":"Logging is disabled at Global level"},
    "NSERR_LSN_CLIENTINUSE":{"errno":"0xff0", "desc":"Client already present in a group"},
    "NSERR_LSN_PORTBLOCKSIZE":{"errno":"0xff1", "desc":"Portblocksize should be multiple of 256"},
    "NSERR_LSN_WRONG_PORTBLOCKSIZE":{"errno":"0x357", "desc":"Portblocksize should not exceed 64512"},
    "NSERR_LSN_BINDINGEXIST":{"errno":"0xff2", "desc":"Binding already exists"},
    "NSERR_LSN_POOLGROUPTYPE":{"errno":"0xff3", "desc":"Both pool and group should be of same nat type"},
    "NSERR_LSN_POOLREUSE_DETERMINISTICNAT":{"errno":"0xff4", "desc":"Pool can be bound to only one group for determinstic nat"},
    "NSERR_LSN_PORT_APPSPROFEXIST":{"errno":"0xff5", "desc":"Profile already exist for one or more ports in this/bound group(s)"},
    "NSERR_LSN_TCPONLY":{"errno":"0xff6", "desc":"Allowed only for TCP profile"},
    "NSERR_LSN_MAPPINGFILTERINGTYPE":{"errno":"0xff7", "desc":"Filtering should be more or equally strict as mapping"},
    "NSERR_LSN_ICMPAPPSPROF_MAPPINGFILTERINGPORT":{"errno":"0xff8", "desc":"Port dependent Filtering or Mapping not allowed for ICMP"},
    "NSERR_LSN_ICMPAPPSPROF_PORT":{"errno":"0xff9", "desc":"Port bindings not allowed for ICMP applicationprofile"},
    "NSERR_LSN_STATIC_NOGROUP":{"errno":"0xffa", "desc":"Client ip not part of any active lsn group"},
    "NSERR_LSN_STATIC_INVPOOL":{"errno":"0xffb", "desc":"No natip available or natip given is invalid"},
    "NSERR_LSN_FINTIMGTSESSTIM":{"errno":"0xffc", "desc":"Finrsttimeout should not be more than session timeout"},
    "NSERR_LSN_SETPORTBLOCK_DETERMINISTICNAT":{"errno":"0xffd", "desc":"Port block size cannot be modified for deterministic nat"},
    "NSERR_LSN_DETERMINISTICNAT_SUBSCR_LIMIT":{"errno":"0xffe", "desc":"Maximum allowed subscribers for deterministic nat group exceeeded"},
    "NSERR_64LIB_MEM_INCOMPLETE":{"errno":"0xf67", "desc":"Active memory could be different from configured memory limit, Please check 'show extendedmemory parameter'"},
    "NSERR_64LIB_MEM_EXCEEDSMAX":{"errno":"0xf68", "desc":"Configured memory cannot exceed maximum limit, Please check 'show extendedmemory parameter'"},
    "NSERR_64LIB_MEM_SIZE2M":{"errno":"0xf69", "desc":"Configured memory should be in multiples of 2MB"},
    "NSERR_LSN_IPINSERT":{"errno":"0xf75", "desc":"LSN IP addition failed"},
    "NSERR_LSN_ICMP_TIMEOUT_EXCEEDED":{"errno":"0xf76", "desc":"Maximum value of ICMP session timeout is 240 seconds"},
    "NSERR_LSN_TCP_UDP_TIMEOUT_EXCEEDED":{"errno":"0xf1b", "desc":"Maximum value of TCP/UDP session timeout is 600 seconds"},
    "NSERR_LSN_APPSPROF_PORTZERO":{"errno":"0xfe9", "desc":"Cannot bind/unbind port 0 to Application Profile"},
    "NSERR_LSN_MEM_DECR":{"errno":"0xf9b", "desc":"Active memory cannot be decreased without reboot"},
    "NSERR_LSN_NOSIPALGPRFL":{"errno":"0xddb", "desc":"No such sipalgprofile"},
    "NSERR_LSN_REM_APPPROFILE_ALGPROFILE_BOUND":{"errno":"0xddc", "desc":"Can not remove Appfprofile, SIP ALG profile and RTSP ALG Profile should be unbound fron the groups bound to the Appprofile"},
    "NSERR_LSN_UNBIND_APPPROFILE_ALGPROFILE_BOUND":{"errno":"0xddd", "desc":"Can not unbind to the Appprofile, SIP ALG profile and RTSP ALG Profile should be unbound fron the groups bound to the Appprofile"},
    "NSERR_LSN_NORTSPALGPRFL":{"errno":"0xfea", "desc":"No such rtspalgprofile"},
    "NSERR_LSN_SIPALGPROF_PORTZERO":{"errno":"0xfeb", "desc":"Cannot add port 0 to SIP ALG Profile"},
    "NSERR_LSN_RTSPALGPROF_PORTZERO":{"errno":"0xfec", "desc":"Cannot add port 0 to RTSP ALG Profile"},
    "NSERR_LSN_IP6PROF_DSLITE":{"errno":"0xfed", "desc":"With DS-Lite add only Network6"},
    "NSERR_LSN_IP6PROF_NAT64":{"errno":"0xfee", "desc":"With NAT64 add only IP6Prefix"},
    "NSERR_LSN_NETWORK6_EXISTS":{"errno":"0xdda", "desc":"network 6  based LSN client already exists for this network 6 address(Duplicate config)"},
    "NSERR_LSN_CLIENTNETWORK_INCORRECT_BINDING":{"errno":"0xddf", "desc":"Both Client and Network type MUST be of the same type, IPv4, IPv6 or DS-Lite Deterministic"},
    "NSERR_LSN_CLIENTGROUPTYPE":{"errno":"0xde1", "desc":"Both client and group should be of same type"},
    "NSERR_LSN_DSLITEPREFIXLEN":{"errno":"0xde2", "desc":"For a DS-Lite DETERMINISTIC type client , network6 MUST have a prefix length 128"},
    "NSERR_LSN_NOIP6PROFILE":{"errno":"0xde3", "desc":"No such IP6 profile"},
    "NSERR_LSN_IP6GROUP":{"errno":"0xfef", "desc":"Please remove associated group first"},
    "NSERR_LSN_DSLITE_INVALIDIP6":{"errno":"0xde4", "desc":"With DS-Lite add only SNIP6."},
    "NSERR_LSN_DSLITE_SNIP6_REQD":{"errno":"0xde5", "desc":"DS-Lite needs SNIP6 in relevent TDs.If not already present,add SNIP6 relevent to all tds belonging to a LSN group"},
    "NSERR_LSN_DUP_IP6PROFILE":{"errno":"0xde0", "desc":"Either IPv6 address or NAT Prefix already been used "},
    "NSERR_LSN_SIPALG_CANNOT_BIND":{"errno":"0xf2a", "desc":"Cannot bind SIPALG profile to the group, either the group is not in full cone mode or IP Pool pair is not enabled"},
    "NSERR_LSN_RTSPALG_CANNOT_BIND":{"errno":"0xf2b", "desc":"Cannot bind RTSP profile to the group, either the group is not in full cone mode or IP Pool pair is not enabled"},
    "NSERR_LSN_SIPALG_TRANSPORT_PROTOCOL_BINDINGEXIST":{"errno":"0xf2c", "desc":"Can not bind more than one SIPALG profile of same transport protocol to the lsn group"},
    "NSERR_LSN_RTSPALG_TRANSPORT_PROTOCOL_BINDINGEXIST":{"errno":"0xf2d", "desc":"Can not bind more than one RTSPALG profile of same transport protocol to the lsn group"},
    "NSERR_LSN_CANNOT_UNBIND_APPPROFILE":{"errno":"0xf2e", "desc":"Can not unbind appprofile unless all SIP ALG Profiles, RTSP ALG Profiles and IPSEC ALG Profile are unbound from all the groups to which appsprofile is bound"},
    "NSERR_LSN_RTSPALGPROF_TRANSPORT_SUPPORTED":{"errno":"0xf2f", "desc":"RTSP ALG profile for only TCP is supported"},
    "NSERR_LSN_IPSECALG_CANNOT_BIND":{"errno":"0xdc0", "desc":"Cannot bind IPSECALG profile to the group, IP Pool pair is not enabled"},
    "NSERR_LSN_SIPALGPROF_PORT_NOT_ADDED":{"errno":"0xd19", "desc":"Atleast sipsrcportrange or sipdstportrange should be added with positive portrange"},
    "NSERR_LSN_GRP_SESS_LIMIT":{"errno":"0x354", "desc":"Group session limit must be greater than the number of Packet Engines"},
    "NSERR_LSN_DETER_POOL":{"errno":"0xf3f", "desc":"Cannot enable portblock allocation on deterministic pool"},
    "NSERR_LSN_SIP_RTSP_ALG_MAPPING_FILTERING_IPPOOLING":{"errno":"0x355", "desc":"Can not set appsprofile unless all SIP ALG profiles and all RTSP ALG profiles are unbound from all the groups to which appsprofile is bound"},
    "NSERR_LSN_PORTBLOCKSIZE_NOTALLOWED":{"errno":"0x358", "desc":"Portblock size should not be changed to zero from nonzero and to nonzero from zero"},
    "NSERR_LSN_POOLGROUP_PORTBLOCK_MISMATCH":{"errno":"0x359", "desc":"Pool's portblock allocation and group's portblocksize fields are not compatable"},
    "NSERR_LSN_GRPID_PERM":{"errno":"0xeea", "desc":"GroupID should not be explicitly specified"},
    "NSERR_LSN_INVALID_DSLITE_PREFIX_LEN":{"errno":"0xeeb", "desc":"Invalid Ipv6 Prefix length for dslite client ipv6 network(only /128 prefix is allowed)"},
    "NSERR_LSN_NOLOGPRFL":{"errno":"0xd38", "desc":"No such log profile"},
    "NSERR_LSN_NOHTTPHDRLOGPRFL":{"errno":"0xd40", "desc":"No such HTTP header log profile"},
    "NSERR_LSN_DOHASYNC":{"errno":"0xd44", "desc":"Force HA Sync should be given to sync Primary's pre-flush operation LSN sessions"},
    "NSERR_LSN_STATICWILD_INV_PORT":{"errno":"0xd45", "desc":"invalid port for static nat wild card port config, subscr port and nat port must be *"},
    "NSERR_LSN_STATICWILD_INV_NATIP":{"errno":"0xd46", "desc":"NAT ip must be given for static nat wildcard port config"},
    "NSERR_LSN_STATICWILD_INV_DSTIP":{"errno":"0xd47", "desc":"Dest ip must not be given for static nat wildcard port config"},
    "NSERR_LSN_STATICWILD_INV_WILDPORT":{"errno":"0xd48", "desc":"wild card port(* or 65535) is valid only for trasport protocol type ALL(i.e only static nat wild card port config)"},
    "NSERR_LSN_STATICWILD_NATIP_INUSE":{"errno":"0xd49", "desc":"NAT ip is already in use for static nat wildcard port config."},
    "NSERR_LSN_STATICWILD_NATIP_NO_FREE_PORTS":{"errno":"0xd4a", "desc":"NAT ip is not valid or not all ports on  NAT ip are free, select different natip which has all ports free."},
    "NSERR_LSN_NAT64_MAP_INS_FAIL":{"errno":"0xd4e", "desc":"Operation on nat64 prefix failed due to low system memory"},
}

NS_SST_ERRORS = {
    "NSERR_SST_SUBSCR_ALLOC_FAILED":{"errno":"0xdb0", "desc":"Cannot allocate memory for subscriber in extended memory space"},
    "NSERR_SST_SUBSCR_LOOKUP_FAILED":{"errno":"0xdb1", "desc":"Cannot find subscriber"},
    "NSERR_SST_SUBSCR_REQUEST_ERROR":{"errno":"0xdb2", "desc":"Invalid request for subscriber"},
    "NSERR_GX_SERVICE_CONFIG_XOR":{"errno":"0xdb3", "desc":"service and vserver cannot be set at the same time."},
    "NSERR_GX_NOT_DIAMETER_VS":{"errno":"0xdb4", "desc":"Not a DIAMETER or SSL_DIAMETER vserver."},
    "NSERR_GX_NOT_DIAMETER_SERVICE":{"errno":"0xdb5", "desc":"Not a DIAMETER or SSL_DIAMETER service."},
    "NSERR_SST_SUBSCRIBER_ENTRY_EXCEEDED":{"errno":"0xdb6", "desc":"Size of subscriber entry exceeds total allowed size."},
    "NSERR_GX_PCRF_NOT_CONFIGURED_VSERVER_SERVICE":{"errno":"0xdb7", "desc":"PCRF not configured. To configure PCRF, please use set gxInteface -vserver/service <DIAMETER vserver/service name>."},
    "NSERR_SST_STATIC_SUBSCRIBER_SESSION_DELETION":{"errno":"0xdb8", "desc":"Static subscriber profiles cannot be deleted using this command, please use 'rm subscriber profile'"},
    "NSERR_SST_SUBSCRIBER_SESSION_EXIST":{"errno":"0xdb9", "desc":"subscriber profile cannot be added as corresponding subscriber session already exists"},
    "NSERR_SST_NOT_RADIUS_SERVICE":{"errno":"0xdba", "desc":"Not RADIUS Listener service"},
    "NSERR_MAX_SERVICE_FUNCTIONS":{"errno":"0xdbb", "desc":"Number for service functions exceeding the limit"},
    "NSERR_NOSUCH_SVCFUNC":{"errno":"0xdbc", "desc":"Service Function is not present with specified name"},
    "NSERR_NOSUCH_SVCPATH":{"errno":"0xdbd", "desc":"Service Path is not present with specified name"},
    "NSERR_INVALID_SVCINDEX":{"errno":"0xdbe", "desc":"The value of service index is invalid"},
    "NSERR_SVCPATH_SVCINX_EXISTS":{"errno":"0xdbf", "desc":"A service function is already bound with given service index"},
}

NS_POOLED_LIC_ERRORS = {
    "NSERR_POOLED_LIC_SET_CAP":{"errno":"0xdf1", "desc":"Unable to set capacity"},
    "NSERR_POOLED_LIC_LPED_COMM":{"errno":"0xdf2", "desc":"Connection to LPED failed"},
    "NSERR_POOLED_LIC_SERVER_CONN":{"errno":"0xdf3", "desc":"Unable to connect to licenseserver"},
}

NS_PCP_ERRORS = {
    "NSERR_PCP_PROFILE_BOUND":{"errno":"0xdc1", "desc":"Cannot remove PCP Profile. To remove PCP profile, first unset it from PCP servers"},
    "NSERR_PCPPROFILE_NOT_EXIST":{"errno":"0xdc2", "desc":"PCP profile does not exist, use 'show pcp profile' to check available pcp profiles"},
    "NSERR_LSNPCP_BINDING_EXIST":{"errno":"0xdc3", "desc":"Please unbind existing PCP server from lsn group"},
    "NSERR_PCPSERVER_NOT_EXIST":{"errno":"0xdc4", "desc":"PCP server does not exist, use 'show pcp server' to check available pcp servers"},
    "NSERR_PCPSERVER_BIND_EXIST":{"errno":"0xdc5", "desc":"Can not Remove PCP server. Please unbind pcp server from all bindings"},
    "NSERR_PCPSERVER_INVALID_IP":{"errno":"0xdc6", "desc":"PCP Server IP Should be SNIP."},
    "NSERR_PCP_LIFE_TIME":{"errno":"0xdc7", "desc":"PCP Min life time is greater than Max life time."},
    "NSERR_PCPSERVER_LSNGROUP_TYPE_DIFF":{"errno":"0xdc8", "desc":"PCP Server being bound is incompatible with the LSN group."},
}

NS_MAP_DOMAIN_ERRORS = {
    "NSERR_MAP_IPV6_PREFIX_INVALID":{"errno":"0xdc9", "desc":"MAP IPv6 Prefix is invalid, it must be global"},
    "NSERR_MAP_IPV6_PREFIX_REQ":{"errno":"0xdca", "desc":"MAP IPv6 Prefix is required"},
    "NSERR_MAP_PSID_INVALID":{"errno":"0xdcb", "desc":"MAP BMR Port Set ID is invalid"},
    "NSERR_MAP_PSID_OFFSET_INVALID":{"errno":"0xdcc", "desc":"MAP BMR Port Set ID offset is invalid"},
    "NSERR_MAP_IPV4_NW_REQ":{"errno":"0xdcd", "desc":"MAP BMR rule ipv4 network and netmask"},
    "NSERR_MAP_BMR_NW_MISSMATCH":{"errno":"0xdce", "desc":"MAP BMR rule and ipv4 network mismatch"},
    "NSERR_MAP_BMR_PSID_LEN_INVALID":{"errno":"0xdcf", "desc":"MAP BMR rule sharing ration is invalid it must be 1 to 16"},
    "NSERR_MAP_BMR_EABIT_LEN_INVALID":{"errno":"0xdd7", "desc":"MAP BMR rule EABIT length invalid"},
    "NSERR_MAP_NSB_CONSUMED":{"errno":"0xdd8", "desc":"NSB is consumed by MAP-T, error return to source or packet forwarded"},
    "NSERR_MAP_NO_CONFIG":{"errno":"0xdd9", "desc":"NO MAP T config, continue with other config "},
}

NS_URLSET_ERRORS = {
    "NSERR_URLSET_CANNOT_INIT_PATTERN":{"errno":"0xeb8", "desc":"Cannot initialize urlset pattern."},
    "NSERR_URLSET_CANNOT_FIND_URL":{"errno":"0xeb9", "desc":"Cannot find url in urlset."},
}

NS_URLFILT_ERRORS = {
    "NSERR_URLFILT_CANNOT_PARSE_XML":{"errno":"0xebc", "desc":"Cannot parse XML categories file."},
    "NSERR_URLFILT_CANNOT_FIND_GROUP":{"errno":"0xebd", "desc":"Cannot find the specified category group."},
    "NSERR_URLFILT_XML_FILE_TOO_BIG":{"errno":"0xebe", "desc":"XML categories file is too big."},
    "NSERR_URLFILT_IC_CACHE_NOT_ENABLED":{"errno":"0xf1d", "desc":"URL Filtering enabled but IC needs to be enabled too."},
}
